/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateFactoryBean
extends AbstractFactoryBean<RestTemplate> {
    private static final int TIMEOUT = 10000;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;

    public Class<?> getObjectType() {
        return RestTemplate.class;
    }

    protected RestTemplate createInstance() throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpComponentsClientHttpRequestFactory.setReadTimeout(10000);
        httpComponentsClientHttpRequestFactory.setConnectTimeout(10000);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        List list = restTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = (MappingJackson2HttpMessageConverter)httpMessageConverter;
            mappingJackson2HttpMessageConverter.setObjectMapper(this.jacksonConfiguration.getObjectMapper());
        }
        list.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }
}

