/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Locale;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.utils.LocaleVO;
import org.cyclos.server.utils.LocaleHelper;
import org.springframework.stereotype.Component;

@Component
public class LocaleVOConverter
extends ObjectConverter<LocaleVO> {
    public LocaleVOConverter() {
        super(LocaleVO.class);
    }

    @Override
    protected void fill(Object object, LocaleVO localeVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        BuiltinLanguage builtinLanguage;
        Locale locale;
        if (object instanceof Locale) {
            locale = (Locale)object;
        } else if (object instanceof BuiltinLanguage) {
            builtinLanguage = (BuiltinLanguage)object;
            locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
        } else if (object instanceof Language) {
            builtinLanguage = (Language)object;
            locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage.getTemplate());
        } else {
            locale = LocaleHelper.toLocale((String)object.toString());
        }
        builtinLanguage = this.getSessionData().getConfiguration().getLanguage();
        Locale locale2 = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage.getTemplate());
        localeVO.setName(locale.getDisplayName(locale2));
        localeVO.setLanguage(locale.getLanguage());
        localeVO.setCountry(locale.getCountry());
        localeVO.setVariant(locale.getVariant());
    }
}

