/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Set;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QBrokering;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.utils.AbstractUserVisibilityApplier;
import org.cyclos.impl.utils.persistence.DBQuery;

public class JPAUserVisibilityApplier
extends AbstractUserVisibilityApplier {
    private DBQuery<?> query;
    private QUser user;
    private QGroup group;

    public JPAUserVisibilityApplier(DBQuery<?> dBQuery, QUser qUser, QGroup qGroup) {
        this.query = dBQuery;
        this.user = qUser;
        this.group = qGroup;
    }

    @Override
    protected void applyBrokerOrSelf(User user) {
        this.query.where((Predicate)this.brokerExpr(user).or((Predicate)this.selfExpr(user)));
    }

    @Override
    protected void applyGroups(Set<Group> set) {
        this.query.where((Predicate)this.accessibleGroupsExpr(set));
    }

    @Override
    protected void applyGroupsOrBrokerOrSelf(Set<Group> set, User user) {
        this.query.where((Predicate)this.accessibleGroupsExpr(set).or((Predicate)this.brokerExpr(user)).or((Predicate)this.selfExpr(user)));
    }

    @Override
    protected void applyGroupsOrSelf(Set<Group> set, User user) {
        this.query.where((Predicate)this.accessibleGroupsExpr(set).or((Predicate)this.selfExpr(user)));
    }

    @Override
    protected void applySelf(User user) {
        this.query.where((Predicate)this.selfExpr(user));
    }

    @Override
    protected void bogusCondition() {
        this.query.where((Predicate)this.user.id.isNull());
    }

    private BooleanExpression accessibleGroupsExpr(Set<Group> set) {
        return this.group.in(set);
    }

    private BooleanExpression brokerExpr(User user) {
        QBrokering qBrokering = QBrokering.brokering;
        BooleanExpression booleanExpression = ((JPAQuery)((JPAQuery)new JPAQuery().from((EntityPath)qBrokering)).where(new Predicate[]{qBrokering.user().eq((Expression)this.user), qBrokering.endDate.isNull().or((Predicate)qBrokering.endDate.after((Expression)DateTimeExpression.currentTimestamp())), qBrokering.broker().eq((Object)user)})).exists();
        return booleanExpression;
    }

    private BooleanExpression selfExpr(User user) {
        return this.user.eq((Object)user);
    }
}

