/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.utils.IdMask;
import org.cyclos.impl.utils.InputOutputProcessingHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.TextMode;
import org.cyclos.model.TrimMode;
import org.cyclos.model.access.RequestData;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.MaskValueInLog;
import org.cyclos.services.RawText;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.IDate;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class InputOutputProcessingHandlerImpl
extends BaseNetworkedHandlerImpl
implements InputOutputProcessingHandler {
    private static final String BEAN_ATTR_LOG_JSON = "logJson";
    private static final Object MUTEX = new Object();
    private static final List<String> IGNORED_THROWABLE_PROPERTIES = Arrays.asList("cause", "message", "localizedMessage", "internationalized", "stackTrace", "suppressed");
    private IdAction ID = new IdAction();
    private TextAction TEXT = new TextAction();
    private InputStreamAction INPUT_STREAM = new InputStreamAction();
    private RecursiveAction RECURSIVE = new RecursiveAction();
    private NoOpAction NO_OP = new NoOpAction();
    private Map<Class<?>, Map<String, ProcessingAction<?>>> pojoActions = new ConcurrentHashMap();
    private Map<Class<? extends Bean>, Map<Property<?, ?>, ProcessingAction<?>>> beanActions = new ConcurrentHashMap();
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    @Lazy
    private DeviceConfirmationServiceLocal deviceConfirmationService;

    public <T> Pair<T, JsonNode> processFromClient(T t, boolean bl) {
        Context context = new Context(InvocationContext.getConversionContext(), t, true, bl, new IdentityHashMap<Object, Pair<Object, JsonNode>>());
        return this.doProcess(t, context);
    }

    public Pair<Object[], JsonNode> processMethodParameters(Method method, Object[] objectArray, boolean bl) {
        if (CollectionHelper.isEmpty((Object[])objectArray)) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        ArrayNode arrayNode = bl ? this.jsonConverter.getObjectMapper().createArrayNode() : null;
        InvocationContext.ConversionContext conversionContext = InvocationContext.getConversionContext();
        IdentityHashMap<Object, Pair<Object, JsonNode>> identityHashMap = new IdentityHashMap<Object, Pair<Object, JsonNode>>();
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        Parameter[] parameterArray = method.getParameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            Object object;
            Parameter parameter = parameterArray[i];
            boolean bl2 = parameter.isAnnotationPresent(RawText.class);
            boolean bl3 = parameter.isAnnotationPresent(MaskValueInLog.class);
            TrimMode trimMode = bl2 ? TrimMode.NONE : TrimMode.BOTH;
            TextMode textMode = bl2 ? TextMode.RAW : TextMode.PLAIN;
            Context context = new Context(conversionContext, null, arrayDeque, true, bl, identityHashMap, trimMode, textMode);
            Pair<Object, JsonNode> pair = this.doProcess(objectArray[i], context);
            Object object2 = object = pair == null ? null : pair.getFirst();
            if (bl3 && object instanceof String && this.deviceConfirmationService.isDeviceConfirmation(object.toString())) {
                this.deviceConfirmationService.registerFeedback(object.toString());
            }
            objectArray2[i] = object;
            if (!bl) continue;
            arrayNode.add(pair == null ? null : (JsonNode)pair.getSecond());
        }
        this.processSensitiveMethodParameters(method, (JsonNode)arrayNode);
        ArrayNode arrayNode2 = arrayNode;
        if (arrayNode != null && arrayNode.size() == 1) {
            arrayNode2 = arrayNode.get(0);
        }
        return Pair.create((Object)objectArray2, (Object)arrayNode2);
    }

    public <T> Pair<T, JsonNode> processMethodResult(Method method, T t, boolean bl) {
        if (t instanceof CharSequence && method.isAnnotationPresent(MaskValueInLog.class)) {
            return Pair.create(t, (Object)(bl ? new TextNode("****") : null));
        }
        return this.processToClient(t, bl);
    }

    public JsonNode processSensitiveMethodParameters(Method method, JsonNode jsonNode) {
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            Parameter[] parameterArray = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                if (!parameterArray[i].isAnnotationPresent(MaskValueInLog.class) || arrayNode.get(i) instanceof NullNode) continue;
                arrayNode.set(i, (JsonNode)new TextNode("****"));
            }
        }
        return jsonNode;
    }

    public <T> Pair<T, JsonNode> processToClient(T t, boolean bl) {
        Context context = new Context(InvocationContext.getConversionContext(), t, false, bl, new IdentityHashMap<Object, Pair<Object, JsonNode>>());
        return this.doProcess(t, context);
    }

    public void restore(Object ... objectArray) {
        if (CollectionHelper.isEmpty((Object[])objectArray)) {
            return;
        }
        Arrays.asList(objectArray).forEach(this::doRestore);
    }

    private ProcessingAction<?> action(Class<?> clazz) {
        if (String.class.equals(clazz)) {
            return this.TEXT;
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return this.ID;
        }
        if (SerializableInputStream.class.equals(clazz)) {
            return this.INPUT_STREAM;
        }
        if (!this.isBasic(clazz)) {
            return this.RECURSIVE;
        }
        return this.NO_OP;
    }

    private void add(JsonNode jsonNode, Pair<?, JsonNode> pair) {
        if (jsonNode != null) {
            ((ArrayNode)jsonNode).add((JsonNode)(pair == null ? NullNode.getInstance() : (JsonNode)pair.getSecond()));
        }
    }

    private void applyActions(Bean bean, Context context, JsonNode jsonNode) {
        Map<Property<?, ?>, ProcessingAction<?>> map = this.getBeanActions(context, bean);
        for (Map.Entry<Property<?, ?>, ProcessingAction<?>> entry : map.entrySet()) {
            Object object;
            Property<?, ?> property = entry.getKey();
            ProcessingAction<?> processingAction = entry.getValue();
            Object object2 = bean.get(property);
            if (object2 == null) continue;
            String string = property.getName();
            Pair<Object, JsonNode> pair = processingAction.process(context.with(property), bean, string, object2);
            Object object3 = object = pair == null ? null : pair.getFirst();
            if (object2 != object) {
                bean.set(property, object);
            }
            JsonNode jsonNode2 = pair == null ? null : (JsonNode)pair.getSecond();
            this.set(jsonNode, string, property.getType(), jsonNode2);
        }
    }

    private Pair<Object, JsonNode> doProcess(Object abstractCollection, Context context) {
        if (abstractCollection == null) {
            return null;
        }
        boolean bl = context.fromClient;
        Class<?> clazz = abstractCollection.getClass();
        if (this.isBasic(clazz)) {
            ProcessingAction<?> processingAction = this.action(clazz);
            return processingAction.process(context, null, null, abstractCollection);
        }
        if (abstractCollection instanceof SimpleEntity && !bl) {
            String string = " for root class " + context.root.getClass().getName() + ", path: " + StringHelper.join(context.pathFromRoot, (String)".");
            throw new IllegalArgumentException("Entity is not expected here, but got " + clazz.getName() + string);
        }
        Pair<Object, JsonNode> pair = context.visited(abstractCollection);
        if (pair != null) {
            return pair;
        }
        Bean bean = null;
        ArrayNode arrayNode = null;
        if (abstractCollection instanceof Page) {
            Page page = (Page)abstractCollection;
            PageImpl pageImpl = new PageImpl(page);
            Pair<Object, JsonNode> pair2 = this.doProcess(pageImpl.getPageItems(), context);
            if (pair2 != null) {
                pageImpl.setPageItems((List)pair2.getFirst());
                arrayNode = (JsonNode)pair2.getSecond();
            }
            bean = pageImpl;
        } else if (abstractCollection instanceof List) {
            ArrayList arrayList = abstractCollection instanceof ArrayList ? (ArrayList)abstractCollection : new ArrayList((List)((Object)abstractCollection));
            arrayNode = context.logJsonArray();
            ListIterator<Object> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                Pair<Object, JsonNode> pair3 = this.doProcess(e, context);
                this.add((JsonNode)arrayNode, pair3);
                listIterator.set(pair3 == null ? null : pair3.getFirst());
            }
            bean = arrayList;
        } else if (abstractCollection instanceof Iterable) {
            Iterable iterable = abstractCollection;
            arrayNode = context.logJsonArray();
            AbstractCollection abstractCollection2 = iterable instanceof Set ? new LinkedHashSet() : new ArrayList();
            for (Object t : iterable) {
                Pair<Object, JsonNode> pair4 = this.doProcess(t, context);
                if (pair4 == null) continue;
                this.add((JsonNode)arrayNode, pair4);
                abstractCollection2.add(pair4.getFirst());
            }
            bean = abstractCollection2;
        } else if (abstractCollection instanceof Properties) {
            bean = abstractCollection;
        } else if (abstractCollection instanceof Map) {
            Map map = (Map)((Object)abstractCollection);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            arrayNode = context.logJsonObject();
            for (Map.Entry entry : map.entrySet()) {
                Pair<Object, JsonNode> pair5;
                Pair<Object, JsonNode> pair6 = this.doProcess(entry.getKey(), context);
                Object object = pair6 == null ? null : pair6.getFirst();
                if (object == null || (pair5 = this.doProcess(entry.getValue(), context)) == null) continue;
                hashMap.put(object, pair5.getFirst());
                this.set((JsonNode)arrayNode, object.toString(), Object.class, (JsonNode)pair5.getSecond());
            }
            bean = hashMap;
        } else if (clazz.isArray()) {
            int n = Array.getLength(abstractCollection);
            arrayNode = context.logJsonArray();
            for (int i = 0; i < n; ++i) {
                Object object = Array.get(abstractCollection, i);
                Pair<Object, JsonNode> pair7 = object == null ? Pair.create(null, (Object)NullNode.getInstance()) : this.doProcess(object, context);
                if (pair7 == null) continue;
                Array.set(abstractCollection, i, pair7.getFirst());
                this.add((JsonNode)arrayNode, pair7);
            }
            bean = abstractCollection;
        } else if (abstractCollection instanceof Bean) {
            Bean bean2 = (Bean)abstractCollection;
            if (!bl) {
                bean2.removeAttribute("stringFromVO");
            }
            if (bean2 instanceof QueryParameters && bl) {
                QueryHelper.internalApplyMaxResults((SessionData)context.conversionContext.getSessionData(), (QueryParameters)((QueryParameters)bean2));
            }
            Boolean bl2 = (Boolean)bean2.getAttribute("fromClient");
            String string = BEAN_ATTR_LOG_JSON + bl;
            arrayNode = (JsonNode)bean2.getAttribute(string);
            if (arrayNode == null && bean2.dataAccessor() != null && (bl2 == null || bl ^ bl2)) {
                bean2.setAttribute("fromClient", (Object)bl);
                boolean bl3 = this.jsonConverter.beanIsSimpleLogNode(bean2);
                if (bl3) {
                    if (bl) {
                        this.applyActions(bean2, context, null);
                        arrayNode = context.logJson(bean2);
                    } else {
                        arrayNode = context.logJson(bean2);
                        this.applyActions(bean2, context, null);
                    }
                } else {
                    arrayNode = context.logJsonObject();
                    this.applyActions(bean2, context, (JsonNode)arrayNode);
                }
                bean2.setAttribute(string, (Object)arrayNode);
            }
            bean2.backup();
            bean = bean2;
        } else {
            if (clazz.getPackage().getName().startsWith("org.cyclos")) {
                Map<String, ProcessingAction<?>> map = this.getPojoActions(context, abstractCollection);
                arrayNode = context.logJsonObject();
                boolean bl4 = false;
                if (abstractCollection instanceof RequestData) {
                    bl4 = ((RequestData)abstractCollection).isProcessedIds();
                }
                if (!bl4) {
                    BeanWrapper beanWrapper = context.wrap(abstractCollection);
                    for (Map.Entry<String, ProcessingAction<?>> entry : map.entrySet()) {
                        Object object;
                        String string = entry.getKey();
                        ProcessingAction<?> processingAction = entry.getValue();
                        Object object2 = beanWrapper.getPropertyValue(string);
                        if (object2 == null) continue;
                        PropertyDescriptor propertyDescriptor = beanWrapper.getPropertyDescriptor(string);
                        Context context2 = context.with(propertyDescriptor.getReadMethod());
                        Pair<Object, JsonNode> pair8 = null;
                        if (propertyDescriptor.getWriteMethod() != null) {
                            pair8 = processingAction.process(context2, beanWrapper, string, object2);
                            JsonNode jsonNode = object = pair8 == null ? null : pair8.getFirst();
                            if (object2 != object && beanWrapper.isWritableProperty(string)) {
                                beanWrapper.setPropertyValue(string, object);
                            }
                        }
                        object = pair8 == null ? null : (JsonNode)pair8.getSecond();
                        this.set((JsonNode)arrayNode, string, beanWrapper.getPropertyType(string), (JsonNode)object);
                    }
                }
            }
            bean = abstractCollection;
        }
        if (arrayNode == null) {
            arrayNode = context.logJson(bean);
        }
        Pair pair9 = Pair.create((Object)bean, (Object)arrayNode);
        context.setVisited((Pair<Object, JsonNode>)pair9);
        return pair9;
    }

    private void doRestore(Object object3) {
        if (object3 instanceof Bean) {
            Bean bean = (Bean)object3;
            bean.restore();
            bean.properties().forEach(property -> this.doRestore(bean.get(property)));
        } else if (object3 instanceof Iterable) {
            ((Iterable)object3).forEach(this::doRestore);
        } else if (object3 instanceof Object[]) {
            Arrays.asList((Object[])object3).forEach(this::doRestore);
        } else if (object3 instanceof Map) {
            ((Map)object3).forEach((object, object2) -> {
                this.doRestore(object);
                this.doRestore(object2);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Property<?, ?>, ProcessingAction<?>> getBeanActions(Context context, Bean bean) {
        Class<?> clazz = bean.getClass();
        Map<Property<?, ?>, ProcessingAction<?>> map = this.beanActions.get(clazz);
        if (map == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (map == null) {
                    map = new HashMap();
                }
                for (Property property : bean.properties()) {
                    Class clazz2 = property.getType();
                    map.put(property, this.action(clazz2));
                }
                this.beanActions.put(clazz, map);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ProcessingAction<?>> getPojoActions(Context context, Object object) {
        Class<?> clazz = object.getClass();
        Map<String, ProcessingAction<?>> map = this.pojoActions.get(clazz);
        if (map == null) {
            Object object2 = MUTEX;
            synchronized (object2) {
                if (map == null) {
                    map = new HashMap();
                }
                BeanWrapper beanWrapper = context.wrap(object);
                for (PropertyDescriptor propertyDescriptor : beanWrapper.getPropertyDescriptors()) {
                    String string = propertyDescriptor.getName();
                    Method method = propertyDescriptor.getReadMethod();
                    if (method == null || "class".equals(string) || object instanceof Throwable && IGNORED_THROWABLE_PROPERTIES.contains(string)) continue;
                    Class<?> clazz2 = propertyDescriptor.getPropertyType();
                    map.put(string, this.action(clazz2));
                }
                this.pojoActions.put(clazz, map);
            }
        }
        return map;
    }

    private boolean isBasic(Class<?> clazz) {
        return CoercionHelper.understands(clazz) || IDate.class.isAssignableFrom(clazz) || SerializableInputStream.class.isAssignableFrom(clazz);
    }

    private void set(JsonNode jsonNode, String string, Class<?> clazz, JsonNode jsonNode2) {
        if (jsonNode == null || jsonNode2 == null || jsonNode2.isNull() || !this.jsonConverter.useLogJsonAsProperty(jsonNode2, clazz)) {
            return;
        }
        ((ObjectNode)jsonNode).set(string, jsonNode2);
    }

    private class IdAction
    implements ProcessingAction<Long> {
        private IdAction() {
        }

        @Override
        public Pair<Object, JsonNode> process(Context context, Object object, String string, Long l) {
            JsonNode jsonNode;
            Long l2;
            IdMask idMask = InputOutputProcessingHandlerImpl.this.applicationHandler.getIdMask();
            if (context.fromClient) {
                l2 = idMask.remove(l);
                jsonNode = context.logJson(l2);
            } else {
                jsonNode = context.logJson(l);
                l2 = idMask.apply(l);
            }
            return Pair.create((Object)l2, (Object)jsonNode);
        }
    }

    private class TextAction
    implements ProcessingAction<String> {
        private TextAction() {
        }

        @Override
        public Pair<Object, JsonNode> process(Context context, Object object, String string, String string2) {
            String string3;
            JsonNode jsonNode;
            if (context.fromClient) {
                jsonNode = context.logJson(JsonConverter.mask((Object)object, (String)string, (Object)string2));
                string3 = context.processText(object, string2);
                if ("confirmationPassword".equals(string) && InputOutputProcessingHandlerImpl.this.deviceConfirmationService.isDeviceConfirmation(string2)) {
                    InputOutputProcessingHandlerImpl.this.deviceConfirmationService.registerFeedback(string2);
                }
            } else {
                string3 = context.processText(object, string2);
                jsonNode = context.logJson(JsonConverter.mask((Object)object, (String)string, (Object)string3));
            }
            return Pair.create((Object)string3, (Object)jsonNode);
        }
    }

    private class InputStreamAction
    implements ProcessingAction<SerializableInputStream> {
        private InputStreamAction() {
        }

        @Override
        public Pair<Object, JsonNode> process(Context context, Object object, String string, SerializableInputStream serializableInputStream) {
            if (context.fromClient) {
                try {
                    RequestContext.ensure().registerFile(serializableInputStream.file());
                    serializableInputStream.reOpen();
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
            return Pair.create((Object)serializableInputStream, (Object)null);
        }
    }

    private class RecursiveAction
    implements ProcessingAction<Object> {
        private RecursiveAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pair<Object, JsonNode> process(Context context, Object object, String string, Object object2) {
            try {
                context.pathFromRoot.addLast(string);
                Pair<Object, JsonNode> pair = InputOutputProcessingHandlerImpl.this.doProcess(object2, context);
                return pair;
            }
            finally {
                context.pathFromRoot.removeLast();
            }
        }
    }

    private class NoOpAction
    implements ProcessingAction<Object> {
        private NoOpAction() {
        }

        @Override
        public Pair<Object, JsonNode> process(Context context, Object object, String string, Object object2) {
            return Pair.create((Object)object2, (Object)context.logJson(object2));
        }
    }

    public class Context {
        private final InvocationContext.ConversionContext conversionContext;
        private final boolean fromClient;
        private final boolean logJson;
        private final IdentityHashMap<Object, Pair<Object, JsonNode>> visited;
        private final TrimMode trimMode;
        private final TextMode textMode;
        private final Object root;
        private final Deque<String> pathFromRoot;

        public Context(InvocationContext.ConversionContext conversionContext, Object object, boolean bl, boolean bl2, IdentityHashMap<Object, Pair<Object, JsonNode>> identityHashMap) {
            this(conversionContext, object, new ArrayDeque<String>(), bl, bl2, identityHashMap, null, null);
        }

        public Context(InvocationContext.ConversionContext conversionContext, Object object, Deque<String> deque, boolean bl, boolean bl2, IdentityHashMap<Object, Pair<Object, JsonNode>> identityHashMap, TrimMode trimMode, TextMode textMode) {
            this.conversionContext = conversionContext;
            this.root = object;
            this.pathFromRoot = deque;
            this.fromClient = bl;
            this.logJson = bl2;
            this.visited = identityHashMap;
            this.trimMode = trimMode;
            this.textMode = textMode;
        }

        public JsonNode logJson(Object object) {
            return this.logJson ? InputOutputProcessingHandlerImpl.this.jsonConverter.toLogNode(object, this.fromClient) : null;
        }

        public ArrayNode logJsonArray() {
            return this.logJson ? InputOutputProcessingHandlerImpl.this.jsonConverter.getObjectMapper().createArrayNode() : null;
        }

        public ObjectNode logJsonObject() {
            return this.logJson ? InputOutputProcessingHandlerImpl.this.jsonConverter.getObjectMapper().createObjectNode() : null;
        }

        public String processText(Object object, String string) {
            if (string == null) {
                return null;
            }
            if (this.fromClient) {
                String string2 = string.replace('\u00a0', ' ');
                string2 = string2.replace("\u0000", "");
                string2 = this.applyTrim(string2);
                string2 = this.applyTextFromClient(string2);
                return string2;
            }
            String string3 = string;
            return this.applyTextToClient(object, string3);
        }

        public void setVisited(Pair<Object, JsonNode> pair) {
            this.visited.put(pair.getFirst(), pair);
        }

        public Pair<Object, JsonNode> visited(Object object) {
            return this.visited.get(object);
        }

        public Context with(Method method) {
            if (method == null) {
                return this;
            }
            boolean bl = method.isAnnotationPresent(RawText.class);
            TrimMode trimMode = bl ? TrimMode.NONE : TrimMode.BOTH;
            TextMode textMode = bl ? TextMode.RAW : TextMode.PLAIN;
            return new Context(this.conversionContext, this.root, this.pathFromRoot, this.fromClient, this.logJson, this.visited, trimMode, textMode);
        }

        public Context with(Property<Object, Bean> property) {
            return new Context(this.conversionContext, this.root, this.pathFromRoot, this.fromClient, this.logJson, this.visited, property.getTrimMode(), property.getTextMode());
        }

        public Context withLogJson(boolean bl) {
            return new Context(this.conversionContext, this.root, this.pathFromRoot, this.fromClient, bl, this.visited, this.trimMode, this.textMode);
        }

        public BeanWrapper wrap(Object object) {
            return this.conversionContext.wrap(object);
        }

        private String applyTextFromClient(String string) {
            if (string == null) {
                return string;
            }
            switch ((TextMode)ObjectHelper.defaultValue((Object)this.textMode, (Object)TextMode.PLAIN)) {
                case PLAIN: {
                    string = InputOutputProcessingHandlerImpl.this.richTextHandler.escapeTags(string);
                    break;
                }
                case RICH: 
                case DYNAMIC: {
                    string = InputOutputProcessingHandlerImpl.this.richTextHandler.sanitize(string);
                    break;
                }
            }
            return string == null || string.isEmpty() ? null : string;
        }

        private String applyTextToClient(Object object, String string) {
            if (this.textMode == TextMode.RICH || this.textMode == TextMode.DYNAMIC) {
                Configuration configuration;
                ConfigurationAccessor configurationAccessor = null;
                if (object instanceof Bean && (configuration = ConfigurationServiceLocal.getConfiguration((Bean)((Bean)object))) != null) {
                    configurationAccessor = InputOutputProcessingHandlerImpl.this.configurationHandler.getAccessor(configuration);
                }
                string = InputOutputProcessingHandlerImpl.this.richTextHandler.replaceTagsByUrls(string, configurationAccessor);
            }
            return string;
        }

        private String applyTrim(String string) {
            if (string == null) {
                return string;
            }
            switch ((TrimMode)ObjectHelper.defaultValue((Object)this.trimMode, (Object)TrimMode.BOTH)) {
                case BOTH: {
                    string = string.trim();
                    break;
                }
                case LEADING: {
                    string = StringUtils.trimLeadingWhitespace((String)string);
                    break;
                }
                case TRAILING: {
                    string = StringUtils.trimTrailingWhitespace((String)string);
                    break;
                }
            }
            return string.isEmpty() ? null : string;
        }
    }

    private static interface ProcessingAction<T> {
        public Pair<Object, JsonNode> process(Context var1, Object var2, String var3, T var4);
    }
}

