/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.cyclos.impl.utils.ExpirableStorage;
import org.cyclos.impl.utils.cluster.StorageType;

public abstract class GuavaStorage<K, V, R extends BiPredicate<K, V>>
implements ExpirableStorage<K, V, R> {
    protected final StorageType<K, V> type;
    protected final Cache<K, V> cache;

    public GuavaStorage(StorageType<K, V> storageType) {
        this.type = storageType;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(storageType.getTtl(), storageType.getTtlUnit()).removalListener(removalNotification -> this.onRemove(removalNotification.getKey(), removalNotification.getValue())).build();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public V get(K k) {
        return (V)this.cache.getIfPresent(k);
    }

    public Set<K> keys(R r) {
        return this.cache.asMap().entrySet().stream().filter(entry -> r.test(entry.getKey(), entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void remove(K k) {
        this.cache.invalidate(k);
    }

    public void removeAll(Collection<K> collection) {
        this.cache.invalidateAll(collection);
    }

    public void removeIf(R r) {
        this.cache.invalidateAll(this.keys(r));
    }

    public void set(K k, V v) {
        this.cache.put(k, v);
    }

    protected void onRemove(K k, V v) {
    }
}

