/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class ConvertingBeanMap
implements Map<String, Object> {
    private static volatile Map<Class<?>, Set<String>> propertiesPerType = new ConcurrentHashMap();
    private BeanWrapper bean;
    private Set<String> propertyNames;
    private Set<String> keys;
    private ConversionHandler conversionHandler;

    private static Set<String> propertyNamesForType(BeanWrapper beanWrapper) {
        Class clazz = beanWrapper.getWrappedClass();
        Set<String> set = propertiesPerType.get(clazz);
        if (set == null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (PropertyDescriptor propertyDescriptor : beanWrapper.getPropertyDescriptors()) {
                hashSet.add(propertyDescriptor.getName());
            }
            set = Collections.unmodifiableSet(hashSet);
        }
        return set;
    }

    public ConvertingBeanMap(Object object, ConversionHandler conversionHandler) {
        this.bean = new BeanWrapperImpl(object);
        this.conversionHandler = conversionHandler;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getPropertyNames().contains(object);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
        for (final String string : this.keySet()) {
            hashSet.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return string;
                }

                @Override
                public Object getValue() {
                    return ConvertingBeanMap.this.get(string);
                }

                @Override
                public Object setValue(Object object) {
                    return ConvertingBeanMap.this.put(string, object);
                }
            });
        }
        return hashSet;
    }

    @Override
    public Object get(Object object) {
        String string = (String)object;
        if (this.getPropertyNames().contains(string)) {
            Class clazz = this.bean.getPropertyType(string);
            if (this.bean.isReadableProperty(string)) {
                return this.conversionHandler.convert(clazz, this.bean.getPropertyValue(string));
            }
        }
        return null;
    }

    public BeanWrapper getBean() {
        return this.bean;
    }

    public ConversionHandler getConversionHandler() {
        return this.conversionHandler;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        if (this.keys == null) {
            this.keys = this.initKeySet();
        }
        return this.keys;
    }

    @Override
    public Object put(String string, Object object) {
        if (this.getPropertyNames().contains(string)) {
            Class clazz = this.bean.getPropertyType(string);
            if (this.bean.isWritableProperty(string)) {
                this.bean.setPropertyValue(string, this.conversionHandler.convert(clazz, object));
            }
        } else {
            throw new IllegalStateException("Invalid property " + string + " on object " + String.valueOf(this.bean.getWrappedInstance()));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object object) {
        this.put((String)object, (Object)null);
        return null;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (String string : this.keySet()) {
            stringBuilder.append(string).append('=').append(this.get(string)).append(',');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, '}');
        return stringBuilder.toString();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    protected Set<String> getPropertyNames() {
        if (this.propertyNames == null) {
            this.propertyNames = ConvertingBeanMap.propertyNamesForType(this.bean);
        }
        return this.propertyNames;
    }

    protected Set<String> initKeySet() {
        HashSet<String> hashSet = new HashSet<String>(this.getPropertyNames());
        return hashSet;
    }
}

