/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.utils.BeanAccessor;
import org.cyclos.impl.utils.formatting.DataTranslationProxy;
import org.cyclos.impl.utils.formatting.DefaultValueFormatter;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.formatting.ValueFormatter;
import org.cyclos.utils.CollectionHelper;

public class BeanFormatter
extends BeanAccessor {
    private Map<String, ValueFormatter> customFormatters;
    private final FormatterImpl formatter;

    public BeanFormatter(FormatterImpl formatterImpl) {
        this.formatter = formatterImpl;
    }

    public String format(Object object, String string) {
        Object object2;
        if (object instanceof BaseEntity) {
            object2 = (BaseEntity)object;
            object = DataTranslationProxy.proxy((Object)object2, (DataTranslationHandler)this.formatter.getDataTranslationHandler(), (Language)this.formatter.getConfiguration().getLanguage());
        }
        object2 = this.get(object, string);
        return this.getFormatterFor(string).format(object, object2, this.formatter);
    }

    public FormatterImpl getFormatter() {
        return this.formatter;
    }

    public void registerFormatter(String string, ValueFormatter valueFormatter) {
        this.getCustomFormatters().put(string, valueFormatter);
    }

    public void registerFormatters(Map<String, ValueFormatter> map) {
        if (CollectionHelper.isNotEmpty(map)) {
            this.getCustomFormatters().putAll(map);
        }
    }

    private Map<String, ValueFormatter> getCustomFormatters() {
        if (this.customFormatters == null) {
            this.customFormatters = new HashMap<String, ValueFormatter>();
        }
        return this.customFormatters;
    }

    private ValueFormatter getFormatterFor(String string) {
        ValueFormatter valueFormatter = null;
        if (this.customFormatters != null) {
            valueFormatter = this.customFormatters.get(string);
        }
        return valueFormatter == null ? DefaultValueFormatter.instance() : valueFormatter;
    }
}

