/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.ConvertingBeanMap;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.utils.CustomFieldHelper;

public abstract class BaseWithCustomValuesMap
extends ConvertingBeanMap {
    private Map<String, CustomField<?, ?, ?>> customFields = new HashMap();
    protected Collection<? extends ICustomFieldValue<?, ?, ?, ?>> customValues;
    protected EntityManagerHandler entityManagerHandler;
    protected CustomFieldValueHandler customFieldValueHandler;

    public BaseWithCustomValuesMap(Object object, Collection<? extends CustomField<?, ?, ?>> collection, Collection<? extends ICustomFieldValue<?, ?, ?, ?>> collection2, ConversionHandler conversionHandler, EntityManagerHandler entityManagerHandler, CustomFieldValueHandler customFieldValueHandler) {
        super(object, conversionHandler);
        this.customValues = collection2;
        this.entityManagerHandler = entityManagerHandler;
        this.customFieldValueHandler = customFieldValueHandler;
        this.customFields = new HashMap();
        for (CustomField<?, ?, ?> customField : collection) {
            this.customFields.put(customField.getInternalName(), customField);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getPropertyNames().contains(object) || this.customFields.containsKey(object);
    }

    @Override
    public Object get(Object object) {
        CustomField<?, ?, ?> customField = this.customFields.get(object);
        if (customField != null) {
            ICustomFieldValue iCustomFieldValue = CustomFieldHelper.findValue(customField, this.customValues);
            return iCustomFieldValue == null ? null : this.customFieldValueHandler.getValue(customField, (Object)iCustomFieldValue, false);
        }
        return super.get(object);
    }

    public CustomField<?, ?, ?> getCustomField(Long l) {
        return this.customFields.values().stream().filter(customField -> customField.getId().equals(l)).findFirst().orElseGet(null);
    }

    public CustomField<?, ?, ?> getCustomField(String string) {
        return this.customFields.get(string);
    }

    public Collection<CustomField<?, ?, ?>> getCustomFields() {
        return this.customFields.values();
    }

    @Override
    public Object put(String string, Object object) {
        CustomField<?, ?, ?> customField = this.customFields.get(string);
        if (customField != null) {
            ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue = CustomFieldHelper.findValue(customField, this.customValues);
            if (iCustomFieldValue == null) {
                iCustomFieldValue = this.newCustomFieldValue(customField);
                this.customValues.add(iCustomFieldValue);
            }
            object = this.customFieldValueHandler.getValue(customField, object, false);
            this.setCustomFieldValue(customField, iCustomFieldValue, object);
            return null;
        }
        return super.put(string, object);
    }

    @Override
    protected Set<String> initKeySet() {
        Set<String> set = super.initKeySet();
        set.addAll(this.customFields.keySet());
        return set;
    }

    protected abstract ICustomFieldValue<?, ?, ?, ?> newCustomFieldValue(CustomField<?, ?, ?> var1);

    protected abstract void setCustomFieldValue(CustomField<?, ?, ?> var1, ICustomFieldValue<?, ?, ?, ?> var2, Object var3);
}

