/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.utils.InputOutputProcessingHandler;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandlerImplementor;
import org.cyclos.impl.utils.PushNotificationSubscriptionMatcher;
import org.cyclos.impl.utils.cluster.PushNotificationSubscription;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.PushNotificationEventFilter;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.TransactionStatus;

public abstract class AbstractPushNotificationHandlerImpl<S extends PushNotificationSubscription>
implements PushNotificationHandlerImplementor {
    private static final Logger LOG = LogManager.getLogger(AbstractPushNotificationHandlerImpl.class);
    private static final long EXPIRATION_OFFSET = 600000L;
    @Autowired
    @Lazy
    private InputOutputProcessingHandler inputOutputProcessingHandler;
    @Autowired
    @Lazy
    protected InvokerHandler invokerHandler;
    @Autowired
    @Lazy
    private TicketServiceLocal ticketService;
    @Autowired
    @Lazy
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    @Lazy
    private InternalIdentityProviderServiceLocal internalIdentityProviderService;
    @Autowired
    @Lazy
    private ApplicationHandler applicationHandler;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private RawEntityManagerHandler rawEntityManagerHandler;
    private long expirationOffset = 600000L;

    public String clientFromId(String string) {
        return StringUtils.substringBefore((String)string, (int)64);
    }

    public abstract void close(String var1);

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public String idFromClientId(BasicUser basicUser, String string) {
        return this.idFromClientId(SimpleEntity.id((SimpleEntity)basicUser), string);
    }

    public String idFromClientId(Long l, String string) {
        if (l == null) {
            return string;
        }
        return string + "@" + this.applicationHandler.getIdMask().apply(l);
    }

    public <T> void publish(PushNotificationEventContext<T> pushNotificationEventContext, Long l, Supplier<T> supplier) {
        this.doPublish(pushNotificationEventContext, () -> this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, arg_0 -> this.lambda$publish$1(l, (Supplier)supplier, arg_0)));
    }

    public <T> void publish(PushNotificationEventContext<T> pushNotificationEventContext, T t) {
        this.doPublish(pushNotificationEventContext, () -> t);
    }

    public void setExpirationOffset(long l) {
        this.expirationOffset = l;
    }

    public final String subscribe(String string, PushNotificationEventFilter pushNotificationEventFilter, Consumer<PushNotificationEvent<?>> consumer) {
        S s;
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        Session session = sessionData.getSession();
        HashSet hashSet = new HashSet();
        if (pushNotificationEventFilter != null) {
            hashSet.addAll(pushNotificationEventFilter.getTypes());
        }
        Long l = basicUser == null ? null : basicUser.getId();
        String string2 = session == null ? null : session.getSessionToken();
        String string3 = pushNotificationEventFilter == null ? null : pushNotificationEventFilter.getTicketNumber();
        String string4 = pushNotificationEventFilter == null ? null : pushNotificationEventFilter.getDeviceConfirmationId();
        String string5 = pushNotificationEventFilter == null ? null : pushNotificationEventFilter.getIdentityProviderRequestId();
        Set set = basicUser != null && hashSet.contains(PushNotificationEventType.ACCOUNT_STATUS) ? SimpleEntity.uniqueIds((Collection)this.accountService.listVisible((InternalAccountOwner)basicUser)) : null;
        PushNotificationSubscriptionMatcher pushNotificationSubscriptionMatcher = new PushNotificationSubscriptionMatcher(hashSet, l, set, string2, string3, string4, string5);
        String string6 = this.idFromClientId(basicUser, string);
        S s2 = this.subscriptionForId(string6);
        if (string3 != null) {
            this.ticketService.checkExists(string3, s2 == null);
        }
        if (string4 != null && s2 != null) {
            this.deviceConfirmationService.find(string4);
        }
        if (string5 != null && s2 == null) {
            this.internalIdentityProviderService.checkExists(string5);
        }
        Consumer<PushNotificationEvent<?>> consumer2 = pushNotificationEvent -> {
            PushNotificationEvent pushNotificationEvent2 = (PushNotificationEvent)this.invokerHandler.runAs(sessionData, () -> {
                Pair pair = this.inputOutputProcessingHandler.processToClient(pushNotificationEvent, false);
                return pair == null ? null : (PushNotificationEvent)pair.getFirst();
            });
            consumer.accept(pushNotificationEvent2);
        };
        if (s2 != null) {
            if (this.isExpired(s2)) {
                this.close(string6);
                s = this.newSubscription(string6, string, pushNotificationSubscriptionMatcher);
                this.connect((PushNotificationSubscription)s, consumer2);
            } else {
                s2.setMatcher(pushNotificationSubscriptionMatcher);
                this.reconnect(s2, consumer2);
                s = s2;
            }
        } else {
            s = this.newSubscription(string6, string, pushNotificationSubscriptionMatcher);
            this.connect((PushNotificationSubscription)s, consumer2);
        }
        this.setCloseAfter(s, null);
        return string6;
    }

    public abstract S subscriptionForClientId(String var1);

    public abstract S subscriptionForId(String var1);

    public final void timeout(String string) {
        S s = this.subscriptionForId(string);
        if (s != null) {
            this.setCloseAfter(s, System.currentTimeMillis() + this.getExpirationOffset());
        }
    }

    protected abstract void addMissedEvent(S var1, PushNotificationEvent<?> var2);

    protected abstract void connect(PushNotificationSubscription var1, Consumer<PushNotificationEvent<?>> var2);

    protected final void dispatch(S s, PushNotificationEvent<?> pushNotificationEvent) {
        if (this.getCloseAfter(s) != null) {
            if (!PushNotificationEventType.LOGGED_OUT.equals((Object)pushNotificationEvent.getType())) {
                this.addMissedEvent(s, pushNotificationEvent);
            }
        } else {
            this.doDispatch((PushNotificationSubscription)s, (PushNotificationEvent)pushNotificationEvent);
        }
    }

    protected abstract Long getCloseAfter(S var1);

    protected SessionData getSessionData() {
        return InvocationContext.getSessionData();
    }

    protected abstract SubscriptionMatchResult<S> matchingSubscriptions(PushNotificationEventContext<?> var1);

    protected <K, V> Cache<K, V> newCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterAccess(20L, TimeUnit.MINUTES).build();
    }

    protected abstract S newSubscription(String var1, String var2, PushNotificationSubscriptionMatcher var3);

    protected abstract void reconnect(S var1, Consumer<PushNotificationEvent<?>> var2);

    protected abstract void setCloseAfter(S var1, Long var2);

    private <T> void doPublish(PushNotificationEventContext<T> pushNotificationEventContext, Supplier<T> supplier) {
        InvocationContext invocationContext = InvocationContext.ensure();
        Runnable runnable = () -> this.invokerHandler.getExecutorService().submit(() -> this.lambda$doPublish$6(pushNotificationEventContext, (Supplier)supplier));
        if (invocationContext.getTransactionLevel() == TransactionLevel.READ_WRITE) {
            invocationContext.addCommitListener(false, runnable);
        } else {
            runnable.run();
        }
    }

    private boolean isExpired(S s) {
        Long l = this.getCloseAfter(s);
        return l != null && l < System.currentTimeMillis();
    }

    private /* synthetic */ void lambda$doPublish$6(PushNotificationEventContext pushNotificationEventContext, Supplier supplier) {
        try {
            SubscriptionMatchResult<S> subscriptionMatchResult = this.matchingSubscriptions(pushNotificationEventContext);
            if (subscriptionMatchResult.hasAnyMatch()) {
                Object var4_5 = supplier == null ? null : supplier.get();
                PushNotificationEvent pushNotificationEvent = pushNotificationEventContext.newEvent(var4_5);
                if (pushNotificationEventContext.getType() != null && pushNotificationEventContext.getType().getDataType() != null && pushNotificationEvent.getData() == null) {
                    return;
                }
                subscriptionMatchResult.publish(pushNotificationEvent);
            }
        }
        catch (Exception exception) {
            LOG.warn("Error publishing a push notification", (Throwable)exception);
        }
    }

    private /* synthetic */ Object lambda$publish$1(Long l, Supplier supplier, TransactionStatus transactionStatus) {
        Network network = l == null ? null : (Network)this.rawEntityManagerHandler.find(Network.class, l);
        return this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> AbstractPushNotificationHandlerImpl.lambda$publish$0((Supplier)supplier));
    }

    private static /* synthetic */ Object lambda$publish$0(Supplier supplier) throws Exception {
        return supplier.get();
    }

    protected static interface SubscriptionMatchResult<S extends PushNotificationSubscription> {
        public Collection<S> getMatches();

        default public boolean hasAnyMatch() {
            return CollectionHelper.isNotEmpty(this.getMatches());
        }

        public void publish(PushNotificationEvent<?> var1);
    }
}

