/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUserGroup;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserVariable;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.GroupVisibility;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class UserVariablesFunction
implements Function<String, String> {
    private final BasicUser user;
    @Autowired
    private ConfigurationHandler configurationHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private UserAddressServiceLocal addressService;
    @Autowired
    private GroupsHandler groupsHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private AccountHandler accountHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private DataTranslationHandler dataTranslationHandler;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    private FormatterImpl formatter;
    private Map<String, ProfileField> profileFields;

    public static boolean isPreview() {
        return Boolean.parseBoolean((String)InvocationContext.get().getAttribute((Object)"userVariablesPreview"));
    }

    public static void preview() {
        InvocationContext.get().setAttribute((Object)"userVariablesPreview", (Object)"true");
    }

    public UserVariablesFunction(BasicUser basicUser) {
        this.user = basicUser;
    }

    @Override
    public String apply(String string) {
        Object object = this.doApply(string);
        return object == null && UserVariablesFunction.isPreview() ? "{" + string + "}" : this.formatter.format(object);
    }

    @PostConstruct
    public void initialize() {
        this.formatter = InvocationContext.getFormatter((ConfigurationAccessor)this.configurationHandler.getAccessor(this.user));
        this.profileFields = new HashMap<String, ProfileField>();
        if (this.user != null) {
            for (ProfileField profileField : this.profileFieldHandler.getVisibleProfileFields(this.user)) {
                BasicProfileField basicProfileField;
                if (profileField instanceof BasicProfileField) {
                    basicProfileField = (BasicProfileField)profileField;
                    for (String string : basicProfileField.getAliases()) {
                        this.profileFields.put(string, profileField);
                    }
                    continue;
                }
                if (!(profileField instanceof UserCustomField)) continue;
                basicProfileField = (UserCustomField)profileField;
                this.profileFields.put(basicProfileField.getInternalName(), profileField);
            }
        }
    }

    private boolean canView(ProfileField profileField) {
        return this.profileFieldHandler.isAllowed(this.user, profileField, ProfileFieldAction.VIEW);
    }

    private Object doApply(String string) {
        if (this.user != null) {
            String string2;
            Pair pair;
            ProfileField profileField = this.profileFields.get(string);
            if (profileField != null) {
                if (!this.canView(profileField)) {
                    return null;
                }
                if (profileField == BasicProfileField.IMAGE) {
                    return null;
                }
                if (profileField == BasicProfileField.ADDRESS && this.user instanceof User) {
                    return this.addressService.getDefaultUserAddress((User)this.user);
                }
                if (profileField == BasicProfileField.FULL_NAME) {
                    return StringHelper.replacePeriod((String)this.user.getName());
                }
                if (profileField == BasicProfileField.PHONE) {
                    return this.user.getPreferredPhone();
                }
                return this.profileFieldHandler.getFieldValue(this.user, profileField);
            }
            List list = StringHelper.splitTrimming((String)string, (String)".");
            if (list.size() == 2 && this.user instanceof User) {
                pair = (User)this.user;
                string2 = (String)list.get(0);
                String string3 = (String)list.get(1);
                if (BasicProfileField.ADDRESS.getAlias().equals(string2)) {
                    if (!this.canView((ProfileField)BasicProfileField.ADDRESS)) {
                        return null;
                    }
                    UserAddress userAddress = this.addressService.getDefaultUserAddress((User)pair);
                    if (UserAddressDTO.NAME.getName().equals(string3)) {
                        return userAddress == null ? null : userAddress.getName();
                    }
                    AddressFields addressFields = AddressFields.findByInternalName((String)string3);
                    String string4 = null;
                    if (addressFields != null) {
                        string4 = AddressHelper.getValue((AddressFields)addressFields, (IAddress)userAddress);
                        if (addressFields == AddressFields.COUNTRY && StringHelper.isNotBlank((Object)string4)) {
                            string4 = this.localizationService.getCountryName(string4);
                        }
                    }
                    return string4;
                }
            }
            if ((pair = UserVariable.variable((String)string)).getFirst() != null) {
                switch ((UserVariable)pair.getFirst()) {
                    case DISPLAY: {
                        return StringHelper.replacePeriod((String)this.formatter.format(this.user));
                    }
                    case GROUP_SET: {
                        return this.getGroupVisibility().isGroupSetVisible() ? this.user.getUser().getGroupSet() : null;
                    }
                    case GROUP: {
                        return this.getGroupVisibility().isGroupSetVisible() ? this.user.getUser().getGroup() : null;
                    }
                    case GROUP_DISPLAY: {
                        string2 = this.getGroupVisibility().isGroupSetVisible() ? this.user.getUser().getGroup() : null;
                        return string2 == null ? null : ObjectHelper.defaultValue((Object)this.dataTranslationHandler.getValue((BaseEntity)string2, QUserGroup.userGroup.initialGroupDescription), (Object)string2);
                    }
                    case PHONES: {
                        return this.canView((ProfileField)BasicProfileField.PHONE) ? this.user.getPhones() : null;
                    }
                    case MOBILE_PHONES: {
                        return this.canView((ProfileField)BasicProfileField.PHONE) ? this.user.getMobilePhones() : null;
                    }
                    case MOBILE_PHONE: {
                        return this.canView((ProfileField)BasicProfileField.PHONE) ? this.user.getPreferredMobilePhone() : null;
                    }
                    case LAND_LINE_PHONES: {
                        return this.canView((ProfileField)BasicProfileField.PHONE) ? this.user.getLandLinePhones() : null;
                    }
                    case LAND_LINE_PHONE: {
                        return this.canView((ProfileField)BasicProfileField.PHONE) ? this.user.getPreferredLandLinePhone() : null;
                    }
                    case APPLICATION_NAME: {
                        return this.configurationHandler.getAccessAccessor(this.user).getApplicationName();
                    }
                    case APPLICATION_URL: {
                        return this.linkGeneratorHandler.root(this.user);
                    }
                    case ACCOUNT_AVAILABLE_BALANCE: {
                        return this.getAmount((String)pair.getSecond(), AccountStatusVO::getAvailableBalance);
                    }
                    case ACCOUNT_BALANCE: {
                        return this.getAmount((String)pair.getSecond(), AccountStatusVO::getBalance);
                    }
                    case ACCOUNT_CREDIT_LIMIT: {
                        return this.getAmount((String)pair.getSecond(), accountStatusVO -> accountStatusVO.getCreditLimit() == null ? null : accountStatusVO.getCreditLimit().negate());
                    }
                    case ACCOUNT_UPPER_CREDIT_LIMIT: {
                        return this.getAmount((String)pair.getSecond(), AccountStatusVO::getUpperCreditLimit);
                    }
                    case ACCOUNT_NUMBER: {
                        return this.getAccount((String)pair.getSecond(), account -> this.accountHandler.getAccountNumber((IAccount)account));
                    }
                    case ACCOUNT_TYPE_ID: {
                        return this.getAccount((String)pair.getSecond(), account -> this.applicationHandler.getIdMask().apply(account.getType().getId()));
                    }
                    case ACCOUNT_TYPE_NAME: {
                        return this.getAccount((String)pair.getSecond(), account -> this.formatter.format((INamedEntity)account.getType()));
                    }
                    case DATE: {
                        return this.formatter.formatAsDate(new Date());
                    }
                    case TIME: {
                        return this.formatter.formatAsTime(new Date());
                    }
                    case DATE_TIME: {
                        return this.formatter.format(new Date());
                    }
                }
            }
        }
        return null;
    }

    private <R> R getAccount(String string, Function<Account, R> function) {
        Account account = null;
        try {
            account = this.accountService.load((InternalAccountOwner)this.user, string);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        return account == null || !this.accountServiceSecurity.hasVisibility(account) ? null : (R)function.apply(account);
    }

    private CurrencyAmount getAmount(String string, Function<AccountStatusVO, BigDecimal> function) {
        Account account2 = this.getAccount(string, account -> account);
        if (account2 != null) {
            AccountStatusVO accountStatusVO = this.accountService.getAccountStatus(account2, null, null);
            BigDecimal bigDecimal = function.apply(accountStatusVO);
            return bigDecimal == null ? null : new CurrencyAmount(account2.getCurrency(), bigDecimal);
        }
        return null;
    }

    private GroupVisibility getGroupVisibility() {
        return this.groupsHandler.getGroupVisibility(InvocationContext.getSessionData().isBrokerOf(this.user));
    }
}

