/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.BaseRecordEntityLogHandlerImpl;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.Property;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.UserRecordDTO;
import org.cyclos.security.users.RecordServiceSecurity;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserRecordEntityLogHandlerImpl
extends BaseRecordEntityLogHandlerImpl<UserRecord, UserRecordDTO> {
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    @Lazy
    private RecordServiceSecurity recordServiceSecurity;

    @Override
    public Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        UserRecord userRecord = this.find(UserRecord.class, l);
        UserRecordType userRecordType = (UserRecordType)userRecord.getType();
        List list = this.recordFieldHandler.getFieldsByAction(userRecordType, (BasicUser)userRecord.getUser(), RecordFieldAction.VIEW);
        if (list.isEmpty()) {
            dBQuery.where((Predicate)UserRecordEntityLogHandlerImpl.$.customFieldId.isNull());
        } else {
            dBQuery.where((Predicate)UserRecordEntityLogHandlerImpl.$.customFieldId.isNull().or((Predicate)UserRecordEntityLogHandlerImpl.$.customFieldId.in((Collection)SimpleEntity.uniqueIds((Collection)list))));
        }
        return null;
    }

    public Class<UserRecord> getEntityClass() {
        return UserRecord.class;
    }

    @Override
    public BasicUser getRelatedUser(UserRecord userRecord) {
        return userRecord.getUser();
    }

    public EntityLogType getType() {
        return EntityLogType.USER_RECORD;
    }

    @Override
    public boolean isAsManager(UserRecord userRecord) {
        return !userRecord.getUser().equals((Object)this.getLoggedUser());
    }

    @Override
    public EntityLogDescriptor<UserRecordDTO> resolveLogDescriptor(UserRecord userRecord) {
        RecordFieldAction recordFieldAction = userRecord.isTransient() ? RecordFieldAction.CREATE : RecordFieldAction.EDIT;
        UserRecordType userRecordType = (UserRecordType)userRecord.getType();
        User user = userRecord.getUser();
        EntityLogDescriptor entityLogDescriptor = super.resolveLogDescriptor(userRecord).ignore((Property)UserRecordDTO.USER).customFields((Iterable)this.recordFieldHandler.getFieldsByAction(userRecordType, (BasicUser)user, recordFieldAction), this.customFieldValueHandler);
        return entityLogDescriptor;
    }

    @Override
    protected Class<UserRecordDTO> resolveDtoType() {
        return UserRecordDTO.class;
    }
}

