/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUserImage;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserImage;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.BaseOwnedImageServiceImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserLocatorVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserImageServiceImpl
extends BaseOwnedImageServiceImpl<User, UserImage, QUserImage, UserLocatorVO>
implements UserImageServiceLocal {
    @Autowired
    private UserSearchHandler userSearchHandler;

    public UserImageServiceImpl() {
        super(ImageNature.USER, User.class, UserImage.class, QUserImage.userImage, QUserImage.userImage.user());
    }

    public void addImage(User user, UserImage userImage) {
        this.doAddImage(user, userImage);
        this.userSearchHandler.index((NetworkedEntity)user);
    }

    public ImageVO getFirst(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        return (ImageVO)((DBQuery)((DBQuery)this.from(this.$).where((Predicate)((QUserImage)this.$).user().eq((Object)user))).orderBy(((QUserImage)this.$).order.asc())).singleResult(ImageVO.class, (Expression)this.$);
    }

    @Override
    protected boolean isCategoryActive(User user) {
        return !user.isRemoved();
    }

    @Override
    protected boolean isRequired(User user) {
        return this.configurationHandler.getAccessAccessor((BasicUser)user).isProfileImageRequired();
    }

    @Override
    protected boolean isTempValid(User user, TempImage tempImage) {
        if (user.isTransient()) {
            return tempImage.getTarget() == TempImageTarget.USER_REGISTRATION;
        }
        return tempImage.getTarget() == TempImageTarget.USER_PROFILE && user.equals((Object)tempImage.getUser());
    }

    @Override
    protected void onAfterRemove(UserImage userImage) {
        super.onAfterRemove(userImage);
        this.userSearchHandler.updateUserFields(userImage.getUser());
    }

    @Override
    protected void onAfterSave(UserImage userImage) {
        super.onAfterSave(userImage);
        this.userSearchHandler.updateUserFields(userImage.getUser());
    }

    @Override
    protected void onBeforeRemove(UserImage userImage) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)userImage.getUser());
        if (configurationAccessor.isProfileImageRequired() && this.count(userImage.getUser()) <= 1) {
            throw new ValidationException(this.message(SystemKeys.Images.ERROR_CANNOT_REMOVE_PROFILE_IMAGE, new Object[0]));
        }
        super.onBeforeRemove(userImage);
    }

    @Override
    protected void onOrderChanged(User user) {
        super.onOrderChanged(user);
        this.userSearchHandler.updateUserFields(user);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QUserImage)this.$).user().network());
    }

    @Override
    protected int resolveMaxImages(User user) {
        if (!this.profileFieldHandler.isEnabled((BasicUser)user, (ProfileField)BasicProfileField.IMAGE)) {
            return 0;
        }
        return this.productsHandler.getAccessor((BasicUser)user).product().getMaxProfileImages();
    }
}

