/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.app.InternalFrontendServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.UserFrontendSettingsServiceLocal;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.users.users.FrontendSettingsDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserFrontendSettingsServiceImpl
extends BaseServiceImpl
implements UserFrontendSettingsServiceLocal {
    @Autowired
    private InternalFrontendServiceLocal internalFrontendService;

    public FrontendSettingsDTO get() throws FrameworkException {
        FrontendSettingsDTO frontendSettingsDTO = new FrontendSettingsDTO();
        frontendSettingsDTO.setFrontend(this.getFrontend(null));
        return frontendSettingsDTO;
    }

    public Frontend getFrontend(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor;
        SessionData sessionData;
        if (basicUser == null) {
            sessionData = this.getSessionData();
            basicUser = sessionData.getLoggedBasicUser();
            configurationAccessor = sessionData.getConfiguration();
        } else {
            configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        }
        sessionData = null;
        if (basicUser != null && this.internalFrontendService.isAllowFrontendSwitching(basicUser)) {
            sessionData = basicUser.getFrontend();
        }
        if (sessionData == null) {
            sessionData = configurationAccessor.getFrontend();
        }
        return sessionData;
    }

    public void save(FrontendSettingsDTO frontendSettingsDTO) throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException();
        }
        basicUser.setFrontend(frontendSettingsDTO.getFrontend());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

