/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserCustomField;
import org.cyclos.entities.users.QUserCustomFieldValue;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldPossibleValue;
import org.cyclos.entities.users.UserCustomFieldPossibleValueCategory;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.UserCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.users.UserCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.fields.UserCustomFieldDTO;
import org.cyclos.model.users.fields.UserCustomFieldData;
import org.cyclos.model.users.fields.UserCustomFieldVO;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class UserCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<UserCustomField, UserCustomFieldPossibleValueCategory, UserCustomFieldPossibleValue, QUserCustomField, UserCustomFieldDTO, UserCustomFieldData, Void>
implements UserCustomFieldServiceLocal {
    @Autowired
    private UserCustomFieldPossibleValueServiceLocal userCustomFieldPossibleValueService;
    @Autowired
    private UserCustomFieldPossibleValueCategoryServiceLocal userCustomFieldPossibleValueCategoryService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    @Lazy
    private PrincipalTypeServiceLocal principalTypeService;

    public UserCustomFieldServiceImpl() {
        super(UserCustomField.class, QUserCustomField.userCustomField, UserCustomFieldDTO.class, UserCustomFieldData.class);
    }

    public boolean existsUser(UserCustomField userCustomField, String string) {
        boolean bl = false;
        Integer n = null;
        if (userCustomField.getType() == CustomFieldType.STRING) {
            bl = true;
            if (userCustomField.getPattern() != null) {
                string = MaskHelper.removeMask((String)userCustomField.getPattern(), (String)string);
            }
        } else if (userCustomField.getType() == CustomFieldType.INTEGER) {
            n = Integer.parseInt(string);
        } else {
            throw new IllegalArgumentException();
        }
        if (StringHelper.isBlank((Object)string)) {
            return false;
        }
        QUser qUser = QUser.user;
        QUserCustomFieldValue qUserCustomFieldValue = QUserCustomFieldValue.userCustomFieldValue;
        return ((DBQuery)this.from(new EntityPath[]{qUser, qUserCustomFieldValue}).where(new Predicate[]{qUser.customValues.contains((Expression)qUserCustomFieldValue), qUserCustomFieldValue.field().eq((Object)userCustomField), bl ? qUserCustomFieldValue.stringValue.eq((Object)string) : qUserCustomFieldValue.integerValue.eq((Object)n), qUser.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).hasResults();
    }

    public List<UserCustomFieldVO> list() {
        return this.conversionHandler.convertList(UserCustomFieldVO.class, this.listAll());
    }

    public List<UserCustomField> listAll() {
        return ((DBQuery)this.selectFromCacheable(this.$).orderBy(new OrderSpecifier[]{((QUserCustomField)this.$).section().order.asc().nullsFirst(), ((QUserCustomField)this.$).order.asc()})).fetch();
    }

    public List<String> listOidcClaims() {
        return ((DBQuery)((DBQuery)this.entityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QUserCustomField)this.$).oidcClaim.isNotNull())).orderBy(((QUserCustomField)this.$).oidcClaim.asc())).list((Expression)((QUserCustomField)this.$).oidcClaim);
    }

    @Override
    public UserCustomField newEntity(Void void_) {
        UserCustomField userCustomField = new UserCustomField();
        userCustomField.setPurgeValues(true);
        return userCustomField;
    }

    public void purgeValues(BasicUser basicUser) {
        QUserCustomFieldValue qUserCustomFieldValue = QUserCustomFieldValue.userCustomFieldValue;
        ((DBQuery)this.from(new EntityPath[]{qUserCustomFieldValue}).where(new Predicate[]{qUserCustomFieldValue.owner().eq((Object)basicUser), qUserCustomFieldValue.field().purgeValues.isTrue()})).stream((Expression)qUserCustomFieldValue).forEach(arg_0 -> ((CustomFieldValueHandler)this.customFieldValueHandler).remove(arg_0));
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, UserCustomFieldDTO userCustomFieldDTO) {
        super.addCustomInternalNameValidations(property, userCustomFieldDTO);
        for (BasicProfileField basicProfileField : BasicProfileField.values()) {
            property.noneOf((Collection)basicProfileField.getAliases());
        }
    }

    @Override
    protected void addCustomValidations(Validator validator, UserCustomFieldDTO userCustomFieldDTO) {
        super.addCustomValidations(validator, userCustomFieldDTO);
        if (userCustomFieldDTO.isPersistent() && !userCustomFieldDTO.isUnique()) {
            UserCustomField userCustomField = (UserCustomField)this.find(userCustomFieldDTO.getId());
            try {
                this.principalTypeService.getCustomField(userCustomField);
                validator.property((Property)CustomFieldDTO.UNIQUE, SystemKeys.Fields.UNIQUE).invalid(UsersKeys.Fields.ERROR_UNIQUE_WITH_PRINCIPAL_TYPE);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected UserCustomFieldData getData(UserCustomField userCustomField) {
        UserCustomFieldData userCustomFieldData = (UserCustomFieldData)super.getData(userCustomField);
        userCustomFieldData.setUsingOpenSearch(this.cyclosProperties.isUsingOpenSearch());
        return userCustomFieldData;
    }

    @Override
    protected Integer getMaxOrder(UserCustomField userCustomField) {
        QUserCustomField qUserCustomField = QUserCustomField.userCustomField;
        return (Integer)this.from(new EntityPath[]{qUserCustomField}).singleResult((Expression)qUserCustomField.order.max());
    }

    @Override
    protected BaseCustomFieldPossibleValueCategoryServiceLocal<UserCustomField, UserCustomFieldPossibleValueCategory, UserCustomFieldPossibleValue> getPossibleValueCategoryService() {
        return this.userCustomFieldPossibleValueCategoryService;
    }

    protected UserCustomFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.userCustomFieldPossibleValueService;
    }

    @Override
    protected List<Class<?>> getPropertyClasses() {
        return Arrays.asList(OperatorDTO.class, UserDTO.class, User.class, Operator.class);
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    @Override
    protected void onAfterRemove(UserCustomField userCustomField) {
        Long l = SimpleEntity.id((SimpleEntity)userCustomField.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QProduct.product.myProfileFields, QProduct.product.userProfileFields, QMemberProduct.memberProduct.operatorProfileFields});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
    }

    @Override
    protected void onBeforeRemove(UserCustomField userCustomField) {
        QUserCustomFieldValue qUserCustomFieldValue = QUserCustomFieldValue.userCustomFieldValue;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qUserCustomFieldValue}).where((Predicate)qUserCustomFieldValue.field().eq((Object)userCustomField))).hasResults();
        QProductMyProfileField qProductMyProfileField = QProductMyProfileField.productMyProfileField;
        boolean bl2 = ((DBQuery)this.from(new EntityPath[]{qProductMyProfileField}).where(new Predicate[]{qProductMyProfileField.customField().eq((Object)userCustomField), qProductMyProfileField.enabled.isTrue()})).hasResults();
        if (bl && bl2) {
            throw new ConstraintViolatedOnRemoveException();
        }
    }

    @Override
    protected Object onBeforeSave(UserCustomField userCustomField, UserCustomField userCustomField2) {
        if (userCustomField.getType().isBinary()) {
            userCustomField.setIncludeInExport(false);
        }
        return super.onBeforeSave(userCustomField, userCustomField2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QUserCustomField)this.$).network());
    }
}

