/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.contactinfos.AddressContactInfoDTO;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAddressEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<UserAddress, UserAddressDTO> {
    @Autowired
    private ContactInfoServiceLocal contactInfoService;
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;

    public Class<UserAddress> getEntityClass() {
        return UserAddress.class;
    }

    @Override
    public BasicUser getRelatedUser(UserAddress userAddress) {
        return userAddress.getUser();
    }

    public EntityLogType getType() {
        return EntityLogType.ADDRESS;
    }

    @Override
    public boolean isAsManager(UserAddress userAddress) {
        return !userAddress.getUser().equals((Object)this.getLoggedUser());
    }

    @Override
    public boolean isPrivateEntity(UserAddress userAddress) {
        return userAddress != null && userAddress.isHidden();
    }

    public EntityLogDescriptor<UserAddressDTO> resolveLogDescriptor(UserAddress userAddress) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(UserAddressDTO.class).property((Property)UserAddressDTO.NAME, GeneralKeys.Ui.NAME).property((Property)UserAddressDTO.HIDDEN, GeneralKeys.Ui.FIELD_VISIBILITY).property((Property)UserAddressDTO.DEFAULT_ADDRESS, UsersKeys.Addresses.DEFAULT).ignore((Property)UserAddressDTO.USER).ignore((Property)UserAddressDTO.LOCATION).ignore((Property)UserAddressDTO.LOCATED);
        User user = userAddress.getUser();
        Set set = this.configurationHandler.getAccessor((BasicUser)user).getAddressConfiguration().getEnabledAddressFields();
        for (AddressFields addressFields : AddressFields.values()) {
            Property property = AddressHelper.getDTOPropertyForField((AddressFields)addressFields);
            MessageKey messageKey = AddressHelper.resolveKey((Collection)set, (AddressFields)addressFields);
            boolean bl = set.contains(addressFields);
            entityLogDescriptor.propertyOrIgnore(property, messageKey, bl);
        }
        if (this.contactInfoService.canHaveContactInfos(user)) {
            entityLogDescriptor.nested((Property)UserAddressDTO.CONTACT_INFO).property((Property)AddressContactInfoDTO.EMAIL, UsersKeys.ContactInfos.EMAIL).property((Property)AddressContactInfoDTO.MOBILE_PHONE, UsersKeys.ContactInfos.MOBILE_PHONE).property((Property)AddressContactInfoDTO.LAND_LINE_PHONE, UsersKeys.ContactInfos.LAND_LINE_PHONE).property((Property)AddressContactInfoDTO.LAND_LINE_EXTENSION, UsersKeys.ContactInfos.LAND_LINE_EXTENSION).ignore((Property)AddressContactInfoDTO.CUSTOM_VALUES).customFields((Iterable)this.contactInfoFieldService.listEnabled(user), this.customFieldValueHandler).addNested();
        } else {
            entityLogDescriptor.ignore((Property)UserAddressDTO.CONTACT_INFO);
        }
        return entityLogDescriptor;
    }

    @Override
    protected UserAddress getEntityToViewLog(long l) {
        return this.find(UserAddress.class, l);
    }
}

