/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QUserAccount;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QReference;
import org.cyclos.entities.users.QTransactionFeedback;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.TransactionFeedback;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.postgresql.PostgresqlTransactionSearchHandlerImpl;
import org.cyclos.impl.users.BaseReferenceServiceImpl;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.TransactionFeedbackReminderRecurringTask;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.BasePaymentData;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.references.ReferenceDTO;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.references.TransactionFeedbackDTO;
import org.cyclos.model.users.references.TransactionFeedbackData;
import org.cyclos.model.users.references.TransactionFeedbackEntryVO;
import org.cyclos.model.users.references.TransactionFeedbackQuery;
import org.cyclos.model.users.references.TransactionFeedbackSearchData;
import org.cyclos.model.users.references.TransactionFeedbackSetting;
import org.cyclos.model.users.references.TransactionFeedbackStatus;
import org.cyclos.model.users.references.TransactionFeedbackUpdateDTO;
import org.cyclos.model.users.references.TransactionFeedbackVO;
import org.cyclos.model.users.references.TransactionsAwaitingFeedbackQuery;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionFeedbackServiceImpl
extends BaseReferenceServiceImpl<TransactionFeedback, QTransactionFeedback, TransactionFeedbackDTO, TransactionFeedbackEntryVO, TransactionFeedbackQuery, TransactionFeedbackData, TransactionVO>
implements TransactionFeedbackServiceLocal {
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ProductServiceLocal productService;

    public TransactionFeedbackServiceImpl() {
        super(TransactionFeedback.class, QTransactionFeedback.transactionFeedback, QTransactionFeedback.transactionFeedback._super, TransactionFeedbackDTO.class, TransactionFeedbackEntryVO.class);
    }

    public void cancelAll(UserAccount userAccount) throws FrameworkException {
        CloseableIterator<BasePayment> closeableIterator = this.iterateTransactionsAwaitingFeedback(userAccount);
        this.processBatch(closeableIterator, (T basePayment) -> {
            TransactionFeedbackStatus transactionFeedbackStatus = TransactionFeedbackStatus.CANCELED;
            ReferenceLevel referenceLevel = ReferenceLevel.NA;
            String string = this.message(UsersKeys.References.CANCELED_COMMENT, new Object[0]);
            Date date = DateHelper.now();
            TransactionFeedback transactionFeedback = new TransactionFeedback();
            transactionFeedback.setDate(date);
            transactionFeedback.setExpirationDate(date);
            transactionFeedback.setFrom(basePayment.getFromUser());
            transactionFeedback.setTo(basePayment.getToUser());
            transactionFeedback.setTransaction(basePayment);
            transactionFeedback.setLevel(referenceLevel);
            transactionFeedback.setStatus(transactionFeedbackStatus);
            transactionFeedback.setComments(string);
            this.persist((IEntity)transactionFeedback);
            basePayment.setFeedback(transactionFeedback);
        });
    }

    public boolean canComment(BasePayment basePayment) {
        if (!this.isFeedbackEnabled(basePayment)) {
            return false;
        }
        PaymentTransferType paymentTransferType = basePayment.getPaymentType();
        TransactionFeedback transactionFeedback = basePayment.getFeedback();
        String string = null;
        String string2 = null;
        Date date = null;
        if (transactionFeedback != null) {
            string = transactionFeedback.getComments();
            date = transactionFeedback.getInitialDate();
            string2 = transactionFeedback.getReplyComments();
        }
        Date date2 = DateHelper.now();
        if (!basePayment.isAuthorized() || !basePayment.getFromUser().equals((Object)this.getLoggedUser()) || StringHelper.isNotBlank((Object)string2)) {
            return false;
        }
        if (StringHelper.isBlank((Object)string)) {
            Date date3 = basePayment.getProcessDate();
            Date date4 = DateHelper.add((Date)date3, (TimeField)TimeField.DAYS, (int)paymentTransferType.getFeedbackExpirationDays());
            return date2.before(date4);
        }
        if (date != null) {
            Date date5 = DateHelper.add((Date)date, (TimeField)TimeField.DAYS, (int)paymentTransferType.getMaxDaysToChangeFeedback());
            return date2.before(date5);
        }
        return false;
    }

    public boolean canReply(BasePayment basePayment) {
        if (!this.isFeedbackEnabled(basePayment)) {
            return false;
        }
        TransactionFeedback transactionFeedback = basePayment.getFeedback();
        if (transactionFeedback == null || this.canComment(basePayment) || !basePayment.getToUser().equals((Object)this.getLoggedUser()) || StringHelper.isNotBlank((Object)transactionFeedback.getReplyComments()) || StringHelper.isBlank((Object)transactionFeedback.getComments())) {
            return false;
        }
        PaymentTransferType paymentTransferType = basePayment.getPaymentType();
        Integer n = paymentTransferType.getFeedbackReplyExpirationDays();
        if (n != null) {
            Date date = (Date)ObjectHelper.defaultValue((Object)transactionFeedback.getInitialDate(), (Object)transactionFeedback.getExpirationDate());
            Date date2 = DateHelper.add((Date)date, (TimeField)TimeField.DAYS, (int)n);
            return DateHelper.now().before(date2);
        }
        return true;
    }

    public Long comment(TransactionVO transactionVO, ReferenceLevel referenceLevel, String string) throws FrameworkException, IllegalActionException {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (!this.canComment(basePayment)) {
            throw new IllegalActionException("Feedback cannot receive comments");
        }
        TransactionFeedback transactionFeedback = basePayment.getFeedback();
        String string2 = null;
        Date date = DateHelper.now();
        if (transactionFeedback == null) {
            transactionFeedback = new TransactionFeedback();
            transactionFeedback.setTransaction(basePayment);
            transactionFeedback.setStatus(TransactionFeedbackStatus.GIVEN);
            transactionFeedback.setInitialDate(date);
            transactionFeedback.setFrom(basePayment.getFromUser());
            transactionFeedback.setTo(basePayment.getToUser());
        } else {
            string2 = transactionFeedback.getComments();
        }
        transactionFeedback.setLevel(referenceLevel);
        transactionFeedback.setDate(date);
        transactionFeedback.setComments(string);
        Validator validator = new Validator();
        validator.property((Property)ReferenceDTO.COMMENTS, UsersKeys.References.COMMENTS).required();
        validator.property((Property)ReferenceDTO.LEVEL, UsersKeys.References.LEVEL).required().anyOf(this.getReferenceLevels());
        this.validate(validator, transactionFeedback, "comment");
        boolean bl = transactionFeedback.isTransient();
        if (bl) {
            this.persist((IEntity)transactionFeedback);
            basePayment.setFeedback(transactionFeedback);
        }
        this.sendFeedbackGivenNotification(transactionFeedback, string2);
        return transactionFeedback.getId();
    }

    public TransactionFeedback createExpiredFeedback(BasePayment basePayment) throws FrameworkException {
        String string;
        ReferenceLevel referenceLevel;
        TransactionFeedbackStatus transactionFeedbackStatus;
        PaymentTransferType paymentTransferType = (PaymentTransferType)basePayment.getType();
        User user = basePayment.getFromUser();
        User user2 = basePayment.getToUser();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        if (paymentTransferType.getFeedbackSetting() != TransactionFeedbackSetting.OPTIONAL && productsAccessor.product().hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE) && !user.getIgnoreFeedback().contains(user2)) {
            transactionFeedbackStatus = TransactionFeedbackStatus.DEFAULT;
            referenceLevel = paymentTransferType.getDefaultFeedbackLevel();
            string = this.getTranslatedValue((BaseEntity)paymentTransferType, QPaymentTransferType.paymentTransferType.defaultFeedbackComments);
        } else {
            transactionFeedbackStatus = TransactionFeedbackStatus.CANCELED;
            referenceLevel = ReferenceLevel.NA;
            string = this.message(UsersKeys.References.CANCELED_COMMENT, new Object[0]);
        }
        Date date = DateHelper.now();
        TransactionFeedback transactionFeedback = new TransactionFeedback();
        transactionFeedback.setDate(date);
        transactionFeedback.setExpirationDate(date);
        transactionFeedback.setFrom(user);
        transactionFeedback.setTo(user2);
        transactionFeedback.setTransaction(basePayment);
        transactionFeedback.setLevel(referenceLevel);
        transactionFeedback.setStatus(transactionFeedbackStatus);
        transactionFeedback.setComments(string);
        this.persist((IEntity)transactionFeedback);
        basePayment.setFeedback(transactionFeedback);
        return transactionFeedback;
    }

    public TransactionFeedbackData getDataFromTransaction(TransactionVO transactionVO) {
        TransactionFeedback transactionFeedback = this.readPaymentAsSystemAndGetFeedback(transactionVO);
        return this.getData(transactionFeedback);
    }

    public TransactionFeedbackData getGiveData(TransactionVO transactionVO) {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (!basePayment.getFromOwner().equals((Object)this.getLoggedUser()) || !this.isFeedbackEnabled(basePayment)) {
            throw new IllegalActionException();
        }
        return (TransactionFeedbackData)this.getDataForNew(transactionVO);
    }

    public TransactionFeedbackData getReplyData(TransactionVO transactionVO) {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (basePayment.getFeedback() == null || !basePayment.getToOwner().equals((Object)this.getLoggedUser()) || !this.isFeedbackEnabled(basePayment)) {
            throw new IllegalActionException();
        }
        return this.getData(basePayment.getFeedback());
    }

    public TransactionFeedbackSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        TransactionFeedbackSearchData transactionFeedbackSearchData = new TransactionFeedbackSearchData();
        transactionFeedbackSearchData.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        transactionFeedbackSearchData.setReferenceLevels(this.getReferenceLevels());
        TransactionFeedbackQuery transactionFeedbackQuery = (TransactionFeedbackQuery)QueryHelper.newQuery(TransactionFeedbackQuery.class);
        transactionFeedbackQuery.setOwner(new UserLocatorVO(user.getId()));
        transactionFeedbackQuery.setActive(true);
        transactionFeedbackSearchData.setQuery((QueryParameters)transactionFeedbackQuery);
        return transactionFeedbackSearchData;
    }

    public TransactionFeedbackVO getTransactionFeedback(TransactionVO transactionVO) throws FrameworkException {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (!this.isFeedbackEnabled(basePayment)) {
            throw new IllegalActionException();
        }
        return (TransactionFeedbackVO)this.conversionHandler.convert(TransactionFeedbackVO.class, (Object)basePayment.getFeedback());
    }

    public boolean hasTransactionFeedbacks(User user) {
        TransactionFeedbackQuery transactionFeedbackQuery = new TransactionFeedbackQuery();
        transactionFeedbackQuery.setOwner(new UserLocatorVO(user.getId()));
        return this.createSearchQuery(transactionFeedbackQuery).hasResults();
    }

    public boolean isFeedbackEnabled(BasePayment basePayment) {
        PaymentTransferType paymentTransferType = basePayment.getPaymentType();
        return paymentTransferType.getDirection() == TransferTypeDirection.USER_TO_USER && paymentTransferType.isRequiresFeedback();
    }

    public List<UserVO> listIgnoredUsers() throws FrameworkException {
        User user = this.getLoggedUser();
        if (user == null) {
            return Collections.emptyList();
        }
        QUser qUser = new QUser("o");
        QUser qUser2 = new QUser("u");
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qUser}).innerJoin((CollectionExpression)qUser.ignoreFeedback, (Path)qUser2)).where((Predicate)qUser.id.eq((Object)user.getId()))).orderBy(qUser2.name.asc())).list(UserVO.class, (Expression)qUser2);
    }

    public boolean markAsIgnored(UserLocatorVO userLocatorVO, boolean bl) throws FrameworkException {
        User user = this.getLoggedUser();
        User user2 = this.userLocatorHandler.locate(userLocatorVO).getUser();
        if (user2.equals((Object)user)) {
            throw new IllegalActionException();
        }
        if (bl) {
            return user.getIgnoreFeedback().add(user2);
        }
        return user.getIgnoreFeedback().remove(user2);
    }

    @Override
    public TransactionFeedback newEntity(TransactionVO transactionVO) {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (!basePayment.getFromOwner().equals((Object)this.getLoggedUser()) || !this.isFeedbackEnabled(basePayment)) {
            throw new IllegalActionException();
        }
        if (basePayment.getFeedback() != null) {
            return basePayment.getFeedback();
        }
        TransactionFeedback transactionFeedback = new TransactionFeedback();
        transactionFeedback.setTransaction(basePayment);
        transactionFeedback.setFrom(this.getLoggedUser());
        transactionFeedback.setTo(basePayment.getToUser());
        transactionFeedback.setLevel(ReferenceLevel.NEUTRAL);
        return transactionFeedback;
    }

    public void notifyTransactionFeedback(PaymentTransferType paymentTransferType) {
        if (paymentTransferType.isRequiresFeedback() && paymentTransferType.getFeedbackReminderDays() == 0) {
            this.recurringTaskHandler.scheduleAwake(TransactionFeedbackReminderRecurringTask.class);
        }
    }

    public TransactionFeedback readPaymentAsSystemAndGetFeedback(TransactionVO transactionVO) throws EntityNotFoundException {
        BasePayment basePayment = (BasePayment)this.invokerHandler.runAs(SessionDataFactory.system(), () -> (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO));
        if (basePayment.getFeedback() == null) {
            throw new EntityNotFoundException(TransactionFeedback.class);
        }
        return basePayment.getFeedback();
    }

    public void removeFromTransaction(TransactionVO transactionVO) {
        TransactionFeedback transactionFeedback = this.readPaymentAsSystemAndGetFeedback(transactionVO);
        this.remove(transactionFeedback.getId());
    }

    public Long reply(TransactionVO transactionVO, String string) throws FrameworkException, IllegalActionException {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (!this.canReply(basePayment)) {
            throw new IllegalActionException("Feedback cannot be replied");
        }
        TransactionFeedback transactionFeedback = basePayment.getFeedback();
        Date date = DateHelper.now();
        transactionFeedback.setReplyCommentsDate(date);
        transactionFeedback.setReplyComments(string);
        Validator validator = new Validator();
        validator.property((Property)TransactionFeedbackDTO.REPLY_COMMENTS, UsersKeys.References.REPLY_COMMENTS).required();
        this.validate(validator, transactionFeedback, "reply");
        this.notificationHandler.user((BasicUser)transactionFeedback.getFrom()).feedbackAndReference().feedbackReplyCreated(transactionFeedback, transactionFeedback.getTo());
        return transactionFeedback.getId();
    }

    public Page<TransactionResultVO> searchTransactionsAwaitingFeedback(TransactionsAwaitingFeedbackQuery transactionsAwaitingFeedbackQuery) {
        User user = transactionsAwaitingFeedbackQuery.getFrom() == null ? this.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)transactionsAwaitingFeedbackQuery.getFrom());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)transactionsAwaitingFeedbackQuery.getTo());
        QBasePayment qBasePayment = QBasePayment.basePayment;
        QAccount qAccount = QAccount.account;
        QAccount qAccount2 = new QAccount("to");
        QUser qUser = new QUser("toUser");
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        QTransactionFeedback qTransactionFeedback = QTransactionFeedback.transactionFeedback;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qBasePayment}).leftJoin((EntityPath)qBasePayment.type(), (Path)qPaymentTransferType._super)).leftJoin((EntityPath)qBasePayment.from(), (Path)qAccount)).leftJoin((EntityPath)qBasePayment.to(), (Path)qAccount2)).leftJoin((EntityPath)qAccount2.user(), (Path)qUser)).leftJoin((CollectionExpression)qBasePayment.feedbacks, (Path)qTransactionFeedback)).where(new Predicate[]{qTransactionFeedback.id.isNull(), qAccount.user().eq((Object)user), user2 == null ? qBasePayment.id.isNotNull() : qAccount2.user().eq((Object)user2), qPaymentTransferType.requiresFeedback.isTrue(), qBasePayment.authorizationStatus.in((Object[])new TransactionAuthorizationStatus[]{TransactionAuthorizationStatus.NA, TransactionAuthorizationStatus.AUTHORIZED}), user.getIgnoreFeedback().isEmpty() ? qBasePayment.id.isNotNull() : qAccount2.user().notIn((Collection)user.getIgnoreFeedback()), this.productService.permissionQuery(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE}).apply(qUser)})).orderBy(qBasePayment.date.desc());
        Page page = dBQuery.page((QueryParameters)transactionsAwaitingFeedbackQuery, (Expression)qBasePayment);
        return PageImpl.transformed((Page)page, basePayment -> PostgresqlTransactionSearchHandlerImpl.toResult(this.getSessionData(), (InternalAccountOwner)user, (Transaction)basePayment, this.conversionHandler, this.dataTranslationHandler, null, null));
    }

    public void setFeedbackData(BasePayment basePayment, BasePaymentData basePaymentData) {
        basePaymentData.setFeedback((TransactionFeedbackVO)this.conversionHandler.convert(TransactionFeedbackVO.class, (Object)basePayment.getFeedback()));
        basePaymentData.setCanViewFeedback(this.isFeedbackEnabled(basePayment));
        basePaymentData.setCanGiveFeedback(this.canComment(basePayment));
        basePaymentData.setCanReplyFeedback(this.canReply(basePayment));
    }

    @Override
    public TransactionFeedbackDTO toDTO(TransactionFeedback transactionFeedback) {
        TransactionFeedbackDTO transactionFeedbackDTO = (TransactionFeedbackDTO)super.toDTO(transactionFeedback);
        QUser qUser = QUser.user;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qUser}).where((Predicate)qUser.id.eq((Object)transactionFeedback.getFrom().getId()).and((Predicate)qUser.ignoreFeedback.contains((Object)transactionFeedback.getTo())));
        transactionFeedbackDTO.setNotSendNotification(dBQuery.hasResults());
        if (!this.getLoggedUser().isUserManager()) {
            transactionFeedbackDTO.setAdminComments(null);
            transactionFeedbackDTO.setAdminCommentsDate(null);
        }
        return transactionFeedbackDTO;
    }

    public void updateFeedbackFromTransaction(TransactionVO transactionVO, TransactionFeedbackUpdateDTO transactionFeedbackUpdateDTO) throws FrameworkException {
        TransactionFeedback transactionFeedback = this.readPaymentAsSystemAndGetFeedback(transactionVO);
        TransactionFeedbackDTO transactionFeedbackDTO = (TransactionFeedbackDTO)this.load(transactionFeedback.getId());
        transactionFeedbackDTO.setAdminComments(transactionFeedbackUpdateDTO.getAdminComments());
        transactionFeedbackDTO.setComments(transactionFeedbackUpdateDTO.getComments());
        transactionFeedbackDTO.setLevel(transactionFeedbackUpdateDTO.getLevel());
        transactionFeedbackDTO.setReplyComments(transactionFeedbackUpdateDTO.getReplyComments());
        transactionFeedbackDTO.setVersion(transactionFeedbackUpdateDTO.getVersion());
        this.save(transactionFeedbackDTO);
    }

    @Override
    protected DBQuery<?> crateStatisticsQuery(User user, ReferenceType referenceType, DatePeriod datePeriod) {
        return (DBQuery)super.crateStatisticsQuery(user, referenceType, datePeriod).where((Predicate)((QTransactionFeedback)this.$).status.ne((Object)TransactionFeedbackStatus.CANCELED));
    }

    @Override
    protected DBQuery<?> createSearchQuery(TransactionFeedbackQuery transactionFeedbackQuery) {
        DBQuery<?> dBQuery = super.createSearchQuery(transactionFeedbackQuery);
        if (transactionFeedbackQuery.isActive()) {
            dBQuery.where((Predicate)((QTransactionFeedback)this.$).status.ne((Object)TransactionFeedbackStatus.CANCELED));
        }
        if (transactionFeedbackQuery.isNoReplied()) {
            dBQuery.where((Predicate)((QTransactionFeedback)this.$).replyComments.isNull());
        }
        return dBQuery;
    }

    @Override
    protected void doRemove(TransactionFeedback transactionFeedback, boolean bl) {
        transactionFeedback.setLevel(ReferenceLevel.NA);
        transactionFeedback.setComments(this.message(UsersKeys.References.CANCELED_COMMENT, new Object[0]));
        transactionFeedback.setStatus(TransactionFeedbackStatus.CANCELED);
        if (bl) {
            this.flush();
        }
    }

    @Override
    protected TransactionFeedbackData getData(TransactionFeedback transactionFeedback) {
        TransactionFeedbackData transactionFeedbackData = new TransactionFeedbackData();
        transactionFeedbackData.setDto((EntityDTO)this.toDTO(transactionFeedback));
        this.fillForComment(transactionFeedback, transactionFeedbackData);
        this.fillForReply(transactionFeedback, transactionFeedbackData);
        transactionFeedbackData.setTransaction((TransactionVO)this.conversionHandler.convert(TransactionVO.class, (Object)transactionFeedback.getTransaction()));
        transactionFeedbackData.setTransactionId(transactionFeedback.getTransaction().getId().longValue());
        transactionFeedbackData.setReferenceLevels(this.getReferenceLevels());
        return transactionFeedbackData;
    }

    @Override
    protected void onAfterSave(TransactionFeedback transactionFeedback, TransactionFeedback transactionFeedback2, Object object) {
        this.sendFeedbackGivenNotification(transactionFeedback, transactionFeedback2.getComments());
    }

    @Override
    protected Object onBeforeSave(TransactionFeedback transactionFeedback, TransactionFeedback transactionFeedback2) {
        if (transactionFeedback2 == null) {
            throw new IllegalActionException("This method is intended for update. Current copy can't be null");
        }
        transactionFeedback.setAdminCommentsDate(DateHelper.now());
        return null;
    }

    @Override
    protected QReference ref() {
        return ((QTransactionFeedback)this.$)._super;
    }

    @Override
    protected Validator resolveValidator(TransactionFeedbackDTO transactionFeedbackDTO) {
        Validator validator = new Validator();
        validator.property((Property)TransactionFeedbackDTO.COMMENTS, UsersKeys.References.COMMENTS).required().maxLength(2048);
        validator.property((Property)TransactionFeedbackDTO.LEVEL, UsersKeys.References.LEVEL).required().anyOf(this.getReferenceLevels());
        validator.property((Property)TransactionFeedbackDTO.FROM, UsersKeys.References.FROM).required();
        validator.property((Property)TransactionFeedbackDTO.TO, UsersKeys.References.TO).required();
        return validator;
    }

    @Override
    protected TransactionFeedbackEntryVO toSearchResultEntry(TransactionFeedback transactionFeedback) {
        TransactionFeedbackEntryVO transactionFeedbackEntryVO = (TransactionFeedbackEntryVO)super.toSearchResultEntry(transactionFeedback);
        transactionFeedbackEntryVO.setTransactionId(transactionFeedbackEntryVO.getTransaction().getId().longValue());
        return transactionFeedbackEntryVO;
    }

    private void fillForComment(TransactionFeedback transactionFeedback, TransactionFeedbackData transactionFeedbackData) {
        BasePayment basePayment = transactionFeedback.getTransaction();
        if (!this.canComment(basePayment)) {
            transactionFeedbackData.setCanComment(false);
            return;
        }
        transactionFeedbackData.setCanComment(true);
        PaymentTransferType paymentTransferType = basePayment.getPaymentType();
        if (StringHelper.isBlank((Object)transactionFeedback.getComments())) {
            Date date = DateHelper.add((Date)basePayment.getProcessDate(), (TimeField)TimeField.DAYS, (int)paymentTransferType.getFeedbackExpirationDays());
            transactionFeedbackData.setDateLimit(this.toDateTime(date));
            if (!DateHelper.now().before(date) && transactionFeedback.getExpirationDate() == null) {
                TransactionFeedbackDTO transactionFeedbackDTO = (TransactionFeedbackDTO)transactionFeedbackData.getDto();
                transactionFeedbackDTO.setDate(transactionFeedbackData.getDateLimit());
                transactionFeedbackDTO.setComments(this.getTranslatedValue((BaseEntity)paymentTransferType, QPaymentTransferType.paymentTransferType.defaultFeedbackComments));
                transactionFeedbackDTO.setLevel(paymentTransferType.getDefaultFeedbackLevel());
            }
        } else {
            Date date = DateHelper.add((Date)transactionFeedback.getInitialDate(), (TimeField)TimeField.DAYS, (int)paymentTransferType.getMaxDaysToChangeFeedback());
            transactionFeedbackData.setDateLimit(this.toDateTime(date));
        }
    }

    private void fillForReply(TransactionFeedback transactionFeedback, TransactionFeedbackData transactionFeedbackData) {
        BasePayment basePayment = transactionFeedback.getTransaction();
        if (!this.canReply(basePayment)) {
            transactionFeedbackData.setCanReply(false);
            return;
        }
        transactionFeedbackData.setCanReply(true);
        PaymentTransferType paymentTransferType = basePayment.getPaymentType();
        Integer n = paymentTransferType.getFeedbackReplyExpirationDays();
        if (n != null) {
            Date date = (Date)ObjectHelper.defaultValue((Object)transactionFeedback.getInitialDate(), (Object)transactionFeedback.getExpirationDate());
            Date date2 = DateHelper.add((Date)date, (TimeField)TimeField.DAYS, (int)n);
            transactionFeedbackData.setDateLimit(this.toDateTime(date2));
        }
    }

    private CloseableIterator<BasePayment> iterateTransactionsAwaitingFeedback(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return CloseableIteratorHelper.empty();
        }
        QBasePayment qBasePayment = QBasePayment.basePayment;
        QUserAccount qUserAccount = QUserAccount.userAccount;
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        QTransactionFeedback qTransactionFeedback = QTransactionFeedback.transactionFeedback;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qBasePayment}).innerJoin((EntityPath)qBasePayment.type(), (Path)qPaymentTransferType._super)).innerJoin((EntityPath)qBasePayment.from(), (Path)qUserAccount._super)).where(new Predicate[]{((DBQuery)this.subQuery(new EntityPath[]{qTransactionFeedback}).where((Predicate)qTransactionFeedback.transaction().eq((Expression)qBasePayment))).notExists(), qPaymentTransferType.requiresFeedback.isTrue(), qBasePayment.from().eq((Object)userAccount).or((Predicate)qBasePayment.to().eq((Object)userAccount))})).iterate((Expression)qBasePayment);
    }

    private void sendFeedbackGivenNotification(TransactionFeedback transactionFeedback, String string) {
        if (!Objects.equals(transactionFeedback.getComments(), string)) {
            if (StringHelper.isBlank((Object)string)) {
                this.notificationHandler.user((BasicUser)transactionFeedback.getTo()).feedbackAndReference().feedbackCreated(transactionFeedback, transactionFeedback.getFrom());
            } else {
                this.notificationHandler.user((BasicUser)transactionFeedback.getTo()).feedbackAndReference().feedbackChanged(transactionFeedback, transactionFeedback.getFrom());
            }
        }
    }
}

