/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.dsl.NumberPath;
import java.util.Date;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.users.AbstractTransactionFeedbackNotificationRecurringTask;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.users.references.TransactionFeedbackSetting;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Component;

@Component
public class TransactionFeedbackReminderRecurringTask
extends AbstractTransactionFeedbackNotificationRecurringTask {
    public TransactionFeedbackReminderRecurringTask() {
        super((NumberPath<Integer>)QPaymentTransferType.paymentTransferType.feedbackReminderDays, QBasePayment.basePayment.feedbackReminderNotified);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.TRANSACTION_FEEDBACK_REMINDER;
    }

    @Override
    protected void finish(BasePayment basePayment, Throwable throwable) throws Throwable {
        basePayment.setFeedbackReminderNotified(Boolean.valueOf(true));
    }

    @Override
    protected void notifyTransactionProcessed(BasePayment basePayment, Date date) {
        if (!DateHelper.now().after(date)) {
            boolean bl;
            PaymentTransferType paymentTransferType = (PaymentTransferType)basePayment.getType();
            TransactionFeedbackSetting transactionFeedbackSetting = paymentTransferType.getFeedbackSetting();
            if (basePayment.getCreationType() == PaymentCreationType.ORDER) {
                bl = transactionFeedbackSetting == TransactionFeedbackSetting.OPTIONAL;
            } else {
                boolean bl2 = bl = transactionFeedbackSetting == TransactionFeedbackSetting.OPTIONAL || transactionFeedbackSetting == TransactionFeedbackSetting.WEB_SHOP_REQUIRED;
            }
            if (bl) {
                this.notificationHandler.user((BasicUser)basePayment.getFromUser()).feedbackAndReference().feedbackOptional((Transaction)basePayment, basePayment.getToUser(), date);
            } else {
                this.notificationHandler.user((BasicUser)basePayment.getFromUser()).feedbackAndReference().feedbackRequired((Transaction)basePayment, basePayment.getToUser(), date);
            }
        }
    }
}

