/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductSystemRecordType;
import org.cyclos.entities.users.QProductUserRecordType;
import org.cyclos.entities.users.QRecordType;
import org.cyclos.entities.users.QRecordTypeSharedRecordField;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.users.QUserRecord;
import org.cyclos.entities.users.QUserRecordType;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.recordsections.RecordSectionVO;
import org.cyclos.model.users.recordtypes.RecordTypeDTO;
import org.cyclos.model.users.recordtypes.RecordTypeData;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.recordtypes.SystemRecordTypeDTO;
import org.cyclos.model.users.recordtypes.UserRecordTypeDTO;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordTypeServiceImpl
extends CRUDServiceImpl<RecordType, QRecordType, RecordTypeDTO, RecordTypeData, RecordTypeNature>
implements RecordTypeServiceLocal {
    private static final BidiMap<Class<? extends RecordType>, Class<? extends RecordTypeDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private RecordCustomFieldServiceLocal recordCustomFieldService;
    @Autowired
    private RecordServiceLocal recordService;

    public RecordTypeServiceImpl() {
        super(RecordType.class, QRecordType.recordType, RecordTypeDTO.class);
    }

    public List<RecordTypeVO> list() {
        return this.conversionHandler.convertList(RecordTypeVO.class, this.listRecordTypes());
    }

    public List<UserRecordType> listEnabled(User user) {
        if (user == null) {
            user = this.getSessionData().getLoggedUser();
        }
        if (user == null) {
            return Collections.emptyList();
        }
        if (user.isRemoved()) {
            QUserRecord qUserRecord = QUserRecord.userRecord;
            QUserRecordType qUserRecordType = QUserRecordType.userRecordType;
            DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qUserRecord}).join((EntityPath)qUserRecord.type(), (Path)qUserRecordType._super);
            dBQuery.where((Predicate)qUserRecord.user().id.eq((Object)user.getId()));
            return ((DBQuery)dBQuery.distinct()).list((Expression)qUserRecordType);
        }
        ArrayList<UserRecordType> arrayList = new ArrayList<UserRecordType>();
        BooleanPropertiesHolder booleanPropertiesHolder = this.productsHandler.getAccessor((BasicUser)user).product().getMyRecordTypes();
        for (Map.Entry entry : booleanPropertiesHolder.entries()) {
            BooleanProperties booleanProperties = (BooleanProperties)entry.getValue();
            if (!booleanProperties.isSet((Path)QProductMyRecordType.productMyRecordType.enabled)) continue;
            arrayList.add((UserRecordType)entry.getKey());
        }
        return arrayList;
    }

    public List<RecordType> listRecordTypes() {
        return ((DBQuery)this.from().orderBy(((QRecordType)this.$).name.asc())).list(RecordType.class, (Expression)this.$);
    }

    public List<RecordTypeVO> listRecordTypesForGeneralSearch() throws FrameworkException {
        return this.conversionHandler.convertList(RecordTypeVO.class, this.listVisibleUserTypes());
    }

    public List<UserRecordType> listVisibleMyTypes() throws FrameworkException {
        BooleanPropertiesHolder booleanPropertiesHolder = this.getProducts().product().getMyRecordTypes();
        return this.listFromProducts(booleanPropertiesHolder, QProductMyRecordType.productMyRecordType.view);
    }

    public List<UserRecordType> listVisibleSharedRecordTypes() {
        return this.listVisibleUserTypes().stream().filter(userRecordType -> CollectionHelper.isNotEmpty((Iterable)userRecordType.getSharedFields())).collect(Collectors.toList());
    }

    public List<SystemRecordType> listVisibleSystemTypes() throws FrameworkException {
        BooleanPropertiesHolder booleanPropertiesHolder = this.getProducts().admin().getSystemRecordTypes();
        return this.listFromProducts(booleanPropertiesHolder, QProductSystemRecordType.productSystemRecordType.view);
    }

    public List<UserRecordType> listVisibleUserTypes() throws FrameworkException {
        BooleanPropertiesHolder booleanPropertiesHolder = this.getProducts().userManagement().getUserRecordTypes();
        return this.listFromProducts(booleanPropertiesHolder, QProductUserRecordType.productUserRecordType.view);
    }

    @Override
    public RecordType newEntity(RecordTypeNature recordTypeNature) {
        switch (recordTypeNature) {
            case SYSTEM: {
                return new SystemRecordType();
            }
            case USER: {
                UserRecordType userRecordType = new UserRecordType();
                userRecordType.setPurgeRecords(true);
                return userRecordType;
            }
        }
        throw new IllegalStateException("Unhandled record type nature: " + String.valueOf(recordTypeNature));
    }

    @Override
    protected RecordTypeData getData(RecordType recordType) {
        RecordTypeData recordTypeData = new RecordTypeData();
        recordTypeData.setDto((EntityDTO)((RecordTypeDTO)this.toDTO(recordType)));
        if (recordType.isPersistent()) {
            recordTypeData.setSections(this.conversionHandler.convertList(RecordSectionVO.class, (Iterable)recordType.getSections()));
            recordTypeData.setCustomFields(this.recordCustomFieldService.list(new RecordTypeVO(recordType.getId())));
            recordTypeData.setCanChangeToSingleForm(this.recordService.canChangeToSingleForm(recordType));
            recordTypeData.setAllSharedCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.recordCustomFieldService.listShared()));
            recordTypeData.setSortFields(this.recordCustomFieldService.list(new RecordTypeVO(recordType.getId())));
            recordTypeData.getSortFields().removeIf(recordCustomFieldVO -> !recordCustomFieldVO.getType().isSortable());
        } else {
            recordTypeData.setCanChangeToSingleForm(true);
        }
        return recordTypeData;
    }

    @Override
    protected void onAfterRemove(RecordType recordType) {
        Long l = SimpleEntity.id((SimpleEntity)recordType.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QProduct.product.myRecordTypes, QAdminProduct.adminProduct.systemRecordTypes, QUserManagementProduct.userManagementProduct.userRecordTypes});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
    }

    @Override
    protected Object onBeforeSave(RecordType recordType, RecordType recordType2) {
        if (recordType2 != null && recordType.getResultsLayout() != recordType2.getResultsLayout() && recordType.getResultsLayout() == RecordTypeResultsLayout.SINGLE_FORM && !this.recordService.canChangeToSingleForm(recordType2)) {
            throw new IllegalActionException();
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QRecordType)this.$).network());
        networkPathRegistry.register(QRecordTypeSharedRecordField.recordTypeSharedRecordField.recordType().network());
    }

    @Override
    protected Validator resolveValidator(RecordTypeDTO recordTypeDTO) {
        Validator validator = new Validator();
        validator.property((Property)RecordTypeDTO.PLURAL_NAME, UsersKeys.RecordTypes.PLURAL_NAME).required().maxLength(100);
        validator.property(RecordTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        validator.property((Property)RecordTypeDTO.RESULTS_LAYOUT, UsersKeys.RecordTypes.RESULTS_LAYOUT).required();
        validator.property((Property)RecordTypeDTO.FIELD_COLUMNS, UsersKeys.RecordTypes.FIELD_COLUMNS).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
        if (recordTypeDTO instanceof SystemRecordTypeDTO) {
            validator.property((Property)SystemRecordTypeDTO.ADMIN_MENU, UsersKeys.RecordTypes.MENU).required();
        } else if (recordTypeDTO instanceof SystemRecordTypeDTO) {
            validator.property((Property)UserRecordTypeDTO.USER_MENU, UsersKeys.RecordTypes.MENU).required();
            validator.property((Property)UserRecordTypeDTO.PROFILE_SECTION, UsersKeys.RecordTypes.PROFILE_SECTION).required();
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends RecordType>, Class<? extends RecordTypeDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private <RT extends RecordType, DTO> List<RT> listFromProducts(BooleanPropertiesHolder<RT> booleanPropertiesHolder, BooleanPath booleanPath) {
        return CollectionHelper.sort((Collection)booleanPropertiesHolder.keysSet((Path)booleanPath));
    }

    static {
        SUBCLASS_MAPPINGS.put(SystemRecordType.class, SystemRecordTypeDTO.class);
        SUBCLASS_MAPPINGS.put(UserRecordType.class, UserRecordTypeDTO.class);
    }
}

