/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.recordtypes.RecordTypeDTO;
import org.cyclos.model.users.recordtypes.SystemRecordTypeDTO;
import org.cyclos.model.users.recordtypes.UserRecordTypeDTO;
import org.cyclos.security.users.RecordTypeServiceSecurity;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RecordTypeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<RecordType, RecordTypeDTO> {
    @Autowired
    @Lazy
    private RecordTypeServiceSecurity recordTypeServiceSecurity;

    public Class<RecordType> getEntityClass() {
        return RecordType.class;
    }

    public EntityLogType getType() {
        return EntityLogType.RECORD_TYPE;
    }

    @Override
    public Pair<Object, Object> getValues(RecordType recordType, RecordType recordType2, PropertyLogDescriptor<RecordTypeDTO> propertyLogDescriptor) {
        Pair<Object, Object> pair = new Pair<Object, Object>(null, null);
        if (propertyLogDescriptor.getAccess().getPropertyName().equals(RecordTypeDTO.SORT_FIELD.getName())) {
            RecordCustomField recordCustomField = recordType.getSortField();
            FormatterImpl formatterImpl = this.getFormatter();
            pair.setFirst((Object)(recordCustomField == null ? this.message(UsersKeys.RecordTypes.SORT_FIELD_DATE, new Object[0]) : formatterImpl.format((INamedEntity)recordCustomField)));
            if (recordType2 != null) {
                RecordCustomField recordCustomField2 = recordType2.getSortField();
                pair.setSecond((Object)(recordCustomField2 == null ? this.message(UsersKeys.RecordTypes.SORT_FIELD_DATE, new Object[0]) : formatterImpl.format((INamedEntity)recordCustomField2)));
            }
        } else {
            pair = super.getValues(recordType, recordType2, propertyLogDescriptor);
        }
        return pair;
    }

    public EntityLogDescriptor<? extends RecordTypeDTO> resolveLogDescriptor(RecordType recordType) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDtoType(recordType)).property(RecordTypeDTO.NAME, GeneralKeys.Ui.NAME).property(RecordTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property(RecordTypeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property((Property)RecordTypeDTO.DISPLAY_TEMPLATE, UsersKeys.RecordTypes.DISPLAY_TEMPLATE).property((Property)RecordTypeDTO.FIELD_COLUMNS, UsersKeys.RecordTypes.FIELD_COLUMNS).property((Property)RecordTypeDTO.HIDE_DATE_ON_LIST, UsersKeys.RecordTypes.HIDE_DATE_ON_LIST).property((Property)RecordTypeDTO.INFORMATION_TEXT, UsersKeys.RecordTypes.INFORMATION_TEXT).property((Property)RecordTypeDTO.NOWRAP_LABELS, UsersKeys.RecordTypes.NOWRAP_LABELS).property((Property)RecordTypeDTO.PLURAL_NAME, UsersKeys.RecordTypes.PLURAL_NAME).property((Property)RecordTypeDTO.RESULTS_LAYOUT, UsersKeys.RecordTypes.RESULTS_LAYOUT).property((Property)RecordTypeDTO.SORT_FIELD, UsersKeys.RecordTypes.SORT_FIELD).property((Property)RecordTypeDTO.USE_VIEW_PAGE, UsersKeys.RecordTypes.USE_VIEW_PAGE).property((Property)RecordTypeDTO.REQUIRE_CONFIRMATION_FOR_MANAGE, UsersKeys.RecordTypes.REQUIRE_CONFIRMATION_FOR_MANAGE).property((Property)RecordTypeDTO.SVG_ICON, GeneralKeys.Ui.SVG_ICON).property((Property)RecordTypeDTO.ICON, UsersKeys.RecordTypes.MOBILE_ICON);
        if (recordType instanceof SystemRecordType) {
            entityLogDescriptor.cast().property((Property)SystemRecordTypeDTO.ADMIN_MENU, UsersKeys.RecordTypes.MENU);
        } else if (recordType instanceof UserRecordType) {
            entityLogDescriptor.cast().property((Property)UserRecordTypeDTO.GENERAL_SEARCH, UsersKeys.RecordTypes.GENERAL_SEARCH).property((Property)UserRecordTypeDTO.SORT_BY_OWNER, UsersKeys.RecordTypes.SORT_BY_OWNER).property((Property)UserRecordTypeDTO.HIDE_KEYWORDS_SEARCH, UsersKeys.RecordTypes.HIDE_KEYWORDS_SEARCH).property((Property)UserRecordTypeDTO.PROFILE_SECTION, UsersKeys.RecordTypes.PROFILE_SECTION).property((Property)UserRecordTypeDTO.PURGE_RECORDS, UsersKeys.RecordTypes.PURGE_RECORDS).property((Property)UserRecordTypeDTO.SHOW_UPDATE_TO_USERS, UsersKeys.RecordTypes.SHOW_UPDATE_TO_USERS).property((Property)UserRecordTypeDTO.USER_MENU, UsersKeys.RecordTypes.MENU);
        }
        return entityLogDescriptor;
    }

    @Override
    protected RecordType getEntityToViewLog(long l) {
        RecordType recordType = this.find(RecordType.class, l);
        if (this.recordTypeServiceSecurity.canPerformOperation((SimpleEntity)recordType, CRUDOperation.READ)) {
            return recordType;
        }
        return null;
    }

    private Class<? extends RecordTypeDTO> resolveDtoType(RecordType recordType) {
        if (recordType instanceof SystemRecordType) {
            return SystemRecordTypeDTO.class;
        }
        if (recordType instanceof UserRecordType) {
            return UserRecordTypeDTO.class;
        }
        return null;
    }
}

