/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.List;
import java.util.Set;
import org.cyclos.entities.users.QRecordSection;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordSection;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.RecordTypeSharedRecordField;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordSectionServiceLocal;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.recordsections.RecordSectionDTO;
import org.cyclos.model.users.recordsections.RecordSectionData;
import org.cyclos.model.users.recordsections.RecordSectionVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordSectionServiceImpl
extends CRUDServiceImpl<RecordSection, QRecordSection, RecordSectionDTO, RecordSectionData, RecordTypeVO>
implements RecordSectionServiceLocal {
    @Autowired
    private RecordFieldHandler recordFieldHandler;

    public RecordSectionServiceImpl() {
        super(RecordSection.class, QRecordSection.recordSection, RecordSectionDTO.class);
    }

    public List<RecordSectionVO> list(RecordTypeVO recordTypeVO) throws FrameworkException {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        return this.conversionHandler.convertList(RecordSectionVO.class, (Iterable)recordType.getSections());
    }

    public void move(Long l, boolean bl) throws FrameworkException {
        boolean bl2;
        RecordSection recordSection = (RecordSection)this.find(l);
        List list = recordSection.getRecordType().getSections();
        int n = list.indexOf(recordSection);
        boolean bl3 = bl2 = bl && n < 1 || !bl && n >= list.size() - 1;
        if (!bl2) {
            RecordSection recordSection2 = (RecordSection)list.get(bl ? n - 1 : n + 1);
            int n2 = recordSection.getOrder();
            recordSection.setOrder(recordSection2.getOrder());
            recordSection2.setOrder(Integer.valueOf(n2));
        }
    }

    @Override
    public RecordSection newEntity(RecordTypeVO recordTypeVO) {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        RecordSection recordSection = new RecordSection();
        recordSection.setRecordType(recordType);
        return recordSection;
    }

    @Override
    protected void doRemove(RecordSection recordSection, boolean bl) {
        recordSection.getAllFields().forEach(recordCustomField -> this.setSection(recordSection.getRecordType(), (RecordCustomField)recordCustomField, null));
        super.doRemove(recordSection, bl);
    }

    @Override
    protected RecordSectionData getData(RecordSection recordSection) {
        RecordType recordType = recordSection.getRecordType();
        RecordSectionData recordSectionData = new RecordSectionData();
        recordSectionData.setDto((EntityDTO)((RecordSectionDTO)this.toDTO(recordSection)));
        recordSectionData.setAllCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.recordFieldHandler.getAllFields(recordType)));
        return recordSectionData;
    }

    @Override
    protected Object onBeforeSave(RecordSection recordSection, RecordSection recordSection2) {
        RecordType recordType = recordSection.getRecordType();
        Set set = recordSection.getSelectedFields();
        if (recordSection2 == null) {
            List list = recordSection.getRecordType().getSections();
            if (CollectionHelper.isEmpty((Iterable)list)) {
                recordSection.setOrder(Integer.valueOf(0));
            } else {
                RecordSection recordSection3 = (RecordSection)list.get(list.size() - 1);
                recordSection.setOrder(Integer.valueOf(recordSection3.getOrder() + 1));
            }
            list.add(recordSection);
        } else {
            recordSection.getAllFields().stream().filter(recordCustomField -> !set.contains(recordCustomField)).forEach(recordCustomField -> this.setSection(recordType, (RecordCustomField)recordCustomField, null));
        }
        set.forEach(recordCustomField -> this.setSection(recordType, (RecordCustomField)recordCustomField, recordSection));
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QRecordSection)this.$).recordType().network());
    }

    @Override
    protected Validator resolveValidator(RecordSectionDTO recordSectionDTO) {
        RecordType recordType;
        Validator validator = new Validator();
        if (recordSectionDTO.isPersistent()) {
            recordType = ((RecordSection)this.find(recordSectionDTO.getId())).getRecordType();
        } else {
            recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordSectionDTO.getRecordType());
            validator.property((Property)RecordSectionDTO.RECORD_TYPE, UsersKeys.Records.TYPE).required();
        }
        if (recordType != null) {
            validator.property((Property)RecordSectionDTO.SELECTED_FIELDS, UsersKeys.RecordSections.SELECTED_FIELDS).entity(RecordCustomField.class, (EntityValidation)new BaseEntityValidation<RecordCustomField>(){

                protected boolean isValid(Object object, Object object2, RecordCustomField recordCustomField) {
                    return RecordSectionServiceImpl.this.recordFieldHandler.getAllFields(recordType).contains(recordCustomField);
                }
            });
        }
        return validator;
    }

    private void setSection(RecordType recordType, RecordCustomField recordCustomField, RecordSection recordSection) {
        if (recordType.equals((Object)recordCustomField.getRecordType())) {
            recordCustomField.setSection(recordSection);
        } else {
            RecordTypeSharedRecordField recordTypeSharedRecordField = recordType.getRecordTypeSharedField(recordCustomField);
            if (recordTypeSharedRecordField == null) {
                throw new EntityNotFoundException(RecordCustomField.class, recordCustomField.getInternalName());
            }
            recordTypeSharedRecordField.setSection(recordSection);
        }
    }
}

