/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QProductRecordField;
import org.cyclos.entities.users.QRecordCustomField;
import org.cyclos.entities.users.QRecordCustomFieldValue;
import org.cyclos.entities.users.QRecordTypeSharedRecordField;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordCustomFieldPossibleValue;
import org.cyclos.entities.users.RecordCustomFieldPossibleValueCategory;
import org.cyclos.entities.users.RecordSection;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.RecordTypeSharedRecordField;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.users.RecordCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.users.RecordCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.system.fields.CustomFieldSize;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.recordfields.RecordCustomFieldDTO;
import org.cyclos.model.users.recordfields.RecordCustomFieldData;
import org.cyclos.model.users.recordfields.RecordCustomFieldVO;
import org.cyclos.model.users.records.SystemRecordDTO;
import org.cyclos.model.users.records.UserRecordDTO;
import org.cyclos.model.users.recordsections.RecordSectionVO;
import org.cyclos.model.users.recordtypes.RecordCustomFieldDetailedVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<RecordCustomField, RecordCustomFieldPossibleValueCategory, RecordCustomFieldPossibleValue, QRecordCustomField, RecordCustomFieldDTO, RecordCustomFieldData, RecordTypeVO>
implements RecordCustomFieldServiceLocal {
    @Autowired
    private RecordCustomFieldPossibleValueServiceLocal recordCustomFieldPossibleValueService;
    @Autowired
    private RecordCustomFieldPossibleValueCategoryServiceLocal recordCustomFieldPossibleValueCategoryService;
    @Autowired
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    private RecordServiceLocal recordServiceLocal;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private CacheHandler cacheHandler;

    public RecordCustomFieldServiceImpl() {
        super(RecordCustomField.class, QRecordCustomField.recordCustomField, RecordCustomFieldDTO.class, RecordCustomFieldData.class);
    }

    public void linkShared(RecordTypeVO recordTypeVO, CustomFieldVO customFieldVO) {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        RecordCustomField recordCustomField = (RecordCustomField)this.conversionHandler.convert(RecordCustomField.class, (Object)customFieldVO);
        if (recordCustomField.getRecordType() != null) {
            throw new IllegalArgumentException();
        }
        RecordTypeSharedRecordField recordTypeSharedRecordField = new RecordTypeSharedRecordField();
        recordTypeSharedRecordField.setRecordType(recordType);
        recordTypeSharedRecordField.setRecordField(recordCustomField);
        Integer n = this.getMaxOrder(recordType);
        recordTypeSharedRecordField.setOrder(Integer.valueOf(n == null ? 0 : n + 1));
        recordType.getSharedFields().add(recordTypeSharedRecordField);
        AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
        AdminProduct adminProduct = adminGroup.getAdminProduct();
        this.recordFieldHandler.assignAllPermissionsToRecordField(recordType, recordCustomField, adminProduct);
    }

    public List<RecordCustomFieldVO> list(RecordTypeVO recordTypeVO) {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        ArrayList<RecordCustomFieldVO> arrayList = new ArrayList<RecordCustomFieldVO>();
        for (RecordCustomField recordCustomField : this.recordFieldHandler.getAllFields(recordType)) {
            RecordSection recordSection = recordType.getSection(recordCustomField);
            RecordCustomFieldVO recordCustomFieldVO = (RecordCustomFieldVO)this.conversionHandler.convert(RecordCustomFieldVO.class, (Object)recordCustomField);
            recordCustomFieldVO.setSection((RecordSectionVO)this.conversionHandler.convert(RecordSectionVO.class, (Object)recordSection));
            arrayList.add(recordCustomFieldVO);
        }
        return arrayList;
    }

    public List<RecordCustomField> listAllShared() {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QRecordCustomField)this.$).recordType().isNull())).orderBy(((QRecordCustomField)this.$).order.asc())).list((Expression)this.$);
    }

    public List<RecordCustomFieldDetailedVO> listDetailed(RecordType recordType) {
        ArrayList<RecordCustomFieldDetailedVO> arrayList = new ArrayList<RecordCustomFieldDetailedVO>();
        for (RecordCustomField recordCustomField : this.recordFieldHandler.getAllFields(recordType)) {
            RecordSection recordSection = recordType.getSection(recordCustomField);
            RecordCustomFieldDetailedVO recordCustomFieldDetailedVO = (RecordCustomFieldDetailedVO)this.conversionHandler.convertExcluding(RecordCustomFieldDetailedVO.class, (Object)recordCustomField, new Object[]{RecordCustomFieldDetailedVO.SECTION});
            recordCustomFieldDetailedVO.setSection((RecordSectionVO)this.conversionHandler.convert(RecordSectionVO.class, (Object)recordSection));
            arrayList.add(recordCustomFieldDetailedVO);
        }
        return arrayList;
    }

    public List<CustomFieldVO> listShared() {
        return this.conversionHandler.convertList(CustomFieldVO.class, this.listAllShared());
    }

    @Override
    public RecordCustomField newEntity(RecordTypeVO recordTypeVO) {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        RecordCustomField recordCustomField = new RecordCustomField();
        recordCustomField.setRecordType(recordType);
        if (recordType != null && recordType.getFieldColumns() > 1) {
            recordCustomField.setSize(CustomFieldSize.FULL);
        }
        return recordCustomField;
    }

    @Override
    public final void saveOrder(List<Long> list) {
        if (list != null) {
            for (Long l : list) {
                RecordCustomField recordCustomField = (RecordCustomField)this.find(l);
                if (recordCustomField.getRecordType() == null || !(recordCustomField.getRecordType() instanceof UserRecordType)) continue;
                throw new IllegalActionException();
            }
            super.saveOrder(list);
        }
    }

    public void saveOrderOnType(RecordTypeVO recordTypeVO, List<CustomFieldVO> list) {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        ArrayList arrayList = new ArrayList();
        List list2 = this.conversionHandler.convertList(RecordCustomField.class, list);
        arrayList.addAll(list2);
        if (!CollectionUtils.isEqualCollection(arrayList, (Collection)this.recordFieldHandler.getAllFields(recordType))) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            RecordCustomField recordCustomField = (RecordCustomField)arrayList.get(i);
            recordType.setOrder(recordCustomField, Integer.valueOf(i));
        }
    }

    public void unlinkShared(RecordTypeVO recordTypeVO, CustomFieldVO customFieldVO) {
        RecordCustomField recordCustomField;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        if (this.recordServiceLocal.hasRecordCustomFieldValue(recordType, recordCustomField = (RecordCustomField)this.conversionHandler.convert(RecordCustomField.class, (Object)customFieldVO))) {
            throw new ConstraintViolatedOnRemoveException("Record custom field values exist for " + recordCustomField.getName() + " on " + recordType.getName());
        }
        if (recordCustomField.equals((Object)recordType.getSortField())) {
            recordType.setSortField(null);
        }
        this.moveFieldToLastPosition(recordType, recordCustomField);
        List list = recordType.getSharedFields();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            RecordTypeSharedRecordField recordTypeSharedRecordField = (RecordTypeSharedRecordField)listIterator.next();
            if (!recordTypeSharedRecordField.getRecordField().equals((Object)recordCustomField)) continue;
            listIterator.remove();
            this.remove(recordTypeSharedRecordField);
            break;
        }
        this.clearCache(recordCustomField);
    }

    @Override
    protected void addCustomInternalNameValidations(Property property, RecordCustomFieldDTO recordCustomFieldDTO) {
        RecordCustomField recordCustomField;
        super.addCustomInternalNameValidations(property, recordCustomFieldDTO);
        if (recordCustomFieldDTO == null || StringHelper.isBlank((Object)recordCustomFieldDTO.getInternalName())) {
            return;
        }
        Long l = recordCustomFieldDTO.getId();
        DBQuery dBQuery = (DBQuery)this.from(this.$).where((Predicate)((QRecordCustomField)this.$).internalName.eq((Object)recordCustomFieldDTO.getInternalName()));
        if (l != null) {
            dBQuery.where((Predicate)((QRecordCustomField)this.$).id.ne((Object)l));
        }
        if (recordCustomFieldDTO != null && recordCustomFieldDTO.getRecordType() != null && recordCustomFieldDTO.getRecordType().getId() != null) {
            dBQuery.where((Predicate)((QRecordCustomField)this.$).recordType().isNull().or((Predicate)((QRecordCustomField)this.$).recordType().id.eq((Object)recordCustomFieldDTO.getRecordType().getId())));
        }
        if ((recordCustomField = (RecordCustomField)dBQuery.singleResult((Expression)this.$)) != null) {
            if (recordCustomField.getRecordType() == null) {
                property.invalid(UsersKeys.RecordFields.SAME_INTERNAL_NAME_AS_SHARED);
            } else {
                property.invalid(new ValidationError(UsersKeys.RecordFields.SAME_INTERNAL_NAME_AS_RECORD_FIELD, new Object[]{this.getTranslatedName((NamedEntity)recordCustomField.getRecordType())}));
            }
        }
    }

    protected void clearCache(RecordCustomField recordCustomField) {
        Long l = SimpleEntity.id((SimpleEntity)recordCustomField.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QProduct.product.myRecordTypes, QUserManagementProduct.userManagementProduct.userRecordTypes, QAdminProduct.adminProduct.systemRecordTypes});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
    }

    @Override
    protected RecordCustomFieldData getData(RecordCustomField recordCustomField) {
        RecordCustomFieldData recordCustomFieldData = (RecordCustomFieldData)super.getData(recordCustomField);
        int n = recordCustomField.getRecordType() == null ? 3 : recordCustomField.getRecordType().getFieldColumns();
        recordCustomFieldData.setMaxColspan(n);
        recordCustomFieldData.setUsingOpenSearch(this.cyclosProperties.isUsingOpenSearch());
        return recordCustomFieldData;
    }

    @Override
    protected Integer getMaxOrder(RecordCustomField recordCustomField) {
        RecordType recordType = recordCustomField.getRecordType();
        return this.getMaxOrder(recordType);
    }

    @Override
    protected Integer getMaxOrder(RecordType recordType) {
        QRecordCustomField qRecordCustomField = QRecordCustomField.recordCustomField;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qRecordCustomField});
        if (recordType == null) {
            dBQuery.where((Predicate)qRecordCustomField.recordType().isNull());
            return (Integer)dBQuery.singleResult((Expression)qRecordCustomField.order.max());
        }
        dBQuery.where((Predicate)qRecordCustomField.recordType().eq((Object)recordType));
        Integer n = (Integer)dBQuery.singleResult((Expression)qRecordCustomField.order.max());
        QRecordTypeSharedRecordField qRecordTypeSharedRecordField = QRecordTypeSharedRecordField.recordTypeSharedRecordField;
        Integer n2 = (Integer)((DBQuery)this.from(new EntityPath[]{qRecordTypeSharedRecordField}).where((Predicate)qRecordTypeSharedRecordField.recordType().eq((Object)recordType))).singleResult((Expression)qRecordTypeSharedRecordField.order.max());
        if (n == null && n2 == null) {
            return null;
        }
        n = n == null ? 0 : n;
        n2 = n2 == null ? 0 : n2;
        return Math.max(n, n2);
    }

    @Override
    protected BaseCustomFieldPossibleValueCategoryServiceLocal<RecordCustomField, RecordCustomFieldPossibleValueCategory, RecordCustomFieldPossibleValue> getPossibleValueCategoryService() {
        return this.recordCustomFieldPossibleValueCategoryService;
    }

    protected RecordCustomFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.recordCustomFieldPossibleValueService;
    }

    @Override
    protected List<Class<?>> getPropertyClasses() {
        return Arrays.asList(SystemRecordDTO.class, UserRecordDTO.class, SystemRecord.class, UserRecord.class);
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    protected void moveFieldToLastPosition(RecordType recordType, RecordCustomField recordCustomField) {
        List list = this.recordFieldHandler.getAllFields(recordType);
        list.remove(recordCustomField);
        list.add(list.size(), recordCustomField);
        ArrayList<CustomFieldVO> arrayList = new ArrayList<CustomFieldVO>();
        for (RecordCustomField recordCustomField2 : list) {
            arrayList.add(new CustomFieldVO(recordCustomField2.getId()));
        }
        this.saveOrderOnType(new RecordTypeVO(recordType.getId()), arrayList);
    }

    @Override
    protected void onAfterRemove(RecordCustomField recordCustomField) {
        this.clearCache(recordCustomField);
    }

    @Override
    protected void onAfterSave(RecordCustomField recordCustomField, RecordCustomField recordCustomField2, Object object) {
        if (recordCustomField2 == null) {
            RecordType recordType = recordCustomField.getRecordType();
            if (recordType != null) {
                recordType.getFields().add(recordCustomField);
            }
            if (this.isAdmin()) {
                AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
                AdminProduct adminProduct = adminGroup.getAdminProduct();
                if (recordType != null) {
                    this.recordFieldHandler.assignAllPermissionsToRecordField(recordType, recordCustomField, adminProduct);
                }
            }
        }
    }

    @Override
    protected void onBeforeRemove(RecordCustomField recordCustomField) {
        QRecordCustomFieldValue qRecordCustomFieldValue = QRecordCustomFieldValue.recordCustomFieldValue;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qRecordCustomFieldValue}).where((Predicate)qRecordCustomFieldValue.field().eq((Object)recordCustomField))).hasResults();
        QProductRecordField qProductRecordField = QProductRecordField.productRecordField;
        boolean bl2 = ((DBQuery)this.from(new EntityPath[]{qProductRecordField}).where(new Predicate[]{qProductRecordField.customField().eq((Object)recordCustomField), qProductRecordField.view.isTrue()})).hasResults();
        if (bl && bl2) {
            throw new ConstraintViolatedOnRemoveException();
        }
        RecordType recordType = recordCustomField.getRecordType();
        if (recordType == null) {
            QRecordTypeSharedRecordField qRecordTypeSharedRecordField = QRecordTypeSharedRecordField.recordTypeSharedRecordField;
            List list = ((DBQuery)this.from(new EntityPath[]{qRecordTypeSharedRecordField}).where((Predicate)qRecordTypeSharedRecordField.recordField().eq((Object)recordCustomField))).list((Expression)qRecordTypeSharedRecordField.recordType());
            for (RecordType recordType2 : list) {
                this.unlinkShared(new RecordTypeVO(recordType2.getId()), new CustomFieldVO(recordCustomField.getId()));
            }
        } else {
            if (recordCustomField.equals((Object)recordType.getSortField())) {
                recordType.setSortField(null);
            }
            this.moveFieldToLastPosition(recordType, recordCustomField);
        }
    }

    @Override
    protected Object onBeforeSave(RecordCustomField recordCustomField, RecordCustomField recordCustomField2) {
        if (!recordCustomField.getType().isAllowedToBeOnResultList()) {
            recordCustomField.setShowInList(false);
        }
        if (!recordCustomField.getType().isAllowedToBeOnSearchFilters()) {
            recordCustomField.setShowInSearch(false);
        }
        return super.onBeforeSave(recordCustomField, recordCustomField2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QRecordCustomField)this.$).network());
    }
}

