/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.users.phones.ManagedPhoneVO;
import org.cyclos.model.users.phones.PhoneVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhoneVOConverter
extends EntityVOConverter<PhoneVO> {
    @Autowired
    private OtpHandler otpHandler;

    public PhoneVOConverter() {
        super(PhoneVO.class);
    }

    @Override
    protected void fill(Object object, PhoneVO phoneVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        objectArray = ArrayUtils.add((Object[])objectArray, (Object)ManagedPhoneVO.VERIFICATION_CODE_SEND_DATE);
        super.fill(object, phoneVO, objectArray, conversionContext);
        if (object instanceof Phone) {
            Phone phone = (Phone)object;
            phoneVO.setFormattedNumber(this.getFormatter().format(phone));
            if (object instanceof MobilePhone && phoneVO instanceof ManagedPhoneVO) {
                MobilePhone mobilePhone = (MobilePhone)phone;
                ManagedPhoneVO managedPhoneVO = (ManagedPhoneVO)phoneVO;
                if (!mobilePhone.isVerified()) {
                    Date date = this.otpHandler.getDate(OtpType.PHONE_VERIFICATION, (OtpOwner)mobilePhone);
                    managedPhoneVO.setVerificationCodeSendDate(this.conversionHandler.toDateTime(date));
                }
            }
        }
    }

    @Override
    protected PhoneVO instantiate(Class<PhoneVO> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        Class<PhoneVO> clazz2 = clazz;
        if (clazz.equals(PhoneVO.class) && object instanceof Phone) {
            Phone phone = (Phone)object;
            if (conversionContext.getSessionData().manages(phone.getUser())) {
                clazz2 = ManagedPhoneVO.class;
            }
        }
        return super.instantiate(clazz2, object, conversionContext);
    }
}

