/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.BooleanUtils;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QLandLinePhone;
import org.cyclos.entities.users.QMobilePhone;
import org.cyclos.entities.users.QPhone;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.PhoneExtensionPointEvent;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.phones.CodeVerificationStatus;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.LandLinePhoneData;
import org.cyclos.model.users.phones.ManagePhoneConfirmationField;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneData;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneData;
import org.cyclos.model.users.phones.PhoneDataParams;
import org.cyclos.model.users.phones.PhoneListData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.server.utils.CallableRunnable;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhoneServiceImpl
extends CRUDServiceImpl<Phone, QPhone, PhoneDTO, PhoneData, PhoneDataParams>
implements PhoneServiceLocal {
    private static final int MAXIMUM_FAILED_VERIFICATION_ATTEMPTS = 3;
    private static final BidiMap<Class<? extends Phone>, Class<? extends PhoneDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private PinServiceLocal pinService;
    @Autowired
    private OtpHandler otpHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;
    @Autowired
    private InvokerHandler invokerHandler;

    public PhoneServiceImpl() {
        super(Phone.class, QPhone.phone, PhoneDTO.class);
    }

    public int count(BasicUser basicUser, PhoneNature phoneNature) {
        if (basicUser == null || basicUser.isTransient()) {
            return 0;
        }
        return this.getBaseQuery(basicUser, phoneNature, false).count(((QPhone)this.$).id);
    }

    public Map<PhoneNature, Integer> counters(BasicUser basicUser) {
        HashMap<PhoneNature, Integer> hashMap = basicUser == null || basicUser.isTransient() ? new HashMap<PhoneNature, Integer>() : ((DBQuery)this.getBaseQuery(basicUser, null, false).groupBy((Expression)((QPhone)this.$).nature)).map((Expression)((QPhone)this.$).nature, (Expression)((QPhone)this.$).id.count().intValue());
        Arrays.asList(PhoneNature.values()).forEach(phoneNature -> hashMap.putIfAbsent((PhoneNature)phoneNature, 0));
        return hashMap;
    }

    public void disableForSms(PhoneVO phoneVO, String string) throws FrameworkException {
        MobilePhone mobilePhone = this.getMobilePhone(phoneVO, true);
        this.checkConfirmationPassword(null, mobilePhone, CRUDOperation.UPDATE, string);
        this.markAsEnabledForSms(mobilePhone, false);
    }

    public void enableForSms(PhoneVO phoneVO) throws FrameworkException {
        MobilePhone mobilePhone = this.getMobilePhone(phoneVO, true);
        this.markAsEnabledForSms(mobilePhone, true);
    }

    public MobilePhone findByNumber(String string) {
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        if (!configurationAccessor.isMobileUnique()) {
            throw new EntityNotFoundException(MobilePhone.class, string);
        }
        QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor);
        if (phoneNumberDescriptor == null) {
            throw new EntityNotFoundException(MobilePhone.class, string);
        }
        MobilePhone mobilePhone = (MobilePhone)((DBQuery)this.from(new EntityPath[]{qMobilePhone}).where((Predicate)qMobilePhone.normalizedNumber.eq((Object)phoneNumberDescriptor.toE164()))).requiredUniqueResult((Expression)qMobilePhone);
        this.entityManagerHandler.checkAccess((IEntity)mobilePhone);
        return mobilePhone;
    }

    public CredentialInputDTO getConfirmationPasswordInputForDisableSms(PhoneVO phoneVO) throws FrameworkException {
        MobilePhone mobilePhone = this.getMobilePhone(phoneVO, true);
        return this.getConfirmationPasswordInput(mobilePhone, CRUDOperation.UPDATE);
    }

    public Phone getDefaultPhone(BasicUser basicUser) {
        return this.getDefaultPhone(basicUser, null);
    }

    public Phone getDefaultPhone(PhoneNature phoneNature, User user) {
        if (phoneNature == null) {
            return this.getDefaultPhone((BasicUser)user);
        }
        if (phoneNature == PhoneNature.MOBILE) {
            QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
            return (Phone)((DBQuery)((DBQuery)this.from(new EntityPath[]{qMobilePhone}).where((Predicate)qMobilePhone.user().eq((Object)user))).orderBy(qMobilePhone.verificationDate.asc().nullsLast())).singleResult((Expression)qMobilePhone);
        }
        QLandLinePhone qLandLinePhone = QLandLinePhone.landLinePhone;
        return (Phone)((DBQuery)((DBQuery)this.from(new EntityPath[]{qLandLinePhone}).where((Predicate)qLandLinePhone.user().eq((Object)user))).limit(1L)).singleResult((Expression)qLandLinePhone);
    }

    public PhoneListData getPhoneListData(BasicUser basicUser) {
        Operator operator;
        PhoneListData phoneListData = new PhoneListData();
        phoneListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)basicUser));
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        boolean bl = outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled();
        SessionData sessionData = this.getSessionData();
        boolean bl2 = basicUser.equals((Object)sessionData.getLoggedBasicUser());
        if (!bl2 && basicUser instanceof Operator) {
            operator = (Operator)basicUser;
            bl2 = sessionData.isOwnerOf((BasicUser)operator);
        }
        phoneListData.setPhones(this.conversionHandler.convertList(PhoneVO.class, this.listByUser(basicUser, null)));
        phoneListData.setManagesPhones(this.canManagePhones(basicUser));
        phoneListData.setEnablePrivacy(this.profileFieldHandler.enablePrivacy(basicUser));
        phoneListData.setCanManagePrivacy(this.canManagePrivacy(basicUser));
        phoneListData.setCanCreateLandlinePhone(this.canCreatePhone(basicUser, PhoneNature.LANDLINE));
        phoneListData.setCanCreateMobilePhone(this.canCreatePhone(basicUser, PhoneNature.MOBILE));
        if (phoneListData.isManagesPhones()) {
            operator = this.productsHandler.getAccessor(basicUser).product();
            phoneListData.setMaxLandLinePhones(Integer.valueOf(operator.getMaxLandlinePhones()));
            phoneListData.setMaxMobilePhones(Integer.valueOf(operator.getMaxMobilePhones()));
        }
        phoneListData.setSmsEnabled(bl);
        phoneListData.setCanVerify(bl && bl2);
        phoneListData.setCanEnableForSms(bl && bl2);
        phoneListData.setLandLineRequired(configurationAccessor.isLandLineRequired());
        phoneListData.setMobileRequired(configurationAccessor.isMobileRequired());
        return phoneListData;
    }

    public PhoneListData getPhoneListData(UserLocatorVO userLocatorVO) {
        return this.getPhoneListData(this.userLocatorHandler.locate(userLocatorVO).getBasicUser());
    }

    public Validator getValidator(PhoneDTO phoneDTO, BasicUser basicUser) {
        PhoneNumberDescriptor phoneNumberDescriptor;
        Validator validator = new Validator();
        PhoneNature phoneNature = phoneDTO instanceof LandLinePhoneDTO ? PhoneNature.LANDLINE : PhoneNature.MOBILE;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        MessageKey messageKey = phoneNature.getMessageKey();
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)PhoneDTO.RAW_NUMBER, messageKey);
        if (StringHelper.isBlank((Object)phoneDTO.getRawNumber())) {
            property.required();
            return validator;
        }
        DBQuery dBQuery = null;
        String string = null;
        if (StringHelper.isNotBlank((Object)phoneDTO.getRawNumber()) && (phoneNumberDescriptor = this.phoneNumberHandler.parse(phoneDTO.getRawNumber(), configurationAccessor)) != null) {
            if (phoneNature == PhoneNature.LANDLINE) {
                if (basicUser.isPersistent()) {
                    dBQuery = (DBQuery)this.from(this.$).where(new Predicate[]{((QPhone)this.$).user().eq((Object)basicUser), ((QPhone)this.$).normalizedNumber.eq((Object)phoneNumberDescriptor.toE164())});
                    string = "landLine_user_" + basicUser.getId() + "_" + String.valueOf(phoneNumberDescriptor);
                }
            } else if (configurationAccessor.isMobileUnique()) {
                dBQuery = (DBQuery)this.from(this.$).where(new Predicate[]{((QPhone)this.$).normalizedNumber.eq((Object)phoneNumberDescriptor.toE164()), ((QPhone)this.$).user().status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})});
                string = "mobile_network_" + SimpleEntity.id((SimpleEntity)basicUser.getNetwork()) + "_" + String.valueOf(phoneNumberDescriptor);
            } else if (basicUser.isPersistent()) {
                dBQuery = (DBQuery)this.from(this.$).where(new Predicate[]{((QPhone)this.$).user().eq((Object)basicUser), ((QPhone)this.$).normalizedNumber.eq((Object)phoneNumberDescriptor.toE164())});
                string = "mobile_user_" + basicUser.getId() + "_" + String.valueOf(phoneNumberDescriptor);
            }
            if (dBQuery != null && phoneDTO.isPersistent()) {
                dBQuery.where((Predicate)((QPhone)this.$).id.ne((Object)phoneDTO.getId()));
            }
        }
        property.phoneNumber(configurationAccessor, phoneNature).unique(string, dBQuery);
        if (phoneDTO instanceof LandLinePhoneDTO) {
            validator.property((Property)LandLinePhoneDTO.EXTENSION, UsersKeys.Phones.EXTENSION).maxLength(6);
        }
        return validator;
    }

    @PostConstruct
    public void initialize() {
        this.restBeanPropertyMapping.register((Property)PhoneDTO.RAW_NUMBER, "number");
    }

    public List<Phone> listByUser(BasicUser basicUser, PhoneNature phoneNature) {
        if (basicUser == null || basicUser.isTransient()) {
            return Collections.emptyList();
        }
        return ((DBQuery)this.getBaseQuery(basicUser, phoneNature, true).orderBy(((QPhone)this.$).name.asc())).list((Expression)this.$);
    }

    public List<MobilePhone> listEnabledPhonesForSmsNotification(BasicUser basicUser, boolean bl) {
        QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
        ArrayList<BasicUser> arrayList = new ArrayList<BasicUser>();
        arrayList.add(basicUser);
        if (bl && basicUser instanceof User) {
            arrayList.addAll(this.operatorService.listAliases((User)basicUser));
        }
        return ((DBQuery)this.from(new EntityPath[]{qMobilePhone}).where(new Predicate[]{qMobilePhone.enabledForSms.isTrue(), qMobilePhone.user().in(arrayList)})).list((Expression)qMobilePhone);
    }

    public PhoneVO loadByNumber(String string) throws FrameworkException {
        return (PhoneVO)this.conversionHandler.convert(PhoneVO.class, (Object)this.findByNumber(string));
    }

    public Phone loadByRawNumber(User user, String string) {
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, this.configurationHandler.getAccessor((BasicUser)user));
        if (phoneNumberDescriptor == null) {
            throw new EntityNotFoundException(Phone.class, string);
        }
        return (Phone)((DBQuery)this.from(this.$).where((Predicate)((QPhone)this.$).normalizedNumber.eq((Object)phoneNumberDescriptor.toE164()))).singleResult((Expression)this.$);
    }

    public void markVerified(MobilePhone mobilePhone) {
        mobilePhone.setVerificationDate(new Date());
    }

    @Override
    public Phone newEntity(PhoneDataParams phoneDataParams) {
        MobilePhone mobilePhone = phoneDataParams.getNature() == PhoneNature.MOBILE ? new MobilePhone() : new LandLinePhone();
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)phoneDataParams.getUser());
        User user = (User)this.conversionHandler.convert(User.class, (Object)phoneDataParams.getOperatorOwner());
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)phoneDataParams.getGroup());
        if (basicUser == null) {
            if (group != null) {
                basicUser = new User(group);
            } else if (user != null) {
                basicUser = new Operator(user);
            } else {
                throw new ValidationException();
            }
        }
        mobilePhone.setUser(basicUser);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        if (configurationAccessor.getDefaultPhonePrivacy() == FieldVisibility.HIDDEN) {
            mobilePhone.setHidden(true);
        }
        if (BooleanUtils.isTrue((Boolean)phoneDataParams.isSuggestPhoneName())) {
            mobilePhone.setName(this.getDefaultPhoneName((Phone)mobilePhone));
        }
        return mobilePhone;
    }

    public void removeAll(BasicUser basicUser) {
        CloseableIterator closeableIterator = ((DBQuery)this.from().where((Predicate)((QPhone)this.$).user().eq((Object)basicUser))).iterate((Expression)this.$);
        this.processBatch(closeableIterator, this::remove);
    }

    public String sendVerificationCode(PhoneVO phoneVO) throws FrameworkException, SmsSendingException {
        MobilePhone mobilePhone = this.getMobilePhone(phoneVO, false);
        this.otpHandler.sendForPhoneVerification(mobilePhone);
        return this.getFormatter().format((Phone)mobilePhone);
    }

    @Override
    public Phone toEntity(PhoneDTO phoneDTO) {
        Phone phone = (Phone)super.toEntity(phoneDTO);
        if (phone instanceof MobilePhone) {
            MobilePhone mobilePhone = (MobilePhone)phone;
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)phoneDTO;
            if (mobilePhoneDTO.isVerified() && !mobilePhone.isVerified()) {
                this.markVerified(mobilePhone);
            } else if (!mobilePhoneDTO.isVerified() && mobilePhone.isVerified()) {
                this.markUnverified(mobilePhone);
            }
        }
        return phone;
    }

    public CodeVerificationStatus verify(PhoneVO phoneVO, String string) throws FrameworkException {
        MobilePhone mobilePhone = this.getMobilePhone(phoneVO, false);
        try {
            this.otpHandler.verify(OtpType.PHONE_VERIFICATION, (OtpOwner)mobilePhone, string);
            this.markVerified(mobilePhone);
            return CodeVerificationStatus.SUCCESS;
        }
        catch (ValidationException validationException) {
            boolean bl = this.failedActionHandler.recordUserFailure(FailedAction.FAILED_PHONE_VERIFICATION, mobilePhone.getUser(), Integer.valueOf(3), () -> this.otpHandler.remove(OtpType.PHONE_VERIFICATION, (OtpOwner)mobilePhone));
            return bl ? CodeVerificationStatus.MAX_ATTEMPTS_REACHED : CodeVerificationStatus.FAILED;
        }
    }

    public void verifyAndEnableForSms(MobilePhone mobilePhone) throws FrameworkException {
        mobilePhone.setVerificationDate(new Date());
        mobilePhone.setEnabledForSms(true);
    }

    @Override
    protected void doRemove(Phone phone, boolean bl) {
        super.doRemove(phone, false);
        phone.getUser().getPhones().remove(phone);
        if (bl) {
            this.flush();
        }
    }

    @Override
    protected PhoneData getData(Phone phone) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(phone.getUser());
        Object object = phone instanceof LandLinePhone ? this.getLandLineData(configurationAccessor, (LandLinePhone)phone) : this.getMobileData(configurationAccessor, (MobilePhone)phone);
        PhoneDTO phoneDTO = (PhoneDTO)this.toDTO(phone);
        object.setDto((EntityDTO)phoneDTO);
        return object;
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(PhoneDTO phoneDTO, Phone phone, CRUDOperation cRUDOperation) {
        return ManagePhoneConfirmationField.confirmation((String)(phoneDTO != null ? phoneDTO.getName() : phone.getName()));
    }

    @Override
    protected void onAfterRemove(Phone phone) {
        BasicUser basicUser = phone.getUser();
        if (basicUser instanceof User) {
            this.userSearchHandler.updateUserFields((User)basicUser);
        }
    }

    @Override
    protected void onAfterSave(Phone phone, Phone phone2, Object object) {
        BasicUser basicUser = phone.getUser();
        if (phone2 == null || !phone.getNormalizedNumber().equals(phone2.getNormalizedNumber())) {
            this.externalPaymentService.processExternalPayments(basicUser.getUser());
        }
        if (phone2 == null) {
            basicUser.getPhones().add(phone);
        }
        if (basicUser instanceof User) {
            this.userSearchHandler.updateUserFields((User)basicUser);
        }
    }

    @Override
    protected void onBeforeRemove(final Phone phone) {
        BasicUser basicUser = phone.getUser();
        if (!basicUser.isPurged()) {
            if (this.profileFieldHandler.isEnabled(basicUser, (ProfileField)BasicProfileField.PHONE)) {
                int n;
                ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
                boolean bl = phone instanceof MobilePhone ? configurationAccessor.isMobileRequired() : configurationAccessor.isLandLineRequired();
                if (bl && (n = this.count(basicUser, phone.getNature())) <= 1) {
                    throw new ValidationException(new ValidationResult(this.translationHandler.message(UsersKeys.Phones.CANNOT_DELETE, new Object[0])));
                }
            }
            if (phone instanceof MobilePhone) {
                this.pinService.relatedEntityRemoved((NetworkedEntity)phone, () -> (Phone)((DBQuery)this.from(this.$).where(new Predicate[]{((QPhone)this.$).user().eq((Object)phone.getUser()), ((QPhone)this.$).nature.eq((Object)PhoneNature.MOBILE), ((QPhone)this.$).id.ne((Object)phone.getId())})).singleResult((Expression)this.$));
                this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), (Callable)new CallableRunnable(){

                    public void run() {
                        PhoneServiceImpl.this.sendSmsToOldMobilePhone((MobilePhone)phone, null);
                    }
                });
            }
        }
    }

    @Override
    protected Object onBeforeSave(final Phone phone, final Phone phone2) {
        ProductAccessor productAccessor;
        BasicUser basicUser = phone.getUser();
        if (!this.profileFieldHandler.enablePrivacy(basicUser)) {
            phone.setHidden(true);
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        PhoneNature phoneNature = phone.getNature();
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(phone.getRawNumber(), configurationAccessor);
        phone.setNormalizedNumber(phoneNumberDescriptor == null ? null : phoneNumberDescriptor.toE164());
        if (phone.isTransient()) {
            productAccessor = this.productsHandler.getAccessor(basicUser).product();
            int n = phoneNature == PhoneNature.LANDLINE ? productAccessor.getMaxLandlinePhones() : productAccessor.getMaxMobilePhones();
            int n2 = this.count(basicUser, phoneNature);
            if (n2 >= n) {
                throw new MaxItemsException(n);
            }
            if (phoneNature == PhoneNature.MOBILE && basicUser.isActive() && basicUser.getRegistrationConfirmationDate() != null) {
                this.mailHandler.send(null, basicUser, MailContext.NEW_MOBILE_PHONE, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.NEW_MOBILE_PHONE_NOTIFICATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.NEW_MOBILE_PHONE_NOTIFICATION_BODY, new Object[]{phone}), new FileInfo[0]);
            }
        }
        if (phoneNature == PhoneNature.MOBILE) {
            productAccessor = (MobilePhone)phone;
            if (phone2 != null) {
                String string = phone2.getNormalizedNumber();
                if (phoneNumberDescriptor == null || !phoneNumberDescriptor.toE164().equals(string)) {
                    if (phone2.getUser().equals((Object)this.getLoggedUser())) {
                        this.markUnverified((MobilePhone)productAccessor);
                    }
                    this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), (Callable)new CallableRunnable(){

                        public void run() {
                            PhoneServiceImpl.this.sendSmsToOldMobilePhone((MobilePhone)phone2, PhoneServiceImpl.this.getFormatter().format(phone));
                        }
                    });
                }
            }
            if (!productAccessor.isVerified()) {
                productAccessor.setEnabledForSms(false);
            }
        } else {
            productAccessor = (LandLinePhone)phone;
            if (!configurationAccessor.isLandLineEnableExtension()) {
                productAccessor.setExtension(null);
            }
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QPhone)this.$).user().network());
    }

    @Override
    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, Phone phone) {
        PhoneExtensionPointEvent phoneExtensionPointEvent;
        try {
            phoneExtensionPointEvent = PhoneExtensionPointEvent.valueOf((String)cRUDOperation.name());
        }
        catch (Exception exception) {
            return null;
        }
        Group group = phone.getUser().getUser().getGroup();
        return this.extensionPointService.newAccessor((ExtensionPointEvent)phoneExtensionPointEvent, new ExtensionPointFilter(group)).attribute("phone", (Object)phone);
    }

    @Override
    protected Validator resolveValidator(PhoneDTO phoneDTO) {
        BasicUser basicUser = phoneDTO.isPersistent() ? ((Phone)this.find(phoneDTO.getId())).getUser() : this.userLocatorHandler.toBasicUserOrCurrent(phoneDTO.getUser());
        return this.getValidator(phoneDTO, (BasicUser)basicUser.getUser());
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(Phone phone, CRUDOperation cRUDOperation) {
        CredentialAccessor credentialAccessor;
        BasicUser basicUser = this.getLoggedBasicUser();
        if (phone.getUser().equals((Object)basicUser) && (credentialAccessor = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION)).isDefined()) {
            if (!(phone instanceof MobilePhone) || cRUDOperation != CRUDOperation.CREATE || !credentialAccessor.getOtpSendMediums().contains(SendMedium.SMS)) {
                return true;
            }
            boolean bl = false;
            List<Phone> list = this.listByUser(basicUser, null);
            for (Phone phone2 : list) {
                if (!(phone2 instanceof MobilePhone) || !((MobilePhone)phone2).isEnabledForSms()) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected BidiMap<Class<? extends Phone>, Class<? extends PhoneDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private boolean canCreatePhone(BasicUser basicUser, PhoneNature phoneNature) {
        if (!this.canManagePhones(basicUser)) {
            return false;
        }
        int n = this.count(basicUser, phoneNature);
        ProductAccessor productAccessor = this.productsHandler.getAccessor(basicUser).product();
        switch (phoneNature) {
            case LANDLINE: {
                return productAccessor.getMaxLandlinePhones() > n;
            }
            case MOBILE: {
                return productAccessor.getMaxMobilePhones() > n;
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean canManagePhones(BasicUser basicUser) {
        return this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.EDIT);
    }

    private boolean canManagePrivacy(BasicUser basicUser) {
        return this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.MANAGE_PRIVACY);
    }

    private void fillPhoneData(ConfigurationAccessor configurationAccessor, PhoneData phoneData, Phone phone) {
        phoneData.setConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
        boolean bl = this.canManagePrivacy(phone.getUser());
        phoneData.setCanManagePrivacy(bl);
        phoneData.setEditable(this.canManagePhones(phone.getUser()));
        phoneData.setEnablePrivacy(this.profileFieldHandler.enablePrivacy(phone.getUser()));
        phoneData.setCanOnlySetPrivate(phoneData.isEnablePrivacy() && !phoneData.isEditable() && bl);
        phoneData.setFormattedNumber(this.getFormatter().format(phone));
    }

    private DBQuery<?> getBaseQuery(BasicUser basicUser, PhoneNature phoneNature, boolean bl) {
        DBQuery dBQuery = (DBQuery)this.from(this.$).where((Predicate)((QPhone)this.$).user().eq((Object)basicUser));
        if (bl && !this.profileFieldHandler.canViewHidden(basicUser)) {
            dBQuery.where((Predicate)((QPhone)this.$).hidden.isFalse());
        }
        if (phoneNature != null) {
            dBQuery.where((Predicate)((QPhone)this.$).nature.eq((Object)phoneNature));
        }
        return dBQuery;
    }

    private Phone getDefaultPhone(BasicUser basicUser, Phone phone) {
        QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from().leftJoin((EntityPath)qMobilePhone)).on((Predicate)((QPhone)this.$).id.eq((Expression)qMobilePhone.id))).where((Predicate)((QPhone)this.$).user().eq((Object)basicUser))).limit(1L);
        if (phone != null) {
            dBQuery.where((Predicate)((QPhone)this.$).id.ne((Object)phone.getId()));
        }
        dBQuery.orderBy(new OrderSpecifier[]{((QPhone)this.$).nature.desc(), qMobilePhone.verificationDate.asc().nullsLast()});
        return (Phone)dBQuery.singleResult((Expression)this.$);
    }

    private String getDefaultPhoneName(Phone phone) {
        MessageKey messageKey;
        Map<PhoneNature, Integer> map = this.counters(phone.getUser());
        int n = map.get(phone.getNature());
        switch (phone.getNature()) {
            case LANDLINE: {
                messageKey = UsersKeys.Phones.LANDLINE_DEFAULT_NAME;
                break;
            }
            case MOBILE: {
                messageKey = UsersKeys.Phones.MOBILE_DEFAULT_NAME;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.translationHandler.message(messageKey, new Object[]{n == 0 ? null : Integer.valueOf(n + 1)}).trim();
    }

    private LandLinePhoneData getLandLineData(ConfigurationAccessor configurationAccessor, LandLinePhone landLinePhone) throws FrameworkException {
        LandLinePhoneData landLinePhoneData = new LandLinePhoneData();
        this.fillPhoneData(configurationAccessor, (PhoneData)landLinePhoneData, (Phone)landLinePhone);
        landLinePhoneData.setExtensionEnabled(configurationAccessor.isLandLineEnableExtension());
        return landLinePhoneData;
    }

    private MobilePhoneData getMobileData(ConfigurationAccessor configurationAccessor, MobilePhone mobilePhone) throws FrameworkException {
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        boolean bl = outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled();
        MobilePhoneData mobilePhoneData = new MobilePhoneData();
        this.fillPhoneData(configurationAccessor, (PhoneData)mobilePhoneData, (Phone)mobilePhone);
        mobilePhoneData.setSmsEnabled(bl);
        mobilePhoneData.setVerified(mobilePhone.isVerified());
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem() || sessionData.isAdminOf(mobilePhone.getUser()) || sessionData.isBrokerOf(mobilePhone.getUser())) {
            mobilePhoneData.setCanManuallyVerify(bl);
        }
        return mobilePhoneData;
    }

    private MobilePhone getMobilePhone(PhoneVO phoneVO, boolean bl) {
        MobilePhone mobilePhone = (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)phoneVO);
        if (mobilePhone.isVerified() != bl) {
            throw new IllegalActionException();
        }
        return mobilePhone;
    }

    private void markAsEnabledForSms(MobilePhone mobilePhone, boolean bl) {
        if (!mobilePhone.isVerified() && bl) {
            throw new IllegalActionException();
        }
        mobilePhone.setEnabledForSms(bl);
    }

    private void markUnverified(MobilePhone mobilePhone) {
        mobilePhone.setVerificationDate(null);
        mobilePhone.setEnabledForSms(false);
    }

    private void sendSmsToOldMobilePhone(MobilePhone mobilePhone, String string) {
        String string2 = string == null ? this.message(MessagingKeys.Notifications.SMS_MOBILE_PHONE_NUMBER_REMOVED, new Object[0]) : this.message(MessagingKeys.Notifications.SMS_MOBILE_PHONE_NUMBER_CHANGED, string);
        this.outboundSmsHandler.sendEvenIfDisabled(mobilePhone, string2, OutboundSmsType.MOBILE_PHONE_NO_LONGER_VALID_FOR_SMS_OPERATIONS);
    }

    static {
        SUBCLASS_MAPPINGS.put(MobilePhone.class, MobilePhoneDTO.class);
        SUBCLASS_MAPPINGS.put(LandLinePhone.class, LandLinePhoneDTO.class);
    }
}

