/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.User;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.users.UserNature;
import org.springframework.stereotype.Component;

@Component
public class PhoneEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<Phone, PhoneDTO> {
    public Class<Phone> getEntityClass() {
        return Phone.class;
    }

    @Override
    public BasicUser getRelatedUser(Phone phone) {
        return phone.getUser();
    }

    public EntityLogType getType() {
        return EntityLogType.PHONE;
    }

    @Override
    public boolean isPrivateEntity(Phone phone) {
        return phone == null ? false : phone.isHidden();
    }

    public EntityLogDescriptor<? extends PhoneDTO> resolveLogDescriptor(Phone phone) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDTOType(phone)).property(PhoneDTO.NAME, GeneralKeys.Ui.NAME).property((Property)PhoneDTO.RAW_NUMBER, UsersKeys.Phones.NUMBER).property((Property)PhoneDTO.HIDDEN, GeneralKeys.Ui.FIELD_VISIBILITY).ignore((Property)PhoneDTO.FORMATTED_NUMBER).ignore((Property)PhoneDTO.NORMALIZED_NUMBER).ignore((Property)PhoneDTO.USER);
        if (phone instanceof LandLinePhone) {
            entityLogDescriptor.cast().property((Property)LandLinePhoneDTO.EXTENSION, UsersKeys.Phones.EXTENSION);
        } else if (phone instanceof MobilePhone) {
            entityLogDescriptor.cast().property((Property)MobilePhoneDTO.VERIFIED, UsersKeys.Phones.VERIFIED).property((Property)MobilePhoneDTO.ENABLED_FOR_SMS, UsersKeys.Phones.ENABLED_FOR_SMS).ignore((Property)MobilePhoneDTO.VERIFICATION_CODE_SEND_DATE);
        }
        return entityLogDescriptor;
    }

    @Override
    protected Phone getEntityToViewLog(long l) {
        return this.find(this.getEntityClass(), l);
    }

    @Override
    protected <BE extends BaseEntity, EDTO extends EntityDTO> EntityLogHandler<BE, EDTO> resolveOwnerEntityLogHandler(EntityLog entityLog) {
        boolean bl = ((BasicUser)this.entityManagerHandler.find(BasicUser.class, entityLog.getOwnerEntityId())).getNature() == UserNature.OPERATOR;
        return this.entityLogRegistry.getHandler(bl ? Operator.class : User.class);
    }

    private Class<? extends PhoneDTO> resolveDTOType(Phone phone) {
        return phone instanceof MobilePhone ? MobilePhoneDTO.class : LandLinePhoneDTO.class;
    }
}

