/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QAccountType;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.messaging.BaseAccountNotificationSettings;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupAccountNotificationSettings;
import org.cyclos.entities.users.OperatorGroupAccountType;
import org.cyclos.entities.users.OperatorGroupLog;
import org.cyclos.entities.users.OperatorGroupPaymentType;
import org.cyclos.entities.users.QMemberProductCustomOperation;
import org.cyclos.entities.users.QOperatorGroup;
import org.cyclos.entities.users.QOperatorGroupAccountType;
import org.cyclos.entities.users.QOperatorGroupLog;
import org.cyclos.entities.users.QOperatorGroupPaymentType;
import org.cyclos.entities.users.QProductMyTokenType;
import org.cyclos.entities.users.QProductRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notificationsettings.AccountNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsDTO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.OperatorExtensionPointEvent;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.UserGroupLogVO;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupDTO;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupData;
import org.cyclos.model.users.operatorgroups.OperatorGroupAccountTypeDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupData;
import org.cyclos.model.users.operatorgroups.OperatorGroupListData;
import org.cyclos.model.users.operatorgroups.OperatorGroupPaymentTypeDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupVO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.Range;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperatorGroupServiceImpl
extends CRUDServiceImpl<OperatorGroup, QOperatorGroup, OperatorGroupDTO, OperatorGroupData, UserLocatorVO>
implements OperatorGroupServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{OperatorGroupDTO.ACCOUNT_TYPES, OperatorGroupDTO.PAYMENT_TYPES, OperatorGroupDTO.ACCOUNT_NOTIFICATION_SETTINGS};
    public static String OPERATOR_GROUP_PROPERTY_NAME = "group";
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    public OperatorGroupServiceImpl() {
        super(OperatorGroup.class, QOperatorGroup.operatorGroup, OperatorGroupDTO.class);
    }

    public boolean anyRequiresAuthorization(OperatorGroup operatorGroup) {
        if (operatorGroup == null) {
            return false;
        }
        QOperatorGroupPaymentType qOperatorGroupPaymentType = QOperatorGroupPaymentType.operatorGroupPaymentType;
        return ((DBQuery)this.from(new EntityPath[]{qOperatorGroupPaymentType}).where(new Predicate[]{qOperatorGroupPaymentType.group().eq((Object)operatorGroup), qOperatorGroupPaymentType.requiresAuthorization.isTrue()})).hasResults();
    }

    public boolean anyRequiresAuthorization(User user) {
        if (user == null) {
            return false;
        }
        QOperatorGroupPaymentType qOperatorGroupPaymentType = QOperatorGroupPaymentType.operatorGroupPaymentType;
        return ((DBQuery)this.from(new EntityPath[]{qOperatorGroupPaymentType}).where(new Predicate[]{qOperatorGroupPaymentType.group().user().eq((Object)user), qOperatorGroupPaymentType.requiresAuthorization.isTrue()})).hasResults();
    }

    public boolean canAuthorizeAnyPayment(OperatorGroup operatorGroup) {
        if (operatorGroup == null) {
            return false;
        }
        QOperatorGroupPaymentType qOperatorGroupPaymentType = QOperatorGroupPaymentType.operatorGroupPaymentType;
        return ((DBQuery)this.from(new EntityPath[]{qOperatorGroupPaymentType}).where(new Predicate[]{qOperatorGroupPaymentType.group().eq((Object)operatorGroup), qOperatorGroupPaymentType.authorize.isTrue()})).hasResults();
    }

    public Long changeGroup(ChangeOperatorGroupDTO changeOperatorGroupDTO) throws FrameworkException {
        Operator operator = (Operator)this.conversionHandler.convert(Operator.class, (Object)changeOperatorGroupDTO.getOperator());
        if (operator.isRemoved()) {
            throw new IllegalActionException();
        }
        OperatorGroup operatorGroup = (OperatorGroup)this.conversionHandler.convert(OperatorGroup.class, (Object)changeOperatorGroupDTO.getGroup());
        if (operatorGroup != null && !operatorGroup.getUser().equals((Object)operator.getUser())) {
            throw new EntityNotFoundException();
        }
        OperatorGroup operatorGroup2 = operator.getGroup();
        if (operatorGroup2 == null && operatorGroup == null) {
            String string = this.message(UsersKeys.Groups.CHANGE_GROUP_NEW_GROUP, new Object[0]);
            String string2 = this.message(GeneralKeys.Errors.REQUIRED, string);
            throw new ValidationException(ChangeOperatorGroupDTO.GROUP.getName(), string2);
        }
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)OperatorExtensionPointEvent.CHANGE_GROUP, new ExtensionPointFilter(operator.getUser().getGroup())).attribute("operator", (Object)operator).attribute("user", null).attribute("oldGroup", (Object)operatorGroup2).attribute("newGroup", (Object)operatorGroup).attribute("comments", (Object)changeOperatorGroupDTO.getComment());
        extensionPointAccessor.fireValidated();
        this.connectedUserService.disconnect(new UserLocatorVO(operator.getId()));
        operator.setGroup(operatorGroup);
        Date date = new Date();
        OperatorGroupLog operatorGroupLog = this.getLastLog(operator);
        if (operatorGroupLog != null) {
            operatorGroupLog.setEndDate(date);
        }
        OperatorGroupLog operatorGroupLog2 = this.createLog(operator, date, changeOperatorGroupDTO.getComment());
        this.entityLogService.log((SimpleEntity)operator, this.message(UsersKeys.Operators.OPERATOR_GROUP, new Object[0]), OPERATOR_GROUP_PROPERTY_NAME, this.getFormatter().format((INamedEntity)operatorGroup2), this.getFormatter().format((INamedEntity)operatorGroup), null);
        extensionPointAccessor.fireSaved();
        return operatorGroupLog2.getId();
    }

    public OperatorGroupLog createInitialGroupHistoryLog(Operator operator) throws FrameworkException {
        return this.createLog(operator, new Date(), this.message(UsersKeys.Operators.INITIAL_LOG_DESCRIPTION, new Object[0]));
    }

    public ChangeOperatorGroupData getChangeGroupData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (!(basicUser instanceof Operator)) {
            throw new EntityNotFoundException();
        }
        Operator operator = (Operator)basicUser;
        List<OperatorGroup> list = this.getPossibleNewGroups(operator);
        List<OperatorGroupLog> list2 = this.getOperatorGroupLogs(operator);
        ChangeOperatorGroupData changeOperatorGroupData = new ChangeOperatorGroupData();
        changeOperatorGroupData.setOperator((OperatorVO)this.conversionHandler.convert(OperatorVO.class, (Object)operator));
        changeOperatorGroupData.setStatus(operator.getStatus());
        changeOperatorGroupData.setCurrentGroup((BasicGroupVO)this.conversionHandler.convert(BasicGroupVO.class, (Object)operator.getGroup()));
        changeOperatorGroupData.setPossibleNewGroups(this.conversionHandler.convertList(BasicGroupVO.class, list));
        changeOperatorGroupData.setLogs(this.conversionHandler.convertList(UserGroupLogVO.class, list2));
        return changeOperatorGroupData;
    }

    public OperatorGroupListData getListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        OperatorGroupListData operatorGroupListData = new OperatorGroupListData();
        operatorGroupListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        operatorGroupListData.setGroups(this.conversionHandler.convertList(OperatorGroupVO.class, this.list(user)));
        operatorGroupListData.setCanManage(!user.isRemoved());
        return operatorGroupListData;
    }

    public List<OperatorGroup> list(User user) {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QOperatorGroup)this.$).user().eq((Object)user))).orderBy(((QOperatorGroup)this.$).name.asc())).list((Expression)this.$);
    }

    public List<AccountType> listAccountTypesWithAuthorization(OperatorGroup operatorGroup) {
        if (operatorGroup == null) {
            return Collections.emptyList();
        }
        QOperatorGroupPaymentType qOperatorGroupPaymentType = QOperatorGroupPaymentType.operatorGroupPaymentType;
        QAccountType qAccountType = QAccountType.accountType;
        return ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qOperatorGroupPaymentType}).join((EntityPath)qOperatorGroupPaymentType.paymentType().from(), (Path)qAccountType)).where(new Predicate[]{qOperatorGroupPaymentType.group().eq((Object)operatorGroup), qOperatorGroupPaymentType.requiresAuthorization.isTrue().or((Predicate)qOperatorGroupPaymentType.authorize.isTrue())})).orderBy(qAccountType.name.asc())).distinct()).list((Expression)qAccountType);
    }

    public List<PaymentTransferType> listPaymentTypesWithAuthorize(OperatorGroup operatorGroup) {
        if (operatorGroup == null) {
            return Collections.emptyList();
        }
        QOperatorGroupPaymentType qOperatorGroupPaymentType = QOperatorGroupPaymentType.operatorGroupPaymentType;
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qOperatorGroupPaymentType}).join((EntityPath)qOperatorGroupPaymentType.paymentType(), (Path)qPaymentTransferType)).where(new Predicate[]{qOperatorGroupPaymentType.group().eq((Object)operatorGroup), qOperatorGroupPaymentType.authorize.isTrue()})).orderBy(qPaymentTransferType.name.asc())).list((Expression)qPaymentTransferType);
    }

    @Override
    public OperatorGroup newEntity(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        OperatorGroup operatorGroup = new OperatorGroup();
        operatorGroup.setUser(user);
        return operatorGroup;
    }

    @Override
    public OperatorGroupDTO toDTO(OperatorGroup operatorGroup) {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        User user = operatorGroup.getUser();
        OperatorGroupDTO operatorGroupDTO = (OperatorGroupDTO)super.toDTO(operatorGroup);
        SessionData sessionData = SessionDataFactory.user((BasicUser)user);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.invokerHandler.runAs(sessionData, () -> {
            MemberProductAccessor memberProductAccessor = sessionData.getProducts().member();
            arrayList.addAll(memberProductAccessor.getUserAccounts());
            arrayList2.addAll(memberProductAccessor.getSystemPayments());
            arrayList2.addAll(memberProductAccessor.getUserPayments());
            arrayList2.addAll(memberProductAccessor.getSelfPayments());
            arrayList2.removeIf(paymentTransferType -> !arrayList.contains(paymentTransferType.getFrom()));
            return null;
        });
        ArrayList<OperatorGroupAccountTypeDTO> arrayList3 = new ArrayList<OperatorGroupAccountTypeDTO>();
        for (Object object42 : arrayList) {
            object32 = operatorGroup.getAccountType((UserAccountType)object42);
            if (object32 == null) {
                object32 = new OperatorGroupAccountType();
                object32.setGroup(operatorGroup);
                object32.setAccountType((UserAccountType)object42);
                object32.setAccess(OperatorGroupAccountAccess.NONE);
            }
            arrayList3.add((OperatorGroupAccountTypeDTO)this.conversionHandler.convert(OperatorGroupAccountTypeDTO.class, object32));
        }
        operatorGroupDTO.setAccountTypes(arrayList3);
        ArrayList arrayList4 = new ArrayList();
        for (Object object32 : arrayList2) {
            object2 = operatorGroup.getPaymentType((PaymentTransferType)object32);
            if (object2 == null) {
                object2 = new OperatorGroupPaymentType();
                object2.setGroup(operatorGroup);
                object2.setPaymentType((PaymentTransferType)object32);
            }
            object = (OperatorGroupPaymentTypeDTO)this.conversionHandler.convert(OperatorGroupPaymentTypeDTO.class, object2);
            object.setMaxAmountPerDay(BigDecimalHelper.round((BigDecimal)object.getMaxAmountPerDay(), (int)object32.getCurrency().getPrecision()));
            arrayList4.add(object);
        }
        operatorGroupDTO.setPaymentTypes((List)arrayList4);
        object42 = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
        object32 = new ArrayList(object42.size());
        object2 = operatorGroup.getAccountNotificationSettings().stream().collect(Collectors.toMap(BaseAccountNotificationSettings::getAccountType, operatorGroupAccountNotificationSettings -> operatorGroupAccountNotificationSettings));
        object = object42.iterator();
        while (object.hasNext()) {
            AccountNotificationSettingsDTO accountNotificationSettingsDTO;
            DecimalRangeDTO decimalRangeDTO;
            UserAccountType userAccountType = (UserAccountType)object.next();
            OperatorGroupAccountNotificationSettings operatorGroupAccountNotificationSettings2 = (OperatorGroupAccountNotificationSettings)object2.get(userAccountType);
            if (operatorGroupAccountNotificationSettings2 == null) {
                operatorGroupAccountNotificationSettings2 = new OperatorGroupAccountNotificationSettings();
                operatorGroupAccountNotificationSettings2.setAccountType(userAccountType);
            }
            if ((decimalRangeDTO = (accountNotificationSettingsDTO = (AccountNotificationSettingsDTO)this.conversionHandler.convert(AccountNotificationSettingsDTO.class, (Object)operatorGroupAccountNotificationSettings2)).getPaymentAmount()) != null) {
                decimalRangeDTO.setMin(BigDecimalHelper.round((BigDecimal)decimalRangeDTO.getMin(), (int)userAccountType.getCurrency().getPrecision()));
                decimalRangeDTO.setMax(BigDecimalHelper.round((BigDecimal)decimalRangeDTO.getMax(), (int)userAccountType.getCurrency().getPrecision()));
            }
            object32.add(accountNotificationSettingsDTO);
        }
        operatorGroupDTO.setAccountNotificationSettings((List)object32);
        return operatorGroupDTO;
    }

    @Override
    public OperatorGroup toEntity(OperatorGroupDTO operatorGroupDTO) {
        Object object4;
        Object object2;
        Object object32;
        OperatorGroup operatorGroup = (OperatorGroup)super.toEntity(operatorGroupDTO);
        Set set = operatorGroup.getAccountTypes();
        HashSet<UserAccountType> hashSet = new HashSet<UserAccountType>();
        for (Object object32 : CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountTypes())) {
            object2 = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)object32.getAccountType());
            hashSet.add((UserAccountType)object2);
            object4 = operatorGroup.getAccountType((UserAccountType)object2);
            if (object4 == null) {
                object4 = new OperatorGroupAccountType();
                object4.setGroup(operatorGroup);
                object4.setAccountType((UserAccountType)object2);
                set.add(object4);
            }
            object4.setAccess(object32.getAccess());
            this.conversionHandler.fillExcluding(object32, object4, new Object[]{OperatorGroupAccountTypeDTO.ACCOUNT_TYPE});
        }
        set.removeIf(operatorGroupAccountType -> !hashSet.contains(operatorGroupAccountType.getAccountType()));
        Set set2 = operatorGroup.getPaymentTypes();
        object32 = new HashSet();
        for (Object object4 : CollectionHelper.orEmpty((List)operatorGroupDTO.getPaymentTypes())) {
            PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)object4.getPaymentType());
            object32.add(paymentTransferType);
            OperatorGroupPaymentType operatorGroupPaymentType = operatorGroup.getPaymentType(paymentTransferType);
            if (operatorGroupPaymentType == null) {
                operatorGroupPaymentType = new OperatorGroupPaymentType();
                operatorGroupPaymentType.setGroup(operatorGroup);
                operatorGroupPaymentType.setPaymentType(paymentTransferType);
                set2.add(operatorGroupPaymentType);
            }
            object4.setMaxAmountPerDay(BigDecimalHelper.round((BigDecimal)object4.getMaxAmountPerDay(), (int)paymentTransferType.getCurrency().getPrecision()));
            this.conversionHandler.fillExcluding(object4, (Object)operatorGroupPaymentType, new Object[]{OperatorGroupPaymentTypeDTO.PAYMENT_TYPE});
        }
        set2.removeIf(arg_0 -> OperatorGroupServiceImpl.lambda$toEntity$4((Set)object32, arg_0));
        object2 = operatorGroup.getAccountNotificationSettings();
        object4 = new HashSet();
        for (OperatorGroupPaymentType operatorGroupPaymentType : CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountNotificationSettings())) {
            UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)operatorGroupPaymentType.getAccountType());
            object4.add(userAccountType);
            OperatorGroupAccountNotificationSettings operatorGroupAccountNotificationSettings2 = operatorGroup.getAccountNotificationSettings(userAccountType);
            DecimalRangeDTO decimalRangeDTO = operatorGroupPaymentType.getPaymentAmount();
            if (decimalRangeDTO != null) {
                decimalRangeDTO.setMin(BigDecimalHelper.round((BigDecimal)decimalRangeDTO.getMin(), (int)userAccountType.getCurrency().getPrecision()));
                decimalRangeDTO.setMax(BigDecimalHelper.round((BigDecimal)decimalRangeDTO.getMax(), (int)userAccountType.getCurrency().getPrecision()));
            }
            if (operatorGroupAccountNotificationSettings2 == null) {
                operatorGroupAccountNotificationSettings2 = new OperatorGroupAccountNotificationSettings();
                operatorGroupAccountNotificationSettings2.setGroup(operatorGroup);
                operatorGroupAccountNotificationSettings2.setAccountType(userAccountType);
                object2.add(operatorGroupAccountNotificationSettings2);
            }
            this.conversionHandler.fillExcluding((Object)operatorGroupPaymentType, (Object)operatorGroupAccountNotificationSettings2, new Object[]{OperatorGroupAccountTypeDTO.ACCOUNT_TYPE});
        }
        object2.removeIf(operatorGroupAccountNotificationSettings -> !hashSet.contains(operatorGroupAccountNotificationSettings.getAccountType()));
        return operatorGroup;
    }

    @Override
    protected OperatorGroupData getData(OperatorGroup operatorGroup) {
        OperatorGroupData operatorGroupData = new OperatorGroupData();
        operatorGroupData.setDto((EntityDTO)this.toDTO(operatorGroup));
        User user = operatorGroup.getUser();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        operatorGroupData.setCanHaveMessages(productsAccessor.product().hasPermission(Permission.MY_MESSAGES_VIEW));
        operatorGroupData.setCanHaveNotifications(productsAccessor.product().hasPermission(Permission.MY_NOTIFICATIONS_ENABLE));
        operatorGroupData.setCanReceivePayments(productsAccessor.product().hasPermission(Permission.MY_PAYMENTS_RECEIVE) || productsAccessor.product().hasPermission(Permission.MY_PAYMENT_TICKETS_CREATE));
        operatorGroupData.setCanRequestPayments(productsAccessor.product().hasPermission(Permission.MY_PAYMENT_REQUESTS_VIEW));
        operatorGroupData.setCanChargebackPayments(productsAccessor.product().hasPermission(Permission.MY_PAYMENTS_CHARGEBACK));
        operatorGroupData.setCanManageAdvertisements(productsAccessor.product().hasPermission(Permission.MY_ADS_MANAGE) || productsAccessor.product().hasPermission(Permission.MY_WEB_SHOP_MANAGE));
        operatorGroupData.setCanViewAdvertisements(productsAccessor.product().hasPermission(Permission.USER_ADS_VIEW) || productsAccessor.product().hasPermission(Permission.USER_WEB_SHOP_VIEW));
        operatorGroupData.setCanPerformVoucherTransactions(productsAccessor.product().hasPermission(Permission.MY_VOUCHERS_REDEEM) || productsAccessor.product().hasPermission(Permission.MY_VOUCHERS_TOP_UP));
        Set set = productsAccessor.member().getMyRecordTypes().keysSet((Path)QProductRecordType.productRecordType.view);
        operatorGroupData.setRecordTypes(this.conversionHandler.convertList(RecordTypeVO.class, (Iterable)CollectionHelper.sort((Collection)set)));
        operatorGroupData.setCanEnableTokenPrincipalTypes(productsAccessor.member().getMyTokenTypes().isAnyKeySet((Path)QProductMyTokenType.productMyTokenType.enable));
        operatorGroupData.setCanBlockTokenPrincipalTypes(productsAccessor.member().getMyTokenTypes().isAnyKeySet((Path)QProductMyTokenType.productMyTokenType.block));
        operatorGroupData.setCanUnblockTokenPrincipalTypes(productsAccessor.member().getMyTokenTypes().isAnyKeySet((Path)QProductMyTokenType.productMyTokenType.unblock));
        operatorGroupData.setCanCancelTokenPrincipalTypes(productsAccessor.member().getMyTokenTypes().isAnyKeySet((Path)QProductMyTokenType.productMyTokenType.cancel));
        QMemberProductCustomOperation qMemberProductCustomOperation = QMemberProductCustomOperation.memberProductCustomOperation;
        BooleanPropertiesHolder booleanPropertiesHolder = productsAccessor.member().getCustomOperations();
        Set set2 = booleanPropertiesHolder.keysSet((Path)qMemberProductCustomOperation.run);
        set2.addAll(booleanPropertiesHolder.keysSet((Path)qMemberProductCustomOperation.runOnOthers));
        List list = CollectionHelper.sort((Collection)set2, Comparator.comparing(CustomOperation::getScope).thenComparing(ConfigurationOrderableEntity::getOrder, Comparator.nullsLast(Comparator.naturalOrder())));
        operatorGroupData.setCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, (Iterable)list));
        operatorGroupData.setBroker(user.isBroker());
        boolean bl = user.equals((Object)this.getLoggedUser()) ? this.voucherConfigurationService.listVisible(user).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null) : CollectionUtils.intersection((Iterable)this.voucherConfigurationService.listEnabled(user), (Iterable)this.voucherConfigurationService.listVisible(this.getLoggedUser())).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null);
        operatorGroupData.setVoucherTopUpEnabled(bl);
        return operatorGroupData;
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(OperatorGroup operatorGroup) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(OperatorGroupDTO operatorGroupDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object onBeforeSave(OperatorGroup operatorGroup, OperatorGroup operatorGroup2) {
        if (!operatorGroup.isEnableTokenPrincipalType()) {
            operatorGroup.setBlockTokenPrincipalType(Boolean.valueOf(false));
            operatorGroup.setUnblockTokenPrincipalType(Boolean.valueOf(false));
            operatorGroup.setCancelTokenPrincipalType(Boolean.valueOf(false));
        }
        CollectionHelper.orEmpty((Set)operatorGroup.getPaymentTypes()).stream().forEach(operatorGroupPaymentType -> {
            if (!operatorGroupPaymentType.isEnabled()) {
                operatorGroupPaymentType.setMaxAmountPerDay(null);
                operatorGroupPaymentType.setRequiresAuthorization(false);
            }
        });
        if (!operatorGroup.isNotifications()) {
            operatorGroup.getAccountNotificationSettings().clear();
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QOperatorGroup)this.$).user().network());
        networkPathRegistry.register(QOperatorGroupAccountType.operatorGroupAccountType.group().user().network());
        networkPathRegistry.register(QOperatorGroupPaymentType.operatorGroupPaymentType.group().user().network());
    }

    @Override
    protected Validator resolveValidator(OperatorGroupDTO operatorGroupDTO) {
        OperatorGroup operatorGroup;
        User user;
        Validator validator = new Validator();
        if (operatorGroupDTO.isTransient()) {
            validator.property((Property)OperatorGroupDTO.USER, UsersKeys.Users.USER).required();
            user = (User)this.conversionHandler.convert(User.class, (Object)operatorGroupDTO.getUser());
        } else {
            operatorGroup = (OperatorGroup)this.find(operatorGroupDTO.getId());
            user = operatorGroup.getUser();
        }
        if (user != null) {
            Set set;
            Object object;
            List list;
            operatorGroup = validator.property((Property)OperatorGroupDTO.PAYMENT_TYPES, UsersKeys.OperatorGroups.PAYMENT_TYPES);
            List list2 = CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountTypes()).stream().filter(operatorGroupAccountTypeDTO -> operatorGroupAccountTypeDTO.getAccess().equals((Object)OperatorGroupAccountAccess.NONE)).map(OperatorGroupAccountTypeDTO::getAccountType).map(this.conversionHandler.convertingFunction(UserAccountType.class, new Object[0])).collect(Collectors.toList());
            if (CollectionHelper.isNotEmpty(list2)) {
                list = CollectionHelper.orEmpty((List)operatorGroupDTO.getPaymentTypes()).stream().filter(OperatorGroupPaymentTypeDTO::isEnabled).map(OperatorGroupPaymentTypeDTO::getPaymentType).map(this.conversionHandler.convertingFunction(PaymentTransferType.class, new Object[0])).filter(paymentTransferType -> list2.contains(paymentTransferType.getFrom())).map(arg_0 -> ((DataTranslationHandler)this.dataTranslationHandler).getName(arg_0)).sorted().collect(Collectors.toList());
                if (CollectionHelper.isNotEmpty(list)) {
                    object = list2.stream().map(arg_0 -> ((DataTranslationHandler)this.dataTranslationHandler).getName(arg_0)).sorted().collect(Collectors.toList());
                    operatorGroup.invalid(new ValidationError(UsersKeys.OperatorGroups.ERROR_PAYMENT_TYPES_ACCOUNT_NOT_VISIBLE, new Object[]{CollectionHelper.join(list, (String)", "), CollectionHelper.join(object, (String)", ")}));
                }
                if (operatorGroupDTO.isNotifications()) {
                    object = CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountNotificationSettings()).stream().filter(accountNotificationSettingsDTO -> list2.contains(this.conversionHandler.convert(UserAccountType.class, (Object)accountNotificationSettingsDTO.getAccountType())) && !Range.isEmpty((Range)accountNotificationSettingsDTO.getPaymentAmount())).map(AccountNotificationSettingsDTO::getAccountType).map(this.conversionHandler.convertingFunction(UserAccountType.class, new Object[0])).map(arg_0 -> ((DataTranslationHandler)this.dataTranslationHandler).getName(arg_0)).sorted().collect(Collectors.toList());
                    if (CollectionHelper.isNotEmpty((Iterable)object)) {
                        validator.property((Property)OperatorGroupDTO.ACCOUNT_NOTIFICATION_SETTINGS, MessagingKeys.NotificationSettings.ACCOUNT_SETTINGS_PAYMENT_AMOUNT).invalid(new ValidationError(UsersKeys.OperatorGroups.ERROR_ACCOUNT_NOTIFICATION_ACCOUNT_NOT_VISIBLE, new Object[]{CollectionHelper.join((Iterable)object, (String)", ")}));
                    }
                }
                if (list2.size() == operatorGroupDTO.getAccountTypes().size()) {
                    if (operatorGroupDTO.isChargebackPayments()) {
                        validator.property((Property)OperatorGroupDTO.CHARGEBACK_PAYMENTS, UsersKeys.OperatorGroups.CHARGEBACK_PAYMENTS).invalid(new ValidationError(UsersKeys.OperatorGroups.ACCOUNT_ACCESS_REQUIRED));
                    }
                    if (operatorGroupDTO.isReceivePayments()) {
                        validator.property((Property)OperatorGroupDTO.RECEIVE_PAYMENTS, UsersKeys.OperatorGroups.RECEIVE_PAYMENTS).invalid(new ValidationError(UsersKeys.OperatorGroups.ACCOUNT_ACCESS_REQUIRED));
                    }
                    if (operatorGroupDTO.isRequestPayments()) {
                        validator.property((Property)OperatorGroupDTO.REQUEST_PAYMENTS, UsersKeys.OperatorGroups.REQUEST_PAYMENTS).invalid(new ValidationError(UsersKeys.OperatorGroups.ACCOUNT_ACCESS_REQUIRED));
                    }
                    if (operatorGroupDTO.isVoucherTransactions()) {
                        object = this.voucherConfigurationService.listVisible(user).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null) ? UsersKeys.OperatorGroups.VOUCHER_TRANSACTIONS : UsersKeys.OperatorGroups.VOUCHER_TRANSACTIONS_REDEEMS;
                        validator.property((Property)OperatorGroupDTO.VOUCHER_TRANSACTIONS, object).invalid(new ValidationError(UsersKeys.OperatorGroups.ACCOUNT_ACCESS_REQUIRED));
                    }
                    if (CollectionHelper.isNotEmpty((Iterable)operatorGroupDTO.getRestrictPaymentsToUsers())) {
                        validator.property((Property)OperatorGroupDTO.RESTRICT_PAYMENTS_TO_USERS, UsersKeys.OperatorGroups.RESTRICT_PAYMENTS_TO_USERS).invalid(new ValidationError(UsersKeys.OperatorGroups.ACCOUNT_ACCESS_REQUIRED));
                    }
                }
            }
            list = CollectionHelper.orEmpty((List)operatorGroupDTO.getAccountTypes()).stream().filter(operatorGroupAccountTypeDTO -> ObjectHelper.isOneOf((Object)operatorGroupAccountTypeDTO.getAccess(), (Object[])new Object[]{OperatorGroupAccountAccess.NONE, OperatorGroupAccountAccess.OWN_PAYMENTS, OperatorGroupAccountAccess.INCOMING_PAYMENTS})).map(OperatorGroupAccountTypeDTO::getAccountType).map(this.conversionHandler.convertingFunction(UserAccountType.class, new Object[0])).collect(Collectors.toList());
            object = CollectionHelper.orEmpty((List)operatorGroupDTO.getPaymentTypes()).stream().filter(OperatorGroupPaymentTypeDTO::isAuthorize).map(operatorGroupPaymentTypeDTO -> (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)operatorGroupPaymentTypeDTO.getPaymentType())).filter(paymentTransferType -> list.contains(paymentTransferType.getFrom())).sorted().collect(Collectors.toList());
            if (CollectionHelper.isNotEmpty(object)) {
                set = object.stream().map(TransferType::getFrom).collect(Collectors.toSet());
                set.retainAll(list);
                operatorGroup.invalid(new ValidationError(UsersKeys.OperatorGroups.ERROR_PAYMENT_TYPES_AUTHORIZE_NOT_ACCESSIBLE, new Object[]{object, CollectionHelper.sort((Collection)set)}));
            }
            if (CollectionHelper.isNotEmpty((Iterable)operatorGroupDTO.getRestrictPaymentsToUsers())) {
                set = this.conversionHandler.convertSet(User.class, (Iterable)operatorGroupDTO.getRestrictPaymentsToUsers());
                set.removeIf(user2 -> this.authHandler.relatesTo((BasicUser)user, (BasicUser)user2));
                if (!set.isEmpty()) {
                    validator.property((Property)OperatorGroupDTO.RESTRICT_PAYMENTS_TO_USERS, UsersKeys.OperatorGroups.RESTRICT_PAYMENTS_TO_USERS).invalid(new ValidationError(UsersKeys.OperatorGroups.RESTRICT_PAYMENTS_TO_USERS_ERROR_NOT_VISIBLE, new Object[]{user, set}));
                }
            }
            if (CollectionHelper.isNotEmpty((Iterable)operatorGroupDTO.getAccountNotificationSettings())) {
                set = validator.property((Property)UserNotificationSettingsDTO.ACCOUNT_NOTIFICATION_SETTINGS, MessagingKeys.NotificationSettings.ACCOUNT_SETTINGS_PAYMENT_AMOUNT);
                this.notificationSettingsService.appendAccountSettingsValidations((BasicUser)user, (org.cyclos.impl.utils.validation.Property)set);
            }
        }
        return validator;
    }

    private OperatorGroupLog createLog(Operator operator, Date date, String string) {
        OperatorGroupLog operatorGroupLog = new OperatorGroupLog();
        operatorGroupLog.setOperator(operator);
        operatorGroupLog.setGroup(operator.getGroup());
        operatorGroupLog.setStartDate(date);
        operatorGroupLog.setComment(string);
        operatorGroupLog.setBy(this.getLoggedBasicUser());
        this.persist((IEntity)operatorGroupLog);
        return operatorGroupLog;
    }

    private OperatorGroupLog getLastLog(Operator operator) {
        List<OperatorGroupLog> list = this.getOperatorGroupLogs(operator);
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        return (OperatorGroupLog)CollectionHelper.first(list);
    }

    private List<OperatorGroupLog> getOperatorGroupLogs(Operator operator) {
        QOperatorGroupLog qOperatorGroupLog = QOperatorGroupLog.operatorGroupLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qOperatorGroupLog}).where((Predicate)qOperatorGroupLog.operator().eq((Object)operator))).orderBy(qOperatorGroupLog.startDate.desc())).list((Expression)qOperatorGroupLog);
    }

    private List<OperatorGroup> getPossibleNewGroups(Operator operator) {
        if (operator.isRemoved()) {
            return Collections.emptyList();
        }
        List<OperatorGroup> list = this.list(operator.getUser());
        list.remove(operator.getGroup());
        return list;
    }

    private static /* synthetic */ boolean lambda$toEntity$4(Set set, OperatorGroupPaymentType operatorGroupPaymentType) {
        return !set.contains(operatorGroupPaymentType.getPaymentType());
    }
}

