/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.GroupsHandlerInternal;
import org.cyclos.impl.users.VisibleGroupListViewFactoryImpl;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.users.users.GroupVisibility;

public class GroupListViewFactoryImpl
implements GroupListViewFactory {
    protected Set<BasicGroup> basicGroups;
    protected GroupListView<BasicGroup, BasicGroupVO> basicGroupsView;
    protected GroupListView<Group, GroupVO> groupsView;
    protected GroupListView<UserGroup, UserGroupVO> userGroupsView;
    protected GroupListView<BrokerGroup, GroupVO> brokerGroupsView;
    protected GroupListView<BasicGroup, BasicGroupVO> basicUserGroupsView;
    protected GroupListView<AdminGroup, AdminGroupVO> adminGroupsView;
    protected GroupListView<GroupSet, GroupSetVO> groupSetsView;
    protected final GroupsHandlerInternal groupsHandler;
    protected final boolean overBrokered;
    protected final boolean includeDisabled;

    static GroupListViewFactoryImpl empty(GroupsHandlerInternal groupsHandlerInternal) {
        return GroupListViewFactoryImpl.of(groupsHandlerInternal, false, false, Collections.emptySet());
    }

    static GroupListViewFactoryImpl of(GroupsHandlerInternal groupsHandlerInternal, boolean bl, boolean bl2, Set<BasicGroup> set) {
        return new GroupListViewFactoryImpl(groupsHandlerInternal, bl, bl2, set, false);
    }

    static GroupListViewFactoryImpl of(GroupsHandlerInternal groupsHandlerInternal, boolean bl, boolean bl2, Set<BasicGroup> set, GroupVisibility groupVisibility) {
        return new VisibleGroupListViewFactoryImpl(groupsHandlerInternal, bl, bl2, set, false, groupVisibility);
    }

    protected GroupListViewFactoryImpl(GroupsHandlerInternal groupsHandlerInternal, boolean bl, boolean bl2, Set<BasicGroup> set, boolean bl3) {
        this.groupsHandler = groupsHandlerInternal;
        this.overBrokered = bl;
        this.includeDisabled = bl2;
        this.basicGroups = set;
        if (bl3) {
            this.basicGroups = new HashSet<BasicGroup>(this.basicGroups);
            this.basicGroups.addAll(groupsHandlerInternal.getAccessibleGlobalGroups());
        }
    }

    public GroupListView<AdminGroup, AdminGroupVO> admins() {
        if (this.adminGroupsView == null) {
            this.adminGroupsView = this.createView(this.basicGroups.stream().filter(AdminGroup.class::isInstance).map(basicGroup -> (AdminGroup)basicGroup).collect(Collectors.toSet()));
        }
        return this.adminGroupsView;
    }

    public GroupListView<BasicGroup, BasicGroupVO> basic() {
        if (this.basicGroupsView == null) {
            Set set = GroupsHandler.doFlatten(this.basicGroups, (boolean)this.includeDisabled, (boolean)true);
            this.basicGroupsView = this.createView(set);
        }
        return this.basicGroupsView;
    }

    public GroupListView<BasicGroup, BasicGroupVO> basicUsers() {
        if (this.basicUserGroupsView == null) {
            this.basicUserGroupsView = this.createView(this.basic().items().stream().filter(basicGroup -> !(basicGroup instanceof AdminGroup)).collect(Collectors.toSet()));
        }
        return this.basicUserGroupsView;
    }

    public GroupListView<BrokerGroup, GroupVO> brokers() {
        if (this.brokerGroupsView == null) {
            this.brokerGroupsView = this.createView(this.groups().items().stream().filter(BrokerGroup.class::isInstance).map(group -> (BrokerGroup)group).collect(Collectors.toSet()));
        }
        return this.brokerGroupsView;
    }

    public GroupListView<Group, GroupVO> groups() {
        if (this.groupsView == null) {
            this.groupsView = this.createView(this.basic().items().stream().filter(basicGroup -> !(basicGroup instanceof GroupSet)).map(basicGroup -> (Group)basicGroup).collect(Collectors.toSet()));
        }
        return this.groupsView;
    }

    public GroupListView<GroupSet, GroupSetVO> groupSets() {
        if (this.groupSetsView == null) {
            this.groupSetsView = this.createView(this.basic().items().stream().filter(GroupSet.class::isInstance).map(basicGroup -> (GroupSet)basicGroup).collect(Collectors.toSet()));
        }
        return this.groupSetsView;
    }

    public GroupListViewFactory includeGlobals() {
        return new GroupListViewFactoryImpl(this.groupsHandler, this.overBrokered, this.includeDisabled, this.basicGroups, true);
    }

    public boolean isEmpty() {
        return this.basicGroups.isEmpty();
    }

    public GroupListView<UserGroup, UserGroupVO> users() {
        if (this.userGroupsView == null) {
            this.userGroupsView = this.createView(this.groups().items().stream().filter(UserGroup.class::isInstance).map(group -> (UserGroup)group).collect(Collectors.toSet()));
        }
        return this.userGroupsView;
    }

    protected <T extends BasicGroup, VO extends BasicGroupVO> GroupListView<T, VO> createView(Set<T> set) {
        return GroupListView.of((GroupsHandlerInternal)this.groupsHandler, set);
    }
}

