/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.marketplace.AdAddress;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.utils.LatLong;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.model.users.addresses.AddressNature;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class GoogleMapsGeocoder {
    private static final Logger LOG = LogManager.getLogger(GoogleMapsGeocoder.class);
    private static final String API_URL = "https://maps.googleapis.com/maps/api/geocode/json?region={reg}&address={address}";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ConfigurationHandler configurationHandler;

    public LocalizationStatus geocode(GeoLocatedAddress geoLocatedAddress) {
        User user = geoLocatedAddress.getNature() == AddressNature.AD ? ((AdAddress)geoLocatedAddress).getAd().getOwner() : ((UserAddress)geoLocatedAddress).getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        String string = configurationAccessor.getMapServerApiKey();
        if (string == null || !configurationAccessor.isUseMap()) {
            return LocalizationStatus.DISABLED;
        }
        return this.geocode(geoLocatedAddress, string, configurationAccessor.getCountry()) ? LocalizationStatus.SUCCESS : LocalizationStatus.FAILED;
    }

    public boolean geocode(GeoLocatedAddress geoLocatedAddress, String string, String string2) {
        Status status;
        if (!AddressHelper.isLocalizable((IAddress)geoLocatedAddress)) {
            return false;
        }
        String string3 = (String)ObjectHelper.defaultValue((Object)geoLocatedAddress.getCountry(), (Object)string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getAddressLine1())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getAddressLine1());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getAddressLine2())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getAddressLine2());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getStreet())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getStreet());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getBuildingNumber())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getBuildingNumber());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getNeighborhood())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getNeighborhood());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getCity())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getCity());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getRegion())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getRegion());
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getZip())) {
            stringBuilder.append(", ").append(geoLocatedAddress.getZip());
        }
        String string4 = "https://maps.googleapis.com/maps/api/geocode/json?region={reg}&address={address}&key=" + string;
        Response response = (Response)this.restTemplate.getForObject(string4, Response.class, new Object[]{string3, stringBuilder.toString()});
        Status status2 = status = response == null ? null : response.getStatus();
        if (status == null) {
            status = Status.ZERO_RESULTS;
        }
        switch (status.ordinal()) {
            case 2: {
                LOG.warn("Query limit exceeded by Google Maps Geocoder for address {}", (Object)geoLocatedAddress);
                return false;
            }
            case 3: {
                LOG.warn("Request denied by Google Maps Geocoder for address {}", (Object)geoLocatedAddress);
                return false;
            }
            case 0: {
                Result result = (Result)CollectionHelper.first(response.getResults());
                Location location = result.getGeometry().getLocation();
                LatLong latLong = new LatLong(location.getLat(), location.getLng());
                geoLocatedAddress.setLocation(latLong);
                geoLocatedAddress.setGeocodeFailed(false);
                LOG.debug("Address located via Google Maps Geocoder for address {}", (Object)geoLocatedAddress);
                break;
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    public static enum LocalizationStatus {
        SUCCESS,
        FAILED,
        DISABLED;

    }

    public static class Response {
        private Status status;
        private List<Result> results;

        public List<Result> getResults() {
            return this.results;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setResults(List<Result> list) {
            this.results = list;
        }

        public void setStatus(Status status) {
            this.status = status;
        }
    }

    public static enum Status {
        OK,
        ZERO_RESULTS,
        OVER_QUERY_LIMIT,
        REQUEST_DENIED,
        INVALID_REQUEST;

    }

    public static class Result {
        private Geometry geometry;

        public Geometry getGeometry() {
            return this.geometry;
        }

        public void setGeometry(Geometry geometry) {
            this.geometry = geometry;
        }
    }

    public static class Geometry {
        private Location location;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }

    public static class Location {
        private double lat;
        private double lng;

        public double getLat() {
            return this.lat;
        }

        public double getLng() {
            return this.lng;
        }

        public void setLat(double d) {
            this.lat = d;
        }

        public void setLng(double d) {
            this.lng = d;
        }
    }
}

