/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Date;
import java.util.Objects;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeneralReference;
import org.cyclos.entities.users.QGeneralReference;
import org.cyclos.entities.users.QReference;
import org.cyclos.entities.users.QReferenceHistory;
import org.cyclos.entities.users.ReferenceHistory;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.users.BaseReferenceServiceImpl;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.references.GeneralReferenceDTO;
import org.cyclos.model.users.references.GeneralReferenceData;
import org.cyclos.model.users.references.GeneralReferenceDataParams;
import org.cyclos.model.users.references.GeneralReferenceEntryVO;
import org.cyclos.model.users.references.GeneralReferenceQuery;
import org.cyclos.model.users.references.GeneralReferenceSearchData;
import org.cyclos.model.users.references.GeneralReferenceVO;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.server.utils.DateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralReferenceServiceImpl
extends BaseReferenceServiceImpl<GeneralReference, QGeneralReference, GeneralReferenceDTO, GeneralReferenceEntryVO, GeneralReferenceQuery, GeneralReferenceData, GeneralReferenceDataParams>
implements GeneralReferenceServiceLocal {
    @Autowired
    private AlertServiceLocal alertService;

    public GeneralReferenceServiceImpl() {
        super(GeneralReference.class, QGeneralReference.generalReference, QGeneralReference.generalReference._super, GeneralReferenceDTO.class, GeneralReferenceEntryVO.class);
    }

    public GeneralReference get(User user, User user2) throws FrameworkException {
        if (user == null || user2 == null) {
            throw new EntityNotFoundException(GeneralReference.class);
        }
        return (GeneralReference)((DBQuery)this.from().where(new Predicate[]{((QGeneralReference)this.$).from().eq((Object)user), ((QGeneralReference)this.$).to().eq((Object)user2)})).requiredUniqueResult((Expression)this.$);
    }

    public GeneralReferenceSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        GeneralReferenceSearchData generalReferenceSearchData = new GeneralReferenceSearchData();
        generalReferenceSearchData.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        generalReferenceSearchData.setReferenceLevels(this.getReferenceLevels());
        GeneralReference generalReference = this.currentReference(this.getLoggedUser(), user);
        generalReferenceSearchData.setCurrent((GeneralReferenceVO)this.conversionHandler.convert(GeneralReferenceVO.class, (Object)generalReference));
        GeneralReferenceQuery generalReferenceQuery = (GeneralReferenceQuery)QueryHelper.newQuery(GeneralReferenceQuery.class);
        generalReferenceQuery.setOwner(new UserLocatorVO(user.getId()));
        generalReferenceSearchData.setQuery((QueryParameters)generalReferenceQuery);
        return generalReferenceSearchData;
    }

    public boolean hasReferences(User user) throws FrameworkException {
        GeneralReferenceQuery generalReferenceQuery = new GeneralReferenceQuery();
        generalReferenceQuery.setOwner(new UserLocatorVO(user.getId()));
        return this.createSearchQuery(generalReferenceQuery).hasResults();
    }

    @Override
    public GeneralReference newEntity(GeneralReferenceDataParams generalReferenceDataParams) {
        GeneralReference generalReference;
        User user = (User)this.conversionHandler.convert(User.class, (Object)generalReferenceDataParams.getFromUser());
        if (user == null) {
            user = this.getLoggedUser();
        }
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)generalReferenceDataParams.getToUser());
        try {
            generalReference = this.get(user, user2);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            generalReference = new GeneralReference();
            generalReference.setFrom(user);
            generalReference.setTo(user2);
            generalReference.setLevel(ReferenceLevel.NEUTRAL);
        }
        return generalReference;
    }

    @Override
    public void removeAll(User user) {
        super.removeAll(user);
        QReferenceHistory qReferenceHistory = QReferenceHistory.referenceHistory;
        this.update((EntityPath<?>)qReferenceHistory).set((Path)qReferenceHistory.period().end, (Expression)DateTimeExpression.currentTimestamp()).where(new Predicate[]{qReferenceHistory.period().end.isNull(), qReferenceHistory.from().eq((Object)user).or((Predicate)qReferenceHistory.to().eq((Object)user))}).execute();
    }

    @Override
    protected GeneralReferenceData getData(GeneralReference generalReference) throws FrameworkException {
        GeneralReferenceData generalReferenceData = new GeneralReferenceData();
        generalReferenceData.setDto((EntityDTO)((GeneralReferenceDTO)this.toDTO(generalReference)));
        generalReferenceData.setReferenceLevels(this.getReferenceLevels());
        return generalReferenceData;
    }

    @Override
    protected void onAfterRemove(GeneralReference generalReference) {
        this.updatePreviousReferenceHistoryLog(generalReference, DateHelper.now());
    }

    @Override
    protected void onAfterSave(GeneralReference generalReference, GeneralReference generalReference2, Object object) {
        boolean bl;
        boolean bl2 = bl = generalReference2 != null;
        if (this.historyLogUpdateNeeded(generalReference, generalReference2)) {
            if (bl && this.sameUsers(generalReference, generalReference2)) {
                this.updatePreviousReferenceHistoryLog(generalReference, null);
            }
            this.createLog(generalReference);
        }
        User user = generalReference.getFrom();
        User user2 = generalReference.getTo();
        if (generalReference.getLevel() == ReferenceLevel.VERY_BAD) {
            int n;
            QReferenceHistory qReferenceHistory = QReferenceHistory.referenceHistory;
            if (this.getConfiguration().getGivenVeryBadRefs() != null && this.getConfiguration().getGivenVeryBadRefs() > 0 && (n = ((DBQuery)this.from(new EntityPath[]{qReferenceHistory}).where(new Predicate[]{qReferenceHistory.from().eq((Object)user), qReferenceHistory.level.eq((Object)ReferenceLevel.VERY_BAD)})).count(qReferenceHistory.id)) >= this.getConfiguration().getGivenVeryBadRefs()) {
                this.alertService.create(user, UserAlertType.GIVEN_VERY_BAD_REFS, new Object[0]);
            }
            if (this.getConfiguration().getReceivedVeryBadRefs() != null && this.getConfiguration().getReceivedVeryBadRefs() > 0 && (n = ((DBQuery)this.from(new EntityPath[]{qReferenceHistory}).where(new Predicate[]{qReferenceHistory.to().eq((Object)user2), qReferenceHistory.level.eq((Object)ReferenceLevel.VERY_BAD)})).count(qReferenceHistory.id)) >= this.getConfiguration().getReceivedVeryBadRefs()) {
                this.alertService.create(user2, UserAlertType.RECEIVED_VERY_BAD_REFS, new Object[0]);
            }
        }
        if (bl) {
            this.notificationHandler.user((BasicUser)user2).feedbackAndReference().referenceChanged(generalReference, user);
        } else {
            this.notificationHandler.user((BasicUser)user2).feedbackAndReference().referenceCreated(generalReference, user);
        }
    }

    @Override
    protected Object onBeforeSave(GeneralReference generalReference, GeneralReference generalReference2) {
        if (generalReference.getDate() == null || generalReference2 != null && (!Objects.equals(generalReference.getLevel(), generalReference2.getLevel()) || !Objects.equals(generalReference.getComments(), generalReference2.getComments()))) {
            generalReference.setDate(DateHelper.now());
        }
        return null;
    }

    @Override
    protected QReference ref() {
        return ((QGeneralReference)this.$)._super;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        super.registerNetworkMappings(networkPathRegistry);
        QReferenceHistory qReferenceHistory = QReferenceHistory.referenceHistory;
        networkPathRegistry.register(qReferenceHistory.from().network());
    }

    @Override
    protected Validator resolveValidator(GeneralReferenceDTO generalReferenceDTO) {
        GeneralReference generalReference;
        User user;
        User user2;
        if (generalReferenceDTO.isTransient()) {
            user2 = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)generalReferenceDTO.getFrom());
            generalReference = this.currentReference(user2, user = (User)this.conversionHandler.convert(User.class, (Object)generalReferenceDTO.getTo()));
            if (generalReference != null) {
                generalReferenceDTO.setId(generalReference.getId());
                generalReferenceDTO.setVersion(generalReference.getVersion());
            }
        } else {
            generalReference = (GeneralReference)this.find(generalReferenceDTO.getId());
            user2 = generalReference.getFrom();
            user = generalReference.getTo();
        }
        generalReference = new Validator();
        generalReference.property((Property)GeneralReferenceDTO.COMMENTS, UsersKeys.References.COMMENTS).required().maxLength(2048);
        generalReference.property((Property)GeneralReferenceDTO.LEVEL, UsersKeys.References.LEVEL).required().anyOf(this.getReferenceLevels());
        if (user == null) {
            generalReference.property((Property)GeneralReferenceDTO.TO, UsersKeys.References.TO).required();
        } else if (user.equals((Object)user2)) {
            generalReference.property((Property)GeneralReferenceDTO.TO, UsersKeys.References.TO).invalid();
        }
        return generalReference;
    }

    private void createLog(GeneralReference generalReference) {
        ReferenceHistory referenceHistory = new ReferenceHistory();
        referenceHistory.setFrom(generalReference.getFrom());
        referenceHistory.setTo(generalReference.getTo());
        referenceHistory.setLevel(generalReference.getLevel());
        referenceHistory.setPeriod(new DatePeriod(generalReference.getDate(), null));
        this.persist((IEntity)referenceHistory);
    }

    private GeneralReference currentReference(User user, User user2) {
        if (user != null && user2 != null) {
            return (GeneralReference)((DBQuery)this.selectFrom(this.$).where(new Predicate[]{((QGeneralReference)this.$).from().eq((Object)user), ((QGeneralReference)this.$).to().eq((Object)user2)})).fetchFirst();
        }
        return null;
    }

    private boolean historyLogUpdateNeeded(GeneralReference generalReference, GeneralReference generalReference2) {
        return generalReference2 == null || !generalReference.getFrom().equals((Object)generalReference2.getFrom()) || !generalReference.getTo().equals((Object)generalReference2.getTo()) || !generalReference.getLevel().equals((Object)generalReference2.getLevel());
    }

    private boolean sameUsers(GeneralReference generalReference, GeneralReference generalReference2) {
        return generalReference2 != null && generalReference.getFrom().equals((Object)generalReference2.getFrom()) && generalReference.getTo().equals((Object)generalReference2.getTo());
    }

    private void updatePreviousReferenceHistoryLog(GeneralReference generalReference, Date date) {
        QReferenceHistory qReferenceHistory = QReferenceHistory.referenceHistory;
        ReferenceHistory referenceHistory = (ReferenceHistory)((DBQuery)this.from(new EntityPath[]{qReferenceHistory}).where(new Predicate[]{qReferenceHistory.from().eq((Object)generalReference.getFrom()), qReferenceHistory.to().eq((Object)generalReference.getTo()), qReferenceHistory.period().end.isNull()})).singleResult((Expression)qReferenceHistory);
        if (referenceHistory != null) {
            Date date2 = date == null ? generalReference.getDate() : date;
            referenceHistory.getPeriod().setEnd(date2);
        }
    }
}

