/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Set;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUserFcmToken;
import org.cyclos.entities.users.UserFcmToken;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.users.FcmTokenServiceLocal;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandler;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FcmTokenServiceImpl
extends BaseServiceImpl
implements FcmTokenServiceLocal {
    private static final QUserFcmToken $ = QUserFcmToken.userFcmToken;
    @Autowired
    private AppNotificationHandler appNotificationHandler;

    public void assign(String string) throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (string == null) {
            throw new IllegalActionException("The registration token is required");
        }
        if (basicUser == null) {
            throw new IllegalActionException("A logged user is required to assign a FCM registration token");
        }
        UserFcmToken userFcmToken = this.findByToken(basicUser, string);
        if (userFcmToken == null) {
            this.appNotificationHandler.validate(basicUser, (Object)string);
            userFcmToken = new UserFcmToken();
            userFcmToken.setCreationDate(DateHelper.now());
            userFcmToken.setToken(string);
            basicUser.addFcmToken(userFcmToken);
            this.persist((IEntity)userFcmToken);
        } else {
            userFcmToken.setUpdatedAt(DateHelper.now());
        }
    }

    public void remove(String string, Set<Long> set) throws FrameworkException {
        if (string == null || CollectionHelper.isEmpty(set)) {
            throw new ValidationException("Both the registration token and a list of users are required for remove to work.");
        }
        this.delete((EntityPath<?>)$).where(new Predicate[]{FcmTokenServiceImpl.$.token.eq((Object)string).and((Predicate)FcmTokenServiceImpl.$.user().id.in(set))}).execute();
    }

    public void replace(String string, String string2) throws FrameworkException {
        if (string == null || string2 == null) {
            throw new ValidationException("Both new and previous tokens are required for replacement to work");
        }
        this.update((EntityPath<?>)$).where(new Predicate[]{FcmTokenServiceImpl.$.token.eq((Object)string)}).set((Path)FcmTokenServiceImpl.$.token, (Object)string2).execute();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network());
    }

    private UserFcmToken findByToken(BasicUser basicUser, String string) {
        return basicUser.getFcmTokens().stream().filter(userFcmToken -> userFcmToken.getToken().equals(string)).findAny().orElse(null);
    }
}

