/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.QContact;
import org.cyclos.entities.users.QContactCustomFieldValue;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.search.ContactSearchHandler;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.ContactServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.contacts.ContactDTO;
import org.cyclos.model.users.contacts.ContactData;
import org.cyclos.model.users.contacts.ContactDataParams;
import org.cyclos.model.users.contacts.ContactOrderBy;
import org.cyclos.model.users.contacts.ContactQuery;
import org.cyclos.model.users.contacts.ContactSearchData;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContactServiceImpl
extends CRUDServiceImpl<Contact, QContact, ContactDTO, ContactData, ContactDataParams>
implements ContactServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{ContactDTO.CUSTOM_VALUES};
    @Autowired
    private ContactCustomFieldServiceLocal contactCustomFieldService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private ContactSearchHandler contactSearchHandler;
    @Autowired
    private LockHandler lockHandler;

    public ContactServiceImpl() {
        super(Contact.class, QContact.contact1, ContactDTO.class);
    }

    public boolean canAddToContacts(BasicUser basicUser, BasicUser basicUser2) throws FrameworkException {
        if (!(basicUser instanceof User) || !(basicUser2 instanceof User)) {
            return false;
        }
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        return !basicUser.equals((Object)basicUser2) && basicUser.isActive() && (basicUser2.isActive() || basicUser2.isBlocked()) && Objects.equals(basicUser.getNetwork(), basicUser2.getNetwork()) && productsAccessor.product().hasPermission(Permission.MY_CONTACTS_ENABLE) && !this.getSessionData().isRestrictedOperator() && !this.isContact((User)basicUser, (User)basicUser2);
    }

    public Contact getByOwnerAndContact(User user, User user2) {
        if (user == null || user2 == null) {
            return null;
        }
        return (Contact)((DBQuery)this.from(this.$).where(new Predicate[]{((QContact)this.$).owner().eq((Object)user), ((QContact)this.$).contact().eq((Object)user2)})).singleResult((Expression)this.$);
    }

    public ContactSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        User user = this.toOwner((UserVO)userLocatorVO);
        ContactSearchData contactSearchData = new ContactSearchData();
        contactSearchData.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        contactSearchData.setResultType(sessionData.getConfiguration().getUsersResultType());
        List list = this.contactCustomFieldService.listVisible(user);
        Function function = this.conversionHandler.convertingFunction(CustomFieldDetailedVO.class, new Object[0]);
        contactSearchData.setFieldsForSearch(list.stream().filter(ContactCustomField::isShowInSearch).map(function).collect(Collectors.toList()));
        contactSearchData.setFieldsForList(list.stream().filter(ContactCustomField::isShowInList).map(function).collect(Collectors.toList()));
        contactSearchData.setHasVisibleFields(CollectionHelper.isNotEmpty((Iterable)list));
        contactSearchData.setHasEditableFields(CollectionHelper.isNotEmpty((Iterable)this.contactCustomFieldService.listEditable(user)));
        List list2 = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.USER_KEYWORDS, false, null);
        contactSearchData.setAllowKeywords(CollectionHelper.isNotEmpty((Iterable)list2));
        Map<String, User> map = Collections.singletonMap("owner", user);
        this.customFieldValueHandler.fillValuesFromScript(ContactCustomField.class, LoadValuesScriptFunction.FILTER, map, (Collection)contactSearchData.getFieldsForSearch());
        ContactQuery contactQuery = (ContactQuery)QueryHelper.newQuery(ContactQuery.class);
        contactQuery.setOwner(userLocatorVO);
        contactQuery.setOrderBy(ContactOrderBy.RELEVANCE);
        contactQuery.setCustomValues(this.customFieldValueHandler.resolveDefaultSearchValues((Collection)contactSearchData.getFieldsForSearch()));
        contactSearchData.setQuery((QueryParameters)contactQuery);
        return contactSearchData;
    }

    public boolean isContact(User user, User user2) {
        return this.getByOwnerAndContact(user, user2) != null;
    }

    @Override
    public Contact newEntity(ContactDataParams contactDataParams) {
        User user = this.toOwner((UserVO)(contactDataParams == null ? null : contactDataParams.getOwner()));
        User user2 = contactDataParams == null ? null : (User)this.conversionHandler.convert(User.class, (Object)contactDataParams.getContact());
        Contact contact = new Contact();
        contact.setOwner(user);
        contact.setContact(user2);
        return contact;
    }

    public void removeAll(User user) {
        CloseableIterator closeableIterator = ((DBQuery)this.from().where((Predicate)((QContact)this.$).owner().eq((Object)user).or((Predicate)((QContact)this.$).contact().eq((Object)user)))).iterate((Expression)this.$);
        this.processBatch(closeableIterator, (T contact) -> this.doRemove((Contact)contact, false));
    }

    public Page<ContactVO> search(ContactQuery contactQuery) throws FrameworkException {
        return this.contactSearchHandler.search((QueryParameters)contactQuery);
    }

    @Override
    public ContactDTO toDTO(Contact contact) {
        ContactDTO contactDTO = (ContactDTO)super.toDTO(contact);
        List list = this.contactCustomFieldService.listVisible(contact.getOwner());
        contactDTO.setCustomValues(contact.getCustomValues().stream().filter(contactCustomFieldValue -> list.contains(contactCustomFieldValue.getField())).map(this.conversionHandler.convertingFunction(CustomFieldValueDTO.class, new Object[0])).collect(Collectors.toList()));
        return contactDTO;
    }

    @Override
    public Contact toEntity(ContactDTO contactDTO) {
        Contact contact = (Contact)super.toEntity(contactDTO);
        if (contact.getOwner() == null) {
            contact.setOwner(this.getLoggedUser());
        }
        List list = this.contactCustomFieldService.listEnabled(contact.getOwner());
        List list2 = this.contactCustomFieldService.listEditable(contact.getOwner());
        this.customFieldValueHandler.setCustomValues((SimpleEntity)contact, (Collection)list, (Collection)list2, (Collection)contactDTO.getCustomValues());
        return contact;
    }

    @Override
    protected void doRemove(Contact contact, boolean bl) {
        this.customFieldValueHandler.removeAll((EntityWithCustomValues)contact);
        super.doRemove(contact, bl);
    }

    @Override
    protected ContactData getData(Contact contact) {
        ContactData contactData = new ContactData();
        contactData.setDto((EntityDTO)this.toDTO(contact));
        List list = this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)this.contactCustomFieldService.listVisible(contact.getOwner()));
        HashMap<String, Contact> hashMap = new HashMap<String, Contact>();
        hashMap.put("contact", contact);
        this.customFieldValueHandler.fillValuesFromScript(ContactCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list);
        contactData.setCustomFields(list);
        this.customFieldValueHandler.setDefaultValues(list, (ModelWithCustomValues)contactData.getDto());
        contactData.setEditableCustomFieldIds(SimpleEntity.uniqueIds((Collection)this.contactCustomFieldService.listEditable(contact.getOwner())));
        if (contact.isPersistent()) {
            contactData.setCustomOperations(this.customOperationService.getRunnableOperationsForContact(new ContactVO(contact.getId())));
        }
        return contactData;
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(Contact contact) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(ContactDTO contactDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(Contact contact, Contact contact2, Object object) {
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)contact);
    }

    @Override
    protected Object onBeforeSave(Contact contact, Contact contact2) {
        if (contact.isTransient()) {
            this.lockHandler.lock(LockType.CONTACT.key(contact.getOwner().getId()));
            if (!this.canAddToContacts((BasicUser)contact.getOwner(), (BasicUser)contact.getContact())) {
                throw new ValidationException(this.message(UsersKeys.Contacts.ERROR_CANNOT_ADD, contact.getContact()));
            }
        }
        return null;
    }

    @Override
    protected void persist(IEntity iEntity) {
        Contact contact;
        Contact contact2;
        if (iEntity instanceof Contact && (contact2 = this.getByOwnerAndContact((contact = (Contact)iEntity).getOwner(), contact.getContact())) != null) {
            throw new MaxItemsException(1);
        }
        super.persist(iEntity);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QContact)this.$).owner().network());
    }

    @Override
    protected Validator resolveValidator(ContactDTO contactDTO) {
        User user;
        Contact contact;
        Validator validator = new Validator();
        if (contactDTO.isPersistent()) {
            contact = (Contact)this.find(contactDTO.getId());
            user = contact.getOwner();
        } else {
            contact = new Contact();
            user = this.toOwner(contactDTO.getOwner());
            validator.property((Property)ContactDTO.CONTACT, UsersKeys.Contacts.CONTACT).required();
        }
        for (ContactCustomField contactCustomField : this.contactCustomFieldService.listEditable(user)) {
            this.customFieldValueHandler.addValueValidation(validator, (CustomField)contactCustomField, (EntityPathBase)QContactCustomFieldValue.contactCustomFieldValue, Collections.singletonMap("contact", contact));
        }
        return validator;
    }

    private User toOwner(UserVO userVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userVO);
        if (user == null) {
            throw new IllegalActionException();
        }
        return user;
    }
}

