/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.ContactInfoFieldValue;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContactInfoVOConverter
extends EntityVOConverter<ContactInfoVO> {
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public ContactInfoVOConverter() {
        super(ContactInfoVO.class);
    }

    @Override
    protected void fill(Object object, ContactInfoVO contactInfoVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof ContactInfo) {
            Object object2;
            ContactInfo contactInfo = (ContactInfo)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            arrayList.add(ContactInfoVO.CUSTOM_VALUES);
            arrayList.add(ContactInfoVO.LAND_LINE_PHONE);
            arrayList.add(ContactInfoVO.MOBILE_PHONE);
            super.fill(object, contactInfoVO, arrayList.toArray(), conversionContext);
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)contactInfo.getUser());
            PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(contactInfo.getMobilePhone(), configurationAccessor);
            PhoneNumberDescriptor phoneNumberDescriptor2 = this.phoneNumberHandler.parse(contactInfo.getLandLinePhone(), configurationAccessor);
            if (phoneNumberDescriptor != null || phoneNumberDescriptor2 != null) {
                object2 = this.getSessionData().getConfiguration();
                if (phoneNumberDescriptor != null) {
                    contactInfoVO.setNormalizedMobilePhone(phoneNumberDescriptor.toE164());
                    contactInfoVO.setMobilePhone(this.phoneNumberHandler.format(phoneNumberDescriptor, object2));
                }
                if (phoneNumberDescriptor2 != null) {
                    contactInfoVO.setNormalizedLandLinePhone(phoneNumberDescriptor2.toE164());
                    contactInfoVO.setLandLinePhone(this.phoneNumberHandler.format(phoneNumberDescriptor2, object2));
                    if (StringHelper.isNotBlank((Object)contactInfo.getLandLineExtension())) {
                        contactInfoVO.setLandLinePhone(contactInfoVO.getLandLinePhone() + " " + this.translationHandler.message(GeneralKeys.Ui.PHONE_EXTENSION_PREFIX, new Object[0]) + " " + contactInfo.getLandLineExtension());
                    }
                }
            }
            object2 = this.contactInfoFieldService.listEnabled(contactInfo.getUser());
            List list = contactInfo.getCustomValues().stream().filter(arg_0 -> ContactInfoVOConverter.lambda$fill$0((List)object2, arg_0)).sorted(Comparator.comparing(ContactInfoFieldValue::getField)).map(this.conversionHandler.convertingFunction(CustomFieldValueVO.class, new Object[0])).collect(Collectors.toList());
            contactInfoVO.setCustomValues(list);
        } else {
            super.fill(object, contactInfoVO, objectArray, conversionContext);
        }
    }

    private static /* synthetic */ boolean lambda$fill$0(List list, ContactInfoFieldValue contactInfoFieldValue) {
        return list.contains(contactInfoFieldValue.getField());
    }
}

