/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.ContactInfoImage;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QBaseContactInfo;
import org.cyclos.entities.users.QContactInfo;
import org.cyclos.entities.users.QContactInfoFieldValue;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.ContactInfoImageServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoData;
import org.cyclos.model.users.contactinfos.ContactInfoListData;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.contactinfos.ManageContactInfoConfirmationField;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContactInfoServiceImpl
extends CRUDServiceImpl<ContactInfo, QContactInfo, ContactInfoDTO, ContactInfoData, UserLocatorVO>
implements ContactInfoServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{ContactInfoDTO.IMAGE, ContactInfoDTO.CUSTOM_VALUES};
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private UserAddressServiceLocal userAddressService;
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private ContactInfoImageServiceLocal contactInfoImageService;

    public ContactInfoServiceImpl() {
        super(ContactInfo.class, QContactInfo.contactInfo, ContactInfoDTO.class);
    }

    public boolean canHaveContactInfos(User user) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        return productsAccessor.member().getMaxContactInfos() > 0;
    }

    public ContactInfoListData getContactInfoListData(UserLocatorVO userLocatorVO, boolean bl) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        ContactInfoListData contactInfoListData = new ContactInfoListData();
        contactInfoListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        int n = productsAccessor.member().getMaxContactInfos();
        List<ContactInfo> list = this.list(user);
        contactInfoListData.setMaxContactInfo(Integer.valueOf(n));
        contactInfoListData.setCanManage(this.permission((BasicUser)user).my(() -> !this.getSessionData().isOperator()).user(new Permission[]{Permission.USER_CONTACT_INFO_MANAGE}).granted());
        contactInfoListData.setCanCreate(contactInfoListData.isCanManage() && list.size() < n);
        List list2 = this.contactInfoFieldService.listEnabled(user);
        contactInfoListData.setContactInfos(this.conversionHandler.convertList(ContactInfoVO.class, list));
        contactInfoListData.setCustomFields(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)list2));
        if (bl) {
            contactInfoListData.getContactInfos().forEach(contactInfoVO -> contactInfoVO.setCustomOperations(this.customOperationService.getRunnableOperationsForContactInfo(contactInfoVO)));
        }
        return contactInfoListData;
    }

    @Override
    public ContactInfoData getDataForNew(Group group) {
        User user = new User(group);
        return this.getData(this.newEntity(user));
    }

    public List<ContactInfo> list(User user) {
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.manages((BasicUser)user);
        return ((DBQuery)((DBQuery)this.from().where(new Predicate[]{((QContactInfo)this.$).user().eq((Object)user), bl ? ((QContactInfo)this.$).id.isNotNull() : ((QContactInfo)this.$).hidden.isFalse()})).orderBy(((QContactInfo)this.$).name.asc())).list((Expression)this.$);
    }

    @Override
    public ContactInfo newEntity(UserLocatorVO userLocatorVO) {
        return this.newEntity(this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO));
    }

    public void removeAll(User user) {
        CloseableIterator closeableIterator = ((DBQuery)this.from().where((Predicate)((QContactInfo)this.$).user().eq((Object)user))).iterate((Expression)this.$);
        this.processBatch(closeableIterator, this::remove);
    }

    @Override
    public ContactInfoDTO toDTO(ContactInfo contactInfo) {
        ContactInfoDTO contactInfoDTO = (ContactInfoDTO)super.toDTO(contactInfo);
        if (!this.profileFieldHandler.isAllowed((BasicUser)contactInfo.getUser(), (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW)) {
            contactInfoDTO.setAddress(null);
        }
        contactInfoDTO.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)contactInfo.getImage()));
        List list = this.contactInfoFieldService.listEnabled(contactInfo.getUser());
        contactInfoDTO.setCustomValues(contactInfo.getCustomValues().stream().filter(contactInfoFieldValue -> list.contains(contactInfoFieldValue.getField())).map(this.conversionHandler.convertingFunction(CustomFieldValueDTO.class, new Object[0])).collect(Collectors.toList()));
        return contactInfoDTO;
    }

    @Override
    public ContactInfo toEntity(ContactInfoDTO contactInfoDTO) {
        Image image;
        UserAddress userAddress = null;
        ContactInfo contactInfo = null;
        if (contactInfoDTO.isPersistent()) {
            contactInfo = (ContactInfo)this.find(contactInfoDTO.getId());
            userAddress = contactInfo.getAddress();
            if (contactInfoDTO.getImage() == null) {
                this.contactInfoImageService.removeAll((BaseEntity)contactInfo);
            }
        }
        if (!this.profileFieldHandler.isAllowed((BasicUser)(contactInfo = (ContactInfo)super.toEntity(contactInfoDTO)).getUser(), (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW)) {
            contactInfo.setAddress(userAddress);
        }
        if (!this.profileFieldHandler.isAllowed((BasicUser)contactInfo.getUser(), (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW)) {
            contactInfoDTO.setAddress(null);
        }
        List list = this.contactInfoFieldService.listEnabled(contactInfo.getUser());
        this.customFieldValueHandler.setCustomValues((SimpleEntity)contactInfo, (Collection)list, (Collection)list, (Collection)contactInfoDTO.getCustomValues());
        if (contactInfoDTO.getImage() != null && (image = (Image)this.conversionHandler.convert(Image.class, (Object)contactInfoDTO.getImage())) instanceof TempImage) {
            contactInfo.setUploadedImage((TempImage)image);
        }
        return contactInfo;
    }

    @Override
    protected void doRemove(ContactInfo contactInfo, boolean bl) {
        this.customFieldValueHandler.removeAll((EntityWithCustomValues)contactInfo);
        super.doRemove(contactInfo, bl);
    }

    @Override
    protected ContactInfoData getData(ContactInfo contactInfo) {
        User user = contactInfo.getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        ContactInfoData contactInfoData = new ContactInfoData();
        contactInfoData.setDto((EntityDTO)this.toDTO(contactInfo));
        contactInfoData.setPhoneConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
        contactInfoData.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)contactInfo.getImage()));
        contactInfoData.setEditable(this.productsHandler.getAccessor((BasicUser)user).member().getMaxContactInfos() > 0);
        if (this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW)) {
            contactInfoData.setAddresses(this.conversionHandler.convertList(UserAddressVO.class, (Iterable)this.userAddressService.getAddresses(user, false, false)));
        }
        List list = this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)this.contactInfoFieldService.listEnabled(user));
        HashMap<String, ContactInfo> hashMap = new HashMap<String, ContactInfo>();
        hashMap.put("contactInfo", contactInfo);
        this.customFieldValueHandler.fillValuesFromScript(ContactInfoField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list);
        contactInfoData.setCustomFields(list);
        this.customFieldValueHandler.setDefaultValues(list, (ModelWithCustomValues)contactInfoData.getDto());
        if (contactInfo.isPersistent()) {
            contactInfoData.setCustomOperations(this.customOperationService.getRunnableOperationsForContactInfo(new ContactInfoVO(contactInfo.getId())));
        }
        return contactInfoData;
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(ContactInfoDTO contactInfoDTO, ContactInfo contactInfo, CRUDOperation cRUDOperation) {
        return ManageContactInfoConfirmationField.confirmation((String)(contactInfoDTO != null ? contactInfoDTO.getName() : contactInfo.getName()));
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(ContactInfo contactInfo) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(ContactInfoDTO contactInfoDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(ContactInfo contactInfo, ContactInfo contactInfo2, Object object) {
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)contactInfo);
        TempImage tempImage = contactInfo.getUploadedImage();
        if (tempImage != null) {
            this.contactInfoImageService.importTempImage((BaseEntity)contactInfo, tempImage);
        }
        contactInfo.getUser().getContactInfos().add(contactInfo);
    }

    @Override
    protected void onBeforeRemove(ContactInfo contactInfo) {
        CollectionHelper.orEmpty((List)contactInfo.getImages()).stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    @Override
    protected Object onBeforeSave(ContactInfo contactInfo, ContactInfo contactInfo2) {
        boolean bl;
        Long l = contactInfo2 == null ? null : SimpleEntity.id((SimpleEntity)contactInfo2.getAddress());
        boolean bl2 = bl = !Objects.equals(l, SimpleEntity.id((SimpleEntity)contactInfo.getAddress()));
        if (bl) {
            if (l != null) {
                UserAddress userAddress = (UserAddress)this.entityManagerHandler.find(UserAddress.class, l);
                userAddress.removeContactInfo(contactInfo);
            }
            if (contactInfo.getAddress() != null) {
                contactInfo.getAddress().addContactInfo(contactInfo);
            }
        }
        if (!this.configurationHandler.getAccessor((BasicUser)contactInfo.getUser()).isLandLineEnableExtension()) {
            contactInfo.setLandLineExtension(null);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QBaseContactInfo.baseContactInfo.user().network());
    }

    @Override
    protected Validator resolveValidator(final ContactInfoDTO contactInfoDTO) {
        ContactInfo contactInfo;
        User user;
        if (contactInfoDTO.isTransient()) {
            user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)contactInfoDTO.getUser());
            contactInfo = new ContactInfo();
            contactInfo.setUser(user);
        } else {
            contactInfo = (ContactInfo)this.find(contactInfoDTO.getId());
            user = contactInfo.getUser();
        }
        Validator validator = new Validator();
        if (user == null) {
            validator.property((Property)ContactInfoDTO.USER, UsersKeys.Users.USER).required();
            return validator;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        validator.property((Property)ContactInfoDTO.EMAIL, UsersKeys.ContactInfos.EMAIL).email();
        validator.property((Property)ContactInfoDTO.MOBILE_PHONE, UsersKeys.ContactInfos.MOBILE_PHONE).phoneNumber(configurationAccessor, PhoneNature.MOBILE);
        validator.property((Property)ContactInfoDTO.LAND_LINE_PHONE, UsersKeys.ContactInfos.LAND_LINE_PHONE).phoneNumber(configurationAccessor, PhoneNature.LANDLINE);
        validator.property((Property)ContactInfoDTO.IMAGE, UsersKeys.ContactInfos.IMAGE).entity(Image.class, (EntityValidation)new BaseEntityValidation<Image>(){

            protected boolean isValid(Object object, Object object2, Image image) {
                if (image instanceof TempImage) {
                    TempImage tempImage = (TempImage)image;
                    return tempImage.getTarget() == TempImageTarget.CONTACT_INFO && tempImage.getUser() == null || user.equals((Object)tempImage.getUser());
                }
                if (image instanceof ContactInfoImage) {
                    ContactInfoImage contactInfoImage = (ContactInfoImage)image;
                    return contactInfoImage.getContactInfo().getId().equals(contactInfoDTO.getId());
                }
                return false;
            }
        });
        validator.property((Property)ContactInfoDTO.ADDRESS, UsersKeys.ContactInfos.ADDRESS).entity(UserAddress.class, (EntityValidation)new BaseEntityValidation<UserAddress>(){

            protected boolean isValid(Object object, Object object2, UserAddress userAddress) {
                return userAddress.getUser().equals((Object)user);
            }
        });
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)ContactInfoDTO.LAND_LINE_EXTENSION, UsersKeys.ContactInfos.LAND_LINE_EXTENSION);
        property.maxLength(6);
        if (StringHelper.isNotBlank((Object)contactInfoDTO.getLandLineExtension()) && StringHelper.isBlank((Object)contactInfoDTO.getLandLinePhone())) {
            property.invalid(UsersKeys.ContactInfos.ERROR_LAND_LINE_EXTENSION_NO_PHONE);
        }
        for (ContactInfoField contactInfoField : this.contactInfoFieldService.listEnabled(user)) {
            this.customFieldValueHandler.addValueValidation(validator, (CustomField)contactInfoField, (EntityPathBase)QContactInfoFieldValue.contactInfoFieldValue, Collections.singletonMap("contactInfo", contactInfo));
        }
        return validator;
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(ContactInfo contactInfo, CRUDOperation cRUDOperation) {
        return contactInfo.getUser().equals((Object)this.getLoggedUser());
    }

    @Override
    private ContactInfo newEntity(User user) {
        ContactInfo contactInfo = new ContactInfo();
        contactInfo.setUser(user);
        return contactInfo;
    }
}

