/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.ContactCustomFieldPossibleValue;
import org.cyclos.entities.users.ContactCustomFieldPossibleValueCategory;
import org.cyclos.entities.users.QContactCustomField;
import org.cyclos.entities.users.QContactCustomFieldValue;
import org.cyclos.entities.users.QProductMyContactField;
import org.cyclos.entities.users.QProductUserContactField;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.users.ContactCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.users.ContactCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.contacts.ContactCustomFieldDTO;
import org.cyclos.model.users.contacts.ContactCustomFieldData;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContactCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<ContactCustomField, ContactCustomFieldPossibleValueCategory, ContactCustomFieldPossibleValue, QContactCustomField, ContactCustomFieldDTO, ContactCustomFieldData, Void>
implements ContactCustomFieldServiceLocal {
    private static QProductMyContactField pm = QProductMyContactField.productMyContactField;
    private static QProductUserContactField pu = QProductUserContactField.productUserContactField;
    @Autowired
    private ContactCustomFieldPossibleValueServiceLocal contactCustomFieldPossibleValueService;
    @Autowired
    private ContactCustomFieldPossibleValueCategoryServiceLocal contactCustomFieldPossibleValueCategoryService;
    @Autowired
    private ProductServiceLocal productService;

    public ContactCustomFieldServiceImpl() {
        super(ContactCustomField.class, QContactCustomField.contactCustomField, ContactCustomFieldDTO.class, ContactCustomFieldData.class);
    }

    public boolean hasEditableFields(UserLocatorVO userLocatorVO) {
        User user;
        User user2 = user = userLocatorVO == null ? this.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (user == null) {
            return false;
        }
        return CollectionHelper.isNotEmpty(this.listEditable(user));
    }

    public List<CustomFieldVO> list() {
        return this.conversionHandler.convertList(CustomFieldVO.class, this.listAll());
    }

    public List<ContactCustomField> listAll() {
        return ((DBQuery)this.from(this.$).orderBy(((QContactCustomField)this.$).order.asc())).list((Expression)this.$);
    }

    public List<ContactCustomField> listEditable(User user) {
        return this.doList(user, true);
    }

    public List<ContactCustomField> listEnabled(User user) {
        return this.listOwn(user, ContactCustomFieldServiceImpl.pm.enabled);
    }

    public List<ContactCustomField> listInList(User user) {
        return this.listVisible(user).stream().filter(ContactCustomField::isShowInList).collect(Collectors.toList());
    }

    public List<ContactCustomField> listInSearch(User user) {
        return this.listVisible(user).stream().filter(ContactCustomField::isShowInSearch).collect(Collectors.toList());
    }

    public List<ContactCustomField> listVisible(User user) {
        return this.doList(user, false);
    }

    @Override
    public ContactCustomField newEntity(Void void_) {
        return new ContactCustomField();
    }

    @Override
    protected Integer getMaxOrder(ContactCustomField contactCustomField) {
        return (Integer)this.from(this.$).singleResult((Expression)((QContactCustomField)this.$).order.max());
    }

    protected ContactCustomFieldPossibleValueCategoryServiceLocal getPossibleValueCategoryService() {
        return this.contactCustomFieldPossibleValueCategoryService;
    }

    protected ContactCustomFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.contactCustomFieldPossibleValueService;
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    @Override
    protected void onAfterSave(ContactCustomField contactCustomField, ContactCustomField contactCustomField2, Object object) {
        AdminGroup adminGroup;
        AdminProduct adminProduct;
        if (contactCustomField2 == null && this.isAdmin() && (adminProduct = (adminGroup = (AdminGroup)this.getSessionData().getGroup()).getAdminProduct()).getPermissions().contains(Permission.USER_CONTACTS_VIEW)) {
            AdminProductDTO adminProductDTO = (AdminProductDTO)this.productService.load(adminProduct.getId());
            adminProductDTO.getUserContactFields().stream().filter(productUserContactFieldDTO -> productUserContactFieldDTO.getCustomField().getId().equals(contactCustomField.getId())).findFirst().ifPresent(productUserContactFieldDTO -> {
                productUserContactFieldDTO.setVisible(true);
                productUserContactFieldDTO.setEditable(true);
            });
            this.productService.save((EntityDTO)adminProductDTO);
        }
    }

    @Override
    protected void onBeforeRemove(ContactCustomField contactCustomField) {
        QContactCustomFieldValue qContactCustomFieldValue = QContactCustomFieldValue.contactCustomFieldValue;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qContactCustomFieldValue}).where((Predicate)qContactCustomFieldValue.field().eq((Object)contactCustomField))).hasResults();
        QProductMyContactField qProductMyContactField = QProductMyContactField.productMyContactField;
        boolean bl2 = ((DBQuery)this.from(new EntityPath[]{qProductMyContactField}).where(new Predicate[]{qProductMyContactField.customField().eq((Object)contactCustomField), qProductMyContactField.enabled.isTrue()})).hasResults();
        if (bl && bl2) {
            throw new ConstraintViolatedOnRemoveException();
        }
    }

    @Override
    protected Object onBeforeSave(ContactCustomField contactCustomField, ContactCustomField contactCustomField2) {
        if (!contactCustomField.getType().isAllowedToBeOnResultList()) {
            contactCustomField.setShowInList(false);
        }
        if (!contactCustomField.getType().isAllowedToBeOnSearchFilters()) {
            contactCustomField.setShowInSearch(false);
        }
        return super.onBeforeSave(contactCustomField, contactCustomField2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QContactCustomField)this.$).network());
    }

    private List<ContactCustomField> doList(User user, boolean bl) {
        List<ContactCustomField> list = this.listEnabled(user);
        if (!list.isEmpty()) {
            SessionData sessionData = this.getSessionData();
            Collection<Object> collection = user.equals((Object)sessionData.getLoggedUser()) ? this.listOwn(user, bl ? ContactCustomFieldServiceImpl.pm.editable : ContactCustomFieldServiceImpl.pm.visible) : sessionData.getProducts().userManagement().getUserContactFields().keysSet((Path)(bl ? ContactCustomFieldServiceImpl.pu.editable : ContactCustomFieldServiceImpl.pu.visible));
            list.retainAll(collection);
        }
        return list;
    }

    private List<ContactCustomField> listOwn(User user, BooleanPath booleanPath) {
        if (user == null) {
            return Collections.emptyList();
        }
        return CollectionHelper.sort((Collection)this.productsHandler.getAccessor((BasicUser)user).product().getMyContactFields().keysSet((Path)booleanPath));
    }
}

