/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.OptimisticLockException;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.messaging.OutboundSms;
import org.cyclos.entities.system.BulkActionFile;
import org.cyclos.entities.system.BulkActionImage;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.CustomFieldValueFile;
import org.cyclos.entities.system.CustomFieldValueImage;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.system.IBulkActionStoredFile;
import org.cyclos.entities.system.ICustomFieldValueStoredFile;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdjustAccountsBulkAction;
import org.cyclos.entities.users.AppMailingBulkAction;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BulkAction;
import org.cyclos.entities.users.BulkActionUser;
import org.cyclos.entities.users.ChangeFieldValueBulkAction;
import org.cyclos.entities.users.ChangeGroupBulkAction;
import org.cyclos.entities.users.ChangeStatusBulkAction;
import org.cyclos.entities.users.CustomOperationBulkAction;
import org.cyclos.entities.users.CustomOperationBulkActionParameter;
import org.cyclos.entities.users.EmailMailingBulkAction;
import org.cyclos.entities.users.QBulkAction;
import org.cyclos.entities.users.QBulkActionUser;
import org.cyclos.entities.users.QCustomOperationBulkActionParameter;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.QUserCustomFieldValue;
import org.cyclos.entities.users.QUserProductPasswordAction;
import org.cyclos.entities.users.ReindexBulkAction;
import org.cyclos.entities.users.ResetPasswordBulkAction;
import org.cyclos.entities.users.SmsMailingBulkAction;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.MobilePageServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.BulkActionProcessingBackgroundTask;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.users.BulkActionUserResult;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.users.UserVariablesFunction;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandler;
import org.cyclos.impl.utils.appnotifications.AppNotificationMessage;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandlerImplementor;
import org.cyclos.impl.utils.notifications.MailProcessingContext;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.EmailValidation;
import org.cyclos.impl.utils.validation.validations.RequiredValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.RetryException;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.passwords.ResetAndSendPasswordDTO;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.mobile.BuiltInMobilePage;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.RunCustomOperationDataParams;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.wizards.CustomWizardNature;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.bulkactions.AdjustAccountsBulkActionDTO;
import org.cyclos.model.users.bulkactions.AppMailingBulkActionDTO;
import org.cyclos.model.users.bulkactions.AppMailingBulkActionData;
import org.cyclos.model.users.bulkactions.AppMailingPreviewData;
import org.cyclos.model.users.bulkactions.BulkActionDTO;
import org.cyclos.model.users.bulkactions.BulkActionData;
import org.cyclos.model.users.bulkactions.BulkActionDataParams;
import org.cyclos.model.users.bulkactions.BulkActionDetailsData;
import org.cyclos.model.users.bulkactions.BulkActionNature;
import org.cyclos.model.users.bulkactions.BulkActionQuery;
import org.cyclos.model.users.bulkactions.BulkActionSearchUsersData;
import org.cyclos.model.users.bulkactions.BulkActionStatus;
import org.cyclos.model.users.bulkactions.BulkActionStatusVO;
import org.cyclos.model.users.bulkactions.BulkActionUsage;
import org.cyclos.model.users.bulkactions.BulkActionUserQuery;
import org.cyclos.model.users.bulkactions.BulkActionUserStatus;
import org.cyclos.model.users.bulkactions.BulkActionUserVO;
import org.cyclos.model.users.bulkactions.BulkActionVO;
import org.cyclos.model.users.bulkactions.BulkActionsSearchData;
import org.cyclos.model.users.bulkactions.ChangeFieldValueBulkActionDTO;
import org.cyclos.model.users.bulkactions.ChangeFieldValueBulkActionData;
import org.cyclos.model.users.bulkactions.ChangeGroupBulkActionDTO;
import org.cyclos.model.users.bulkactions.ChangeGroupBulkActionData;
import org.cyclos.model.users.bulkactions.ChangeStatusBulkActionDTO;
import org.cyclos.model.users.bulkactions.ChangeStatusBulkActionData;
import org.cyclos.model.users.bulkactions.CustomOperationBulkActionDTO;
import org.cyclos.model.users.bulkactions.CustomOperationBulkActionData;
import org.cyclos.model.users.bulkactions.EmailMailingBulkActionDTO;
import org.cyclos.model.users.bulkactions.EmailMailingBulkActionData;
import org.cyclos.model.users.bulkactions.EmailMailingPreviewData;
import org.cyclos.model.users.bulkactions.MailingListPreviewData;
import org.cyclos.model.users.bulkactions.ReindexBulkActionDTO;
import org.cyclos.model.users.bulkactions.ResetPasswordBulkActionDTO;
import org.cyclos.model.users.bulkactions.ResetPasswordBulkActionData;
import org.cyclos.model.users.bulkactions.SendSMSResult;
import org.cyclos.model.users.bulkactions.SimpleBulkActionData;
import org.cyclos.model.users.bulkactions.SmsMailingBulkActionDTO;
import org.cyclos.model.users.bulkactions.SmsMailingPreviewData;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ChangeUserStatusParams;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserSearchContext;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
public class BulkActionServiceImpl
extends CRUDServiceImpl<BulkAction, QBulkAction, BulkActionDTO, BulkActionData, BulkActionDataParams>
implements BulkActionServiceLocal {
    private static final BidiMap<Class<? extends BulkAction>, Class<? extends BulkActionDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private UserSearchHandler userSearcHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    private Map<BulkActionNature, Function<BulkActionUser, BulkActionUserResult>> processors;
    private Map<BulkActionNature, BiFunction<BulkAction, User, MailingListPreviewData>> mailingListPreview;
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private EntityLogServiceLocal entityLogService;
    @Autowired
    private UserGroupServiceLocal userGroupService;
    @Autowired
    private AccountServiceLocal accountsService;
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private MobilePageServiceLocal mobilePageService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private MailHandlerImplementor mailHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private AppNotificationHandler appNotificationHandler;
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;
    @Autowired
    private LinkGeneratorHandler linkGenerator;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    protected EntityLogRegistry entityLogRegistry;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    public BulkActionServiceImpl() {
        super(BulkAction.class, QBulkAction.bulkAction, BulkActionDTO.class);
    }

    public long archive(long l) {
        QBulkActionUser qBulkActionUser;
        BulkAction bulkAction = (BulkAction)this.find(l);
        if (bulkAction.isArchived()) {
            return 0L;
        }
        this.updateUserCounters(bulkAction);
        bulkAction.setArchived(true);
        if (bulkAction instanceof ChangeFieldValueBulkAction) {
            qBulkActionUser = (ChangeFieldValueBulkAction)bulkAction;
            List list = qBulkActionUser.getImages();
            qBulkActionUser.setImages(new ArrayList());
            list.forEach(bulkActionImage -> this.storedFileHandler.remove(bulkActionImage.getId().longValue()));
            List list2 = qBulkActionUser.getFiles();
            qBulkActionUser.setFiles(new ArrayList());
            list2.forEach(bulkActionFile -> this.storedFileHandler.remove(bulkActionFile.getId().longValue()));
        }
        qBulkActionUser = QBulkActionUser.bulkActionUser;
        return (int)this.delete((EntityPath<?>)qBulkActionUser).where(new Predicate[]{qBulkActionUser.bulkAction().eq((Object)bulkAction)}).execute();
    }

    public int cancel(Long l) throws FrameworkException {
        BulkAction bulkAction = (BulkAction)this.find(l);
        if (bulkAction.getStatus() != BulkActionStatus.RUNNING) {
            throw new IllegalActionException();
        }
        bulkAction.setStatus(BulkActionStatus.CANCELED);
        QBulkActionUser qBulkActionUser = QBulkActionUser.bulkActionUser;
        int n = (int)this.update((EntityPath<?>)qBulkActionUser).set((Path)qBulkActionUser.status, (Object)BulkActionUserStatus.CANCELED).where(new Predicate[]{qBulkActionUser.bulkAction().eq((Object)bulkAction), qBulkActionUser.status.eq((Object)BulkActionUserStatus.PENDING)}).execute();
        this.updateUserCounters(bulkAction);
        return n;
    }

    public String getErrorStackTrace(Long l) throws FrameworkException {
        BulkActionUser bulkActionUser = this.find(BulkActionUser.class, l);
        return bulkActionUser.getErrorStackTrace();
    }

    public BulkActionsSearchData getSearchData(BulkActionUsage bulkActionUsage) throws FrameworkException {
        Object object;
        BulkActionsSearchData bulkActionsSearchData = new BulkActionsSearchData();
        switch (bulkActionUsage) {
            case GENERAL: {
                bulkActionsSearchData.setRunBuiltIn(new ArrayList(BulkActionNature.builtIn()));
                object = this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.BULK_ACTION});
                bulkActionsSearchData.setRunCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, (Iterable)object));
                break;
            }
            case MAILING_LIST: {
                bulkActionsSearchData.setRunBuiltIn(new ArrayList(BulkActionNature.byUsage((BulkActionUsage)BulkActionUsage.MAILING_LIST)));
            }
        }
        object = (BulkActionQuery)QueryHelper.newQuery(BulkActionQuery.class);
        object.setUsage(bulkActionUsage);
        object.setNatures((Set)BulkActionNature.byUsage((BulkActionUsage)bulkActionUsage));
        bulkActionsSearchData.setQuery((QueryParameters)object);
        return bulkActionsSearchData;
    }

    public BulkActionSearchUsersData getSearchUsersData(BulkActionDataParams bulkActionDataParams) throws FrameworkException {
        BulkActionSearchUsersData bulkActionSearchUsersData = new BulkActionSearchUsersData();
        BulkActionNature bulkActionNature = bulkActionDataParams.getNature();
        bulkActionSearchUsersData.setNature(bulkActionNature);
        if (bulkActionNature == BulkActionNature.CUSTOM_OPERATION) {
            CustomOperation customOperation = this.getCustomOperation(bulkActionDataParams.getCustomOperation());
            bulkActionSearchUsersData.setCustomOperation((CustomOperationVO)this.conversionHandler.convert(CustomOperationVO.class, (Object)customOperation));
        }
        bulkActionSearchUsersData.setSearchData(this.userService.getSearchData(UserSearchContext.BULK_ACTION, null));
        return bulkActionSearchUsersData;
    }

    public BulkActionStatusVO getStatus(Long l) throws FrameworkException {
        BulkAction bulkAction = (BulkAction)this.find(l);
        return this.getStatus(bulkAction);
    }

    @PostConstruct
    public void initialize() {
        this.processors = new HashMap<BulkActionNature, Function<BulkActionUser, BulkActionUserResult>>();
        this.processors.put(BulkActionNature.CHANGE_GROUP, this::changeGroup);
        this.processors.put(BulkActionNature.CHANGE_STATUS, this::changeStatus);
        this.processors.put(BulkActionNature.CHANGE_FIELD_VALUE, this::changeFieldValue);
        this.processors.put(BulkActionNature.RESET_PASSWORD, this::resetPassword);
        this.processors.put(BulkActionNature.REINDEX, this::reindex);
        this.processors.put(BulkActionNature.CUSTOM_OPERATION, arg_0 -> ((CustomOperationServiceLocal)this.customOperationService).runForBulkAction(arg_0));
        this.processors.put(BulkActionNature.ADJUST_ACCOUNTS, this::adjustAccounts);
        this.processors.put(BulkActionNature.EMAIL_MAILING, this::emailMailing);
        this.processors.put(BulkActionNature.SMS_MAILING, this::smsMailing);
        this.processors.put(BulkActionNature.APP_MAILING, this::appMailing);
        if (this.processors.size() != BulkActionNature.values().length) {
            throw new IllegalStateException("Some bulk action nature has no processor");
        }
        this.mailingListPreview = new HashMap<BulkActionNature, BiFunction<BulkAction, User, MailingListPreviewData>>();
        this.mailingListPreview.put(BulkActionNature.EMAIL_MAILING, (bulkAction, user) -> this.previewEmailMailing((EmailMailingBulkAction)bulkAction, (User)user));
        this.mailingListPreview.put(BulkActionNature.SMS_MAILING, (bulkAction, user) -> this.previewSmsMailing((SmsMailingBulkAction)bulkAction, (User)user));
        this.mailingListPreview.put(BulkActionNature.APP_MAILING, (bulkAction, user) -> this.previewAppMailing((AppMailingBulkAction)bulkAction, (User)user));
        if (this.mailingListPreview.size() != BulkActionNature.mailings().size()) {
            throw new IllegalStateException("Some mailing list nature has no preview handler");
        }
    }

    public void markFinished(BulkAction bulkAction) {
        if (bulkAction.getStatus() == BulkActionStatus.RUNNING) {
            bulkAction.setStatus(BulkActionStatus.FINISHED);
            bulkAction.setFinishDate(new Date());
            this.updateUserCounters(bulkAction);
        }
    }

    @Override
    public BulkAction newEntity(BulkActionDataParams bulkActionDataParams) {
        if (bulkActionDataParams == null || bulkActionDataParams.getNature() == null || bulkActionDataParams.getNature() == BulkActionNature.CUSTOM_OPERATION && !RequiredValidation.isValid((Object)bulkActionDataParams.getCustomOperation())) {
            throw new ValidationException();
        }
        switch (bulkActionDataParams.getNature()) {
            case CHANGE_GROUP: {
                return new ChangeGroupBulkAction();
            }
            case CHANGE_STATUS: {
                return new ChangeStatusBulkAction();
            }
            case RESET_PASSWORD: {
                return new ResetPasswordBulkAction();
            }
            case CHANGE_FIELD_VALUE: {
                return new ChangeFieldValueBulkAction();
            }
            case REINDEX: {
                return new ReindexBulkAction();
            }
            case ADJUST_ACCOUNTS: {
                return new AdjustAccountsBulkAction();
            }
            case EMAIL_MAILING: {
                return new EmailMailingBulkAction();
            }
            case SMS_MAILING: {
                return new SmsMailingBulkAction();
            }
            case APP_MAILING: {
                return new AppMailingBulkAction();
            }
            case CUSTOM_OPERATION: {
                CustomOperationBulkAction customOperationBulkAction = new CustomOperationBulkAction();
                CustomOperation customOperation = this.getCustomOperation(bulkActionDataParams.getCustomOperation());
                customOperationBulkAction.setCustomOperation(customOperation);
                return customOperationBulkAction;
            }
        }
        return null;
    }

    public MailingListPreviewData previewMailingList(@NotNull BulkActionDTO bulkActionDTO, UserVO userVO) throws FrameworkException {
        BulkAction bulkAction = this.toEntity(bulkActionDTO);
        if (bulkAction.getNature().getUsage() != BulkActionUsage.MAILING_LIST || bulkActionDTO.isPersistent()) {
            throw new IllegalActionException("Not a transient mailing list bulk action");
        }
        this.validateAndSanitize(bulkActionDTO);
        User user = this.resolvePreviewUser(bulkActionDTO, userVO);
        UserVariablesFunction.preview();
        MailingListPreviewData mailingListPreviewData = this.mailingListPreview.get(bulkAction.getNature()).apply(bulkAction, user);
        mailingListPreviewData.setDto(bulkActionDTO);
        mailingListPreviewData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        return mailingListPreviewData;
    }

    public BulkActionUserResult process(TransactionStatus transactionStatus, BulkActionUser bulkActionUser) {
        if (bulkActionUser.getStatus() != BulkActionUserStatus.PENDING) {
            return null;
        }
        BulkActionNature bulkActionNature = bulkActionUser.getBulkAction().getNature();
        Function<BulkActionUser, BulkActionUserResult> function = this.processors.get(bulkActionNature);
        if (function == null) {
            throw new IllegalStateException("No suitable bulk action processor for " + String.valueOf(bulkActionNature));
        }
        BulkActionUserResult bulkActionUserResult = function.apply(bulkActionUser);
        if (bulkActionUserResult == null) {
            bulkActionUserResult = new BulkActionUserResult(BulkActionUserStatus.SKIPPED);
        }
        if (bulkActionUserResult.getStatus() == null) {
            bulkActionUserResult.setStatus(BulkActionUserStatus.SKIPPED);
        }
        BulkActionUserStatus bulkActionUserStatus = bulkActionUserResult.getStatus();
        String string = bulkActionUserResult.getMessage();
        Throwable throwable = bulkActionUserResult.getError();
        if (bulkActionUserStatus == BulkActionUserStatus.SUCCESS || this.cyclosProperties.isTestingEnv()) {
            bulkActionUser.setStatus(bulkActionUserStatus);
            bulkActionUser.setMessage(string);
            bulkActionUser.setProcessDate(new Date());
        } else {
            transactionStatus.setRollbackOnly();
            InvocationContext.ensure().addRollbackListener(true, () -> {
                BulkActionUser bulkActionUser2 = this.find(BulkActionUser.class, bulkActionUser.getId());
                bulkActionUser2.setStatus(bulkActionUserStatus);
                bulkActionUser2.setMessage(string);
                bulkActionUser2.setProcessDate(new Date());
                if (throwable != null) {
                    bulkActionUser.setErrorStackTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
                }
            });
        }
        return bulkActionUserResult;
    }

    public boolean processNext(Long l) {
        MutableObject mutableObject;
        block2: {
            QBulkActionUser qBulkActionUser = QBulkActionUser.bulkActionUser;
            mutableObject = new MutableObject();
            try {
                this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                    try {
                        BulkActionUser bulkActionUser = (BulkActionUser)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qBulkActionUser}).innerJoin((EntityPath)qBulkActionUser.bulkAction(), (Path)this.$)).innerFetchHint(new Path[]{qBulkActionUser, qBulkActionUser.bulkAction()}).where(new Predicate[]{((QBulkAction)this.$).id.eq((Object)l), ((QBulkAction)this.$).status.eq((Object)BulkActionStatus.RUNNING), qBulkActionUser.status.eq((Object)BulkActionUserStatus.PENDING)})).singleResult((Expression)qBulkActionUser);
                        if (bulkActionUser != null) {
                            mutableObject.set((Object)bulkActionUser.getId());
                            BulkAction bulkAction = bulkActionUser.getBulkAction();
                            SessionData sessionData = SessionDataFactory.system((Network)bulkAction.getNetwork());
                            if (bulkAction.getBy() != null) {
                                sessionData = SessionDataFactory.direct((BasicUser)bulkAction.getBy()).basedOn(sessionData).build();
                            }
                            this.invokerHandler.runAs(sessionData, () -> this.process(transactionStatus, bulkActionUser));
                        }
                    }
                    catch (OptimisticLockException | StaleEntityException throwable) {
                        throw new RetryException(throwable);
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                Long l2 = (Long)mutableObject.get();
                if (l2 == null) break block2;
                this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                    BulkActionUser bulkActionUser = (BulkActionUser)this.rawEntityManagerHandler.find(BulkActionUser.class, l2);
                    this.markFailure(bulkActionUser, exception);
                    return null;
                });
            }
        }
        return mutableObject.get() != null;
    }

    public Page<BulkActionVO> search(BulkActionQuery bulkActionQuery) throws FrameworkException {
        BooleanExpression booleanExpression;
        User user;
        DBQuery<?> dBQuery = this.from(this.$);
        if (CollectionHelper.isNotEmpty((Iterable)bulkActionQuery.getNatures())) {
            dBQuery.where((Predicate)((QBulkAction)this.$).nature.in((Collection)bulkActionQuery.getNatures()));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)bulkActionQuery.getBy())) != null) {
            booleanExpression = ((QBulkAction)this.$).by().eq((Object)user);
            if (user.isBroker()) {
                booleanExpression = booleanExpression.or((Predicate)((QBulkAction)this.$).by().operatorUserId.eq((Object)user.getId()));
            }
            dBQuery.where((Predicate)booleanExpression);
        }
        booleanExpression = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)bulkActionQuery.getCreated());
        dBQuery.where(((QBulkAction)this.$).creationDate.period((DatePeriod)booleanExpression));
        dBQuery.orderBy(((QBulkAction)this.$).creationDate.desc());
        SessionData sessionData = this.getSessionData();
        EnumSet enumSet = BulkActionNature.mailings();
        if (!sessionData.hasPermission(Permission.BULK_ACTIONS_VIEW)) {
            dBQuery.where((Predicate)((QBulkAction)this.$).nature.notIn(EnumSet.complementOf(enumSet)));
        }
        if (!sessionData.hasPermission(Permission.MAILINGS_VIEW)) {
            dBQuery.where((Predicate)((QBulkAction)this.$).nature.notIn((Collection)enumSet));
        }
        return dBQuery.page(BulkActionVO.class, (QueryParameters)bulkActionQuery, (Expression)this.$);
    }

    public Page<BulkActionUserVO> searchUsers(BulkActionUserQuery bulkActionUserQuery) throws FrameworkException {
        Set set;
        User user;
        BulkAction bulkAction = (BulkAction)this.conversionHandler.convert(BulkAction.class, (Object)bulkActionUserQuery.getBulkAction());
        if (bulkAction == null) {
            return PageImpl.empty();
        }
        QBulkActionUser qBulkActionUser = QBulkActionUser.bulkActionUser;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qBulkActionUser}).where((Predicate)qBulkActionUser.bulkAction().eq((Object)bulkAction));
        if (CollectionHelper.isNotEmpty((Iterable)bulkActionUserQuery.getStatuses())) {
            dBQuery.where((Predicate)qBulkActionUser.status.in((Collection)bulkActionUserQuery.getStatuses()));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)bulkActionUserQuery.getUser())) != null) {
            dBQuery.where((Predicate)qBulkActionUser.user().eq((Object)user));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = this.groupsHandler.flattenVOs((Collection)bulkActionUserQuery.getGroups())))) {
            dBQuery.where((Predicate)qBulkActionUser.user().group().in((Collection)set));
        }
        this.visibility(dBQuery, qBulkActionUser.user()).onlySelf();
        dBQuery.orderBy(qBulkActionUser.user().displayForManagers.asc());
        return dBQuery.page(BulkActionUserVO.class, (QueryParameters)bulkActionUserQuery, (Expression)qBulkActionUser);
    }

    public boolean sendTestApp(AppMailingBulkActionDTO appMailingBulkActionDTO, UserVO userVO, UserVO userVO2) throws FrameworkException {
        this.validateAndSanitize((BulkActionDTO)appMailingBulkActionDTO);
        User user = this.resolvePreviewUser((BulkActionDTO)appMailingBulkActionDTO, userVO);
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)userVO2);
        if (user2 == null) {
            throw new ValidationException("user", this.message(GeneralKeys.Errors.REQUIRED, UsersKeys.Users.USER));
        }
        if (!this.appNotificationHandler.canReceiveNotifications((BasicUser)user2)) {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor((BasicUser)user);
            String string = configurationAccessor.getFirebasePrivateKey();
            Object object = "The user %s can not receive app notifications: ";
            boolean bl = StringHelper.isBlank((Object)string);
            if (bl) {
                object = (String)object + "its configuration doesn't define a Firebase private key";
            }
            if (CollectionHelper.isEmpty((Iterable)user.getFcmTokens())) {
                object = (String)object + (bl ? " and " : "") + "it doesn't have any FCM token where to send the notification";
            }
            this.getLogger().warn(String.format((String)object, user));
            return false;
        }
        UserVariablesFunction.preview();
        AppMailingBulkAction appMailingBulkAction = (AppMailingBulkAction)this.toEntity((BulkActionDTO)appMailingBulkActionDTO);
        return this.appNotificationHandler.notify(this.resolveAppNotification(appMailingBulkAction, user).build());
    }

    public boolean sendTestEmail(EmailMailingBulkActionDTO emailMailingBulkActionDTO, UserVO userVO, String string) {
        this.validate(emailMailingBulkActionDTO);
        if (StringHelper.isBlank((Object)string) || !EmailValidation.isValid((String)string)) {
            throw new ValidationException("email", this.message(GeneralKeys.Errors.INVALID, UsersKeys.Users.EMAIL));
        }
        User user = this.resolvePreviewUser((BulkActionDTO)emailMailingBulkActionDTO, userVO);
        UserVariablesFunction.preview();
        EmailMailingBulkAction emailMailingBulkAction = (EmailMailingBulkAction)this.toEntity((BulkActionDTO)emailMailingBulkActionDTO);
        MailProcessingContext mailProcessingContext = this.mailHandler.preview(null, (BasicUser)user, MailContext.MAILING_LIST, this.emailProducer(emailMailingBulkAction, user), new FileInfo[0]);
        mailProcessingContext.setSubject(this.message(MessagingKeys.MailingLists.TEST_EMAIL_SUBJECT, mailProcessingContext.getSubject()));
        mailProcessingContext.setToEmail(string);
        return this.mailHandler.sendNow(mailProcessingContext, this.mailHandler.getMailSender());
    }

    public SendSMSResult sendTestSms(SmsMailingBulkActionDTO smsMailingBulkActionDTO, UserVO userVO, String string) {
        this.validateAndSanitize((BulkActionDTO)smsMailingBulkActionDTO);
        User user = this.resolvePreviewUser((BulkActionDTO)smsMailingBulkActionDTO, userVO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        ConfigurationAccessor configurationAccessor2 = this.getConfiguration();
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor2);
        if (phoneNumberDescriptor == null) {
            throw new ValidationException(new ValidationResult("phoneNumber", this.message(GeneralKeys.Errors.NOT_MOBILE_PHONE, UsersKeys.Users.PHONE)));
        }
        UserVariablesFunction.preview();
        SmsMailingBulkAction smsMailingBulkAction = (SmsMailingBulkAction)this.toEntity((BulkActionDTO)smsMailingBulkActionDTO);
        OutboundSms outboundSms = this.outboundSmsHandler.sendToUnregistered(configurationAccessor, string, this.processSmsMessage(smsMailingBulkAction, user), OutboundSmsType.MAILING);
        SendSMSResult sendSMSResult = new SendSMSResult();
        sendSMSResult.setFormattedPhoneNumber(this.phoneNumberHandler.format(phoneNumberDescriptor, configurationAccessor2));
        sendSMSResult.setSuccessfullySent(outboundSms.getStatus() == OutboundSmsStatus.SUCCESS);
        if (!sendSMSResult.isSuccessfullySent()) {
            this.getLogger().warn("The test SMS couldn't be sent to {}: {}", (Object)sendSMSResult.getFormattedPhoneNumber(), (Object)this.message(outboundSms.getStatus().getMessageKey(), new Object[0]));
        }
        return sendSMSResult;
    }

    @Override
    public BulkActionDTO toDTO(BulkAction bulkAction) {
        BulkActionDTO bulkActionDTO = (BulkActionDTO)super.toDTO(bulkAction);
        if (bulkAction instanceof ChangeFieldValueBulkAction && bulkAction.isPersistent()) {
            ChangeFieldValueBulkAction changeFieldValueBulkAction = (ChangeFieldValueBulkAction)bulkAction;
            UserCustomField userCustomField = changeFieldValueBulkAction.getCustomField();
            ChangeFieldValueBulkActionDTO changeFieldValueBulkActionDTO = (ChangeFieldValueBulkActionDTO)bulkActionDTO;
            CustomFieldValueDTO customFieldValueDTO = new CustomFieldValueDTO();
            customFieldValueDTO.setField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)userCustomField));
            if (userCustomField.getType().isBinary()) {
                if (userCustomField.getType() == CustomFieldType.IMAGE) {
                    customFieldValueDTO.setImageValues(this.conversionHandler.convertList(ImageVO.class, (Iterable)changeFieldValueBulkAction.getImages()));
                } else {
                    customFieldValueDTO.setFileValues(this.conversionHandler.convertList(RawFileVO.class, (Iterable)changeFieldValueBulkAction.getFiles()));
                }
                changeFieldValueBulkActionDTO.setFileNames(changeFieldValueBulkAction.getNewFieldValue());
            } else {
                Object object = this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)changeFieldValueBulkAction.getNewFieldValue(), false);
                this.customFieldValueHandler.setModelValue((CustomField)userCustomField, object, (ICustomFieldValue)customFieldValueDTO);
            }
            changeFieldValueBulkActionDTO.setFieldValue(customFieldValueDTO);
        }
        return bulkActionDTO;
    }

    @Override
    public BulkAction toEntity(BulkActionDTO bulkActionDTO) {
        String string;
        if (bulkActionDTO.isPersistent()) {
            throw new IllegalActionException();
        }
        UserQuery userQuery = bulkActionDTO.getQuery();
        try {
            string = this.jacksonConfiguration.getObjectMapper().writeValueAsString((Object)userQuery);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
        BulkAction bulkAction = (BulkAction)super.toEntity(bulkActionDTO);
        bulkAction.setCreationDate(new Date());
        bulkAction.setBy(this.getLoggedBasicUser());
        bulkAction.setQuery(string);
        bulkAction.setStatus(BulkActionStatus.RUNNING);
        if (bulkAction instanceof ChangeFieldValueBulkAction) {
            ChangeFieldValueBulkActionDTO changeFieldValueBulkActionDTO = (ChangeFieldValueBulkActionDTO)bulkActionDTO;
            CustomFieldValueDTO customFieldValueDTO2 = changeFieldValueBulkActionDTO.getFieldValue();
            UserCustomField userCustomField = (UserCustomField)this.conversionHandler.convert(UserCustomField.class, (Object)customFieldValueDTO2.getField());
            Object object = this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)customFieldValueDTO2, true);
            ChangeFieldValueBulkAction changeFieldValueBulkAction = (ChangeFieldValueBulkAction)bulkAction;
            changeFieldValueBulkAction.setCustomField(userCustomField);
            changeFieldValueBulkAction.setNewFieldValue(this.customFieldValueHandler.toReference((CustomField)userCustomField, object));
        } else if (bulkAction instanceof CustomOperationBulkAction) {
            CustomOperationBulkActionDTO customOperationBulkActionDTO = (CustomOperationBulkActionDTO)bulkActionDTO;
            CustomOperationBulkAction customOperationBulkAction = (CustomOperationBulkAction)bulkAction;
            Set set = CollectionHelper.orEmpty((List)customOperationBulkActionDTO.getFormParameters()).stream().map(customFieldValueDTO -> {
                CustomOperationField customOperationField = (CustomOperationField)this.conversionHandler.convert(CustomOperationField.class, (Object)customFieldValueDTO.getField());
                Object object = this.customFieldValueHandler.getValue((CustomField)customOperationField, customFieldValueDTO, true);
                String string = this.customFieldValueHandler.toReference((CustomField)customOperationField, object);
                CustomOperationBulkActionParameter customOperationBulkActionParameter = new CustomOperationBulkActionParameter();
                customOperationBulkActionParameter.setBulkAction(customOperationBulkAction);
                customOperationBulkActionParameter.setCustomField(customOperationField);
                customOperationBulkActionParameter.setValue(string);
                return customOperationBulkActionParameter;
            }).collect(Collectors.toSet());
            customOperationBulkAction.setFormParameters(set);
        }
        return bulkAction;
    }

    protected MailContentProducer emailProducer(EmailMailingBulkAction emailMailingBulkAction, User user) {
        return () -> new MailContent(emailMailingBulkAction.getEmailSubject(), this.richTextHandler.replaceTagsByUrls(emailMailingBulkAction.getEmailBody(), this.configurationHandler.getAccessor((BasicUser)user)));
    }

    protected void fixBulkAction(BulkAction bulkAction) {
        if (bulkAction instanceof AppMailingBulkAction) {
            AppMailingBulkAction appMailingBulkAction = (AppMailingBulkAction)bulkAction;
            if (appMailingBulkAction.getBuiltInMobilePage() != BuiltInMobilePage.URL) {
                appMailingBulkAction.setCustomUrl(null);
            }
            if (appMailingBulkAction.getBuiltInMobilePage() != BuiltInMobilePage.RUN_OPERATION) {
                appMailingBulkAction.setCustomOperation(null);
            }
            if (appMailingBulkAction.getBuiltInMobilePage() != BuiltInMobilePage.RUN_WIZARD) {
                appMailingBulkAction.setCustomWizard(null);
            }
            if (appMailingBulkAction.getBuiltInMobilePage() != BuiltInMobilePage.CONTENT_PAGE) {
                appMailingBulkAction.setMobilePage(null);
            }
        }
    }

    @Override
    protected BulkActionData getData(BulkAction bulkAction) {
        SimpleBulkActionData simpleBulkActionData = null;
        if (bulkAction.isPersistent()) {
            BulkActionDetailsData bulkActionDetailsData = new BulkActionDetailsData();
            bulkActionDetailsData.setStatus(this.getStatus(bulkAction));
            if (!this.getLoggedUser().isBroker()) {
                bulkActionDetailsData.setGroups(this.groupsHandler.visibles().accessibles().basic().sorted());
            }
            bulkActionDetailsData.setCanCancel(bulkAction.getStatus() == BulkActionStatus.RUNNING);
            simpleBulkActionData = bulkActionDetailsData;
        } else {
            switch (bulkAction.getNature()) {
                case CHANGE_GROUP: {
                    ChangeGroupBulkActionData changeGroupBulkActionData = new ChangeGroupBulkActionData();
                    changeGroupBulkActionData.setGroups(this.groupsHandler.visibles().accessibles().basic().sorted());
                    simpleBulkActionData = changeGroupBulkActionData;
                    break;
                }
                case CHANGE_STATUS: {
                    ChangeStatusBulkActionData changeStatusBulkActionData = new ChangeStatusBulkActionData();
                    changeStatusBulkActionData.setStatuses(this.userStatusService.getManagedStatuses());
                    simpleBulkActionData = changeStatusBulkActionData;
                    break;
                }
                case RESET_PASSWORD: {
                    ResetPasswordBulkActionData resetPasswordBulkActionData = new ResetPasswordBulkActionData();
                    Set set = this.getProducts().userManagement().getUserPasswordActions().keysSet((Path)QUserProductPasswordAction.userProductPasswordAction.reset);
                    resetPasswordBulkActionData.setPasswordTypes(this.conversionHandler.convertList(PasswordTypeVO.class, (Iterable)CollectionHelper.sort((Collection)set)));
                    simpleBulkActionData = resetPasswordBulkActionData;
                    break;
                }
                case CHANGE_FIELD_VALUE: {
                    ChangeFieldValueBulkActionData changeFieldValueBulkActionData = new ChangeFieldValueBulkActionData();
                    List list = this.profileFieldHandler.getCustomFields((Collection)this.profileFieldHandler.getMatchingFields(this.getSessionData().getProducts().userManagement().getUserProfileFields(), QProductUserProfileField.productUserProfileField.editable));
                    list.removeIf(CustomField::isUnique);
                    List list2 = this.conversionHandler.convertList(UserCustomFieldDetailedVO.class, (Iterable)list);
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("searchContext", null);
                    hashMap.put("overBrokeredUsers", this.getLoggedUser().isBroker());
                    this.customFieldValueHandler.fillValuesFromScript(UserCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list2, true);
                    changeFieldValueBulkActionData.setCustomFields(list2);
                    simpleBulkActionData = changeFieldValueBulkActionData;
                    break;
                }
                case ADJUST_ACCOUNTS: {
                    throw new IllegalActionException();
                }
                case CUSTOM_OPERATION: {
                    CustomOperationBulkAction customOperationBulkAction = (CustomOperationBulkAction)bulkAction;
                    CustomOperation customOperation2 = customOperationBulkAction.getCustomOperation();
                    CustomOperationBulkActionData customOperationBulkActionData = new CustomOperationBulkActionData();
                    RunCustomOperationDataParams runCustomOperationDataParams = new RunCustomOperationDataParams();
                    runCustomOperationDataParams.setCustomOperation(new CustomOperationVO(customOperation2.getId()));
                    customOperationBulkActionData.setRunData(this.customOperationService.getRunData(runCustomOperationDataParams));
                    simpleBulkActionData = customOperationBulkActionData;
                    break;
                }
                case APP_MAILING: {
                    SessionData sessionData = this.getSessionData();
                    ConfigurationVO configurationVO = (ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)sessionData.getConfiguration().getConfiguration());
                    AppMailingBulkActionData appMailingBulkActionData = new AppMailingBulkActionData();
                    appMailingBulkActionData.setMobilePages(this.mobilePageService.list(configurationVO));
                    List list = this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.USER});
                    list = CollectionHelper.orEmpty((List)list).stream().filter(customOperation -> CollectionHelper.orEmpty((Set)customOperation.getChannels()).stream().filter(Channel::isMobile).findAny().isPresent()).collect(Collectors.toList());
                    appMailingBulkActionData.setCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, list));
                    List list3 = this.customWizardService.list();
                    ChannelVO channelVO = this.channelService.getMobileVO();
                    list3 = list3.stream().filter(customWizardResultVO -> sessionData.isAdmin() || customWizardResultVO.getNature() != CustomWizardNature.SYSTEM).filter(customWizardResultVO -> CollectionHelper.orEmpty((List)customWizardResultVO.getChannels()).contains(channelVO)).collect(Collectors.toList());
                    appMailingBulkActionData.setCustomWizards(this.conversionHandler.convertList(CustomWizardVO.class, list3));
                    simpleBulkActionData = appMailingBulkActionData;
                    break;
                }
                case EMAIL_MAILING: {
                    EmailMailingBulkActionData emailMailingBulkActionData = new EmailMailingBulkActionData();
                    emailMailingBulkActionData.setParameters(this.profileFieldHandler.getUserVariables());
                    simpleBulkActionData = emailMailingBulkActionData;
                    break;
                }
                case REINDEX: 
                case SMS_MAILING: {
                    simpleBulkActionData = new SimpleBulkActionData();
                }
            }
            if (simpleBulkActionData == null) {
                throw new IllegalStateException("Unhandled bulk action nature: " + String.valueOf(bulkAction.getNature()));
            }
        }
        simpleBulkActionData.setDto((EntityDTO)this.toDTO(bulkAction));
        simpleBulkActionData.setNature(bulkAction.getNature());
        return simpleBulkActionData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(BulkActionDTO bulkActionDTO) {
        return new Object[]{CustomOperationBulkActionDTO.FORM_PARAMETERS};
    }

    @Override
    protected void onAfterSave(BulkAction bulkAction, BulkAction bulkAction2, Object object) {
        ChangeFieldValueBulkAction changeFieldValueBulkAction;
        UserCustomField userCustomField;
        UserQuery userQuery;
        try {
            userQuery = (UserQuery)this.jacksonConfiguration.getObjectMapper().readValue(bulkAction.getQuery(), UserQuery.class);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.nativeQueryHandler.insertUsersForBulkAction(bulkAction.getId(), userQuery);
        if (bulkAction instanceof ChangeFieldValueBulkAction && (userCustomField = (changeFieldValueBulkAction = (ChangeFieldValueBulkAction)bulkAction).getCustomField()).getType().isBinary()) {
            boolean bl = userCustomField.getType() == CustomFieldType.IMAGE;
            Class clazz = bl ? BulkActionImage.class : BulkActionFile.class;
            List list = (List)this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)changeFieldValueBulkAction.getNewFieldValue(), true);
            int n = 0;
            ArrayList<BulkActionImage> arrayList = new ArrayList<BulkActionImage>();
            ArrayList<BulkActionFile> arrayList2 = new ArrayList<BulkActionFile>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Object e : list) {
                StoredFile storedFile = (StoredFile)this.conversionHandler.convert(clazz, e);
                ((IBulkActionStoredFile)storedFile).setOrder(Integer.valueOf(n++));
                ((IBulkActionStoredFile)storedFile).setBulkAction(bulkAction);
                this.storedFileHandler.move((StoredFile)e, storedFile);
                this.persist((IEntity)storedFile);
                if (bl) {
                    arrayList.add((BulkActionImage)storedFile);
                } else {
                    arrayList2.add((BulkActionFile)storedFile);
                }
                arrayList3.add(storedFile.getName());
            }
            changeFieldValueBulkAction.setImages(arrayList);
            changeFieldValueBulkAction.setFiles(arrayList2);
            changeFieldValueBulkAction.setNewFieldValue(StringHelper.join(arrayList3, (String)", "));
        }
        this.backgroundTaskHandler.schedule(BulkActionProcessingBackgroundTask.scheduling(bulkAction));
    }

    @Override
    protected Object onBeforeSave(BulkAction bulkAction, BulkAction bulkAction2) {
        if (bulkAction2 != null) {
            throw new IllegalActionException();
        }
        this.fixBulkAction(bulkAction);
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QBulkAction)this.$).network());
        networkPathRegistry.register(QBulkActionUser.bulkActionUser.bulkAction().network());
        networkPathRegistry.register(QCustomOperationBulkActionParameter.customOperationBulkActionParameter.bulkAction().network());
    }

    @Override
    protected Validator resolveValidator(BulkActionDTO bulkActionDTO) {
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)BulkActionDTO.QUERY, UsersKeys.BulkActions.RUN_APPLY_TO).required();
        if (bulkActionDTO instanceof ChangeGroupBulkActionDTO) {
            validator.property((org.cyclos.model.Property)ChangeGroupBulkActionDTO.NEW_GROUP, UsersKeys.BulkActions.NEW_GROUP).required();
        } else if (bulkActionDTO instanceof ChangeStatusBulkActionDTO) {
            validator.property((org.cyclos.model.Property)ChangeStatusBulkActionDTO.NEW_STATUS, UsersKeys.BulkActions.NEW_STATUS).required();
        } else if (bulkActionDTO instanceof ResetPasswordBulkActionDTO) {
            validator.property((org.cyclos.model.Property)ResetPasswordBulkActionDTO.PASSWORD_TYPE, UsersKeys.BulkActions.PASSWORD_TYPE).required();
        } else if (bulkActionDTO instanceof ChangeFieldValueBulkActionDTO) {
            UserCustomField userCustomField;
            CustomFieldValueDTO customFieldValueDTO = ((ChangeFieldValueBulkActionDTO)bulkActionDTO).getFieldValue();
            Property property = validator.property((org.cyclos.model.Property)ChangeFieldValueBulkActionDTO.FIELD_VALUE, UsersKeys.BulkActions.FIELD_VALUE);
            property.required();
            if (customFieldValueDTO != null) {
                property.nested((org.cyclos.model.Property)CustomFieldValueDTO.FIELD, UsersKeys.BulkActions.CUSTOM_FIELD).required().entity(UserCustomField.class, (EntityValidation)new BaseEntityValidation<UserCustomField>(){

                    protected boolean isValid(Object object, Object object2, UserCustomField userCustomField) {
                        return !userCustomField.isUnique();
                    }
                });
            }
            UserCustomField userCustomField2 = userCustomField = customFieldValueDTO == null ? null : (UserCustomField)this.conversionHandler.convert(UserCustomField.class, (Object)customFieldValueDTO.getField());
            if (userCustomField != null) {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("searchContext", null);
                hashMap.put("overBrokeredUsers", this.getLoggedUser().isBroker());
                this.customFieldValueHandler.addValueValidation(validator, (CustomField)userCustomField, (EntityPathBase)QUserCustomFieldValue.userCustomFieldValue, hashMap, LoadValuesScriptFunction.ENTITY, ChangeFieldValueBulkActionDTO.FIELD_VALUE.getName());
            }
        } else if (bulkActionDTO instanceof CustomOperationBulkActionDTO) {
            CustomOperationBulkActionDTO customOperationBulkActionDTO = (CustomOperationBulkActionDTO)bulkActionDTO;
            validator.property((org.cyclos.model.Property)CustomOperationBulkActionDTO.CUSTOM_OPERATION, UsersKeys.BulkActions.CUSTOM_OPERATION).required().entity(CustomOperation.class, (EntityValidation)new BaseEntityValidation<CustomOperation>(){

                protected boolean isValid(Object object, Object object2, CustomOperation customOperation) {
                    return customOperation.getScope() == CustomOperationScope.BULK_ACTION;
                }
            });
            CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationBulkActionDTO.getCustomOperation());
            if (customOperation != null) {
                Map<String, CustomOperation> map = Collections.singletonMap("customOperation", customOperation);
                for (CustomOperationField customOperationField : customOperation.getFormParameters()) {
                    this.customFieldValueHandler.addValueValidation(validator, (CustomField)customOperationField, null, map, CustomOperationBulkActionDTO.FORM_PARAMETERS.getName());
                }
            }
        } else if (bulkActionDTO instanceof EmailMailingBulkActionDTO) {
            validator.property((org.cyclos.model.Property)EmailMailingBulkActionDTO.EMAIL_SUBJECT, UsersKeys.BulkActions.EMAIL_SUBJECT).required();
            validator.property((org.cyclos.model.Property)EmailMailingBulkActionDTO.EMAIL_BODY, UsersKeys.BulkActions.EMAIL_BODY).required();
            Integer n = this.getConfiguration().getSmtpConfiguration().getMaxRecipients();
            if (n != null) {
                validator.general(object -> {
                    UserQuery userQuery = bulkActionDTO.getQuery();
                    Integer n2 = userQuery.getCurrentPage();
                    Integer n3 = userQuery.getPageSize();
                    userQuery.setCountOnly();
                    Integer n4 = this.userService.search(userQuery).getTotalCount();
                    userQuery.setCurrentPage(n2);
                    userQuery.setPageSize(n3);
                    if (n4 > n) {
                        return new ValidationError(MessagingKeys.MailingLists.ERROR_MAX_RECIPIENTS_EXCEEDED, new Object[]{n});
                    }
                    return null;
                });
            }
        } else if (bulkActionDTO instanceof SmsMailingBulkActionDTO) {
            validator.property((org.cyclos.model.Property)SmsMailingBulkActionDTO.SMS_MESSAGE, UsersKeys.BulkActions.SMS_MESSAGE).required();
        } else if (bulkActionDTO instanceof AppMailingBulkActionDTO) {
            AppMailingBulkActionDTO appMailingBulkActionDTO = (AppMailingBulkActionDTO)bulkActionDTO;
            validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.TITLE, UsersKeys.BulkActions.APP_TITLE).required().maxLength(1000);
            validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.BODY, UsersKeys.BulkActions.APP_BODY).required().maxLength(1000);
            validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.IMAGE_URL, UsersKeys.BulkActions.APP_IMAGE_URL).maxLength(1000);
            Property property = validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.CUSTOM_URL, UsersKeys.BulkActions.CUSTOM_URL).maxLength(1000);
            if (appMailingBulkActionDTO.getBuiltInMobilePage() != null) {
                switch (appMailingBulkActionDTO.getBuiltInMobilePage()) {
                    case URL: {
                        property.required();
                        break;
                    }
                    case RUN_OPERATION: {
                        validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.CUSTOM_OPERATION, UsersKeys.BulkActions.CUSTOM_OPERATION).required();
                        break;
                    }
                    case RUN_WIZARD: {
                        validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.CUSTOM_WIZARD, UsersKeys.BulkActions.CUSTOM_WIZARD).required();
                        break;
                    }
                    case CONTENT_PAGE: {
                        validator.property((org.cyclos.model.Property)AppMailingBulkActionDTO.MOBILE_PAGE, UsersKeys.BulkActions.MOBILE_PAGE).required();
                        break;
                    }
                }
            }
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends BulkAction>, Class<? extends BulkActionDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private BulkActionUserResult adjustAccounts(BulkActionUser bulkActionUser) {
        try {
            User user = bulkActionUser.getUser();
            AccountServiceLocal.AdjustAccountsResult adjustAccountsResult = this.accountsService.adjustAccounts(user);
            if (adjustAccountsResult.isEmptyResult()) {
                return new BulkActionUserResult(BulkActionUserStatus.SKIPPED);
            }
            Function<List, String> function = list -> list.stream().map(arg_0 -> ((DataTranslationHandler)this.dataTranslationHandler).getName(arg_0)).collect(Collectors.joining(", "));
            ArrayList<String> arrayList = new ArrayList<String>();
            if (CollectionHelper.isNotEmpty((Iterable)adjustAccountsResult.getCreatedAccounts())) {
                arrayList.add(this.message(BankingKeys.Accounts.ADJUSTED_CREATED, function.apply(adjustAccountsResult.getCreatedAccounts())));
            }
            if (CollectionHelper.isNotEmpty((Iterable)adjustAccountsResult.getActivatedAccounts())) {
                arrayList.add(this.message(BankingKeys.Accounts.ADJUSTED_ACTIVATED, function.apply(adjustAccountsResult.getActivatedAccounts())));
            }
            if (CollectionHelper.isNotEmpty((Iterable)adjustAccountsResult.getNewAccountNumbers())) {
                arrayList.add(this.message(BankingKeys.Accounts.ADJUSTED_NEW_NUMBERS, StringHelper.join((Collection)adjustAccountsResult.getNewAccountNumbers().stream().map(string -> MaskHelper.applyMask((String)this.configurationHandler.getAccessor((BasicUser)user).getAccountNumberConfiguration().getMask(), (String)string)).collect(Collectors.toList()), (String)", ")));
            }
            if (CollectionHelper.isNotEmpty((Iterable)adjustAccountsResult.getDisposedAccounts())) {
                arrayList.add(this.message(BankingKeys.Accounts.ADJUSTED_DISPOSED, function.apply(adjustAccountsResult.getDisposedAccounts())));
            }
            return new BulkActionUserResult(BulkActionUserStatus.SUCCESS, StringHelper.join(arrayList, (String)". "));
        }
        catch (ValidationException validationException) {
            return new BulkActionUserResult(BulkActionUserStatus.ERROR, StringHelper.join((Collection)validationException.getValidation().getAllErrors(), (String)"\n"));
        }
    }

    private BulkActionUserResult appMailing(BulkActionUser bulkActionUser) {
        User user = bulkActionUser.getUser();
        if (!this.appNotificationHandler.canReceiveNotifications((BasicUser)user)) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_NO_APP, new Object[0]));
        }
        if (!this.notificationSettingsService.allowMailing(user, BulkActionNature.APP_MAILING)) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_DISABLED_MAILING, new Object[0]));
        }
        AppMailingBulkAction appMailingBulkAction = (AppMailingBulkAction)bulkActionUser.getBulkAction();
        AppNotificationMessage appNotificationMessage = this.resolveAppNotification(appMailingBulkAction, user).build();
        if (this.appNotificationHandler.notify(appNotificationMessage)) {
            return new BulkActionUserResult(BulkActionUserStatus.SUCCESS);
        }
        return new BulkActionUserResult(BulkActionUserStatus.ERROR);
    }

    private BulkActionUserResult changeFieldValue(BulkActionUser bulkActionUser) {
        BulkActionUserStatus bulkActionUserStatus;
        ChangeFieldValueBulkAction changeFieldValueBulkAction = (ChangeFieldValueBulkAction)bulkActionUser.getBulkAction();
        UserCustomField userCustomField = changeFieldValueBulkAction.getCustomField();
        User user = bulkActionUser.getUser();
        boolean bl = this.profileFieldHandler.isEnabled((BasicUser)user, (ProfileField)userCustomField);
        BulkActionUserStatus bulkActionUserStatus2 = bulkActionUserStatus = bl ? BulkActionUserStatus.SUCCESS : BulkActionUserStatus.SKIPPED;
        if (bl) {
            ExtensionPointAccessor extensionPointAccessor;
            ExtensionPointAccessor extensionPointAccessor2;
            this.userService.fetchCollections(user);
            this.detach((IEntity)user);
            User user2 = (User)this.entityManagerHandler.find(User.class, user.getId());
            UserCustomFieldValue userCustomFieldValue = (UserCustomFieldValue)ObjectHelper.defaultValue((Object)((UserCustomFieldValue)CustomFieldHelper.findValue((ICustomField)userCustomField, (Collection)user2.getCustomValues())), () -> {
                UserCustomFieldValue userCustomFieldValue = new UserCustomFieldValue();
                userCustomFieldValue.setOwner((BasicUser)user2);
                userCustomFieldValue.setField(userCustomField);
                user2.getCustomValues().add(userCustomFieldValue);
                return userCustomFieldValue;
            });
            Object object = this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)userCustomFieldValue, false);
            if (userCustomField.getType() == CustomFieldType.IMAGE) {
                userCustomFieldValue.getImageValues().forEach(customFieldValueImage -> this.storedFileHandler.remove(customFieldValueImage.getId().longValue()));
                extensionPointAccessor2 = changeFieldValueBulkAction.getImages().stream().map(bulkActionImage -> this.toCustomValueStoredFile(userCustomFieldValue, CustomFieldValueImage.class, (StoredFile)bulkActionImage)).collect(Collectors.toList());
                userCustomFieldValue.setImageValues(extensionPointAccessor2);
                extensionPointAccessor = extensionPointAccessor2;
            } else if (userCustomField.getType() == CustomFieldType.FILE) {
                userCustomFieldValue.getFileValues().forEach(customFieldValueFile -> this.storedFileHandler.remove(customFieldValueFile.getId().longValue()));
                extensionPointAccessor2 = changeFieldValueBulkAction.getFiles().stream().map(bulkActionFile -> this.toCustomValueStoredFile(userCustomFieldValue, CustomFieldValueFile.class, (StoredFile)bulkActionFile)).collect(Collectors.toList());
                userCustomFieldValue.setFileValues(extensionPointAccessor2);
                extensionPointAccessor = extensionPointAccessor2;
            } else {
                extensionPointAccessor = this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)changeFieldValueBulkAction.getNewFieldValue(), true);
                if (Objects.equals(object, extensionPointAccessor)) {
                    return new BulkActionUserResult(bulkActionUserStatus);
                }
                CustomFieldHelper.setCustomFieldValue((ICustomFieldValue)userCustomFieldValue, (Object)extensionPointAccessor);
            }
            extensionPointAccessor2 = this.extensionPointService.newAccessor((ExtensionPointEvent)UserExtensionPointEvent.UPDATE, new ExtensionPointFilter(user2.getGroup())).attribute("user", (Object)user2).attribute("currentCopy", (Object)user);
            extensionPointAccessor2.fireValidated();
            this.flush();
            this.userSearcHandler.updateUserFields(user2);
            FormatterImpl formatterImpl = this.getFormatter();
            EntityPropertyLog entityPropertyLog = new EntityPropertyLog();
            entityPropertyLog.setCustomFieldId(userCustomField.getId());
            entityPropertyLog.setName(userCustomField.getName());
            entityPropertyLog.setOrder(Integer.valueOf(0));
            entityPropertyLog.setValues(formatterImpl.format(object), formatterImpl.format((Object)extensionPointAccessor));
            EntityLogHandler entityLogHandler = this.entityLogRegistry.getHandler(User.class);
            String string = entityLogHandler.getEntityLogName((SimpleEntity)user2, null, EntityLogEvent.UPDATE);
            String string2 = entityLogHandler.getEntityLogNamePrefix((SimpleEntity)user2, null);
            this.entityLogService.log(string, string2, user2.getId().longValue(), null, null, entityLogHandler.getRelatedEntityId((SimpleEntity)user2), EntityLogType.USER, EntityLogEvent.UPDATE, null, Collections.singletonList(entityPropertyLog), this.isAdmin() || this.isSystem());
            extensionPointAccessor2.fireSaved();
        }
        return new BulkActionUserResult(bulkActionUserStatus);
    }

    private BulkActionUserResult changeGroup(BulkActionUser bulkActionUser) {
        BulkActionUserStatus bulkActionUserStatus;
        ChangeGroupBulkAction changeGroupBulkAction = (ChangeGroupBulkAction)bulkActionUser.getBulkAction();
        ChangeGroupDTO changeGroupDTO = new ChangeGroupDTO();
        changeGroupDTO.setGroup((BasicGroupVO)new GroupVO(changeGroupBulkAction.getNewGroup().getId()));
        changeGroupDTO.setUser((BasicUserVO)new UserVO(bulkActionUser.getUser().getId()));
        changeGroupDTO.setComment(this.message(UsersKeys.BulkActions.CHANGE_GROUP_COMMENT, new Object[0]));
        String string = null;
        try {
            this.userGroupService.changeGroup(changeGroupDTO);
            bulkActionUserStatus = BulkActionUserStatus.SUCCESS;
        }
        catch (IllegalActionException | ValidationException throwable) {
            bulkActionUserStatus = BulkActionUserStatus.SKIPPED;
            string = this.messageFrom(throwable);
        }
        return new BulkActionUserResult(bulkActionUserStatus, string);
    }

    private BulkActionUserResult changeStatus(BulkActionUser bulkActionUser) {
        BulkActionUserStatus bulkActionUserStatus;
        ChangeStatusBulkAction changeStatusBulkAction = (ChangeStatusBulkAction)bulkActionUser.getBulkAction();
        String string = null;
        try {
            User user = bulkActionUser.getUser();
            if (user.getStatus() == UserStatus.PENDING && changeStatusBulkAction.getNewStatus() == UserStatus.ACTIVE) {
                this.basicUserService.manuallyValidateRegistration((UserLocatorVO)this.conversionHandler.convert(UserLocatorVO.class, (Object)user));
            } else {
                ChangeUserStatusParams changeUserStatusParams = new ChangeUserStatusParams();
                changeUserStatusParams.setUser(new BasicUserVO(user.getId()));
                changeUserStatusParams.setStatus(changeStatusBulkAction.getNewStatus());
                changeUserStatusParams.setComment(this.message(UsersKeys.BulkActions.CHANGE_STATUS_COMMENT, new Object[0]));
                this.userStatusService.changeStatus(changeUserStatusParams);
            }
            bulkActionUserStatus = BulkActionUserStatus.SUCCESS;
        }
        catch (IllegalActionException | ValidationException throwable) {
            bulkActionUserStatus = BulkActionUserStatus.SKIPPED;
            string = this.messageFrom(throwable);
        }
        return new BulkActionUserResult(bulkActionUserStatus, string);
    }

    private BulkActionUserResult emailMailing(BulkActionUser bulkActionUser) {
        User user = bulkActionUser.getUser();
        if (StringHelper.isBlank((Object)user.getEmail())) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_NO_EMAIL, new Object[0]));
        }
        if (!this.notificationSettingsService.allowMailing(user, BulkActionNature.EMAIL_MAILING)) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_DISABLED_MAILING, new Object[0]));
        }
        EmailMailingBulkAction emailMailingBulkAction = (EmailMailingBulkAction)bulkActionUser.getBulkAction();
        this.mailHandler.send(null, (BasicUser)user, MailContext.MAILING_LIST, this.emailProducer(emailMailingBulkAction, user), new FileInfo[0]);
        return new BulkActionUserResult(BulkActionUserStatus.SUCCESS);
    }

    private CustomOperation getCustomOperation(CustomOperationVO customOperationVO) {
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationVO);
        if (customOperation.getScope() != CustomOperationScope.BULK_ACTION) {
            throw new EntityNotFoundException(CustomOperation.class);
        }
        return customOperation;
    }

    private BulkActionStatusVO getStatus(BulkAction bulkAction) {
        EnumMap<BulkActionUserStatus, Integer> enumMap = new EnumMap<BulkActionUserStatus, Integer>(BulkActionUserStatus.class);
        Integer n = bulkAction.getTotalUsers();
        if (n != null) {
            enumMap.put(BulkActionUserStatus.PENDING, bulkAction.getPendingUsers());
            enumMap.put(BulkActionUserStatus.SUCCESS, bulkAction.getSuccessUsers());
            enumMap.put(BulkActionUserStatus.SKIPPED, bulkAction.getSkippedUsers());
            enumMap.put(BulkActionUserStatus.ERROR, bulkAction.getErrorUsers());
            enumMap.put(BulkActionUserStatus.CANCELED, bulkAction.getCanceledUsers());
        } else {
            QBulkActionUser qBulkActionUser = QBulkActionUser.bulkActionUser;
            Map map = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qBulkActionUser}).where((Predicate)qBulkActionUser.bulkAction().eq((Object)bulkAction))).groupBy((Expression)qBulkActionUser.status)).map((Expression)qBulkActionUser.status, (Expression)qBulkActionUser.id.count());
            n = 0;
            for (BulkActionUserStatus bulkActionUserStatus : BulkActionUserStatus.values()) {
                int n2 = ((Number)ObjectHelper.defaultValue((Object)((Number)map.get(bulkActionUserStatus)), (Object)0)).intValue();
                enumMap.put(bulkActionUserStatus, n2);
                n = n + n2;
            }
        }
        int n3 = (Integer)ObjectHelper.defaultValue((Object)((Integer)enumMap.get(BulkActionUserStatus.PENDING)), (Object)0);
        double d = (double)(n - n3) / (double)n.intValue();
        BulkActionStatusVO bulkActionStatusVO = new BulkActionStatusVO();
        bulkActionStatusVO.setStatus(bulkAction.getStatus());
        bulkActionStatusVO.setProgress(d);
        bulkActionStatusVO.setTotalUsers(n.intValue());
        bulkActionStatusVO.setUsersByStatus(enumMap);
        return bulkActionStatusVO;
    }

    private void markFailure(BulkActionUser bulkActionUser, Exception exception) {
        bulkActionUser.setProcessDate(new Date());
        bulkActionUser.setStatus(BulkActionUserStatus.ERROR);
        bulkActionUser.setMessage(this.messageFrom(exception));
        bulkActionUser.setErrorStackTrace(ExceptionUtils.getStackTrace((Throwable)exception));
    }

    private String messageFrom(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationResult validationResult = ((ValidationException)throwable).getValidation();
            String string = validationResult == null ? null : validationResult.getFirstError();
            return Objects.toString(string, this.message(GeneralKeys.Errors.VALIDATION, new Object[0]));
        }
        if (throwable instanceof EntityNotFoundException) {
            EntityNotFoundException entityNotFoundException = (EntityNotFoundException)throwable;
            String string = entityNotFoundException.getEntityType();
            String string2 = Objects.toString(entityNotFoundException.getId(), entityNotFoundException.getKey());
            if (string == null) {
                return this.message(GeneralKeys.Errors.NOT_FOUND, new Object[0]);
            }
            if (string2 != null) {
                return this.message(GeneralKeys.Errors.ENTITY_NOT_FOUND_KEY, string2);
            }
            return this.message(GeneralKeys.Errors.ENTITY_NOT_FOUND, new Object[0]);
        }
        Throwable throwable2 = ExceptionUtils.getRootCause((Throwable)throwable);
        return StringHelper.trimToNull((Object)throwable2.getMessage());
    }

    private AppMailingPreviewData previewAppMailing(AppMailingBulkAction appMailingBulkAction, User user) {
        this.fixBulkAction((BulkAction)appMailingBulkAction);
        AppNotificationMessage appNotificationMessage = this.resolveAppNotification(appMailingBulkAction, user).build();
        AppMailingPreviewData appMailingPreviewData = (AppMailingPreviewData)this.conversionHandler.convert(AppMailingPreviewData.class, (Object)appMailingBulkAction);
        appMailingPreviewData.setTitle(appNotificationMessage.getTitle());
        appMailingPreviewData.setBody(appNotificationMessage.getBody());
        appMailingPreviewData.setCustomUrl(appNotificationMessage.getCustomUrl());
        return appMailingPreviewData;
    }

    private EmailMailingPreviewData previewEmailMailing(EmailMailingBulkAction emailMailingBulkAction, User user) {
        MailProcessingContext mailProcessingContext = this.mailHandler.preview(null, (BasicUser)user, MailContext.MAILING_LIST, this.emailProducer(emailMailingBulkAction, user), new FileInfo[0]);
        EmailMailingPreviewData emailMailingPreviewData = new EmailMailingPreviewData();
        emailMailingPreviewData.setSubject(mailProcessingContext.getSubject());
        emailMailingPreviewData.setBody(mailProcessingContext.getBody());
        return emailMailingPreviewData;
    }

    private SmsMailingPreviewData previewSmsMailing(SmsMailingBulkAction smsMailingBulkAction, User user) {
        SmsMailingPreviewData smsMailingPreviewData = new SmsMailingPreviewData();
        smsMailingPreviewData.setMessage(this.processSmsMessage(smsMailingBulkAction, user));
        return smsMailingPreviewData;
    }

    private String processSmsMessage(SmsMailingBulkAction smsMailingBulkAction, User user) {
        String string = (String)this.invokerHandler.runAs(UserVariablesFunction.isPreview() ? this.getSessionData() : SessionDataFactory.user((BasicUser)user), () -> {
            Function function = this.profileFieldHandler.getUserVariablesFunction((BasicUser)user);
            return StringHelper.replaceVariables((String)smsMailingBulkAction.getSmsMessage(), (Function)function);
        });
        return string;
    }

    private BulkActionUserResult reindex(BulkActionUser bulkActionUser) {
        this.basicUserService.reindex((BasicUser)bulkActionUser.getUser());
        return new BulkActionUserResult(BulkActionUserStatus.SUCCESS);
    }

    private BulkActionUserResult resetPassword(BulkActionUser bulkActionUser) {
        BulkActionUserStatus bulkActionUserStatus;
        ResetPasswordBulkAction resetPasswordBulkAction = (ResetPasswordBulkAction)bulkActionUser.getBulkAction();
        ResetAndSendPasswordDTO resetAndSendPasswordDTO = new ResetAndSendPasswordDTO();
        resetAndSendPasswordDTO.setType(new PasswordTypeDetailedVO(resetPasswordBulkAction.getPasswordType().getId()));
        resetAndSendPasswordDTO.setUser((BasicUserVO)new UserVO(bulkActionUser.getUser().getId()));
        String string = null;
        try {
            this.passwordService.resetAndSend(resetAndSendPasswordDTO);
            bulkActionUserStatus = BulkActionUserStatus.SUCCESS;
        }
        catch (IllegalActionException | ValidationException throwable) {
            bulkActionUserStatus = BulkActionUserStatus.SKIPPED;
            string = this.messageFrom(throwable);
        }
        return new BulkActionUserResult(bulkActionUserStatus, string);
    }

    private AppNotificationMessage.Builder resolveAppNotification(AppMailingBulkAction appMailingBulkAction, User user) {
        String string;
        HashMap hashMap = new HashMap();
        String string2 = null;
        if (appMailingBulkAction.getBuiltInMobilePage() != null) {
            string2 = appMailingBulkAction.getBuiltInMobilePage().getLocation();
            string = this.applicationHandler.getIdMask();
            switch (appMailingBulkAction.getBuiltInMobilePage()) {
                case RUN_OPERATION: {
                    string2 = string2.replace("operation_id", string.apply(appMailingBulkAction.getCustomOperation().getId()).toString()).replace("scope_type", appMailingBulkAction.getCustomOperation().getScope().name());
                    break;
                }
                case RUN_WIZARD: {
                    string2 = string2.replace("wizard_id", string.apply(appMailingBulkAction.getCustomWizard().getId()).toString()).replace("scope_type", appMailingBulkAction.getCustomWizard().getNature().name()).replace("user_id", string.apply(user.getId()).toString());
                    break;
                }
                case CONTENT_PAGE: {
                    string2 = string2.replace("page_id", string.apply(appMailingBulkAction.getMobilePage().getId()).toString());
                    break;
                }
                case URL: {
                    string2 = appMailingBulkAction.getCustomUrl();
                    break;
                }
                default: {
                    string2 = this.linkGenerator.mobile(string2);
                }
            }
        }
        string = string2;
        AppNotificationMessage.Builder builder = (AppNotificationMessage.Builder)this.invokerHandler.runAs(UserVariablesFunction.isPreview() ? this.getSessionData() : SessionDataFactory.user((BasicUser)user), () -> AppNotificationMessage.builder().setTitle(appMailingBulkAction.getTitle()).setBody(appMailingBulkAction.getBody()).setUser((BasicUser)user).setCustomUrl(string).setImageUrl(appMailingBulkAction.getImageUrl()).setVariables(hashMap));
        return builder;
    }

    private User resolvePreviewUser(BulkActionDTO bulkActionDTO, UserVO userVO) {
        UserQuery userQuery;
        if (userVO == null) {
            userQuery = bulkActionDTO.getQuery();
            userQuery.setCurrentPage(null);
            userQuery.setPageSize(Integer.valueOf(1));
            userQuery.setSkipTotalCount(true);
            userQuery.setIgnoreProfileFieldsInList(true);
            BulkActionServiceLocal.setEmailRequired((AbstractUserQuery)userQuery);
            userVO = (UserVO)CollectionHelper.first((Iterable)this.userSearcHandler.search((QueryParameters)userQuery));
        }
        User user = userQuery = userVO == null ? this.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)userVO);
        if (userQuery == null) {
            throw new IllegalActionException("Couldn't resolve a user");
        }
        if (StringHelper.isBlank((Object)userQuery.getEmail())) {
            throw new ValidationException(this.message(UsersKeys.BulkActions.USER_MESSAGE_NO_EMAIL, new Object[0]));
        }
        return userQuery;
    }

    private BulkActionUserResult smsMailing(BulkActionUser bulkActionUser) {
        User user = bulkActionUser.getUser();
        SmsMailingBulkAction smsMailingBulkAction = (SmsMailingBulkAction)bulkActionUser.getBulkAction();
        if (!this.notificationSettingsService.allowMailing(user, BulkActionNature.EMAIL_MAILING)) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_DISABLED_MAILING, new Object[0]));
        }
        List list = this.outboundSmsHandler.send((BasicUser)user, smsMailingBulkAction.getSmsMessage(), OutboundSmsType.MAILING);
        if (list.stream().anyMatch(outboundSms -> outboundSms.getStatus() == OutboundSmsStatus.SUCCESS)) {
            return new BulkActionUserResult(BulkActionUserStatus.SUCCESS);
        }
        if (list.isEmpty()) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_NO_SMS_PHONE, new Object[0]));
        }
        if (list.stream().anyMatch(outboundSms -> outboundSms.getStatus() == OutboundSmsStatus.MAX_USER_MESSAGES_REACHED)) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_MAX_INDIVIDUAL_SMS_REACHED, new Object[0]));
        }
        if (list.stream().anyMatch(outboundSms -> outboundSms.getStatus() == OutboundSmsStatus.MAX_GLOBAL_MESSAGES_REACHED)) {
            return new BulkActionUserResult(BulkActionUserStatus.SKIPPED, this.message(UsersKeys.BulkActions.USER_MESSAGE_MAX_GLOBAL_SMS_REACHED, new Object[0]));
        }
        return new BulkActionUserResult(BulkActionUserStatus.ERROR, list.stream().filter(outboundSms -> outboundSms.getStatus() != OutboundSmsStatus.SUCCESS).map(outboundSms -> this.getFormatter().format((HasMessageKey)outboundSms.getStatus())).collect(Collectors.joining(", ")));
    }

    private <F extends StoredFile> F toCustomValueStoredFile(UserCustomFieldValue userCustomFieldValue, Class<F> clazz, StoredFile storedFile) {
        StoredFile storedFile2 = (StoredFile)this.conversionHandler.convert(clazz, (Object)storedFile);
        ((ICustomFieldValueStoredFile)storedFile2).setCustomFieldValue((CustomFieldValue)userCustomFieldValue);
        this.storedFileHandler.copy(storedFile, storedFile2);
        this.persist((IEntity)storedFile2);
        return (F)storedFile2;
    }

    private void updateUserCounters(BulkAction bulkAction) {
        BulkActionStatusVO bulkActionStatusVO = this.getStatus(bulkAction);
        Map map = CollectionHelper.orEmpty((Map)bulkActionStatusVO.getUsersByStatus());
        bulkAction.setSuccessUsers((Integer)ObjectHelper.defaultValue((Object)((Integer)map.get(BulkActionUserStatus.SUCCESS)), (Object)0));
        bulkAction.setErrorUsers((Integer)ObjectHelper.defaultValue((Object)((Integer)map.get(BulkActionUserStatus.ERROR)), (Object)0));
        bulkAction.setPendingUsers((Integer)ObjectHelper.defaultValue((Object)((Integer)map.get(BulkActionUserStatus.PENDING)), (Object)0));
        bulkAction.setSkippedUsers((Integer)ObjectHelper.defaultValue((Object)((Integer)map.get(BulkActionUserStatus.SKIPPED)), (Object)0));
        bulkAction.setPendingUsers((Integer)ObjectHelper.defaultValue((Object)((Integer)map.get(BulkActionUserStatus.CANCELED)), (Object)0));
    }

    private void validateAndSanitize(BulkActionDTO bulkActionDTO) {
        this.validate(bulkActionDTO);
        if (bulkActionDTO instanceof AppMailingBulkActionDTO) {
            AppMailingBulkActionDTO appMailingBulkActionDTO = (AppMailingBulkActionDTO)bulkActionDTO;
            BuiltInMobilePage builtInMobilePage = appMailingBulkActionDTO.getBuiltInMobilePage();
            if (builtInMobilePage != BuiltInMobilePage.RUN_OPERATION) {
                appMailingBulkActionDTO.setCustomOperation(null);
            }
            if (builtInMobilePage != BuiltInMobilePage.RUN_WIZARD) {
                appMailingBulkActionDTO.setCustomWizard(null);
            }
            if (builtInMobilePage != BuiltInMobilePage.CONTENT_PAGE) {
                appMailingBulkActionDTO.setMobilePage(null);
            }
            if (builtInMobilePage != BuiltInMobilePage.URL) {
                appMailingBulkActionDTO.setCustomUrl(null);
            }
        }
    }

    static {
        SUBCLASS_MAPPINGS.put(ChangeGroupBulkAction.class, ChangeGroupBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(ChangeStatusBulkAction.class, ChangeStatusBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(ResetPasswordBulkAction.class, ResetPasswordBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(ChangeFieldValueBulkAction.class, ChangeFieldValueBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(ReindexBulkAction.class, ReindexBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(CustomOperationBulkAction.class, CustomOperationBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(AdjustAccountsBulkAction.class, AdjustAccountsBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(EmailMailingBulkAction.class, EmailMailingBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(SmsMailingBulkAction.class, SmsMailingBulkActionDTO.class);
        SUBCLASS_MAPPINGS.put(AppMailingBulkAction.class, AppMailingBulkActionDTO.class);
    }
}

