/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.products.BrokerVisibility;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicUserVOConverter
extends EntityVOConverter<BasicUserVO> {
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;

    public BasicUserVOConverter() {
        super(BasicUserVO.class);
    }

    @Override
    protected void fill(Object object, BasicUserVO basicUserVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof BasicUser) {
            BasicUser basicUser = (BasicUser)object;
            SessionData sessionData = conversionContext.getSessionData();
            FormatterImpl formatterImpl = this.getFormatter();
            if (!sessionData.relatesTo(basicUser) || basicUser.isOperator() && !this.operatorServiceSecurity.canViewOperators(basicUser.getUser()) && !basicUser.equals((Object)sessionData.getLoggedBasicUser())) {
                String string;
                Long l = null;
                if (basicUser.isOperator()) {
                    User user = basicUser.getUser();
                    string = formatterImpl.format((BasicUser)user);
                    if (sessionData.relatesTo((BasicUser)user)) {
                        l = user.getId();
                    }
                } else {
                    string = basicUser.isAdmin() && !sessionData.isAdmin() ? sessionData.getConfiguration().getApplicationUsername() : formatterImpl.format(basicUser);
                }
                basicUserVO.setId(l);
                basicUserVO.setDisplay(string);
                return;
            }
            basicUserVO.setDisplay(formatterImpl.format(basicUser));
            objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicUserVO.DISPLAY);
            if (!this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.VIEW)) {
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)UserVO.IMAGE);
            }
            if (basicUserVO instanceof UserWithFieldsVO) {
                if (!this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW)) {
                    objectArray = ArrayUtils.add((Object[])objectArray, (Object)UserWithFieldsVO.ADDRESS);
                }
                boolean bl = sessionData.isSystem();
                BasicUser basicUser2 = (BasicUser)object;
                if (sessionData.isLoggedIn()) {
                    BasicUser basicUser3 = sessionData.getLoggedBasicUser();
                    if (basicUser3.equals((Object)basicUser2)) {
                        BrokerVisibility brokerVisibility = sessionData.getProducts().member().getShowBrokers();
                        bl = brokerVisibility == BrokerVisibility.ALL || brokerVisibility == BrokerVisibility.ONLY_MAIN;
                    } else if (sessionData.manages(basicUser2)) {
                        bl = sessionData.hasPermission(Permission.USER_BROKER_VIEW);
                    }
                }
                if (!bl) {
                    objectArray = ArrayUtils.add((Object[])objectArray, (Object)UserWithFieldsVO.MAIN_BROKER);
                }
            }
        }
        super.fill(object, basicUserVO, objectArray, conversionContext);
    }

    @Override
    protected BasicUserVO instantiate(Class<BasicUserVO> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        if (BasicUserVO.class.equals(clazz) && object instanceof BasicUser) {
            BasicUser basicUser = (BasicUser)object;
            if (conversionContext.getSessionData().relatesTo(basicUser)) {
                if (object instanceof Operator) {
                    if (this.operatorServiceSecurity.canViewOperators(basicUser.getUser()) || basicUser.equals((Object)this.getSessionData().getLoggedBasicUser())) {
                        clazz = OperatorVO.class;
                    }
                } else {
                    clazz = UserVO.class;
                }
            }
        }
        return super.instantiate(clazz, object, conversionContext);
    }
}

