/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.utils.conversion.BaseEntityConverter;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicUserConverter
extends BaseEntityConverter<BasicUser> {
    @Autowired
    private UserLocatorHandler userLocatorHandler;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;

    public BasicUserConverter() {
        super(BasicUser.class);
    }

    @Override
    protected void fill(Object object, BasicUser basicUser, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof BasicUserDTO) {
            BasicUser basicUser2 = basicUser;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (objectArray != null) {
                CollectionUtils.addAll(arrayList, (Object[])objectArray);
            }
            arrayList.add(UserDTO.CUSTOM_VALUES.getName());
            super.fill(object, basicUser2, arrayList.toArray(), conversionContext);
            List list = this.profileFieldHandler.getCustomFields((Collection)this.profileFieldHandler.getEnabledProfileFields(basicUser2));
            List list2 = this.profileFieldHandler.getCustomFields((Collection)this.profileFieldHandler.getFieldsByAction(basicUser2, ProfileFieldAction.EDIT));
            if (object instanceof UserDTO) {
                List list3 = this.profileFieldHandler.getCustomFields((Collection)this.profileFieldHandler.getFieldsByAction(basicUser2, ProfileFieldAction.MANAGE_PRIVACY));
                UserDTO userDTO = (UserDTO)object;
                this.customFieldValueHandler.setCustomValues(basicUser2, (Collection)list, (Collection)list2, (Collection)list3, (Collection)userDTO.getCustomValues());
            } else if (object instanceof OperatorDTO) {
                OperatorDTO operatorDTO = (OperatorDTO)object;
                this.customFieldValueHandler.setCustomValues((SimpleEntity)basicUser2, (Collection)list, (Collection)list2, (Collection)operatorDTO.getCustomValues());
            }
        } else {
            super.fill(object, basicUser, objectArray, conversionContext);
        }
    }

    @Override
    protected BasicUser instantiate(Class<BasicUser> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        IEntity iEntity;
        if (object instanceof BasicUser) {
            BasicUser basicUser = (BasicUser)object;
            if (clazz.equals(Operator.class) && !(basicUser instanceof Operator)) {
                throw new EntityNotFoundException(clazz);
            }
            if (clazz.equals(User.class)) {
                return basicUser.getUser();
            }
            return basicUser;
        }
        if (object instanceof LocateAccountOwnerResult) {
            BasicUser basicUser = ((LocateAccountOwnerResult)object).getBasicUser();
            if (basicUser == null) {
                throw new EntityNotFoundException(clazz);
            }
            return this.instantiate(clazz, (Object)basicUser, conversionContext);
        }
        if (object instanceof LocateUserResult) {
            return this.instantiate(clazz, (Object)((LocateUserResult)object).getBasicUser(), conversionContext);
        }
        UserLocatorVO userLocatorVO = null;
        if (object instanceof UserLocatorVO) {
            userLocatorVO = (UserLocatorVO)object;
        } else if (object instanceof IEntity) {
            iEntity = (IEntity)object;
            userLocatorVO = new UserLocatorVO();
            userLocatorVO.setId(iEntity.getId());
        } else if (object instanceof CharSequence) {
            userLocatorVO = new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)object.toString());
        }
        if (ModelHelper.isValid((UserLocatorVO)userLocatorVO)) {
            iEntity = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
            if (clazz.equals(User.class)) {
                iEntity = iEntity.getUser();
            } else if (clazz.equals(Operator.class) && !(iEntity instanceof Operator)) {
                String string = (String)ObjectHelper.defaultValue((Object)userLocatorVO.getPrincipal(), (Object)StringHelper.trimToNull((Object)userLocatorVO.getId()));
                throw new EntityNotFoundException(Operator.class, string);
            }
            return iEntity;
        }
        iEntity = super.instantiate(clazz, object, conversionContext);
        if (iEntity != null && iEntity.isTransient()) {
            iEntity.setNetwork(conversionContext.getSessionData().getNetwork());
        }
        return iEntity;
    }
}

