/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.cyclos.entities.users.Record;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.Property;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.security.users.RecordServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public abstract class BaseRecordEntityLogHandlerImpl<R extends Record, DTO extends RecordDTO>
extends BaseEntityLogHandlerImpl<R, DTO> {
    @Autowired
    @Lazy
    private RecordServiceSecurity recordServiceSecurity;

    @Override
    public Long getRelatedEntityId(Record record) {
        return record.getType().getId();
    }

    public EntityLogDescriptor<DTO> resolveLogDescriptor(R r) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDtoType()).property((Property)RecordDTO.TYPE, UsersKeys.Records.TYPE).property((Property)RecordDTO.CREATED_BY, UsersKeys.Records.CREATED_BY).property((Property)RecordDTO.CREATION_DATE, UsersKeys.Records.CREATION_DATE).ignore((Property)RecordDTO.LAST_MODIFIED_DATE).ignore((Property)RecordDTO.MODIFIED_BY).ignore((Property)RecordDTO.CUSTOM_VALUES);
        return entityLogDescriptor;
    }

    @Override
    protected R getEntityToViewLog(long l) {
        Record record = (Record)this.find(this.getEntityClass(), l);
        if (this.recordServiceSecurity.canPerformOperation(record, CRUDOperation.READ)) {
            return (R)record;
        }
        return null;
    }

    protected abstract Class<DTO> resolveDtoType();
}

