/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedImage;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.QImportedLine;
import org.cyclos.entities.system.UserImportedFile;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseWithFieldsImportHandlerImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ImportHelper;
import org.cyclos.impl.system.ImportWithImageHandler;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.banking.accounts.UserRegistrationAccountConfigurationDTO;
import org.cyclos.model.banking.accounttypes.UserAccountTypeVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.ImportedFileStatus;
import org.cyclos.model.system.imports.ImportedLineStatus;
import org.cyclos.model.system.imports.UserImportField;
import org.cyclos.model.system.imports.UserImportedFileDTO;
import org.cyclos.model.system.imports.UserImportedFileData;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressDataParams;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneData;
import org.cyclos.model.users.phones.PhoneDataParams;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserImportHandlerImpl
extends BaseWithFieldsImportHandlerImpl<UserCustomField, UserCustomFieldValueDTO, UserImportedFileDTO, UserImportedFileData, UserImportedFile, User>
implements ImportWithImageHandler<UserImportedFileDTO, UserImportedFileData, UserImportedFile, User> {
    private static final String UNLIMITED_UPPER_CREDIT_LIMIT = "UNLIMITED";
    private static final Set<String> REQUIRED_HEADERS_WHEN_GROUP_FROM_FILE = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{UserImportField.GROUP.getName()}));
    @Autowired
    private GroupsHandler groupsHandler;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private BrokeringServiceLocal brokeringService;
    @Autowired
    private UserImageServiceLocal userImageService;
    @Autowired
    private ProductsHandler productsHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private UserAddressServiceLocal addressService;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private PasswordHandler passwordHandler;

    UserImportHandlerImpl() {
        super(UserCustomField.class, UserCustomFieldValueDTO.class, (ImportField[])UserImportField.values());
    }

    @Override
    public void finishImport(UserImportedFile userImportedFile) {
        super.finishImport(userImportedFile);
        if (userImportedFile.getStatus() == ImportedFileStatus.IMPORTED) {
            if (!userImportedFile.isUseGroupFromFile()) {
                int n = this.importService.getImportProgress((ImportedFile)userImportedFile).getLinesImported();
                this.notificationHandler.admin().userImportRegistration(userImportedFile, n, userImportedFile.getGroup());
            } else {
                QImportedLine qImportedLine = QImportedLine.importedLine;
                QUser qUser = QUser.user;
                ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qImportedLine}).innerJoin((EntityPath)qUser)).on((com.querydsl.core.types.Predicate)qUser.id.eq((Expression)qImportedLine.importedEntityId))).where(new com.querydsl.core.types.Predicate[]{qImportedLine.importedFile().eq((Object)userImportedFile), qImportedLine.status.eq((Object)ImportedLineStatus.IMPORTED)})).groupBy((Expression)qUser.group())).list(new Expression[]{qUser.group(), qImportedLine.count()}).stream().forEach(tuple -> this.notificationHandler.admin().userImportRegistration(userImportedFile, ((Long)tuple.get(1, Long.class)).intValue(), (UserGroup)tuple.get(0, UserGroup.class)));
            }
        }
    }

    public Predicate<String> getAllowedImportFieldsPredicate(UserImportedFile userImportedFile) {
        if (userImportedFile.isUseGroupFromFile()) {
            return string -> Stream.of(UserImportField.values()).anyMatch(userImportField -> userImportField.getPrefix() != null && string.startsWith(userImportField.getPrefix() + ".") || userImportField.getPrefix() == null && string.equals(userImportField.getName()) || string.startsWith("field."));
        }
        Set<String> set = this.getImportFields((Group)userImportedFile.getGroup(), false, userImportedFile.isSendActivationEmail());
        return string -> set.contains(ImportHelper.extractCanonicalFieldAndId(string).getFirst());
    }

    public UserImportedFileData getData(UserImportedFile userImportedFile) {
        UserImportedFileData userImportedFileData = new UserImportedFileData();
        userImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(UserImportedFileDTO.class, (Object)userImportedFile)));
        if (userImportedFile.isTransient()) {
            userImportedFileData.setGroups(this.groupsHandler.accessibles().basic().sorted());
        }
        return userImportedFileData;
    }

    public Class<User> getEntityClass() {
        return User.class;
    }

    public ImportedField getImagesField(UserImportedFile userImportedFile) {
        return userImportedFile.getField(UserImportField.IMAGES.getName());
    }

    public Class<UserImportedFile> getImportedFileClass() {
        return UserImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.USERS_IMPORT;
    }

    public Set<String> getMissingRequiredFields(UserImportedFile userImportedFile, List<String> list) {
        Set<String> set;
        if (userImportedFile.isUseGroupFromFile()) {
            set = REQUIRED_HEADERS_WHEN_GROUP_FROM_FILE;
        } else {
            set = this.getImportFields((Group)userImportedFile.getGroup(), true, userImportedFile.isSendActivationEmail());
            Collection collection = CollectionUtils.select(set, string -> string.startsWith(UserImportField.getPasswordPrefix() + "."));
            if (collection.size() == 1) {
                collection.add(UserImportField.PASSWORD_DEFAULT.getName());
                collection.add(UserImportField.PASSWORD_VALUE.getName());
                if (CollectionHelper.containsAny(list, (Collection)collection)) {
                    set.removeAll(collection);
                }
            }
            this.processMissingFieldsWithIdentifier(list, set, UserImportField.getAddressPrefix());
            this.processMissingFieldsWithIdentifier(list, set, UserImportField.getLandlinePrefix());
            this.processMissingFieldsWithIdentifier(list, set, UserImportField.getMobilePrefix());
        }
        return Set.copyOf(CollectionUtils.subtract(set, list));
    }

    public Object instantiateContext() {
        return null;
    }

    @Override
    public UserImportedFile newEntity(ImportedFileDataParams importedFileDataParams) {
        UserImportedFile userImportedFile = (UserImportedFile)super.newEntity(importedFileDataParams);
        userImportedFile.setUseGroupFromFile(true);
        return userImportedFile;
    }

    public UserImportedFile newImportedFile(UserImportedFileDTO userImportedFileDTO) {
        UserImportedFile userImportedFile = new UserImportedFile();
        userImportedFile.setGroup((UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)userImportedFileDTO.getGroup()));
        userImportedFile.setSendActivationEmail(userImportedFileDTO.isSendActivationEmail());
        userImportedFile.setUseGroupFromFile(userImportedFileDTO.isUseGroupFromFile());
        return userImportedFile;
    }

    public void processImportedImages(User user, List<ImportedImage> list) {
        for (ImportedImage importedImage : list) {
            UserImage userImage = (UserImage)this.conversionHandler.convertExcluding(UserImage.class, (Object)importedImage, new Object[]{"category"});
            this.storedFileHandler.copy((StoredFile)importedImage, (StoredFile)userImage);
            this.userImageService.addImage(user, userImage);
            userImage.setName(new File(importedImage.getName()).getName());
        }
    }

    public User processImportedLine(ImportedLine importedLine, Object object) {
        String string;
        UserRegistrationDTO userRegistrationDTO = this.convertToDTO(importedLine);
        userRegistrationDTO.setSkipActivationEmail(!((UserImportedFile)importedLine.getImportedFile()).isSendActivationEmail());
        User user = this.userService.importUser(userRegistrationDTO);
        String string2 = importedLine.getValue((ImportField)UserImportField.BROKER);
        if (StringHelper.isNotBlank((Object)string2)) {
            string = new UserLocatorVO((Property)UserLocatorVO.USERNAME, (Object)string2);
            UserLocatorVO userLocatorVO = new UserLocatorVO(user.getId());
            this.brokeringService.addBroker(userLocatorVO, (UserLocatorVO)string, true);
        }
        string = UserImportField.getPasswordPrefix();
        importedLine.getValues().forEach(importedLineValue -> {
            String string2 = importedLineValue.getImportedField().getFieldName();
            if (string2.equals(string) || string2.startsWith(string + ".") && string2.endsWith("." + UserImportField.PASSWORD_VALUE.getSimpleName())) {
                importedLineValue.setValue("****");
            }
        });
        return user;
    }

    public Validator resolveValidator(UserImportedFileDTO userImportedFileDTO) {
        Validator validator = new Validator();
        if (userImportedFileDTO.isTransient() && !userImportedFileDTO.isUseGroupFromFile()) {
            UserGroup userGroup;
            validator.property((Property)UserImportedFileDTO.GROUP, SystemKeys.Imports.GROUP).required();
            if (userImportedFileDTO.getGroup() != null && !(userGroup = (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)userImportedFileDTO.getGroup())).isEnabled()) {
                throw new ValidationException(this.message(SystemKeys.Imports.ERROR_GROUP_DISABLED, userGroup));
            }
        }
        return validator;
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) {
        User user;
        UserRegistrationDTO userRegistrationDTO = this.convertToDTO(importedLine);
        this.userService.validate((UserDTO)userRegistrationDTO, UserRegistration.IMPORT, null);
        String string = importedLine.getValue((ImportField)UserImportField.BROKER);
        if (!(!StringHelper.isNotBlank((Object)string) || (user = (User)this.locateUser(string)).isActive() && user.isBroker())) {
            String string2 = this.message(SystemKeys.Imports.ERROR_INVALID_BROKER, new Object[0]);
            throw new ValidationException(string2);
        }
    }

    @Override
    protected List<ImportField> doGetFieldsInList(UserImportedFile userImportedFile) {
        return Arrays.asList(UserImportField.NAME, UserImportField.USERNAME);
    }

    @Override
    protected UserCustomFieldValueDTO getCustomFieldValueDto(Object object, UserCustomField userCustomField, ImportedLine importedLine) {
        UserCustomFieldValueDTO userCustomFieldValueDTO = new UserCustomFieldValueDTO();
        this.customFieldValueHandler.setModelValue((CustomField)userCustomField, object, (ICustomFieldValue)userCustomFieldValueDTO);
        String string = this.getPrivateImportFieldName(userCustomField);
        String string2 = importedLine.getValue(string);
        Boolean bl = this.parseBoolean(string2);
        if (bl != null) {
            userCustomFieldValueDTO.setHidden(bl.booleanValue());
        }
        return userCustomFieldValueDTO;
    }

    private UserRegistrationDTO convertToDTO(ImportedLine importedLine) {
        UserImportedFile userImportedFile = (UserImportedFile)importedLine.getImportedFile();
        UserGroup userGroup = this.resolveGroup(importedLine);
        GroupVO groupVO = (GroupVO)this.conversionHandler.convert(GroupVO.class, (Object)userGroup);
        UserRegistrationDTO userRegistrationDTO = new UserRegistrationDTO();
        userRegistrationDTO.setGroup(groupVO);
        userRegistrationDTO.setSkipActivationEmail(!userImportedFile.isSendActivationEmail());
        userRegistrationDTO.setName(importedLine.getValue((ImportField)UserImportField.NAME));
        userRegistrationDTO.setUsername(importedLine.getValue((ImportField)UserImportField.USERNAME));
        userRegistrationDTO.setEmail(importedLine.getValue((ImportField)UserImportField.EMAIL));
        String string = importedLine.getValue((ImportField)UserImportField.CREATION_DATE);
        userRegistrationDTO.setCreationDate(this.parseDateTime(string));
        this.filterNotApplicableFields(importedLine, (Group)userGroup);
        this.setPasswords(importedLine, userRegistrationDTO, userGroup);
        this.setAddressValues(importedLine, userRegistrationDTO);
        this.setPhoneValues(importedLine, userRegistrationDTO);
        this.setCustomFieldValues(importedLine, userRegistrationDTO);
        this.setAccountConfigurations(importedLine, userRegistrationDTO);
        return userRegistrationDTO;
    }

    private PasswordRegistrationDTO createPasswordRegistrationDTO(PasswordTypeVO passwordTypeVO, boolean bl) {
        PasswordRegistrationDTO passwordRegistrationDTO = new PasswordRegistrationDTO();
        passwordRegistrationDTO.setType(passwordTypeVO);
        passwordRegistrationDTO.setAssign(bl);
        return passwordRegistrationDTO;
    }

    private void filterNotApplicableFields(ImportedLine importedLine, Group group) {
        Set<String> set = this.getImportFields(group, false, false);
        importedLine.getValues().forEach(importedLineValue -> {
            if (!set.contains(importedLineValue.getImportedField().getFieldName())) {
                importedLineValue.setValue(null);
            }
        });
    }

    private Set<String> getImportFields(Group group, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.profileFieldHandler.getEnabledProfileFields((BasicUser)new User(group));
        List list2 = this.profileFieldHandler.getCustomFields((Collection)list);
        if (bl) {
            list2.removeIf(userCustomField -> !userCustomField.isRequired());
        }
        if (!bl) {
            hashSet.addAll(this.getPrivateImportFieldNames(list2));
        }
        hashSet.addAll(this.getImportFieldNames(list2));
        for (Object object6 : UserImportField.values()) {
            object5 = object6.getProfileField();
            if (object5 != null && !list.contains(object5)) continue;
            if (bl) {
                if (object5 == BasicProfileField.ADDRESS) {
                    object4 = this.configurationHandler.getAccessor((BasicGroup)group);
                    object3 = object4.getAddressConfiguration();
                    object2 = object6.getAddressField();
                    if (object2 != null) {
                        if (!object3.getEnabledAddressFields().contains(object2) || bl && !object3.getRequiredAddressFields().contains(object2)) continue;
                        hashSet.add(object6.getName());
                        continue;
                    }
                    if (bl) continue;
                    hashSet.add(object6.getName());
                    continue;
                }
                if (object5 == null || !this.isRequired(group, (BasicProfileField)object5, (UserImportField)object6)) continue;
                hashSet.add(object6.getName());
                continue;
            }
            if (object5 != null && !list.contains(object5)) continue;
            hashSet.add(object6.getName());
        }
        if (!bl) {
            object = this.productsHandler.getAccessor((BasicGroup)group);
            List list3 = object.member().getUserAccounts();
            for (Object object6 : list3) {
                object5 = object6.getInternalName();
                if (!StringHelper.isNotBlank((Object)object5)) continue;
                object4 = UserImportField.getFieldsByPrefix((String)UserImportField.getAccountPrefix());
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (UserImportField)object3.next();
                    String string = object2.getName().replaceFirst("\\.", "." + (String)object5 + ".");
                    hashSet.add(string);
                }
            }
        }
        if (!bl || !bl2) {
            object = this.passwordHandler.getPasswordTypesAtRegistration(group, UserRegistration.IMPORT, PasswordMode.MANUAL);
            for (PasswordType passwordType : object.keySet()) {
                Object object6;
                object6 = passwordType.getInternalName();
                if (!StringHelper.isNotBlank((Object)object6)) continue;
                if (!bl) {
                    object5 = UserImportField.getFieldsByPrefix((String)UserImportField.getPasswordPrefix());
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (UserImportField)object4.next();
                        object2 = object3.getName().replaceFirst("\\.", "." + (String)object6 + ".");
                        hashSet.add((String)object2);
                    }
                    continue;
                }
                hashSet.add(UserImportField.PASSWORD_VALUE.getName().replaceFirst("\\.", "." + (String)object6 + "."));
            }
            if (!bl && object.size() == 1) {
                hashSet.add(UserImportField.PASSWORD_VALUE.getName());
                hashSet.add(UserImportField.PASSWORD_DEFAULT.getName());
                hashSet.add(UserImportField.PASSWORD_FORCE_CHANGE.getName());
            }
        }
        return hashSet;
    }

    private boolean isRequired(Group group, BasicProfileField basicProfileField, UserImportField userImportField) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        switch (basicProfileField) {
            case FULL_NAME: {
                return true;
            }
            case LOGIN_NAME: {
                return !configurationAccessor.isGeneratedUsername();
            }
            case EMAIL: {
                return configurationAccessor.isEmailRequired();
            }
            case PHONE: {
                if (userImportField == UserImportField.LANDLINE_NUMBER || userImportField == UserImportField.MOBILE_NUMBER) {
                    return userImportField.getPhoneNature() == PhoneNature.LANDLINE ? configurationAccessor.isLandLineRequired() : configurationAccessor.isMobileRequired();
                }
                return false;
            }
            case ADDRESS: {
                return configurationAccessor.isRequiredAddress();
            }
        }
        return false;
    }

    private void processMissingFieldsWithIdentifier(List<String> list, Set<String> set, String string3) {
        Collection collection = CollectionUtils.select(set, string2 -> string2.startsWith(string3 + "."));
        if (!collection.isEmpty()) {
            Collection collection2 = collection.stream().map(string -> string.substring(string.indexOf(".") + 1)).collect(Collectors.toList());
            Set set2 = list.stream().filter(string2 -> string2.startsWith(string3 + "[") || string2.startsWith(string3 + ".")).map(string2 -> string2.startsWith(string3 + ".") ? null : string2.substring(string2.indexOf("[") + 1, string2.indexOf("]"))).collect(Collectors.toSet());
            if (!set2.contains(null)) {
                set.removeAll(collection);
            }
            collection2.forEach(string2 -> set2.forEach(string3 -> {
                String string4 = string3 + (String)(string3 == null ? "." : "[" + string3 + "].") + string2;
                if (list.contains(string4)) {
                    if (string3 == null) {
                        set.remove(string4);
                    }
                } else if (string3 != null) {
                    set.add(string4);
                }
            }));
        }
    }

    private UserGroup resolveGroup(ImportedLine importedLine) throws ValidationException {
        UserGroup userGroup;
        block5: {
            String string;
            UserImportedFile userImportedFile = (UserImportedFile)importedLine.getImportedFile();
            userGroup = userImportedFile.getGroup();
            if (userImportedFile.isUseGroupFromFile() && StringHelper.isNotBlank((Object)(string = importedLine.getValue((ImportField)UserImportField.GROUP)))) {
                try {
                    userGroup = (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)string);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    Group group = this.groupService.findByName(string);
                    if (!(group instanceof UserGroup)) break block5;
                    userGroup = (UserGroup)group;
                }
            }
        }
        if (userGroup == null) {
            throw new ValidationException(this.message(SystemKeys.Imports.MISSING_GROUP, new Object[0]));
        }
        if (!userGroup.isEnabled()) {
            throw new ValidationException(this.message(SystemKeys.Imports.ERROR_GROUP_DISABLED, userGroup));
        }
        return userGroup;
    }

    private void setAccountConfigurations(ImportedLine importedLine, UserRegistrationDTO userRegistrationDTO) {
        HashMap<String, UserRegistrationAccountConfigurationDTO> hashMap = new HashMap<String, UserRegistrationAccountConfigurationDTO>();
        HashMap<String, AccountType> hashMap2 = new HashMap<String, AccountType>();
        Map<String, String> map = ImportHelper.getFieldValuesForPrefix(importedLine, UserImportField.getAccountPrefix());
        for (String string : map.keySet()) {
            AccountType accountType;
            String[] stringArray = string.split("\\.");
            String string2 = stringArray[1];
            String string3 = UserImportField.getAccountPrefix() + "." + stringArray[2];
            UserRegistrationAccountConfigurationDTO userRegistrationAccountConfigurationDTO = (UserRegistrationAccountConfigurationDTO)hashMap.get(string2);
            if (userRegistrationAccountConfigurationDTO == null) {
                userRegistrationAccountConfigurationDTO = new UserRegistrationAccountConfigurationDTO();
                hashMap.put(string2, userRegistrationAccountConfigurationDTO);
                try {
                    accountType = (AccountType)this.entityManagerHandler.find(AccountType.class, string2);
                    userRegistrationAccountConfigurationDTO.setAccountType((UserAccountTypeVO)this.conversionHandler.convert(UserAccountTypeVO.class, (Object)accountType));
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    accountType = null;
                }
                hashMap2.put(string2, accountType);
            }
            if ((accountType = (AccountType)hashMap2.get(string2)) == null) continue;
            String string4 = map.get(string);
            boolean bl = true;
            if (string3.equals(UserImportField.ACCOUNT_NUMBER.getName())) {
                userRegistrationAccountConfigurationDTO.setAccountNumber(string4);
            } else if (string3.equals(UserImportField.ACCOUNT_CREDIT_LIMIT.getName())) {
                if (string4 != null) {
                    userRegistrationAccountConfigurationDTO.setCreditLimit(this.parseAmount(string4, accountType.getCurrency()).getAmount());
                }
            } else if (string3.equals(UserImportField.ACCOUNT_UPPER_CREDIT_LIMIT.getName())) {
                if (UNLIMITED_UPPER_CREDIT_LIMIT.equalsIgnoreCase(string4)) {
                    userRegistrationAccountConfigurationDTO.setUpperCreditLimit(null);
                    bl = false;
                } else if (string4 != null) {
                    userRegistrationAccountConfigurationDTO.setUpperCreditLimit(this.parseAmount(string4, accountType.getCurrency()).getAmount());
                    bl = false;
                }
            }
            userRegistrationAccountConfigurationDTO.setUpperCreditLimitFromProduct(bl);
        }
        userRegistrationDTO.setAccountConfigurations(new ArrayList(hashMap.values()));
    }

    private void setAddressValues(ImportedLine importedLine, UserRegistrationDTO userRegistrationDTO) {
        UserAddressDataParams userAddressDataParams = new UserAddressDataParams();
        userAddressDataParams.setGroup(userRegistrationDTO.getGroup());
        List<String> list = ImportHelper.getFieldIdsForPrefix(importedLine, UserImportField.getAddressPrefix());
        int n = 0;
        ArrayList<UserAddressDTO> arrayList = new ArrayList<UserAddressDTO>();
        for (String string : list) {
            ++n;
            UserAddressData userAddressData = (UserAddressData)this.addressService.getDataForNew((Object)userAddressDataParams);
            UserAddressDTO userAddressDTO = (UserAddressDTO)userAddressData.getDto();
            boolean bl = ImportHelper.areAllEmptyValues(importedLine, string, new ImportField[]{UserImportField.ADDRESS_LINE1, UserImportField.ADDRESS_LINE2, UserImportField.ADDRESS_NAME, UserImportField.ADDRESS_NEIGHBORHOOD, UserImportField.ADDRESS_POBOX, UserImportField.ADDRESS_ZIP, UserImportField.ADDRESS_CITY, UserImportField.ADDRESS_COUNTRY, UserImportField.ADDRESS_REGION, UserImportField.ADDRESS_BUILDING_NUMBER, UserImportField.ADDRESS_COMPLEMENT, UserImportField.ADDRESS_STREET});
            if (bl) continue;
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_LINE1, userAddressDTO, UserAddressDTO.ADDRESS_LINE_1);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_LINE2, userAddressDTO, UserAddressDTO.ADDRESS_LINE_2);
            String string2 = this.translationHandler.message(UsersKeys.Addresses.DEFAULT_ADDRESS_NAME, new Object[]{n});
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_NAME, userAddressDTO, UserAddressDTO.NAME, string2);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_NEIGHBORHOOD, userAddressDTO, UserAddressDTO.NEIGHBORHOOD);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_POBOX, userAddressDTO, UserAddressDTO.PO_BOX);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_ZIP, userAddressDTO, UserAddressDTO.ZIP);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_CITY, userAddressDTO, UserAddressDTO.CITY);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_COUNTRY, userAddressDTO, UserAddressDTO.COUNTRY);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_REGION, userAddressDTO, UserAddressDTO.REGION);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_COMPLEMENT, userAddressDTO, UserAddressDTO.COMPLEMENT);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_STREET, userAddressDTO, UserAddressDTO.STREET);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.ADDRESS_BUILDING_NUMBER, userAddressDTO, UserAddressDTO.BUILDING_NUMBER);
            String string3 = importedLine.getValue((ImportField)UserImportField.ADDRESS_PRIVATE, string);
            if (string3 != null) {
                Boolean bl2 = this.parseBoolean(string3);
                userAddressDTO.setHidden(bl2.booleanValue());
            }
            arrayList.add(userAddressDTO);
        }
        userRegistrationDTO.setAddresses(arrayList);
    }

    private void setPasswords(ImportedLine importedLine, UserRegistrationDTO userRegistrationDTO, UserGroup userGroup) {
        Object object;
        Object object2;
        Map map = this.passwordHandler.getPasswordTypesAtRegistration((Group)userGroup, UserRegistration.IMPORT, PasswordMode.MANUAL);
        boolean bl = true;
        if (map.size() == 1) {
            object2 = importedLine.getValue((ImportField)UserImportField.PASSWORD_DEFAULT);
            object = this.parseBoolean(importedLine.getValue((ImportField)UserImportField.PASSWORD_FORCE_CHANGE));
            if (StringHelper.isBlank((Object)object2)) {
                object2 = importedLine.getValue((ImportField)UserImportField.PASSWORD_VALUE);
            }
            if (StringHelper.isNotBlank((Object)object2)) {
                PasswordType passwordType2 = (PasswordType)map.keySet().iterator().next();
                String string = this.createPasswordRegistrationDTO(new PasswordTypeVO(passwordType2.getId()), true);
                string.setConfirmationValue((String)object2);
                string.setValue((String)object2);
                string.setForceChange(Boolean.TRUE.equals(object));
                userRegistrationDTO.setPasswords((List)Lists.newArrayList((Object[])new PasswordRegistrationDTO[]{string}));
                bl = false;
            }
        }
        if (bl) {
            object2 = new HashMap();
            object = ImportHelper.getFieldValuesForPrefix(importedLine, UserImportField.getPasswordPrefix() + ".");
            for (String string : object.keySet()) {
                Boolean bl2;
                String[] stringArray = string.split("\\.");
                String string2 = stringArray[0];
                String string3 = UserImportField.getPasswordPrefix() + "." + stringArray[1];
                PasswordRegistrationDTO passwordRegistrationDTO = (PasswordRegistrationDTO)object2.get(string2);
                if (passwordRegistrationDTO == null) {
                    passwordRegistrationDTO = this.createPasswordRegistrationDTO(new PasswordTypeVO(PasswordTypeVO.INTERNAL_NAME, (Object)string2), true);
                    object2.put(string2, passwordRegistrationDTO);
                    map.keySet().removeIf(passwordType -> string2.equals(passwordType.getInternalName()));
                }
                String string4 = (String)object.get(string);
                if (string3.equals(UserImportField.PASSWORD_VALUE.getName())) {
                    passwordRegistrationDTO.setValue(string4);
                    passwordRegistrationDTO.setConfirmationValue(string4);
                    continue;
                }
                if (!string3.equals(UserImportField.PASSWORD_FORCE_CHANGE.getName()) || (bl2 = this.parseBoolean(string4)) == null) continue;
                passwordRegistrationDTO.setForceChange(bl2.booleanValue());
            }
            map.keySet().forEach(arg_0 -> this.lambda$setPasswords$15((Map)object2, arg_0));
            userRegistrationDTO.setPasswords((List)Lists.newArrayList(object2.values()));
        }
    }

    private void setPhoneValues(ImportedLine importedLine, UserRegistrationDTO userRegistrationDTO) {
        Object object;
        PhoneDataParams phoneDataParams = new PhoneDataParams();
        phoneDataParams.setNature(PhoneNature.LANDLINE);
        phoneDataParams.setGroup(userRegistrationDTO.getGroup());
        List<String> list = ImportHelper.getFieldIdsForPrefix(importedLine, UserImportField.getLandlinePrefix());
        int n = 0;
        ArrayList<LandLinePhoneDTO> arrayList = new ArrayList<LandLinePhoneDTO>();
        for (String object22 : list) {
            ++n;
            boolean arrayList2 = ImportHelper.areAllEmptyValues(importedLine, object22, new ImportField[]{UserImportField.LANDLINE_NAME, UserImportField.LANDLINE_NUMBER});
            if (arrayList2) continue;
            LandLinePhoneDTO landLinePhoneDTO = (LandLinePhoneDTO)((PhoneData)this.phoneService.getDataForNew((Object)phoneDataParams)).getDto();
            String string = this.translationHandler.message(UsersKeys.Phones.LANDLINE_DEFAULT_NAME, new Object[]{n});
            ImportHelper.setFieldValue(importedLine, object22, (ImportField)UserImportField.LANDLINE_NAME, landLinePhoneDTO, LandLinePhoneDTO.NAME, string);
            ImportHelper.setFieldValue(importedLine, object22, (ImportField)UserImportField.LANDLINE_NUMBER, landLinePhoneDTO, LandLinePhoneDTO.RAW_NUMBER);
            String bl = importedLine.getValue((ImportField)UserImportField.LANDLINE_PRIVATE, object22);
            if (bl != null) {
                object = this.parseBoolean(bl);
                landLinePhoneDTO.setHidden(((Boolean)object).booleanValue());
            }
            arrayList.add(landLinePhoneDTO);
        }
        userRegistrationDTO.setLandLinePhones(arrayList);
        PhoneDataParams phoneDataParams2 = new PhoneDataParams();
        phoneDataParams2.setNature(PhoneNature.MOBILE);
        phoneDataParams2.setGroup(userRegistrationDTO.getGroup());
        List<String> list2 = ImportHelper.getFieldIdsForPrefix(importedLine, UserImportField.getMobilePrefix());
        n = 0;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (String string : list2) {
            ++n;
            boolean bl = ImportHelper.areAllEmptyValues(importedLine, string, new ImportField[]{UserImportField.MOBILE_NAME, UserImportField.MOBILE_NUMBER});
            if (bl) continue;
            object = (MobilePhoneDTO)((PhoneData)this.phoneService.getDataForNew((Object)phoneDataParams2)).getDto();
            String string2 = this.translationHandler.message(UsersKeys.Phones.MOBILE_DEFAULT_NAME, new Object[]{n});
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.MOBILE_NAME, object, MobilePhoneDTO.NAME, string2);
            ImportHelper.setFieldValue(importedLine, string, (ImportField)UserImportField.MOBILE_NUMBER, object, MobilePhoneDTO.RAW_NUMBER);
            String string3 = importedLine.getValue((ImportField)UserImportField.MOBILE_PRIVATE, string);
            if (string3 != null) {
                Boolean bl2 = this.parseBoolean(string3);
                object.setHidden(bl2.booleanValue());
            }
            arrayList2.add(object);
        }
        userRegistrationDTO.setMobilePhones(arrayList2);
    }

    private /* synthetic */ void lambda$setPasswords$15(Map map, PasswordType passwordType) {
        map.put(passwordType.getInternalName(), this.createPasswordRegistrationDTO(new PasswordTypeVO(passwordType.getId()), false));
    }
}

