/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.ImportTransaction;
import org.cyclos.entities.banking.ImportTransfer;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QImportTransaction;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.TransferImportedFile;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.TransferStatusFlowServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.system.BankingImportHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ImportHelper;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactions.ImportTransferDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.imports.BankingImportedFileDTO;
import org.cyclos.model.system.imports.BankingImportedFileData;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.TransactionImportField;
import org.cyclos.model.system.imports.TransferImportedFileDTO;
import org.cyclos.model.system.imports.TransferImportedFileData;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransferImportHandlerImpl
extends BankingImportHandlerImpl<TransferImportedFile, ImportTransfer> {
    private static final String TRANSFER_STATUS_IMPORT_PREFIX = "status.";
    @Autowired
    protected TransferServiceLocal transferService;
    @Autowired
    protected TransferTypeServiceLocal transferTypeService;
    @Autowired
    protected AccountServiceLocal accountService;
    @Autowired
    protected CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    protected TransferStatusFlowServiceLocal transferStatusFlowService;
    @Autowired
    private ApplicationHandler applicationHandler;

    TransferImportHandlerImpl() {
        super(EnumSet.complementOf(EnumSet.of(TransactionImportField.FROM_NAME, TransactionImportField.TO_NAME)).toArray(new ImportField[0]));
    }

    @Override
    public Predicate<String> getAllowedImportFieldsPredicate(TransferImportedFile transferImportedFile) {
        Predicate<String> predicate = super.getAllowedImportFieldsPredicate(transferImportedFile);
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        List list = this.transferStatusFlowService.listAll();
        for (TransferStatusFlow transferStatusFlow : list) {
            String string2 = transferStatusFlow.getInternalName();
            arrayList.add((CallSite)((Object)(TRANSFER_STATUS_IMPORT_PREFIX + string2)));
        }
        return predicate.or(string -> arrayList.contains(string));
    }

    public BankingImportedFileData getData(TransferImportedFile transferImportedFile) {
        TransferImportedFileData transferImportedFileData = new TransferImportedFileData();
        transferImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(TransferImportedFileDTO.class, (Object)transferImportedFile)));
        return transferImportedFileData;
    }

    public Class<ImportTransfer> getEntityClass() {
        return ImportTransfer.class;
    }

    public Class<TransferImportedFile> getImportedFileClass() {
        return TransferImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.TRANSFERS_IMPORT;
    }

    public TransferImportedFile newImportedFile(BankingImportedFileDTO bankingImportedFileDTO) {
        return new TransferImportedFile();
    }

    public ImportTransfer processImportedLine(ImportedLine importedLine, Object object) {
        ImportTransaction importTransaction = this.convertToImportTransaction(importedLine, true);
        this.persist((IEntity)importTransaction);
        Set<TransferStatus> set = this.parseTransferStatuses(importedLine);
        ImportTransfer importTransfer = this.transferService.insertImportTransfer(importTransaction, set);
        this.fixAccountsCreationDate(importTransfer);
        return importTransfer;
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) throws ValidationException {
        ImportTransaction importTransaction = this.convertToImportTransaction(importedLine, false);
        this.validateImportTransaction(importTransaction);
        this.parseTransferStatuses(importedLine);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(TransferImportedFile transferImportedFile) {
        return Arrays.asList(TransactionImportField.DATE, TransactionImportField.FROM, TransactionImportField.TO, TransactionImportField.AMOUNT, TransactionImportField.TYPE);
    }

    protected void setAmount(String string, ImportTransaction importTransaction, TransferType transferType) {
        CurrencyAmountDTO currencyAmountDTO;
        if (transferType != null && (currencyAmountDTO = this.parseAmount(string, transferType.getCurrency())) != null) {
            importTransaction.setAmount(currencyAmountDTO.getAmount());
        }
    }

    private ImportTransaction convertToImportTransaction(ImportedLine importedLine, boolean bl) {
        Account account;
        Account account2;
        ImportTransaction importTransaction = new ImportTransaction();
        InternalAccountOwner internalAccountOwner = this.parseAccountOwner(importedLine.getValue((ImportField)TransactionImportField.FROM));
        InternalAccountOwner internalAccountOwner2 = this.parseAccountOwner(importedLine.getValue((ImportField)TransactionImportField.TO));
        TransferType transferType = this.parseTransferType(importedLine.getValue((ImportField)TransactionImportField.TYPE));
        if (internalAccountOwner == null) {
            String string = this.translationHandler.message(SystemKeys.Imports.TRANSFER_FROM_IS_REQUIRED, new Object[0]);
            throw new ValidationException(string);
        }
        if (internalAccountOwner2 == null) {
            String string = this.translationHandler.message(SystemKeys.Imports.TRANSFER_TO_IS_REQUIRED, new Object[0]);
            throw new ValidationException(string);
        }
        if (transferType == null) {
            String string = this.translationHandler.message(SystemKeys.Imports.TRANSFER_TYPE_IS_REQUIRED, new Object[0]);
            throw new ValidationException(string);
        }
        if (bl) {
            account2 = this.accountService.require(internalAccountOwner, transferType.getFrom());
            account = this.accountService.require(internalAccountOwner2, transferType.getTo());
        } else {
            account2 = this.accountService.load(internalAccountOwner, transferType.getFrom());
            account = this.accountService.load(internalAccountOwner2, transferType.getTo());
        }
        importTransaction.setType(transferType);
        importTransaction.setFrom(account2);
        importTransaction.setTo(account);
        importTransaction.setBy((BasicUser)importedLine.getImportedFile().getBy());
        importTransaction.setChannel(importedLine.getImportedFile().getChannel());
        String string = importedLine.getValue((ImportField)TransactionImportField.AMOUNT);
        this.setAmount(string, importTransaction, transferType);
        importTransaction.setDescription(importedLine.getValue((ImportField)TransactionImportField.DESCRIPTION));
        importTransaction.setDate(this.toDate(this.parseDateTime(importedLine.getValue((ImportField)TransactionImportField.DATE))));
        if (importTransaction.getDate() == null) {
            importTransaction.setDate(new Date());
        }
        this.setCustomFieldValues(importedLine, importTransaction);
        return importTransaction;
    }

    private void fixAccountsCreationDate(ImportTransfer importTransfer) {
        Account account = importTransfer.getFrom();
        Account account2 = importTransfer.getTo();
        Date date = importTransfer.getDate();
        if (date.before(account.getCreationDate())) {
            account.setCreationDate(date);
        }
        if (date.before(account2.getCreationDate())) {
            account2.setCreationDate(date);
        }
    }

    private TransferStatus parseTransferStatus(String string, String string2) {
        TransferStatusFlow transferStatusFlow = null;
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            transferStatusFlow = (TransferStatusFlow)this.entityManagerHandler.find(TransferStatusFlow.class, string2);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            String string3 = this.translationHandler.message(SystemKeys.Imports.TRANSFER_STATUS_FLOW_NOT_ALLOWED, new Object[]{string2});
            throw new ValidationException(string3);
        }
        try {
            return (TransferStatus)this.entityManagerHandler.find(TransferStatus.class, string, (SimpleEntity)transferStatusFlow);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            String string4 = this.translationHandler.message(SystemKeys.Imports.TRANSFER_STATUS_INVALID, new Object[]{string});
            throw new ValidationException(string4);
        }
    }

    private Set<TransferStatus> parseTransferStatuses(ImportedLine importedLine) {
        HashSet<TransferStatus> hashSet = new HashSet<TransferStatus>();
        Map<String, String> map = ImportHelper.getFieldValuesForPrefix(importedLine, TRANSFER_STATUS_IMPORT_PREFIX);
        for (String string : map.keySet()) {
            TransferStatus transferStatus = this.parseTransferStatus(map.get(string), string);
            if (transferStatus == null) continue;
            hashSet.add(transferStatus);
        }
        return hashSet;
    }

    private void setCustomFieldValues(ImportedLine importedLine, ImportTransaction importTransaction) {
        ImportTransferDTO importTransferDTO = new ImportTransferDTO();
        this.setCustomFieldValues(importedLine, importTransferDTO);
        List list = importTransferDTO.getCustomValues();
        Set set = list.stream().map(customFieldValueDTO -> customFieldValueDTO.getField().getInternalName()).map(string -> (TransactionCustomField)this.entityManagerHandler.find(TransactionCustomField.class, string)).collect(Collectors.toSet());
        this.customFieldValueHandler.setCustomValues((SimpleEntity)importTransaction, set, set, (Collection)importTransferDTO.getCustomValues());
    }

    private void validateImportTransaction(ImportTransaction importTransaction) {
        ZoneId zoneId;
        SessionData sessionData = this.getSessionData();
        Validator validator = new Validator();
        QImportTransaction qImportTransaction = QImportTransaction.importTransaction;
        validator.property((Path)qImportTransaction.description, GeneralKeys.Ui.DESCRIPTION).maxLength(4000);
        validator.property((Path)qImportTransaction.amount, BankingKeys.Transactions.AMOUNT).required().positiveNonZero((HasCurrency)importTransaction.getType()).lessEquals((Comparable)new CurrencyAmount(importTransaction.getCurrency(), TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE));
        Date date = this.applicationHandler.getApplication().getArchivingDate();
        if (date == null) {
            zoneId = ZoneId.of(sessionData.getConfiguration().getTimeZoneId());
            date = Date.from(ZonedDateTime.of(LocalDate.of(2000, 1, 1), LocalTime.MIDNIGHT, zoneId).toInstant());
        }
        validator.property((Path)qImportTransaction.date, BankingKeys.Transactions.DATE).greaterThan((Comparable)date);
        zoneId = importTransaction.getType();
        InternalAccountOwner internalAccountOwner = importTransaction.getFromOwner();
        InternalAccountOwner internalAccountOwner2 = importTransaction.getToOwner();
        Property property = validator.property((Path)qImportTransaction.type(), BankingKeys.Transactions.TYPE);
        if (zoneId != null) {
            TransferTypeDirection transferTypeDirection = this.transferTypeService.resolveDirection(internalAccountOwner, (AccountOwner)internalAccountOwner2);
            if (zoneId.getDirection() != transferTypeDirection) {
                property.invalid();
            }
            if (internalAccountOwner != null && internalAccountOwner2 != null && (zoneId.isFromUser() && internalAccountOwner instanceof SystemAccountOwner || zoneId.isFromSystem() && internalAccountOwner instanceof User || zoneId.isToSystem() && internalAccountOwner2 instanceof User || zoneId.isToUser() && internalAccountOwner2 instanceof SystemAccountOwner)) {
                property.invalid();
            }
            Set set = Collections.emptySet();
            if (zoneId instanceof PaymentTransferType) {
                set = ((PaymentTransferType)zoneId).getCustomFields();
            }
            Set set2 = importTransaction.getCustomValues();
            for (Object object : set2) {
                if (set.contains(object.getField())) continue;
                String string = this.translationHandler.message(SystemKeys.Imports.INVALID_CUSTOM_FIELD, new Object[]{object.getField().getInternalName()});
                throw new ValidationException(string);
            }
            HashMap hashMap = new HashMap();
            hashMap.put("paymentType", zoneId);
            hashMap.put("fromOwner", internalAccountOwner);
            hashMap.put("fromOwnerResult", this.accountHandler.locate((AccountOwner)internalAccountOwner));
            hashMap.put("toOwner", internalAccountOwner2);
            hashMap.put("toOwnerResult", this.accountHandler.locate((AccountOwner)internalAccountOwner2));
            for (TransactionCustomField transactionCustomField : set) {
                this.customFieldValueHandler.addValueValidation(validator, (CustomField)transactionCustomField, (EntityPathBase)QTransactionCustomFieldValue.transactionCustomFieldValue, (Map)hashMap);
            }
        }
        this.validate(validator, importTransaction, "validateImportTransaction");
    }
}

