/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.utils.ObjectHelper;

public class TransactionReportEntry {
    private final boolean authorized;
    private final Transaction transaction;
    private final Object related;
    private final BigDecimal amount;
    private final boolean from;

    public TransactionReportEntry(boolean bl, AccountOwner accountOwner, Transaction transaction) {
        this.authorized = bl;
        this.transaction = transaction;
        if (transaction instanceof ExternalPayment) {
            ExternalPayment externalPayment = (ExternalPayment)transaction;
            this.related = externalPayment.getToPrincipalValue();
            this.from = true;
        } else {
            InternalTransaction internalTransaction = (InternalTransaction)transaction;
            InternalAccountOwner internalAccountOwner = internalTransaction.getFromOwner();
            InternalAccountOwner internalAccountOwner2 = internalTransaction.getToOwner();
            this.from = accountOwner.equals((Object)internalAccountOwner) && !accountOwner.equals((Object)internalAccountOwner2);
            this.related = this.from ? internalAccountOwner2 : internalAccountOwner;
        }
        this.amount = this.from ? transaction.getAmount().negate() : transaction.getAmount();
    }

    public CurrencyAmount getAmount() {
        return new CurrencyAmount(this.transaction.getCurrency(), this.amount);
    }

    public Set<TransactionCustomFieldValue> getCustomValues() {
        return this.transaction.getCustomValues();
    }

    public Date getDate() {
        return this.transaction.getDate();
    }

    public Object getRelatedOwner() {
        return this.related;
    }

    public String getScheduling() {
        String string = "";
        if (this.transaction instanceof TransactionWithInstallments) {
            TransactionWithInstallments transactionWithInstallments = (TransactionWithInstallments)this.transaction;
            Installment installment = transactionWithInstallments.getLastProcessedInstallment();
            Integer n = installment == null ? null : Integer.valueOf(installment.getNumber());
            int n2 = (Integer)ObjectHelper.defaultValue((Object)n, (Object)0);
            Integer n3 = transactionWithInstallments.getInstallmentsCount();
            if (n3 == null) {
                return String.valueOf(n2);
            }
            return n2 + " / " + n3;
        }
        return string;
    }

    public Object getStatus() {
        TransactionAuthorizationStatus transactionAuthorizationStatus = null;
        if (this.authorized) {
            if (this.transaction instanceof BasePayment) {
                transactionAuthorizationStatus = ((BasePayment)this.transaction).getAuthorizationStatus();
            }
        } else if (this.transaction instanceof HasTransactionStatus) {
            transactionAuthorizationStatus = ((HasTransactionStatus)this.transaction).getStatus();
        }
        return transactionAuthorizationStatus;
    }

    public boolean isFrom() {
        return this.from;
    }
}

