/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.AcceptPaymentRequestSmsOperationConfiguration;
import org.cyclos.entities.system.AccountInformationSmsOperationConfiguration;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.CustomSmsOperationConfiguration;
import org.cyclos.entities.system.DenyPaymentRequestSmsOperationConfiguration;
import org.cyclos.entities.system.HelpSmsOperationConfiguration;
import org.cyclos.entities.system.PaymentSmsOperationConfiguration;
import org.cyclos.entities.system.PerformExternalPaymentSmsOperationConfiguration;
import org.cyclos.entities.system.QSmsOperationConfiguration;
import org.cyclos.entities.system.QTextSmsOperationConfiguration;
import org.cyclos.entities.system.RedeemVoucherSmsOperationConfiguration;
import org.cyclos.entities.system.RegisterSmsOperationConfiguration;
import org.cyclos.entities.system.SendPaymentRequestSmsOperationConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.system.TextSmsOperationConfiguration;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.SmsOperationConfigurationServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeQuery;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.smsoperationconfigurations.AcceptPaymentRequestSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.AccountInformationSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.AccountInformationSmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.CustomSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.CustomSmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.CustomizableSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.DenyPaymentRequestSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.HelpSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.PaymentSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.PaymentSmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.PerformExternalPaymentSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.PerformExternalPaymentSmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.RedeemVoucherSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.RegisterSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.RegisterSmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.SendPaymentRequestSmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.SendPaymentRequestSmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationDataParams;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationNature;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationVO;
import org.cyclos.model.system.smsoperationconfigurations.SmsTextsListData;
import org.cyclos.model.system.smsoperationconfigurations.TextSmsOperationConfigurationDTO;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupQuery;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsOperationConfigurationServiceImpl
extends CRUDServiceImpl<SmsOperationConfiguration, QSmsOperationConfiguration, SmsOperationConfigurationDTO, SmsOperationConfigurationData, SmsOperationConfigurationDataParams>
implements SmsOperationConfigurationServiceLocal {
    private static final int MAX_HELP_LENGTH = 140;
    private static final int MAX_ALIAS_WORDS_COUNT = 3;
    private static final BidiMap<Class<? extends SmsOperationConfiguration>, Class<? extends SmsOperationConfigurationDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Map<SmsOperationConfigurationNature, Class<? extends SmsOperationConfiguration>> NATURE_MAPPINGS;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private LockHandler lockHandler;

    public SmsOperationConfigurationServiceImpl() {
        super(SmsOperationConfiguration.class, QSmsOperationConfiguration.smsOperationConfiguration, SmsOperationConfigurationDTO.class);
    }

    public SmsTextsListData getSmsTextsListData(Long l) throws FrameworkException {
        SmsTextsListData smsTextsListData = new SmsTextsListData();
        SmsChannelConfiguration smsChannelConfiguration = this.find(SmsChannelConfiguration.class, l);
        smsTextsListData.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)smsChannelConfiguration.getConfiguration()));
        smsTextsListData.setSmsTexts(this.listSmsTexts(l));
        return smsTextsListData;
    }

    public List<SmsOperationConfigurationVO> listSmsTexts(Long l) throws FrameworkException {
        SmsChannelConfiguration smsChannelConfiguration = this.find(SmsChannelConfiguration.class, l);
        List<TextSmsOperationConfiguration> list = this.listSmsTexts(smsChannelConfiguration);
        return this.conversionHandler.convertList(SmsOperationConfigurationVO.class, list);
    }

    public List<TextSmsOperationConfiguration> listSmsTexts(SmsChannelConfiguration smsChannelConfiguration) {
        QTextSmsOperationConfiguration qTextSmsOperationConfiguration = QTextSmsOperationConfiguration.textSmsOperationConfiguration;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qTextSmsOperationConfiguration}).where((Predicate)qTextSmsOperationConfiguration.channelConfiguration().eq((Object)smsChannelConfiguration))).orderBy(qTextSmsOperationConfiguration.name.asc())).list((Expression)qTextSmsOperationConfiguration);
    }

    @Override
    public SmsOperationConfiguration newEntity(SmsOperationConfigurationDataParams smsOperationConfigurationDataParams) {
        SmsChannelConfiguration smsChannelConfiguration = this.find(SmsChannelConfiguration.class, smsOperationConfigurationDataParams.getChannelConfigurationId());
        SmsOperationConfigurationNature smsOperationConfigurationNature = (SmsOperationConfigurationNature)ObjectHelper.defaultValue((Object)smsOperationConfigurationDataParams.getNature(), (Object)SmsOperationConfigurationNature.CUSTOM);
        Class<? extends SmsOperationConfiguration> clazz = NATURE_MAPPINGS.get(smsOperationConfigurationNature);
        if (clazz == null) {
            throw new IllegalStateException("Unhandled sms operation nature: " + String.valueOf(smsOperationConfigurationNature));
        }
        SmsOperationConfiguration smsOperationConfiguration = (SmsOperationConfiguration)this.beanHandler.instantiate(clazz);
        smsOperationConfiguration.setEnabled(true);
        smsOperationConfiguration.setChannelConfiguration(smsChannelConfiguration);
        if (SmsOperationConfigurationNature.CUSTOM == smsOperationConfigurationNature) {
            ((CustomSmsOperationConfiguration)smsOperationConfiguration).setLogPlainSms(true);
        }
        return smsOperationConfiguration;
    }

    @Override
    protected SmsOperationConfigurationData getData(SmsOperationConfiguration smsOperationConfiguration) {
        SmsOperationConfigurationData smsOperationConfigurationData;
        if (smsOperationConfiguration instanceof AccountInformationSmsOperationConfiguration) {
            AccountInformationSmsOperationConfigurationData accountInformationSmsOperationConfigurationData = new AccountInformationSmsOperationConfigurationData();
            AccountTypeQuery accountTypeQuery = new AccountTypeQuery();
            accountTypeQuery.setUnlimited();
            accountTypeQuery.setNature(AccountTypeNature.USER);
            accountInformationSmsOperationConfigurationData.setAccountTypes(this.accountTypeService.search(AccountTypeVO.class, accountTypeQuery).getPageItems());
            smsOperationConfigurationData = accountInformationSmsOperationConfigurationData;
        } else if (smsOperationConfiguration instanceof PaymentSmsOperationConfiguration) {
            SendPaymentRequestSmsOperationConfigurationData sendPaymentRequestSmsOperationConfigurationData;
            if (smsOperationConfiguration instanceof SendPaymentRequestSmsOperationConfiguration) {
                sendPaymentRequestSmsOperationConfigurationData = new SendPaymentRequestSmsOperationConfigurationData();
            } else if (smsOperationConfiguration instanceof PerformExternalPaymentSmsOperationConfiguration) {
                sendPaymentRequestSmsOperationConfigurationData = new PerformExternalPaymentSmsOperationConfigurationData();
            } else if (smsOperationConfiguration instanceof PaymentSmsOperationConfiguration) {
                sendPaymentRequestSmsOperationConfigurationData = new PaymentSmsOperationConfigurationData();
            } else {
                throw new IllegalArgumentException();
            }
            TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setUnlimited();
            transferTypeQuery.setNatures(EnumSet.of(TransferTypeNature.PAYMENT));
            transferTypeQuery.setFromNature(AccountTypeNature.USER);
            transferTypeQuery.setChannel(new ChannelVO(this.channelService.getSms().getId()));
            sendPaymentRequestSmsOperationConfigurationData.setPaymentTypes(this.transferTypeService.search(transferTypeQuery).getPageItems());
            smsOperationConfigurationData = sendPaymentRequestSmsOperationConfigurationData;
        } else if (smsOperationConfiguration instanceof RegisterSmsOperationConfiguration) {
            RegisterSmsOperationConfigurationData registerSmsOperationConfigurationData = new RegisterSmsOperationConfigurationData();
            BasicGroupQuery basicGroupQuery = new BasicGroupQuery();
            basicGroupQuery.setUnlimited();
            basicGroupQuery.setNatures(EnumSet.of(BasicGroupNature.MEMBER_GROUP, BasicGroupNature.BROKER_GROUP));
            registerSmsOperationConfigurationData.setGroups(this.groupService.search(basicGroupQuery).getPageItems());
            smsOperationConfigurationData = registerSmsOperationConfigurationData;
        } else if (smsOperationConfiguration instanceof CustomSmsOperationConfiguration) {
            CustomSmsOperationConfigurationData customSmsOperationConfigurationData = new CustomSmsOperationConfigurationData();
            customSmsOperationConfigurationData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.SMS_OPERATION)));
            smsOperationConfigurationData = customSmsOperationConfigurationData;
        } else {
            smsOperationConfigurationData = new SmsOperationConfigurationData();
        }
        smsOperationConfigurationData.setDto((EntityDTO)((SmsOperationConfigurationDTO)this.toDTO(smsOperationConfiguration)));
        smsOperationConfigurationData.setConfigurationVO((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)smsOperationConfiguration.getChannelConfiguration().getConfiguration()));
        return smsOperationConfigurationData;
    }

    @Override
    protected Object onBeforeSave(SmsOperationConfiguration smsOperationConfiguration, SmsOperationConfiguration smsOperationConfiguration2) {
        List list = smsOperationConfiguration.getAliases();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : list) {
            if ((string = StringHelper.trimToNull((Object)string)) == null) continue;
            string = StringUtils.join((Object[])StringUtils.split((String)string), (String)" ");
            treeSet.add(string.toLowerCase());
        }
        list.clear();
        list.addAll(treeSet);
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QSmsOperationConfiguration)this.$).channelConfiguration().configuration().network());
    }

    @Override
    protected Validator resolveValidator(SmsOperationConfigurationDTO smsOperationConfigurationDTO) {
        CollectionHelper.removeNulls((Collection)smsOperationConfigurationDTO.getAliases());
        Validator validator = new Validator();
        validator.property((Property)SmsOperationConfigurationDTO.HELP_MESSAGE, SystemKeys.SmsOperationConfigurations.HELP_MESSAGE).maxLength(140);
        validator.property((Property)SmsOperationConfigurationDTO.CHANNEL_CONFIGURATION, SystemKeys.SmsOperationConfigurations.CHANNEL_CONFIGURATION).required();
        SmsChannelConfiguration smsChannelConfiguration = (SmsChannelConfiguration)this.conversionHandler.convert(SmsChannelConfiguration.class, (Object)smsOperationConfigurationDTO.getChannelConfiguration());
        DBQuery dBQuery = null;
        if (smsChannelConfiguration != null && CollectionHelper.isNotEmpty((Iterable)smsOperationConfigurationDTO.getAliases())) {
            dBQuery = (DBQuery)this.from().where(new Predicate[]{((QSmsOperationConfiguration)this.$).channelConfiguration().eq((Object)smsChannelConfiguration), smsOperationConfigurationDTO.isPersistent() ? ((QSmsOperationConfiguration)this.$).id.ne((Object)smsOperationConfigurationDTO.getId()) : ((QSmsOperationConfiguration)this.$).id.isNotNull(), ((StringPath)((QSmsOperationConfiguration)this.$).aliases.any()).in((Collection)smsOperationConfigurationDTO.getAliases())});
            Long l = SimpleEntity.id((SimpleEntity)smsChannelConfiguration);
            smsOperationConfigurationDTO.getAliases().forEach(string -> this.lockHandler.lock(LockType.UNIQUE_VALIDATION.key("smsAlias_" + l + "_" + string)));
        }
        validator.property((Property)SmsOperationConfigurationDTO.ALIASES, SystemKeys.SmsOperationConfigurations.ALIASES).required().unique(null, dBQuery).add((PropertyValidation)new AliasValidation());
        if (smsOperationConfigurationDTO instanceof AccountInformationSmsOperationConfigurationDTO) {
            validator.property((Property)AccountInformationSmsOperationConfigurationDTO.ACCOUNT_TYPE, SystemKeys.SmsOperationConfigurations.ACCOUNT_TYPE).required();
        } else if (smsOperationConfigurationDTO instanceof PaymentSmsOperationConfigurationDTO) {
            validator.property((Property)PaymentSmsOperationConfigurationDTO.PAYMENT_TYPE, SystemKeys.SmsOperationConfigurations.PAYMENT_TYPE).required();
            if (smsOperationConfigurationDTO instanceof SendPaymentRequestSmsOperationConfigurationDTO) {
                validator.property((Property)SendPaymentRequestSmsOperationConfigurationDTO.EXPIRATION_INTERVAL, SystemKeys.SmsOperationConfigurations.SEND_PAYMENT_REQUEST_EXPIRATION).required().timeInterval();
            }
        } else if (smsOperationConfigurationDTO instanceof RegisterSmsOperationConfigurationDTO) {
            validator.property((Property)RegisterSmsOperationConfigurationDTO.GROUP, SystemKeys.SmsOperationConfigurations.GROUP).required();
        } else if (smsOperationConfigurationDTO instanceof CustomizableSmsOperationConfigurationDTO) {
            if (smsOperationConfigurationDTO instanceof TextSmsOperationConfigurationDTO) {
                validator.property((Property)TextSmsOperationConfigurationDTO.TEXT, SystemKeys.SmsOperationConfigurations.TEXT).required().maxLength(160);
            } else if (smsOperationConfigurationDTO instanceof CustomSmsOperationConfigurationDTO) {
                validator.property((Property)CustomSmsOperationConfigurationDTO.SCRIPT, SystemKeys.SmsOperationConfigurations.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                    protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                        return customScript.getType() == ScriptType.SMS_OPERATION;
                    }
                });
            }
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends SmsOperationConfiguration>, Class<? extends SmsOperationConfigurationDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    static {
        SUBCLASS_MAPPINGS.put(AccountInformationSmsOperationConfiguration.class, AccountInformationSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(PaymentSmsOperationConfiguration.class, PaymentSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(PerformExternalPaymentSmsOperationConfiguration.class, PerformExternalPaymentSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(RegisterSmsOperationConfiguration.class, RegisterSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(CustomSmsOperationConfiguration.class, CustomSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(TextSmsOperationConfiguration.class, TextSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(HelpSmsOperationConfiguration.class, HelpSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(DenyPaymentRequestSmsOperationConfiguration.class, DenyPaymentRequestSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(AcceptPaymentRequestSmsOperationConfiguration.class, AcceptPaymentRequestSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(SendPaymentRequestSmsOperationConfiguration.class, SendPaymentRequestSmsOperationConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(RedeemVoucherSmsOperationConfiguration.class, RedeemVoucherSmsOperationConfigurationDTO.class);
        NATURE_MAPPINGS = new HashMap<SmsOperationConfigurationNature, Class<? extends SmsOperationConfiguration>>();
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.ACCOUNT_INFORMATION, AccountInformationSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.PAYMENT, PaymentSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.PERFORM_EXTERNAL_PAYMENT, PerformExternalPaymentSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.REGISTER, RegisterSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.TEXT, TextSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.CUSTOM, CustomSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.HELP, HelpSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.DENY_PAYMENT_REQUEST, DenyPaymentRequestSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.ACCEPT_PAYMENT_REQUEST, AcceptPaymentRequestSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.SEND_PAYMENT_REQUEST, SendPaymentRequestSmsOperationConfiguration.class);
        NATURE_MAPPINGS.put(SmsOperationConfigurationNature.REDEEM_VOUCHER, RedeemVoucherSmsOperationConfiguration.class);
    }

    private class AliasValidation
    extends BasePropertyValidation {
        public AliasValidation() {
            super(new ValidationError(SystemKeys.SmsOperationConfigurations.ERROR_INVALID_ALIAS_WORDS_COUNT));
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            SmsOperationConfigurationDTO smsOperationConfigurationDTO = (SmsOperationConfigurationDTO)object;
            Set set = smsOperationConfigurationDTO.getAliases();
            if (CollectionHelper.isEmpty((Iterable)set)) {
                return true;
            }
            for (String string : set) {
                if (!StringUtils.isNotEmpty((CharSequence)string) || StringUtils.split((String)string).length <= 3) continue;
                return false;
            }
            return true;
        }
    }
}

