/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.cyclos.entities.system.QScriptStorage;
import org.cyclos.entities.system.ScriptStorage;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.ScriptObjectStorage;
import org.cyclos.impl.system.ScriptStorageHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.JacksonParameterStorage;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScriptStorageHandlerImpl
extends BaseNetworkedHandlerImpl
implements ScriptStorageHandler {
    private static final QScriptStorage $ = QScriptStorage.scriptStorage;
    @Autowired
    private NetworkPathRegistry networkPathRegistry;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private LockHandler lockHandler;

    public void detach(String string) {
        String string2;
        InvocationContext invocationContext = InvocationContext.ensure();
        ScriptStorage scriptStorage = (ScriptStorage)invocationContext.getAttribute((Object)(string2 = this.invocationContextKey(string)));
        if (scriptStorage != null) {
            this.detach((IEntity)scriptStorage);
            invocationContext.setAttribute((Object)string2, null);
        }
    }

    public boolean exists(String string) {
        return this.doGetIfValid(InvocationContext.ensure(), string) != null;
    }

    public ScriptObjectStorage get(String string) {
        return this.get(string, null);
    }

    public ScriptObjectStorage get(String string, Integer n) {
        InvocationContext invocationContext = InvocationContext.ensure();
        ScriptStorage scriptStorage = (ScriptStorage)invocationContext.getAttribute((Object)this.invocationContextKey(string), () -> this.doGetStorage(string, n, invocationContext));
        return this.prepareStorage(scriptStorage);
    }

    public ScriptObjectStorage getIfValid(String string) {
        InvocationContext invocationContext = InvocationContext.ensure();
        ScriptStorage scriptStorage = this.doGetIfValid(invocationContext, string);
        if (scriptStorage == null) {
            return null;
        }
        return this.prepareStorage(scriptStorage);
    }

    @PostConstruct
    public void initialize() {
        this.networkPathRegistry.register($.network(), true);
    }

    public boolean remove(String string) {
        InvocationContext invocationContext = InvocationContext.ensure();
        invocationContext.setAttribute((Object)this.invocationContextKey(string), null);
        return this.delete((EntityPath<?>)$).where(new Predicate[]{ScriptStorageHandlerImpl.$.key.eq((Object)string)}).execute() > 0L;
    }

    private ScriptStorage doGetIfValid(InvocationContext invocationContext, String string) {
        ScriptStorage scriptStorage = (ScriptStorage)invocationContext.getAttribute((Object)this.invocationContextKey(string));
        if (scriptStorage == null) {
            scriptStorage = (ScriptStorage)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)ScriptStorageHandlerImpl.$.key.eq((Object)string))).singleResult((Expression)$);
        }
        if (scriptStorage != null && (scriptStorage.getExpirationDate() == null || scriptStorage.getExpirationDate().after(new Date()))) {
            return scriptStorage;
        }
        return null;
    }

    private ScriptStorage doGetStorage(String string, Integer n, InvocationContext invocationContext) {
        boolean bl2;
        Supplier<ScriptStorage> supplier = () -> (ScriptStorage)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)ScriptStorageHandlerImpl.$.key.eq((Object)string))).singleResult((Expression)$);
        ScriptStorage scriptStorage = supplier.get();
        boolean bl3 = this.isWrite();
        if (scriptStorage == null || scriptStorage.isExpired()) {
            if (bl3) {
                this.lockHandler.lock(LockType.STORAGE.key(string));
                scriptStorage = supplier.get();
            }
            if (scriptStorage == null) {
                scriptStorage = new ScriptStorage();
                scriptStorage.setCreationDate(new Date());
                scriptStorage.setKey(string);
                if (bl3) {
                    this.entityManagerHandler.persist((IEntity)scriptStorage);
                }
            } else if (scriptStorage.isExpired()) {
                scriptStorage.setCreationDate(new Date());
                scriptStorage.setContent(null);
            }
        }
        boolean bl4 = bl2 = scriptStorage.getExpirationDate() != null || n != null;
        if (bl2) {
            Long l = scriptStorage.getId();
            InvocationContext.ensure().addTransactionEndListener(true, bl -> {
                if ((bl == null || bl.booleanValue()) && this.lockHandler.tryLock(LockType.STORAGE.key(string))) {
                    ScriptStorage scriptStorage = (ScriptStorage)this.entityManagerHandler.find(ScriptStorage.class, l);
                    Date date = n == null ? null : DateHelper.add((Date)new Date(), (TimeField)TimeField.SECONDS, (int)n);
                    scriptStorage.setExpirationDate(date);
                }
            });
        }
        return scriptStorage;
    }

    private String invocationContextKey(String string) {
        return "scriptStorage:" + string;
    }

    private boolean isWrite() {
        return InvocationContext.ensure().getTransactionLevel() == TransactionLevel.READ_WRITE || this.cyclosProperties.isTestingEnv();
    }

    private ScriptParameterStorage prepareStorage(ScriptStorage scriptStorage) {
        return new ScriptParameterStorage(scriptStorage, this.isWrite());
    }

    private class ScriptParameterStorage
    extends JacksonParameterStorage
    implements ScriptObjectStorage {
        private ScriptStorage storage;
        private final boolean isWrite;

        public ScriptParameterStorage(ScriptStorage scriptStorage, boolean bl) {
            super(ScriptStorageHandlerImpl.this.jacksonConfiguration.getObjectMapper(), (Object)scriptStorage.getContent());
            this.storage = scriptStorage;
            this.isWrite = bl;
        }

        public Date getCreationDate() {
            return this.storage.getCreationDate();
        }

        public Date getExpirationDate() {
            return this.storage.getExpirationDate();
        }

        public String getKey() {
            return this.storage.getKey();
        }

        public void lock() {
            LockKey lockKey;
            if (!this.isWrite) {
                throw new IllegalActionException("Cannot lock the storage " + this.storage.getKey() + " in a read-only transaction");
            }
            InvocationContext invocationContext = InvocationContext.ensure();
            if (invocationContext.hasLock(lockKey = LockType.STORAGE.key(this.storage.getKey()))) {
                return;
            }
            ScriptStorageHandlerImpl.this.lockHandler.lock(lockKey);
            this.storage = (ScriptStorage)ScriptStorageHandlerImpl.this.refresh((IEntity)this.storage);
            this.setInput(this.storage.getContent());
            invocationContext.setAttribute((Object)ScriptStorageHandlerImpl.this.invocationContextKey(this.storage.getKey()), (Object)this.storage);
        }

        protected void onChange() {
            if (!this.isWrite) {
                throw new IllegalActionException("Cannot modify the storage " + this.storage.getKey() + " in a read-only transaction");
            }
            this.storage.setContent(this.toString());
        }
    }
}

