/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.system.CustomRecurringTask;
import org.cyclos.impl.system.CustomRecurringTaskServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RunScheduledBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private CustomRecurringTaskServiceLocal customRecurringTaskService;

    public static BackgroundTaskScheduling scheduling(CustomRecurringTask customRecurringTask) {
        return new BackgroundTaskScheduling(RunScheduledBackgroundTask.class, (Object)customRecurringTask.getId(), "Execution of custom recurring task " + customRecurringTask.getName());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.RUN_CUSTOM_RECURRING_TASK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        try {
            this.getLogger().debug("Running custom recurring task with ctx: " + string);
            Long l = Long.parseLong(string);
            boolean bl = this.customRecurringTaskService.run(l, profilingEntry);
            long l2 = bl ? 1L : 0L;
            return l2;
        }
        finally {
            this.getLogger().debug("Finished custom recurring task with ctx: " + string);
        }
    }
}

