/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.entities.system.RecordImportedFile;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.system.BaseWithFieldsImportHandlerImpl;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.RecordImportField;
import org.cyclos.model.system.imports.RecordImportedFileDTO;
import org.cyclos.model.system.imports.RecordImportedFileData;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.RecordData;
import org.cyclos.model.users.records.RecordDataParams;
import org.cyclos.model.users.records.UserRecordDTO;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordImportHandlerImpl
extends BaseWithFieldsImportHandlerImpl<RecordCustomField, CustomFieldValueDTO, RecordImportedFileDTO, RecordImportedFileData, RecordImportedFile, Record> {
    protected static final Set<String> USER_REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{RecordImportField.USER.getName()}));
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RecordFieldHandler recordFieldHandler;

    RecordImportHandlerImpl() {
        super(RecordCustomField.class, CustomFieldValueDTO.class, (ImportField[])RecordImportField.values());
    }

    public Predicate<String> getAllowedImportFieldsPredicate(RecordImportedFile recordImportedFile) {
        List<String> list = this.getImportFieldNames(this.recordFieldHandler.getAllFields(recordImportedFile.getType()));
        for (RecordImportField recordImportField : RecordImportField.values()) {
            list.add(recordImportField.getName());
        }
        return string -> list.contains(string);
    }

    public RecordImportedFileData getData(RecordImportedFile recordImportedFile) {
        RecordImportedFileData recordImportedFileData = new RecordImportedFileData();
        recordImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(RecordImportedFileDTO.class, (Object)recordImportedFile)));
        if (recordImportedFile.isTransient()) {
            List list = this.conversionHandler.convertList(RecordTypeVO.class, (Iterable)this.recordTypeService.listVisibleUserTypes());
            list.addAll(this.conversionHandler.convertList(RecordTypeVO.class, (Iterable)this.recordTypeService.listVisibleSystemTypes()));
            recordImportedFileData.setTypes(list);
        }
        return recordImportedFileData;
    }

    public Class<Record> getEntityClass() {
        return Record.class;
    }

    public Class<RecordImportedFile> getImportedFileClass() {
        return RecordImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.RECORDS_IMPORT;
    }

    public Set<String> getMissingRequiredFields(RecordImportedFile recordImportedFile, List<String> list) {
        return recordImportedFile.getType().getNature() == RecordTypeNature.SYSTEM ? Set.of() : Set.copyOf(CollectionUtils.subtract(USER_REQUIRED_HEADERS, list));
    }

    public Object instantiateContext() {
        return new HashMap();
    }

    public RecordImportedFile newImportedFile(RecordImportedFileDTO recordImportedFileDTO) {
        RecordImportedFile recordImportedFile = new RecordImportedFile();
        recordImportedFile.setType((RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordImportedFileDTO.getType()));
        return recordImportedFile;
    }

    public Record processImportedLine(ImportedLine importedLine, Object object) {
        RecordDTO recordDTO = this.convertToDTO(importedLine);
        Long l = this.recordService.save((EntityDTO)recordDTO);
        return (Record)this.find(l);
    }

    public Validator resolveValidator(RecordImportedFileDTO recordImportedFileDTO) {
        Validator validator = new Validator();
        if (recordImportedFileDTO.isTransient()) {
            validator.property((Property)RecordImportedFileDTO.TYPE, SystemKeys.Imports.RECORD_TYPE).required();
        }
        return validator;
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) {
        RecordDTO recordDTO = this.convertToDTO(importedLine);
        this.recordService.validate((EntityDTO)recordDTO);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(RecordImportedFile recordImportedFile) {
        ArrayList<ImportField> arrayList = new ArrayList<ImportField>();
        if (recordImportedFile.getType() != null && recordImportedFile.getType().getNature() == RecordTypeNature.USER) {
            arrayList.add((ImportField)RecordImportField.USER);
        }
        arrayList.add((ImportField)RecordImportField.CREATED_BY);
        arrayList.add((ImportField)RecordImportField.DATE);
        return arrayList;
    }

    @Override
    protected Collection<RecordCustomField> getCustomFields(ImportedLine importedLine, List<ImportedLineValue> list2) {
        List list3 = this.recordFieldHandler.getAllFields(((RecordImportedFile)importedLine.getImportedFile()).getType());
        BiFunction<String, List, RecordCustomField> biFunction = (string, list) -> list.stream().filter(recordCustomField -> recordCustomField.getInternalName().equals(string)).findFirst().orElseGet(null);
        return this.getCustomFieldValues(importedLine).keySet().stream().filter(string -> !string.endsWith(".private")).map(string -> (RecordCustomField)biFunction.apply((String)string, list3)).filter(recordCustomField -> recordCustomField != null).collect(Collectors.toSet());
    }

    private RecordDTO convertToDTO(ImportedLine importedLine) {
        String string;
        String string2;
        RecordType recordType;
        RecordImportedFile recordImportedFile = (RecordImportedFile)importedLine.getImportedFile();
        RecordType recordType2 = recordType = recordImportedFile.getType();
        RecordDataParams recordDataParams = new RecordDataParams();
        User user = null;
        if (recordType2 instanceof UserRecordType) {
            user = this.locateUser(importedLine.getValue((ImportField)RecordImportField.USER), true).getUser();
            recordDataParams.setUser(new UserLocatorVO(user.getId()));
        }
        recordDataParams.setRecordType(new RecordTypeVO(recordType2.getId()));
        RecordData recordData = (RecordData)this.recordService.getDataForNew((Object)recordDataParams);
        RecordDTO recordDTO = (RecordDTO)recordData.getDto();
        if (recordDTO instanceof UserRecordDTO) {
            ((UserRecordDTO)recordDTO).setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        }
        User user2 = StringHelper.isNotBlank((Object)(string2 = importedLine.getValue((ImportField)RecordImportField.CREATED_BY))) ? (User)this.locateUser(string2) : recordImportedFile.getBy();
        recordDTO.setCreatedBy((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user2));
        String string3 = importedLine.getValue((ImportField)RecordImportField.DATE);
        if (StringHelper.isNotBlank((Object)string3)) {
            recordDTO.setCreationDate(this.parseDateTime(string3));
        }
        if (StringHelper.isNotBlank((Object)(string = importedLine.getValue((ImportField)RecordImportField.LAST_MODIFICATION_DATE)))) {
            recordDTO.setLastModifiedDate(this.parseDateTime(string));
        }
        User user3 = (User)this.locateUser(importedLine.getValue((ImportField)RecordImportField.LAST_MODIFIED_BY));
        recordDTO.setModifiedBy((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user3));
        this.setCustomFieldValues(importedLine, recordDTO);
        return recordDTO;
    }
}

