/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.cyclos.entities.banking.QChargebackTransfer;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.QUserAccount;
import org.cyclos.entities.banking.TransferSummary;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.QAccessLog;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.entities.users.QUserStatusLog;
import org.cyclos.impl.system.LabeledData;
import org.cyclos.impl.system.PeriodSubReportsResultData;
import org.cyclos.impl.system.PeriodSubReportsTestableHandler;
import org.cyclos.impl.system.ReportSection;
import org.cyclos.impl.system.SubReportsHandler;
import org.cyclos.impl.system.SubReportsHandlerImpl;
import org.cyclos.impl.system.TradeType;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.stereotype.Component;

@Component
public class PeriodSubReportsHandlerImpl
extends SubReportsHandlerImpl
implements PeriodSubReportsTestableHandler {
    public List<ReportSection> data(SystemReportQuery systemReportQuery) {
        PeriodSubReportsResultData periodSubReportsResultData = this.getData(systemReportQuery);
        ArrayList<LabeledData> arrayList = new ArrayList<LabeledData>();
        if (systemReportQuery.isExpenditure()) {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_RESULTS_GROSS_EXPENDITURE, periodSubReportsResultData.getGrossExpenditure()));
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_RESULTS_NUMBER_OUTGOING, periodSubReportsResultData.getNumberOfOutgoingTransfers()));
        }
        if (systemReportQuery.isIncome()) {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_RESULTS_GROSS_INCOME, periodSubReportsResultData.getGrossIncome()));
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERIOD_RESULTS_NUMBER_INCOMING, periodSubReportsResultData.getNumberOfIncomingTransfers()));
        }
        if (systemReportQuery.isNumberLogins()) {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_NUMBER_LOGINS, periodSubReportsResultData.getNumberOfLogins()));
        }
        if (systemReportQuery.isPercentageNotTrading()) {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_PERCENTAGE_NO_TRADE, periodSubReportsResultData.getPercentageNotTrading()));
        }
        if (!arrayList.isEmpty()) {
            arrayList.add(new LabeledData(SystemKeys.Reports.SYSTEM_NUMBER_OF_USERS_OVER_PERIOD, periodSubReportsResultData.getNumberOfMembers()));
            ReportSection reportSection = new ReportSection((Object)SystemKeys.Reports.SYSTEM_RESULTS, false, arrayList);
            return Collections.singletonList(reportSection);
        }
        return null;
    }

    public BigDecimal getMembersOverPeriod(SystemReportQuery systemReportQuery) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        Date date = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Date date2 = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        long l = date.getTime();
        long l2 = date2.getTime();
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        QUserStatusLog qUserStatusLog = QUserStatusLog.userStatusLog;
        BigDecimal bigDecimal = new BigDecimal(l2 - l);
        Supplier<DBQuery> supplier = () -> (DBQuery)this.from(new EntityPath[]{qUserGroupLog}).where(new Predicate[]{qUserGroupLog.group().in((Collection)set), qUserGroupLog.startDate.before((Comparable)date2), qUserGroupLog.endDate.isNull().or((Predicate)qUserGroupLog.endDate.after((Comparable)date)), ((DBQuery)this.subQuery(new EntityPath[]{qUserStatusLog}).where(new Predicate[]{qUserStatusLog.user().eq((Expression)qUserGroupLog.user()._super), qUserStatusLog.startDate.after((Comparable)date), qUserStatusLog.status.in((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).notExists()});
        long l3 = (Long)((DBQuery)supplier.get().where((Predicate)qUserGroupLog.startDate.after((Comparable)date))).singleResult(Long.TYPE, (Expression)qUserGroupLog.startDate.unixTimestamp().sum());
        BigDecimal bigDecimal2 = new BigDecimal(l3).divide(bigDecimal, 4, RoundingMode.HALF_UP);
        int n = ((DBQuery)supplier.get().where((Predicate)qUserGroupLog.startDate.loe((Comparable)date))).count(qUserGroupLog.id);
        BigDecimal bigDecimal3 = new BigDecimal(n).multiply(new BigDecimal(l)).divide(bigDecimal, 4, RoundingMode.HALF_UP);
        long l4 = (Long)((DBQuery)supplier.get().where((Predicate)qUserGroupLog.endDate.before((Comparable)date2))).singleResult(Long.TYPE, (Expression)qUserGroupLog.endDate.unixTimestamp().sum());
        BigDecimal bigDecimal4 = new BigDecimal(l4).divide(bigDecimal, 4, RoundingMode.HALF_UP);
        int n2 = ((DBQuery)supplier.get().where((Predicate)qUserGroupLog.endDate.isNull().or((Predicate)qUserGroupLog.endDate.goe((Comparable)date2)))).count(qUserGroupLog.id);
        BigDecimal bigDecimal5 = new BigDecimal(n2).multiply(new BigDecimal(l2)).divide(bigDecimal, 4, RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = bigDecimal4.add(bigDecimal5).subtract(bigDecimal2.add(bigDecimal3));
        return bigDecimal6;
    }

    public int getNumberOfLogins(SystemReportQuery systemReportQuery) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        Date date = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Date date2 = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        QAccessLog qAccessLog = QAccessLog.accessLog;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qAccessLog}).where(new Predicate[]{qAccessLog.date.before((Comparable)date2), qAccessLog.date.after((Comparable)date)});
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
            DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qUserGroupLog}).where(new Predicate[]{qUserGroupLog.group().in((Collection)set), qUserGroupLog.startDate.loe((Expression)qAccessLog.date), qUserGroupLog.endDate.isNull().or((Predicate)qUserGroupLog.endDate.gt((Expression)qAccessLog.date)), qUserGroupLog.user().eq((Expression)qAccessLog.user())});
            dBQuery.where((Predicate)dBQuery2.exists());
        }
        return dBQuery.count(qAccessLog.id);
    }

    public BigDecimal getPercentageNoTrade(SystemReportQuery systemReportQuery) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        Date date = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Date date2 = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        QUserStatusLog qUserStatusLog = QUserStatusLog.userStatusLog;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qUserGroupLog}).where(new Predicate[]{qUserGroupLog.group().in((Collection)set), qUserGroupLog.startDate.before((Comparable)date2), qUserGroupLog.endDate.isNull().or((Predicate)qUserGroupLog.endDate.after((Comparable)date)), ((DBQuery)this.subQuery(new EntityPath[]{qUserStatusLog}).where(new Predicate[]{qUserStatusLog.user().eq((Expression)qUserGroupLog.user()._super), qUserStatusLog.status.in((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED}), qUserStatusLog.startDate.before((Comparable)date2), qUserStatusLog.endDate.isNull().or((Predicate)qUserStatusLog.endDate.after((Comparable)date))})).notExists()});
        QTransfer qTransfer = QTransfer.transfer;
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery<?> dBQuery2 = this.subQuery(new EntityPath[]{qTransfer, qUserAccount});
        QChargebackTransfer qChargebackTransfer = QChargebackTransfer.chargebackTransfer;
        DBQuery dBQuery3 = (DBQuery)this.subQuery(new EntityPath[]{qChargebackTransfer}).where((Predicate)qChargebackTransfer.id.eq((Expression)qTransfer.id));
        DBQuery dBQuery4 = (DBQuery)this.from(new EntityPath[]{qUserGroupLog}).where((Predicate)qUserGroupLog.group().in((Collection)set));
        dBQuery2.where(new Predicate[]{qUserAccount.eq((Expression)qTransfer.to()).and((Predicate)qUserAccount.user().eq((Expression)qUserGroupLog.user())).or((Predicate)qUserAccount.eq((Expression)qTransfer.from()).and((Predicate)qUserAccount.user().eq((Expression)qUserGroupLog.user()))), qTransfer.chargedBackBy().isNull(), dBQuery3.notExists(), qTransfer.date.isNotNull(), qTransfer.date.goe((Comparable)date), qTransfer.date.lt((Comparable)date2), qTransfer.date.goe((Expression)qUserGroupLog.startDate), qUserGroupLog.endDate.isNull().or((Predicate)qTransfer.date.lt((Expression)qUserGroupLog.endDate))});
        Set set2 = this.conversionHandler.convertSet(TransferType.class, (Iterable)systemReportQuery.getTransferTypes());
        if (CollectionHelper.isNotEmpty((Iterable)set2)) {
            dBQuery2.where((Predicate)qTransfer.type().in((Collection)set2));
        }
        Long l = (Long)dBQuery.singleResult((Expression)qUserGroupLog.user().countDistinct());
        Long l2 = (Long)((DBQuery)dBQuery4.where((Predicate)dBQuery2.exists())).singleResult((Expression)qUserGroupLog.user().countDistinct());
        if (l == null || l.intValue() == 0) {
            return null;
        }
        double d = (double)l2.longValue() * 1.0 / (double)l.longValue();
        return new BigDecimal((1.0 - d) * 100.0);
    }

    public TransferSummary getTradeResult(SystemReportQuery systemReportQuery, TradeType tradeType) {
        Object object;
        Set set;
        QTransfer qTransfer = QTransfer.transfer;
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qTransfer, qUserAccount});
        switch (tradeType) {
            case EXPENDITURE: {
                dBQuery.where((Predicate)qUserAccount.eq((Expression)qTransfer.from()));
                break;
            }
            case INCOME: {
                dBQuery.where((Predicate)qUserAccount.eq((Expression)qTransfer.to()));
            }
        }
        QChargebackTransfer qChargebackTransfer = QChargebackTransfer.chargebackTransfer;
        DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qChargebackTransfer}).where((Predicate)qChargebackTransfer.id.eq((Expression)qTransfer.id));
        dBQuery.where(new Predicate[]{qTransfer.chargedBackBy().isNull(), dBQuery2.notExists()});
        Date date = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Date date2 = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        dBQuery.where(new Predicate[]{qTransfer.date.isNotNull(), qTransfer.date.goe((Comparable)date)});
        if (QueryHelper.useParameter((Object)date2)) {
            dBQuery.where((Predicate)qTransfer.date.lt((Comparable)date2));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true)))) {
            object = QUserGroupLog.userGroupLog;
            DBQuery dBQuery3 = (DBQuery)this.subQuery(new EntityPath[]{object}).where(new Predicate[]{object.group().in((Collection)set), object.startDate.loe((Expression)qTransfer.date), object.endDate.isNull().or((Predicate)object.endDate.gt((Expression)qTransfer.date)), object.user().eq((Expression)qUserAccount.user())});
            dBQuery.where((Predicate)dBQuery3.exists());
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object = this.conversionHandler.convertSet(TransferType.class, (Iterable)systemReportQuery.getTransferTypes())))) {
            dBQuery.where((Predicate)qTransfer.type().in((Collection)object));
        }
        return (TransferSummary)dBQuery.singleResult((Expression)Projections.constructor(TransferSummary.class, (Expression[])new Expression[]{qTransfer.count(), qTransfer.amount.sum()}));
    }

    public int order() {
        return 0;
    }

    private PeriodSubReportsResultData getData(SystemReportQuery systemReportQuery) {
        CurrencyAmountDTO currencyAmountDTO;
        TransferSummary transferSummary;
        PeriodSubReportsResultData periodSubReportsResultData = new PeriodSubReportsResultData();
        periodSubReportsResultData.setNumberOfMembers(this.getMembersOverPeriod(systemReportQuery));
        if (systemReportQuery.isExpenditure()) {
            transferSummary = this.getTradeResult(systemReportQuery, TradeType.EXPENDITURE);
            currencyAmountDTO = new CurrencyAmountDTO();
            currencyAmountDTO.setAmount(BigDecimalHelper.zeroWhenNull((BigDecimal)transferSummary.getAmount()));
            currencyAmountDTO.setCurrency(systemReportQuery.getCurrency());
            periodSubReportsResultData.setGrossExpenditure(currencyAmountDTO);
            periodSubReportsResultData.setNumberOfOutgoingTransfers(transferSummary.getCount());
        }
        if (systemReportQuery.isIncome()) {
            transferSummary = this.getTradeResult(systemReportQuery, TradeType.INCOME);
            currencyAmountDTO = new CurrencyAmountDTO();
            currencyAmountDTO.setAmount(BigDecimalHelper.zeroWhenNull((BigDecimal)transferSummary.getAmount()));
            currencyAmountDTO.setCurrency(systemReportQuery.getCurrency());
            periodSubReportsResultData.setGrossIncome(currencyAmountDTO);
            periodSubReportsResultData.setNumberOfIncomingTransfers(transferSummary.getCount());
        }
        if (systemReportQuery.isNumberLogins()) {
            periodSubReportsResultData.setNumberOfLogins(this.getNumberOfLogins(systemReportQuery));
        }
        if (systemReportQuery.isPercentageNotTrading()) {
            periodSubReportsResultData.setPercentageNotTrading(this.getPercentageNoTrade(systemReportQuery));
        }
        return periodSubReportsResultData;
    }
}

