/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QAdminGroup;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.logging.LoggingHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.system.NetworkPopulator;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.system.ServiceInterceptorServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.configurations.ConfigurationDetailedVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.networks.BasicNetworkInitialDataDTO;
import org.cyclos.model.system.networks.NetworkDTO;
import org.cyclos.model.system.networks.NetworkData;
import org.cyclos.model.system.networks.NetworkInitialAdministrator;
import org.cyclos.model.system.networks.NetworkInitialDataDTO;
import org.cyclos.model.system.networks.NetworkInitialMessageCategory;
import org.cyclos.model.system.networks.NetworkOrderBy;
import org.cyclos.model.system.networks.NetworkQuery;
import org.cyclos.model.system.networks.NetworkSearchData;
import org.cyclos.model.system.networks.NetworkVO;
import org.cyclos.model.system.networks.NetworkWithInitialDataData;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.model.users.products.SpecificConfigurationAccess;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NetworkServiceImpl
extends CRUDServiceImpl<Network, QNetwork, NetworkDTO, NetworkData, Void>
implements NetworkServiceLocal {
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LoggingHandler loggingHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private ServiceInterceptorServiceLocal serviceInterceptorService;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    public NetworkServiceImpl() {
        super(Network.class, QNetwork.network, NetworkDTO.class);
    }

    public Long createWithData(NetworkDTO networkDTO, NetworkInitialDataDTO networkInitialDataDTO) throws FrameworkException {
        this.validate((BasicNetworkInitialDataDTO)networkInitialDataDTO);
        Long l = this.save(networkDTO);
        Network network = (Network)this.find(l);
        return (Long)this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> {
            NetworkPopulator networkPopulator = (NetworkPopulator)this.beanHandler.autowireWithArgs(NetworkPopulator.class, new Object[]{network, networkInitialDataDTO});
            networkPopulator.populate();
            return l;
        });
    }

    public Network findEnabled(NetworkVO networkVO) throws FrameworkException {
        if (networkVO == null) {
            return null;
        }
        Long l = networkVO.getId();
        String string = networkVO.getInternalName();
        if (l == null && StringHelper.isBlank((Object)string)) {
            return null;
        }
        DBQuery dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{this.$});
        if (l != null) {
            dBQuery.where((Predicate)((QNetwork)this.$).id.eq((Object)l));
        }
        if (StringHelper.isNotBlank((Object)string)) {
            dBQuery.where((Predicate)((QNetwork)this.$).internalName.eq((Object)string));
        }
        dBQuery.where((Predicate)((QNetwork)this.$).enabled.isTrue());
        Network network = (Network)dBQuery.requiredUniqueResult((Expression)this.$);
        if (network == null) {
            throw new EntityNotFoundException(Network.class, l);
        }
        return network;
    }

    public NetworkWithInitialDataData getDataForNewWithData() throws FrameworkException {
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        BasicNetworkInitialDataDTO basicNetworkInitialDataDTO = new BasicNetworkInitialDataDTO();
        basicNetworkInitialDataDTO.setCustomizeLocalization(false);
        basicNetworkInitialDataDTO.setCountry(configurationAccessor.getCountry());
        basicNetworkInitialDataDTO.setLanguage((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)configurationAccessor.getLanguage()));
        basicNetworkInitialDataDTO.setTimeZoneId(configurationAccessor.getTimeZoneId());
        NetworkWithInitialDataData networkWithInitialDataData = new NetworkWithInitialDataData();
        networkWithInitialDataData.setNetworkData((NetworkData)this.getDataForNew(null));
        networkWithInitialDataData.setBasicData(basicNetworkInitialDataDTO);
        networkWithInitialDataData.setLocalizationData(this.localizationService.getLocalizationData(configurationAccessor.getCountry(), configurationAccessor.getTimeZoneId()));
        networkWithInitialDataData.setLanguages(this.conversionHandler.convertList(LanguageVO.class, (Iterable)this.languageService.list()));
        return networkWithInitialDataData;
    }

    public Network getDefault() {
        return (Network)((DBQuery)this.from(this.$).where(new Predicate[]{((QNetwork)this.$).defaultNetwork.isTrue(), ((QNetwork)this.$).enabled.isTrue()})).singleResult((Expression)this.$);
    }

    public NetworkInitialDataDTO getInitialData(BasicNetworkInitialDataDTO basicNetworkInitialDataDTO) throws FrameworkException {
        this.validate(basicNetworkInitialDataDTO);
        boolean bl = basicNetworkInitialDataDTO.isCustomizeLocalization();
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        Language language = bl ? (Language)this.conversionHandler.convert(Language.class, (Object)basicNetworkInitialDataDTO.getLanguage()) : configurationAccessor.getLanguage();
        NetworkInitialDataDTO networkInitialDataDTO = (NetworkInitialDataDTO)this.conversionHandler.convert(NetworkInitialDataDTO.class, (Object)basicNetworkInitialDataDTO);
        networkInitialDataDTO.setAccountAdminsSpecificConfigurationAccess(SpecificConfigurationAccess.MANAGE_CONTENT);
        networkInitialDataDTO.setAdministrator(NetworkInitialAdministrator.NETWORK);
        networkInitialDataDTO.setUnlimitedAccount(this.message(language, GeneralKeys.InitialData.ACCOUNT_TYPE_DEBIT, new Object[0]));
        networkInitialDataDTO.setSystemAccount(this.message(language, GeneralKeys.InitialData.ACCOUNT_TYPE_ORGANIZATION, new Object[0]));
        networkInitialDataDTO.setAdditionalSystemAccount(this.message(language, GeneralKeys.InitialData.ACCOUNT_TYPE_COMMUNITY, new Object[0]));
        networkInitialDataDTO.setUserAccount(this.message(language, GeneralKeys.InitialData.ACCOUNT_TYPE_MEMBER, new Object[0]));
        networkInitialDataDTO.setInitialCredit(BigDecimal.ZERO);
        networkInitialDataDTO.setDefaultCreditLimit(BigDecimal.ZERO);
        networkInitialDataDTO.setCreateSampleStaticContent(true);
        networkInitialDataDTO.setCreateAdCategories(true);
        networkInitialDataDTO.setMessageCategories(new HashSet());
        for (NetworkInitialMessageCategory networkInitialMessageCategory : NetworkInitialMessageCategory.values()) {
            networkInitialDataDTO.getMessageCategories().add(this.message(language, networkInitialMessageCategory.getMessageKey(), new Object[0]));
        }
        return networkInitialDataDTO;
    }

    public List<NetworkVO> getManagedNetworks() throws FrameworkException {
        boolean bl = this.isSystem();
        if (!(bl || this.isAdmin() && this.getSessionData().getNetwork() == null)) {
            return null;
        }
        NetworkQuery networkQuery = new NetworkQuery();
        networkQuery.setUnlimited();
        networkQuery.setOrderBy(NetworkOrderBy.NAME);
        if (!bl && !this.isGlobalAdmin()) {
            AdminGroupVO adminGroupVO = (AdminGroupVO)this.conversionHandler.convert(AdminGroupVO.class, (Object)this.getLoggedUser().getGroup());
            networkQuery.setManagedByGroup(adminGroupVO);
        }
        return this.search(networkQuery).getPageItems();
    }

    public NetworkSearchData getSearchData() {
        NetworkSearchData networkSearchData = new NetworkSearchData();
        if (this.isGlobalAdmin()) {
            networkSearchData.setGroups(this.groupsHandler.visibles().accessibles().admins().sorted());
        }
        NetworkQuery networkQuery = (NetworkQuery)QueryHelper.newQuery(NetworkQuery.class);
        networkQuery.setOrderBy(NetworkOrderBy.DATE);
        networkQuery.setReturnDisabled(true);
        networkSearchData.setQuery((QueryParameters)networkQuery);
        return networkSearchData;
    }

    @Override
    public Network newEntity(Void void_) {
        Network network = new Network();
        network.setEnabled(true);
        network.setDefaultNetwork(!this.hasNetworks());
        return network;
    }

    public String resolveNetworkUrl(NetworkVO networkVO) throws FrameworkException {
        Network network = networkVO == null ? null : this.findEnabled(networkVO);
        Configuration configuration = this.configurationHandler.getGlobalDefault();
        String string = network == null ? "global" : network.getInternalName();
        return this.configurationHandler.getAccessor(configuration).getRootUrl() + "/" + string;
    }

    public Page<NetworkVO> search(NetworkQuery networkQuery) {
        QAdminGroup qAdminGroup;
        AdminGroup adminGroup;
        DBQuery<?> dBQuery = this.from();
        if (!networkQuery.isFromMenu()) {
            networkQuery.setUnlimited();
        }
        if (QueryHelper.useParameter((Object)networkQuery.getName())) {
            dBQuery.where((Predicate)((QNetwork)this.$).name.containsIgnoreCase(networkQuery.getName()));
        }
        if (QueryHelper.useParameter((Object)networkQuery.getInternalName())) {
            dBQuery.where((Predicate)((QNetwork)this.$).internalName.equalsIgnoreCase(networkQuery.getInternalName()));
        }
        if (!networkQuery.isReturnDisabled()) {
            dBQuery.where((Predicate)((QNetwork)this.$).enabled.isTrue());
        }
        if (networkQuery.isDefaultOnly()) {
            dBQuery.where((Predicate)((QNetwork)this.$).defaultNetwork.isTrue());
        }
        if ((adminGroup = (AdminGroup)this.conversionHandler.convert(AdminGroup.class, (Object)networkQuery.getManagedByGroup())) != null && adminGroup.getAdminType() != AdminGroupType.GLOBAL) {
            qAdminGroup = QAdminGroup.adminGroup;
            ((DBQuery)dBQuery.from((EntityPath)qAdminGroup)).where(new Predicate[]{qAdminGroup.eq((Object)adminGroup), qAdminGroup.managedNetworks.contains((Expression)this.$)});
        }
        qAdminGroup = (NetworkOrderBy)ObjectHelper.defaultValue((Object)networkQuery.getOrderBy(), (Object)NetworkOrderBy.DATE);
        switch (2.$SwitchMap$org$cyclos$model$system$networks$NetworkOrderBy[qAdminGroup.ordinal()]) {
            case 1: {
                dBQuery.orderBy(new OrderSpecifier[]{((QNetwork)this.$).creationDate.desc(), ((QNetwork)this.$).name.asc()});
                break;
            }
            case 2: {
                dBQuery.orderBy(((QNetwork)this.$).name.asc());
            }
        }
        return dBQuery.page((QueryParameters)networkQuery, (Expression)Projections.bean(NetworkVO.class, (Expression[])new Expression[]{((QNetwork)this.$).id, ((QNetwork)this.$).name, ((QNetwork)this.$).internalName, ((QNetwork)this.$).enabled, ((QNetwork)this.$).defaultNetwork}));
    }

    @Override
    public NetworkDTO toDTO(Network network) {
        NetworkDTO networkDTO = (NetworkDTO)super.toDTO(network);
        if (networkDTO.isPersistent()) {
            networkDTO.setParentConfiguration((ConfigurationDetailedVO)this.conversionHandler.convert(ConfigurationDetailedVO.class, (Object)network.getDefaultConfiguration().getParent()));
        }
        return networkDTO;
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, NetworkDTO networkDTO) {
        property.noneOf((Collection)ReservedUris.all());
    }

    @Override
    protected NetworkData getData(Network network) {
        NetworkData networkData = new NetworkData();
        networkData.setDto((EntityDTO)this.toDTO(network));
        SessionData sessionData = this.getSessionData();
        AdminGroup adminGroup = (AdminGroup)sessionData.getGroup();
        if (sessionData.isGlobalAdmin()) {
            HashSet<AdminGroup> hashSet = new HashSet<AdminGroup>(network.getManagedByGroups());
            hashSet.add(adminGroup);
            networkData.setManagedByGroups(this.conversionHandler.convertList(AdminGroupVO.class, (Iterable)CollectionHelper.sort(hashSet)));
            networkData.setConfigurations(this.configurationService.list());
        } else {
            List list = this.configurationService.sortByHierarchy((Collection)adminGroup.getPossibleParentConfigurations());
            networkData.setConfigurations(this.conversionHandler.convertList(ConfigurationDetailedVO.class, (Iterable)list));
            if (network.isTransient() && CollectionHelper.size((Collection)list) == 1) {
                ((NetworkDTO)networkData.getDto()).setParentConfiguration((ConfigurationDetailedVO)CollectionHelper.first((Iterable)networkData.getConfigurations()));
            }
        }
        if (network.isPersistent()) {
            networkData.setHasEnabledServiceInterceptors(this.serviceInterceptorService.hasEnabledInterceptors(network));
            networkData.setDefaultUrl(this.configurationHandler.getAccessor(network.getDefaultConfiguration()).getFullUrl());
        }
        return networkData;
    }

    @Override
    protected boolean isEntityInternalNameRequired(NetworkDTO networkDTO) {
        return true;
    }

    @Override
    protected void onAfterRemove(Network network) {
        AdminGroup adminGroup;
        this.invalidateRequestDataCache();
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser != null && (adminGroup = (AdminGroup)basicUser.getUser().getGroup()).getAdminType() != AdminGroupType.GLOBAL) {
            Set set = adminGroup.getManagedNetworks();
            set.remove(network);
            if (set.isEmpty()) {
                AdminProduct adminProduct = adminGroup.getAdminProduct();
                adminProduct.getPermissions().remove(Permission.SPECIFIC_NETWORKS_MANAGE);
                Long l = SimpleEntity.id((SimpleEntity)adminProduct);
                this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesProduct(l));
            }
        }
    }

    @Override
    protected void onAfterSave(Network network, Network network2, Object object) {
        if (network2 == null) {
            AdminGroup adminGroup;
            Configuration configuration = this.configurationService.createDefaultForNetwork(network);
            network.setDefaultConfiguration(configuration);
            SessionData sessionData = this.getSessionData();
            BasicUser basicUser = sessionData.getLoggedBasicUser();
            this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> {
                AdminGroup adminGroup = this.groupService.createNetworkAdmins(network);
                network.setAdministrators(adminGroup);
                EntityLog entityLog = this.entityLogService.logEntity(null, (SimpleEntity)configuration, () -> null);
                entityLog.setBy(basicUser);
                return entityLog;
            });
            if (basicUser != null && (adminGroup = (AdminGroup)basicUser.getUser().getGroup()).getAdminType() != AdminGroupType.GLOBAL) {
                Set set = adminGroup.getManagedNetworks();
                if (set.isEmpty()) {
                    AdminProduct adminProduct = adminGroup.getAdminProduct();
                    adminProduct.getPermissions().add(Permission.SPECIFIC_NETWORKS_MANAGE);
                    Long l = SimpleEntity.id((SimpleEntity)adminProduct);
                    this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesProduct(l));
                }
                set.add(network);
            }
            this.invalidateRequestDataCache();
            this.notificationHandler.admin().networkCreated(network);
        } else {
            boolean bl;
            boolean bl2 = !Objects.equals(network.getInternalName(), network2.getInternalName());
            boolean bl3 = network.isDefaultNetwork() != network2.isDefaultNetwork();
            boolean bl4 = bl = network.isEnabled() != network2.isEnabled();
            if (bl2) {
                this.loggingHandler.invalidateLoggers(network2.getInternalName());
            }
            if (bl2 || bl3 || bl) {
                this.invalidateRequestDataCache();
            }
            if (bl3 || bl) {
                this.cacheHandler.scheduleClear(CacheType.CONFIGURATION_ACCESSOR);
            }
        }
    }

    @Override
    protected Object onBeforeSave(Network network, Network network2) {
        if (network2 == null) {
            AdminGroup adminGroup;
            network.setCreationDate(new Date());
            SessionData sessionData = this.getSessionData();
            BasicUser basicUser = sessionData.getLoggedBasicUser();
            if (basicUser != null && (adminGroup = (AdminGroup)basicUser.getUser().getGroup()).getAdminType() != AdminGroupType.GLOBAL) {
                network.setRegisteredByGroup(adminGroup);
            }
        }
        if (network.isDefaultNetwork()) {
            for (BasicUser basicUser : ((DBQuery)this.from(this.$).where((Predicate)((QNetwork)this.$).defaultNetwork.isTrue())).list((Expression)this.$)) {
                if (basicUser.equals((Object)network)) continue;
                basicUser.setDefaultNetwork(false);
            }
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    @Override
    protected Validator resolveValidator(NetworkDTO networkDTO) {
        BasicUser basicUser;
        AdminGroup adminGroup;
        Validator validator = new Validator();
        if (networkDTO.isDefaultNetwork() && !networkDTO.isEnabled()) {
            validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.Networks.ERROR_CANNOT_DISABLE_DEFAULT, (Object[])new Object[0]));
        }
        SessionData sessionData = this.getSessionData();
        if (networkDTO.isTransient() && !sessionData.isSystem() && (adminGroup = (AdminGroup)(basicUser = sessionData.getLoggedBasicUser()).getUser().getGroup()).getAdminType() != AdminGroupType.GLOBAL) {
            boolean bl;
            Integer n = adminGroup.getMaxManagedNetworks();
            boolean bl2 = bl = n != null && n == 0;
            if (!bl) {
                int n2 = adminGroup.getManagedNetworks().size();
                boolean bl3 = bl = n != null && n2 >= n;
            }
            if (bl) {
                validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.Networks.ERROR_MAXIMUM_MANAGED_NETWORKS, (Object[])new Object[]{n}));
            }
            validator.property((Property)NetworkDTO.PARENT_CONFIGURATION, SystemKeys.Networks.PARENT_CONFIGURATION).required().entity(Configuration.class, (EntityValidation)new BaseEntityValidation<Configuration>(){

                protected boolean isValid(Object object, Object object2, Configuration configuration) {
                    return adminGroup.getPossibleParentConfigurations().contains(configuration);
                }
            });
        }
        return validator;
    }

    private boolean hasNetworks() {
        return this.from(this.$).hasResults();
    }

    private void invalidateRequestDataCache() {
        this.cacheHandler.scheduleClear(CacheType.REQUEST_DATA);
    }

    @Override
    private void validate(BasicNetworkInitialDataDTO basicNetworkInitialDataDTO) {
        Validator validator = new Validator();
        if (basicNetworkInitialDataDTO.isCustomizeLocalization()) {
            validator.property((Property)NetworkInitialDataDTO.LANGUAGE, SystemKeys.Configurations.DEFAULT_LANGUAGE).required();
            validator.property((Property)NetworkInitialDataDTO.COUNTRY, SystemKeys.Configurations.COUNTRY).required().anyOf((Collection)this.localizationService.listCountryCodes());
            validator.property((Property)NetworkInitialDataDTO.TIME_ZONE_ID, SystemKeys.Configurations.TIME_ZONE_ID).anyOf((Collection)this.localizationService.listTimeZoneIds());
        }
        if (basicNetworkInitialDataDTO instanceof NetworkInitialDataDTO) {
            NetworkInitialDataDTO networkInitialDataDTO = (NetworkInitialDataDTO)basicNetworkInitialDataDTO;
            if (networkInitialDataDTO.getAdministrator() != null) {
                validator.property((Property)NetworkInitialDataDTO.ADMIN_NAME, UsersKeys.Users.NAME).required().length(5, 100).maxWordSize(50);
                validator.property((Property)NetworkInitialDataDTO.ADMIN_USERNAME, UsersKeys.Users.USERNAME).required().length(3, 20);
                validator.property((Property)NetworkInitialDataDTO.ADMIN_EMAIL, UsersKeys.Users.EMAIL).required().email();
                PasswordType passwordType = this.getSessionData().getChannelAccessAccessor().getAccessPassword();
                org.cyclos.impl.utils.validation.Property property = validator.property((Property)NetworkInitialDataDTO.ADMIN_PASSWORD, UsersKeys.Users.PASSWORD).required();
                this.passwordService.addValidations(property, null, networkInitialDataDTO.getAdminUsername(), passwordType, true);
                String string = networkInitialDataDTO.getAdminPassword();
                if (StringHelper.isNotBlank((Object)string)) {
                    validator.property((Property)NetworkInitialDataDTO.ADMIN_CONFIRM_PASSWORD, UsersKeys.Users.CONFIRM_PASSWORD).required().anyOf(new Object[]{string});
                }
            }
            validator.property((Property)NetworkInitialDataDTO.CURRENCY_NAME, GeneralKeys.InitialData.CURRENCY_NAME).required().maxLength(100);
            validator.property((Property)NetworkInitialDataDTO.CURRENCY_SYMBOL, GeneralKeys.InitialData.CURRENCY_SYMBOL).required().maxLength(19);
            validator.property((Property)NetworkInitialDataDTO.UNLIMITED_ACCOUNT, GeneralKeys.InitialData.UNLIMITED_ACCOUNT).maxLength(100);
            validator.property((Property)NetworkInitialDataDTO.SYSTEM_ACCOUNT, GeneralKeys.InitialData.SYSTEM_ACCOUNT).required().maxLength(100);
            validator.property((Property)NetworkInitialDataDTO.ADDITIONAL_SYSTEM_ACCOUNT, GeneralKeys.InitialData.ADDITIONAL_SYSTEM_ACCOUNT).maxLength(100);
            validator.property((Property)NetworkInitialDataDTO.USER_ACCOUNT, GeneralKeys.InitialData.USER_ACCOUNT).required().maxLength(100);
        }
        this.validate(validator, basicNetworkInitialDataDTO, "basicNetworkInitialDataDTO");
    }
}

