/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.utils.CountryVO;
import org.cyclos.model.utils.LocalizationData;
import org.cyclos.model.utils.TimeZoneVO;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.ResourceHelper;
import org.springframework.stereotype.Component;

@Component
public class LocalizationServiceImpl
extends BaseNetworkedHandlerImpl
implements LocalizationServiceLocal {
    private static final String TIMEZONES_CSV = "/localization/timezones.csv";
    private static final String DEFAULT_COUNTRIES_PER_LANGUAGE_CSV = "/localization/defaultCountriesPerLanguage.csv";
    private List<String> timeZoneIds;
    private List<String> countryCodes;
    private Map<String, List<String>> timeZonesPerCountry;
    private Map<String, String> defaultCountriesPerLanguage;
    private Map<BuiltinLanguage, List<CountryVO>> countriesPerLanguage = new HashMap<BuiltinLanguage, List<CountryVO>>();

    public List<String> getCountryCodes() throws FrameworkException {
        return this.countryCodes;
    }

    public String getCountryName(String string) {
        BuiltinLanguage builtinLanguage = this.getConfiguration().getLanguage().getTemplate();
        Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
        return new Locale("", string).getDisplayCountry(locale);
    }

    public String getDefaultCountryForLanguage(String string) {
        return this.defaultCountriesPerLanguage.get(string);
    }

    public LocalizationData getLocalizationData(String string, String string2) throws FrameworkException {
        LocalizationData localizationData = new LocalizationData();
        localizationData.setCountries(this.listCountries());
        localizationData.setSelectedCountry((CountryVO)this.conversionHandler.convert(CountryVO.class, (Object)string));
        localizationData.setSelectedTimeZone((TimeZoneVO)this.conversionHandler.convert(TimeZoneVO.class, (Object)string2));
        if (string != null) {
            localizationData.setSelectedCountryTimeZones(this.listTimeZonesByCountry(string));
        }
        return localizationData;
    }

    @PostConstruct
    public void initialize() {
        String[] stringArray;
        String string;
        Object object2;
        Object object3;
        Object object4;
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        try {
            object4 = new BufferedReader(ResourceHelper.openReader((String)TIMEZONES_CSV));
            try {
                object3 = new CSVReader((Reader)object4);
                try {
                    object3.readNext();
                    while ((object2 = object3.readNext()) != null) {
                        String object5 = object2[0];
                        string = object2[1];
                        treeSet.add(object5);
                        treeSet2.add(string);
                        stringArray = (String[])hashMap.get(object5);
                        if (stringArray == null) {
                            stringArray = new TreeSet();
                            hashMap.put(object5, stringArray);
                        }
                        stringArray.add(string);
                    }
                }
                finally {
                    object3.close();
                }
            }
            finally {
                ((BufferedReader)object4).close();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Couldn't initialize the time zone database", exception);
        }
        this.countryCodes = Collections.unmodifiableList(new ArrayList(treeSet));
        object4 = new ArrayList(treeSet2);
        object4.add(0, "GMT");
        this.timeZoneIds = Collections.unmodifiableList(object4);
        object3 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            object3.put((String)entry.getKey(), Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        this.timeZonesPerCountry = Collections.unmodifiableMap(object3);
        object2 = new HashMap();
        try (BufferedReader bufferedReader = new BufferedReader(ResourceHelper.openReader((String)DEFAULT_COUNTRIES_PER_LANGUAGE_CSV));){
            string = new CSVReader((Reader)bufferedReader);
            try {
                string.readNext();
                while ((stringArray = string.readNext()) != null) {
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    object2.put(string2, string3);
                }
            }
            finally {
                string.close();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Couldn't initialize the default languages per country database", exception);
        }
        this.defaultCountriesPerLanguage = Collections.unmodifiableMap(object2);
    }

    public List<CountryVO> listCountries() {
        BuiltinLanguage builtinLanguage = this.getConfiguration().getLanguage().getTemplate();
        return this.getCountriesForLanguage(builtinLanguage);
    }

    public List<String> listCountryCodes() {
        return this.countryCodes;
    }

    public List<String> listTimeZoneIds() {
        return this.timeZoneIds;
    }

    public List<String> listTimeZoneIdsForCountry(String string) {
        return this.timeZonesPerCountry.get(string);
    }

    public List<TimeZoneVO> listTimeZones() throws FrameworkException {
        return this.conversionHandler.convertList(TimeZoneVO.class, this.listTimeZoneIds());
    }

    public List<TimeZoneVO> listTimeZonesByCountry(String string) throws FrameworkException {
        return this.conversionHandler.convertList(TimeZoneVO.class, this.listTimeZoneIdsForCountry(string));
    }

    private List<CountryVO> getCountriesForLanguage(BuiltinLanguage builtinLanguage) {
        List<CountryVO> list = this.countriesPerLanguage.get(builtinLanguage);
        if (list == null) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
            list = new ArrayList<CountryVO>(this.countryCodes.size());
            for (String string : this.countryCodes) {
                CountryVO countryVO3 = new CountryVO();
                countryVO3.setCode(string);
                countryVO3.setName(new Locale("", string).getDisplayCountry(locale));
                list.add(countryVO3);
            }
            Collections.sort(list, (countryVO, countryVO2) -> countryVO.getName().compareTo(countryVO2.getName()));
            this.countriesPerLanguage.put(builtinLanguage, list);
        }
        return list;
    }
}

