/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Date;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.system.InstanceHandler;
import org.cyclos.impl.system.LicenseHandler;
import org.cyclos.impl.system.LicenseServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.license.api.model.LicenseDetails;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.licensing.BasicLicenseVO;
import org.cyclos.model.system.licensing.LicenseStatus;
import org.cyclos.model.system.licensing.LicenseType;
import org.cyclos.model.system.licensing.LicenseVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
extends BaseServiceImpl
implements LicenseServiceLocal {
    @Autowired
    private LicenseHandler licenseHandler;
    @Autowired
    private InstanceHandler instanceHandler;
    @Autowired
    private UserServiceLocal userService;

    public BasicLicenseVO getBasicLicense() throws FrameworkException {
        return (BasicLicenseVO)this.conversionHandler.convert(BasicLicenseVO.class, (Object)this.licenseHandler.getDetails());
    }

    public LicenseVO getLicense() throws FrameworkException {
        Comparable<Date> comparable;
        LicenseDetails licenseDetails = this.licenseHandler.getDetails();
        LicenseVO licenseVO = (LicenseVO)this.conversionHandler.convert(LicenseVO.class, (Object)licenseDetails);
        if (licenseDetails != null) {
            licenseVO.setType((LicenseType)CoercionHelper.coerce(LicenseType.class, (Object)licenseDetails.getLicenseRootType()));
            comparable = null;
            Integer n = licenseDetails.getMaxUsers();
            if (n != null) {
                comparable = this.userService.countTotalUsers();
                licenseVO.setCurrentUsers((Integer)comparable);
            }
            Date date = licenseDetails.getExpirationDate();
            LicenseStatus licenseStatus = null;
            if (date != null && date.before(new Date())) {
                licenseStatus = LicenseStatus.EXPIRED;
            } else if (n != null && comparable != null && (Integer)comparable >= n) {
                licenseStatus = LicenseStatus.MAX_USERS_REACHED;
            } else if (date != null && DateHelper.subtract((Date)date, (TimeField)TimeField.MONTHS, (int)1).before(new Date())) {
                licenseStatus = LicenseStatus.ABOUT_TO_EXPIRE;
            } else if (n != null && comparable != null && (double)((Integer)comparable).intValue() >= Math.floor((double)n.intValue() * 0.95)) {
                licenseStatus = LicenseStatus.MAX_USERS_ABOUT_TO_BE_REACHED;
            }
            licenseVO.setStatus(licenseStatus);
        }
        comparable = this.instanceHandler.getLastUpdate();
        licenseVO.setLastUpdate(this.conversionHandler.toDateTime((Date)comparable));
        return licenseVO;
    }

    public void offlineUpdate(SerializableInputStream serializableInputStream) throws FrameworkException {
        this.instanceHandler.offlineUpdate(serializableInputStream);
    }

    public void onlineUpdate() throws FrameworkException {
        this.instanceHandler.onlineUpdate();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

