/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.querydsl.core.types.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.entities.Application;
import org.cyclos.entities.QApplication;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.BalanceInconsistencyParameters;
import org.cyclos.impl.system.DbSchemaInconsistencyParameters;
import org.cyclos.impl.system.InstanceHandler;
import org.cyclos.impl.system.LicenseHandlerImplementor;
import org.cyclos.impl.system.LocalLicenseDetails;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.license.api.model.CyclosRequestParameters;
import org.cyclos.license.api.model.CyclosUrlData;
import org.cyclos.license.api.model.IssueReportType;
import org.cyclos.license.api.model.LicenseActivationParameters;
import org.cyclos.license.api.model.LicenseActivationResult;
import org.cyclos.license.api.model.LicenseDetails;
import org.cyclos.license.api.model.LicenseRootType;
import org.cyclos.license.api.model.PingParameters;
import org.cyclos.license.api.model.ReportIssueParameters;
import org.cyclos.license.core.CipherHelper;
import org.cyclos.model.CyclosException;
import org.cyclos.model.FileParsingException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.licensing.LicenseAuthenticationException;
import org.cyclos.model.system.licensing.LicenseServerOfflineException;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class LicenseHandlerImpl
extends BaseGlobalHandlerImpl
implements LicenseHandlerImplementor,
InstanceHandler {
    private static final String LICENSE_KEY_CACHE_KEY = "key";
    private static final String LICENSE_DATA_CACHE_KEY = "data";
    private static final String LICENSE_LOCAL_DATA_CACHE_KEY = "localData";
    private static final String LICENSE_DETAILS_CACHE_KEY = "details";
    private static final String LICENSE_LOCAL_DETAILS_CACHE_KEY = "localDetails";
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    @Lazy
    private UserServiceLocal userService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;
    @Autowired
    @Lazy
    private AlertServiceLocal alertService;
    @Autowired
    private LockHandler lockHandler;
    private Cache<String, Serializable> licenseDetailsCache;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;

    public void activate(LicenseActivationParameters licenseActivationParameters) {
        if (this.isSet()) {
            throw new IllegalActionException();
        }
        LicenseActivationResult licenseActivationResult = this.activateNew(licenseActivationParameters);
        Application application = this.applicationHandler.getApplication();
        application.setLicenseKey(licenseActivationResult.getKey());
        application.setLicenseData(licenseActivationResult.getData());
        this.getEntityManager().flush();
        this.cacheHandler.scheduleClear(CacheType.LICENSE);
    }

    public void checkNewVouchers(int n) {
        int n2;
        Integer n3 = this.getMaxNumberOfUsers();
        if (n3 != null && (n2 = n3 * 10) <= this.voucherService.countTotalOpenVouchers() + n) {
            throw new ValidationException(this.translationHandler.message(SystemKeys.Licensing.ERROR_MAX_OPEN_VOUCHERS_REACHED, new Object[0]));
        }
    }

    public void checkUserRegistration() {
        Integer n = this.getMaxNumberOfUsers();
        if (n != null) {
            Application application;
            boolean bl;
            int n2 = this.userService.countTotalUsers();
            boolean bl2 = n <= n2;
            int n3 = this.cyclosProperties.getLicenseMaxUsersAlertPercentage();
            boolean bl3 = bl = (double)(n2 + 1) >= (double)n.intValue() * ((double)n3 / 100.0);
            if (n3 > 0 && bl && (application = this.applicationHandler.getApplication()).getMaxUsersAlmostReachedAlertDate() == null) {
                this.lockHandler.lock(LockType.MAX_USERS_ALERT.nullKey());
                this.getEntityManager().refresh((Object)application);
                if (application.getMaxUsersAlmostReachedAlertDate() == null) {
                    Runnable runnable = () -> {
                        application.setMaxUsersAlmostReachedAlertDate(DateHelper.now());
                        this.alertService.create((Network)null, SystemAlertType.MAX_USERS_ALMOST_REACHED, new Object[]{n, n3, this.cyclosProperties.getLicenseUrl()});
                    };
                    SessionData sessionData = SessionDataFactory.system();
                    if (bl2) {
                        this.invokerHandler.submitAsInParallelTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> runnable.run());
                    } else {
                        this.invokerHandler.runAs(sessionData, () -> {
                            runnable.run();
                            return null;
                        });
                    }
                }
            }
            if (bl2) {
                throw new ValidationException(this.translationHandler.message(SystemKeys.Licensing.ERROR_MAX_USERS_REACHED, new Object[0]));
            }
        }
    }

    public LicenseDetails getDetails() {
        byte[] byArray = this.getEncryptionKey();
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.getEncryptedData();
        if (byArray2 == null) {
            return null;
        }
        return (LicenseDetails)this.licenseDetailsCache.get((Serializable)((Object)LICENSE_DETAILS_CACHE_KEY), () -> {
            String string = CipherHelper.decrypt((byte[])byArray, (byte[])byArray2);
            LicenseDetails licenseDetails = (LicenseDetails)this.jsonConverter.readValue(string, LicenseDetails.class);
            if (licenseDetails.getLicenseRootType() == LicenseRootType.DEVELOPMENT) {
                licenseDetails.setLicenseKey("00000-00000-00000-00000");
                licenseDetails.setPingKey("00000000000000000000000000000000");
                licenseDetails.setOrganizationName("***For development only - commercial use is forbidden***");
                licenseDetails.setAllowOfflineUpdate(false);
                licenseDetails.setMaxUsers(null);
                licenseDetails.setExpirationDate(null);
            }
            return licenseDetails;
        });
    }

    @Override
    public byte[] getEncryptionKey() {
        return this.doGetBytesFromCache(LICENSE_KEY_CACHE_KEY, (Path<byte[]>)QApplication.application.licenseKey);
    }

    public Date getLastUpdate() {
        LocalLicenseDetails localLicenseDetails = this.getLocalLicenseDetails();
        return localLicenseDetails == null ? null : localLicenseDetails.getLastUpdate();
    }

    @PostConstruct
    public void initialize() {
        this.licenseDetailsCache = this.cacheHandler.getCache(CacheType.LICENSE);
    }

    public boolean isSet() {
        LicenseDetails licenseDetails = this.getDetails();
        return licenseDetails != null && licenseDetails.getLicenseKey() != null;
    }

    public void offlineUpdate(SerializableInputStream serializableInputStream) {
        this.lockApplication();
        try {
            LicenseDetails licenseDetails = this.getDetails();
            if (!licenseDetails.isAllowOfflineUpdate()) {
                throw new IllegalActionException("Offline updates are not allowed for this license");
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)serializableInputStream);
            this.doUpdate(byArray, licenseDetails);
        }
        catch (CyclosException cyclosException) {
            throw cyclosException;
        }
        catch (Exception exception) {
            throw new FileParsingException((Throwable)exception);
        }
    }

    public void onlineUpdate() {
        byte[] byArray;
        this.lockApplication();
        PingParameters pingParameters = new PingParameters();
        LicenseDetails licenseDetails = this.fill((CyclosRequestParameters)pingParameters);
        pingParameters.setUsers(Integer.valueOf(this.userService.countTotalUsers()));
        List list = this.nativeQueryHandler.countUsersByUrl();
        pingParameters.setCyclosUrls(new ArrayList());
        CollectionUtils.collect((Iterable)list, this::toCyclosUrlData, (Collection)pingParameters.getCyclosUrls());
        try {
            byArray = this.ping(pingParameters);
        }
        catch (Exception exception) {
            throw new LicenseServerOfflineException((Throwable)exception);
        }
        if (byArray != null) {
            this.doUpdate(byArray, licenseDetails);
        }
    }

    public boolean onlineUpdateIfNeeded() {
        LicenseDetails licenseDetails = this.getDetails();
        if (licenseDetails == null || licenseDetails.getLicenseRootType() == LicenseRootType.DEVELOPMENT) {
            return false;
        }
        Date date = this.getLastUpdate();
        if (date != null && DateHelper.add((Date)date, (TimeField)TimeField.WEEKS, (int)1).after(new Date())) {
            return false;
        }
        this.onlineUpdate();
        return true;
    }

    public void reportInconsistentBalance(BalanceInconsistencyParameters balanceInconsistencyParameters) throws LicenseServerOfflineException {
        ReportIssueParameters reportIssueParameters = new ReportIssueParameters();
        this.fill((CyclosRequestParameters)reportIssueParameters);
        reportIssueParameters.setType(IssueReportType.INCONSISTENT_BALANCE);
        reportIssueParameters.setInconsistentAccounts(Integer.valueOf(balanceInconsistencyParameters.getInconsistentAccounts()));
        reportIssueParameters.setInconsistentAccountsHash(balanceInconsistencyParameters.getInconsistentAccountsHash());
        reportIssueParameters.setAccountsBelowLimit(Integer.valueOf(balanceInconsistencyParameters.getBelowLimit()));
        reportIssueParameters.setAccountsBelowLimitHash(balanceInconsistencyParameters.getBelowLimitHash());
        this.reportIssue(reportIssueParameters);
    }

    public void reportInconsistentDbSchema(DbSchemaInconsistencyParameters dbSchemaInconsistencyParameters) throws LicenseServerOfflineException {
        ReportIssueParameters reportIssueParameters = new ReportIssueParameters();
        this.fill((CyclosRequestParameters)reportIssueParameters);
        try {
            reportIssueParameters.setDbDiffAsJson(this.jacksonConfiguration.getObjectMapper().writeValueAsString((Object)dbSchemaInconsistencyParameters.getDiff()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new UncheckedIOException("Error generating db diff as JSON: " + jsonProcessingException.getMessage(), (IOException)((Object)jsonProcessingException));
        }
        reportIssueParameters.setPostgreSQLVersion(dbSchemaInconsistencyParameters.getPostgresqlVersion());
        reportIssueParameters.setFailedDatabaseUpgrades(dbSchemaInconsistencyParameters.getFailedDatabaseUpgrades());
        reportIssueParameters.setType(IssueReportType.INCONSISTENT_DB_SCHEMA);
        this.reportIssue(reportIssueParameters);
    }

    private LicenseActivationResult activateNew(LicenseActivationParameters licenseActivationParameters) {
        try {
            return this.post("/activate-new", licenseActivationParameters, LicenseActivationResult.class);
        }
        catch (HttpClientErrorException httpClientErrorException) {
            if (httpClientErrorException.getStatusCode() == HttpStatus.FORBIDDEN) {
                throw new LicenseAuthenticationException();
            }
            throw new LicenseServerOfflineException((Throwable)httpClientErrorException);
        }
        catch (Exception exception) {
            throw new LicenseServerOfflineException((Throwable)exception);
        }
    }

    private byte[] doGetBytesFromCache(String string, Path<byte[]> path) {
        AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.licenseDetailsCache.get((Serializable)((Object)string), () -> (Serializable)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            Application application = this.applicationHandler.getApplication();
            byte[] byArray = (byte[])InvocationContext.wrap((Object)application).getPropertyValue(PropertyHelper.getPropertyName((Path)path));
            return AccessorCacheValue.create((Object)byArray);
        }));
        return (byte[])accessorCacheValue.unwrap(this.getApplicationContext());
    }

    private void doUpdate(byte[] byArray, LicenseDetails licenseDetails) {
        byte[] byArray2;
        LicenseDetails licenseDetails2;
        if (licenseDetails == null || licenseDetails.getLicenseKey() == null) {
            throw new IllegalActionException();
        }
        byte[] byArray3 = this.getEncryptionKey();
        String string = CipherHelper.decrypt((byte[])byArray3, (byte[])byArray);
        try {
            licenseDetails2 = (LicenseDetails)this.jsonConverter.readValue(string, LicenseDetails.class);
        }
        catch (Exception exception) {
            throw new FileParsingException((Throwable)exception);
        }
        if (!licenseDetails.getLicenseKey().equals(licenseDetails2.getLicenseKey())) {
            throw new FileParsingException("License key mismatch");
        }
        LocalLicenseDetails localLicenseDetails = this.getLocalLicenseDetails();
        if (localLicenseDetails == null) {
            localLicenseDetails = new LocalLicenseDetails();
        }
        localLicenseDetails.setLastUpdate(new Date());
        try {
            string = this.jsonConverter.writeValueAsString((Object)localLicenseDetails);
            byArray2 = CipherHelper.encrypt((byte[])byArray3, (String)string);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error while writing the local license details", exception);
        }
        Application application = this.applicationHandler.getApplication();
        application.setLicenseData(byArray);
        application.setLocalLicenseData(byArray2);
        if (licenseDetails.getMaxUsers() != licenseDetails2.getMaxUsers()) {
            application.setMaxUsersAlmostReachedAlertDate(null);
        }
        this.getEntityManager().flush();
        this.cacheHandler.scheduleClear(CacheType.LICENSE);
    }

    private LicenseDetails fill(CyclosRequestParameters cyclosRequestParameters) {
        LicenseDetails licenseDetails = this.getDetails();
        cyclosRequestParameters.setKey(licenseDetails.getPingKey());
        cyclosRequestParameters.setCyclosVersion(CyclosVersion.get());
        cyclosRequestParameters.setCyclosInstanceName(this.configurationHandler.getGlobalDefault().getApplicationName());
        cyclosRequestParameters.setChallenge(CipherHelper.encrypt((byte[])this.getEncryptionKey(), (String)licenseDetails.getLicenseKey()));
        return licenseDetails;
    }

    private byte[] getEncryptedData() {
        return this.doGetBytesFromCache(LICENSE_DATA_CACHE_KEY, (Path<byte[]>)QApplication.application.licenseData);
    }

    private byte[] getEncryptedLocalData() {
        return this.doGetBytesFromCache(LICENSE_LOCAL_DATA_CACHE_KEY, (Path<byte[]>)QApplication.application.localLicenseData);
    }

    private LocalLicenseDetails getLocalLicenseDetails() {
        byte[] byArray = this.getEncryptionKey();
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.getEncryptedLocalData();
        if (byArray2 == null) {
            return null;
        }
        return (LocalLicenseDetails)this.licenseDetailsCache.get((Serializable)((Object)LICENSE_LOCAL_DETAILS_CACHE_KEY), () -> {
            String string = CipherHelper.decrypt((byte[])byArray, (byte[])byArray2);
            return (Serializable)this.jsonConverter.readValue(string, LocalLicenseDetails.class);
        });
    }

    private Integer getMaxNumberOfUsers() {
        Serializable serializable;
        LicenseDetails licenseDetails = this.getDetails();
        if (licenseDetails.getLicenseRootType() == LicenseRootType.DEVELOPMENT) {
            return null;
        }
        Date date = licenseDetails.getExpirationDate();
        if (date != null && DateHelper.add((Date)date, (TimeField)TimeField.MONTHS, (int)1).before(new Date())) {
            throw new ValidationException(this.translationHandler.message(SystemKeys.Licensing.ERROR_LICENSE_EXPIRED, new Object[0]));
        }
        if (!licenseDetails.isAllowOfflineUpdate()) {
            Date date2;
            serializable = this.getLocalLicenseDetails();
            Date date3 = date2 = serializable == null ? null : ((LocalLicenseDetails)serializable).getLastUpdate();
            if (date2 == null) {
                date2 = licenseDetails.getActivationDate();
            }
            if (DateHelper.add((Date)date2, (TimeField)TimeField.MONTHS, (int)1).before(new Date())) {
                throw new ValidationException(this.translationHandler.message(SystemKeys.Licensing.ERROR_LAST_ONLINE_UPDATE_TOO_OLD, new Object[0]));
            }
        }
        serializable = licenseDetails.getMaxUsers();
        return serializable;
    }

    private void lockApplication() {
        this.lockHandler.lock(LockType.APPLICATION.nullKey());
    }

    private byte[] ping(PingParameters pingParameters) {
        try {
            return this.post("/ping", pingParameters, byte[].class);
        }
        catch (Exception exception) {
            throw new LicenseServerOfflineException((Throwable)exception);
        }
    }

    private <T> T post(String string, Object object, Class<T> clazz) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(object, (MultiValueMap)httpHeaders);
        String string2 = this.cyclosProperties.getLicenseUrl() + "/api" + string;
        return (T)this.restTemplate.postForObject(string2, (Object)httpEntity, clazz, new Object[0]);
    }

    private void reportIssue(ReportIssueParameters reportIssueParameters) {
        try {
            this.post("/report-issue", reportIssueParameters, Void.class);
        }
        catch (Exception exception) {
            throw new LicenseServerOfflineException((Throwable)exception);
        }
    }

    private CyclosUrlData toCyclosUrlData(Pair<String, Long> pair) {
        CyclosUrlData cyclosUrlData = new CyclosUrlData();
        cyclosUrlData.setUrl((String)pair.getFirst());
        cyclosUrlData.setUsers(((Long)pair.getSecond()).intValue());
        return cyclosUrlData;
    }
}

