/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QLanguage;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.languages.LanguageDTO;
import org.cyclos.model.system.languages.LanguageData;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LanguageServiceImpl
extends CRUDServiceImpl<Language, QLanguage, LanguageDTO, LanguageData, Void>
implements LanguageServiceLocal,
ApplicationUpgradeInitializationListener {
    public static final int MAX_LEVELS = 4;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    private Set<String> builtInternalNames;
    @Autowired
    private CacheHandler cacheHandler;

    public LanguageServiceImpl() {
        super(Language.class, QLanguage.language, LanguageDTO.class);
    }

    public LanguageDetailedVO get(LanguageVO languageVO) {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        return (LanguageDetailedVO)this.conversionHandler.convert(LanguageDetailedVO.class, (Object)language);
    }

    public LanguageDetailedVO getCurrent() {
        return (LanguageDetailedVO)this.conversionHandler.convert(LanguageDetailedVO.class, (Object)this.getConfiguration().getLanguage());
    }

    public List<Language> getHierarchy(Language language) throws FrameworkException {
        LinkedList<Language> linkedList = new LinkedList<Language>();
        while (language != null) {
            linkedList.addFirst(language);
            language = language.getParent();
        }
        return linkedList;
    }

    public List<Language> importBuiltin() {
        List list = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new Predicate[]{((QLanguage)this.$).network().isNull(), ((QLanguage)this.$).parent().isNull()})).list((Expression)((QLanguage)this.$).template);
        EnumSet<BuiltinLanguage> enumSet = EnumSet.allOf(BuiltinLanguage.class);
        enumSet.removeAll(list);
        ArrayList<Language> arrayList = new ArrayList<Language>();
        for (BuiltinLanguage builtinLanguage : enumSet) {
            Language language = new Language();
            language.setInternalName(builtinLanguage.name());
            language.setName(builtinLanguage.getDisplayName());
            language.setTemplate(builtinLanguage);
            this.persist((IEntity)language);
            arrayList.add(language);
        }
        return arrayList;
    }

    @PostConstruct
    public void initialize() {
        this.builtInternalNames = EnumSet.allOf(BuiltinLanguage.class).stream().map(Enum::name).collect(Collectors.toSet());
    }

    public boolean isBuiltin(Language language) {
        return language != null && this.builtInternalNames.contains(language.getInternalName());
    }

    public List<LanguageDetailedVO> list() {
        SessionData sessionData = this.getSessionData();
        Network network = sessionData.getNetwork();
        List list = ((DBQuery)((DBQuery)this.from().where((Predicate)(network == null ? ((QLanguage)this.$).network().isNull() : ((QLanguage)this.$).network().eq((Object)network)))).orderBy(((QLanguage)this.$).nameHierarchy().asc())).list((Expression)this.$);
        ArrayList<LanguageDetailedVO> arrayList = new ArrayList<LanguageDetailedVO>(list.size());
        for (Language language : list) {
            LanguageDetailedVO languageDetailedVO = (LanguageDetailedVO)this.conversionHandler.convert(LanguageDetailedVO.class, (Object)language);
            languageDetailedVO.setBuiltin(this.isBuiltin(language));
            arrayList.add(languageDetailedVO);
        }
        return arrayList;
    }

    public List<Language> listAll() {
        return ((DBQuery)this.from().orderBy(((QLanguage)this.$).name.asc())).list((Expression)this.$);
    }

    @Override
    public Language newEntity(Void void_) {
        return new Language();
    }

    public void onApplicationUpgradeInitialization() {
        Pair pair = this.nativeQueryHandler.purgeRemovedBuiltinLanguages();
        Set set = (Set)pair.getFirst();
        Set set2 = (Set)pair.getSecond();
        if (!set.isEmpty()) {
            this.getLogger().warn("The following language templates are no longer supported and were removed: " + String.valueOf(set) + ". As consequence, the builtin languages with the following ids were removed: " + String.valueOf(set2) + ". Any child languages were changed to inherit from English.");
        }
        this.importBuiltin();
    }

    public LanguageDetailedVO resolve(String string) throws FrameworkException {
        Locale locale = LocaleHelper.toLocale((String)string);
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        Language language2 = null;
        if (locale != null) {
            HashSet<Language> hashSet = new HashSet<Language>(configurationAccessor.getAllowedLanguages());
            hashSet.add(configurationAccessor.getDefaultLanguage());
            BuiltinLanguage builtinLanguage = LocaleHelper.mapLocale((Locale)locale);
            language2 = hashSet.stream().filter(language -> language.getTemplate() == builtinLanguage).findAny().orElse(null);
        }
        return (LanguageDetailedVO)this.conversionHandler.convert(LanguageDetailedVO.class, ObjectHelper.defaultValue(language2, (Object)configurationAccessor.getDefaultLanguage()));
    }

    public void updateLastModified(Language language) throws FrameworkException {
        language.setLastModified(new Date());
        for (Language language2 : language.getChildren()) {
            this.updateLastModified(language2);
        }
    }

    @Override
    protected void doRemove(Language language, boolean bl) {
        this.productService.removeAllRelationships((Property)AdminProductDTO.APPLICATION_TRANSLATION, (SimpleEntity)language);
        super.doRemove(language, bl);
    }

    @Override
    protected LanguageData getData(Language language) {
        List<Object> list;
        LanguageData languageData = new LanguageData();
        languageData.setDto((EntityDTO)((LanguageDTO)this.toDTO(language)));
        if (language.isPersistent()) {
            list = language.getParent() != null ? Collections.singletonList(language.getParent()) : Collections.emptyList();
        } else {
            list = this.listAll();
            list.remove(language);
        }
        languageData.setPossibleParents(this.conversionHandler.convertList(LanguageVO.class, list));
        return languageData;
    }

    @Override
    protected void onAfterRemove(Language language) {
        this.cacheHandler.scheduleClear(CacheType.CUSTOMIZED_TRANSLATIONS);
    }

    @Override
    protected void onAfterSave(Language language, Language language2, Object object) {
        if (language2 == null && this.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
            AdminProduct adminProduct = adminGroup.getAdminProduct();
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.APPLICATION_TRANSLATION, (SimpleEntity)language);
        }
    }

    @Override
    protected Object onBeforeSave(Language language, Language language2) {
        if (language.getTemplate() == null && language.getParent() != null) {
            language.setTemplate(language.getParent().getTemplate());
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QLanguage)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(LanguageDTO languageDTO) {
        Validator validator = new Validator();
        if (languageDTO.isTransient()) {
            int n;
            validator.property((Property)LanguageDTO.PARENT, SystemKeys.Languages.PARENT).required();
            Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageDTO.getParent());
            if (language != null && (n = language.getLevel() + 1) >= 4) {
                validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.Languages.ERROR_MAX_LEVELS, (Object[])new Object[]{4}));
            }
        }
        return validator;
    }
}

